// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/service_service.proto

package monitoring

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The `CreateService` request.
type CreateServiceRequest struct {
	// Required. Resource name of the parent workspace. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The Service id to use for this Service. If omitted, an id will be
	// generated instead. Must match the pattern `[a-z0-9\-]+`
	ServiceId string `protobuf:"bytes,3,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// Required. The `Service` to create.
	Service              *Service `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateServiceRequest) Reset()         { *m = CreateServiceRequest{} }
func (m *CreateServiceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceRequest) ProtoMessage()    {}
func (*CreateServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{0}
}

func (m *CreateServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceRequest.Unmarshal(m, b)
}
func (m *CreateServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceRequest.Merge(m, src)
}
func (m *CreateServiceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceRequest.Size(m)
}
func (m *CreateServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceRequest proto.InternalMessageInfo

func (m *CreateServiceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateServiceRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *CreateServiceRequest) GetService() *Service {
	if m != nil {
		return m.Service
	}
	return nil
}

// The `GetService` request.
type GetServiceRequest struct {
	// Required. Resource name of the `Service`. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceRequest) Reset()         { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()    {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{1}
}

func (m *GetServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceRequest.Unmarshal(m, b)
}
func (m *GetServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceRequest.Merge(m, src)
}
func (m *GetServiceRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceRequest.Size(m)
}
func (m *GetServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceRequest proto.InternalMessageInfo

func (m *GetServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The `ListServices` request.
type ListServicesRequest struct {
	// Required. Resource name of the parent containing the listed services, either a
	// project or a Monitoring Workspace. The formats are:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	//     workspaces/[HOST_PROJECT_ID_OR_NUMBER]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A filter specifying what `Service`s to return. The filter currently
	// supports the following fields:
	//
	//     - `identifier_case`
	//     - `app_engine.module_id`
	//     - `cloud_endpoints.service`
	//     - `cluster_istio.location`
	//     - `cluster_istio.cluster_name`
	//     - `cluster_istio.service_namespace`
	//     - `cluster_istio.service_name`
	//
	// `identifier_case` refers to which option in the identifier oneof is
	// populated. For example, the filter `identifier_case = "CUSTOM"` would match
	// all services with a value for the `custom` field. Valid options are
	// "CUSTOM", "APP_ENGINE", "CLOUD_ENDPOINTS", and "CLUSTER_ISTIO".
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// A non-negative number that is the maximum number of results to return.
	// When 0, use default page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return additional results from the previous method call.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesRequest) Reset()         { *m = ListServicesRequest{} }
func (m *ListServicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListServicesRequest) ProtoMessage()    {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{2}
}

func (m *ListServicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesRequest.Unmarshal(m, b)
}
func (m *ListServicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesRequest.Marshal(b, m, deterministic)
}
func (m *ListServicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesRequest.Merge(m, src)
}
func (m *ListServicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListServicesRequest.Size(m)
}
func (m *ListServicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesRequest proto.InternalMessageInfo

func (m *ListServicesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListServicesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListServicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The `ListServices` response.
type ListServicesResponse struct {
	// The `Service`s matching the specified filter.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// If there are more results than have been returned, then this field is set
	// to a non-empty value.  To see the additional results,
	// use that value as `page_token` in the next call to this method.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServicesResponse) Reset()         { *m = ListServicesResponse{} }
func (m *ListServicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListServicesResponse) ProtoMessage()    {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{3}
}

func (m *ListServicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServicesResponse.Unmarshal(m, b)
}
func (m *ListServicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServicesResponse.Marshal(b, m, deterministic)
}
func (m *ListServicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServicesResponse.Merge(m, src)
}
func (m *ListServicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListServicesResponse.Size(m)
}
func (m *ListServicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServicesResponse proto.InternalMessageInfo

func (m *ListServicesResponse) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *ListServicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The `UpdateService` request.
type UpdateServiceRequest struct {
	// Required. The `Service` to draw updates from.
	// The given `name` specifies the resource to update.
	Service *Service `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// A set of field paths defining which fields to use for the update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateServiceRequest) Reset()         { *m = UpdateServiceRequest{} }
func (m *UpdateServiceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateServiceRequest) ProtoMessage()    {}
func (*UpdateServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{4}
}

func (m *UpdateServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateServiceRequest.Unmarshal(m, b)
}
func (m *UpdateServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateServiceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateServiceRequest.Merge(m, src)
}
func (m *UpdateServiceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateServiceRequest.Size(m)
}
func (m *UpdateServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateServiceRequest proto.InternalMessageInfo

func (m *UpdateServiceRequest) GetService() *Service {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *UpdateServiceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The `DeleteService` request.
type DeleteServiceRequest struct {
	// Required. Resource name of the `Service` to delete. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceRequest) Reset()         { *m = DeleteServiceRequest{} }
func (m *DeleteServiceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceRequest) ProtoMessage()    {}
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{5}
}

func (m *DeleteServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceRequest.Unmarshal(m, b)
}
func (m *DeleteServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceRequest.Merge(m, src)
}
func (m *DeleteServiceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceRequest.Size(m)
}
func (m *DeleteServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceRequest proto.InternalMessageInfo

func (m *DeleteServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The `CreateServiceLevelObjective` request.
type CreateServiceLevelObjectiveRequest struct {
	// Required. Resource name of the parent `Service`. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ServiceLevelObjective id to use for this
	// ServiceLevelObjective. If omitted, an id will be generated instead. Must
	// match the pattern `[a-z0-9\-]+`
	ServiceLevelObjectiveId string `protobuf:"bytes,3,opt,name=service_level_objective_id,json=serviceLevelObjectiveId,proto3" json:"service_level_objective_id,omitempty"`
	// Required. The `ServiceLevelObjective` to create.
	// The provided `name` will be respected if no `ServiceLevelObjective` exists
	// with this name.
	ServiceLevelObjective *ServiceLevelObjective `protobuf:"bytes,2,opt,name=service_level_objective,json=serviceLevelObjective,proto3" json:"service_level_objective,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}               `json:"-"`
	XXX_unrecognized      []byte                 `json:"-"`
	XXX_sizecache         int32                  `json:"-"`
}

func (m *CreateServiceLevelObjectiveRequest) Reset()         { *m = CreateServiceLevelObjectiveRequest{} }
func (m *CreateServiceLevelObjectiveRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceLevelObjectiveRequest) ProtoMessage()    {}
func (*CreateServiceLevelObjectiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{6}
}

func (m *CreateServiceLevelObjectiveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceLevelObjectiveRequest.Unmarshal(m, b)
}
func (m *CreateServiceLevelObjectiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceLevelObjectiveRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceLevelObjectiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceLevelObjectiveRequest.Merge(m, src)
}
func (m *CreateServiceLevelObjectiveRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceLevelObjectiveRequest.Size(m)
}
func (m *CreateServiceLevelObjectiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceLevelObjectiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceLevelObjectiveRequest proto.InternalMessageInfo

func (m *CreateServiceLevelObjectiveRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateServiceLevelObjectiveRequest) GetServiceLevelObjectiveId() string {
	if m != nil {
		return m.ServiceLevelObjectiveId
	}
	return ""
}

func (m *CreateServiceLevelObjectiveRequest) GetServiceLevelObjective() *ServiceLevelObjective {
	if m != nil {
		return m.ServiceLevelObjective
	}
	return nil
}

// The `GetServiceLevelObjective` request.
type GetServiceLevelObjectiveRequest struct {
	// Required. Resource name of the `ServiceLevelObjective` to get. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// View of the `ServiceLevelObjective` to return. If `DEFAULT`, return the
	// `ServiceLevelObjective` as originally defined. If `EXPLICIT` and the
	// `ServiceLevelObjective` is defined in terms of a `BasicSli`, replace the
	// `BasicSli` with a `RequestBasedSli` spelling out how the SLI is computed.
	View                 ServiceLevelObjective_View `protobuf:"varint,2,opt,name=view,proto3,enum=google.monitoring.v3.ServiceLevelObjective_View" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *GetServiceLevelObjectiveRequest) Reset()         { *m = GetServiceLevelObjectiveRequest{} }
func (m *GetServiceLevelObjectiveRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceLevelObjectiveRequest) ProtoMessage()    {}
func (*GetServiceLevelObjectiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{7}
}

func (m *GetServiceLevelObjectiveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceLevelObjectiveRequest.Unmarshal(m, b)
}
func (m *GetServiceLevelObjectiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceLevelObjectiveRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceLevelObjectiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceLevelObjectiveRequest.Merge(m, src)
}
func (m *GetServiceLevelObjectiveRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceLevelObjectiveRequest.Size(m)
}
func (m *GetServiceLevelObjectiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceLevelObjectiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceLevelObjectiveRequest proto.InternalMessageInfo

func (m *GetServiceLevelObjectiveRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetServiceLevelObjectiveRequest) GetView() ServiceLevelObjective_View {
	if m != nil {
		return m.View
	}
	return ServiceLevelObjective_VIEW_UNSPECIFIED
}

// The `ListServiceLevelObjectives` request.
type ListServiceLevelObjectivesRequest struct {
	// Required. Resource name of the parent containing the listed SLOs, either a
	// project or a Monitoring Workspace. The formats are:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
	//     workspaces/[HOST_PROJECT_ID_OR_NUMBER]/services/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A filter specifying what `ServiceLevelObjective`s to return.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// A non-negative number that is the maximum number of results to return.
	// When 0, use default page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return additional results from the previous method call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// View of the `ServiceLevelObjective`s to return. If `DEFAULT`, return each
	// `ServiceLevelObjective` as originally defined. If `EXPLICIT` and the
	// `ServiceLevelObjective` is defined in terms of a `BasicSli`, replace the
	// `BasicSli` with a `RequestBasedSli` spelling out how the SLI is computed.
	View                 ServiceLevelObjective_View `protobuf:"varint,5,opt,name=view,proto3,enum=google.monitoring.v3.ServiceLevelObjective_View" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ListServiceLevelObjectivesRequest) Reset()         { *m = ListServiceLevelObjectivesRequest{} }
func (m *ListServiceLevelObjectivesRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceLevelObjectivesRequest) ProtoMessage()    {}
func (*ListServiceLevelObjectivesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{8}
}

func (m *ListServiceLevelObjectivesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceLevelObjectivesRequest.Unmarshal(m, b)
}
func (m *ListServiceLevelObjectivesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceLevelObjectivesRequest.Marshal(b, m, deterministic)
}
func (m *ListServiceLevelObjectivesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceLevelObjectivesRequest.Merge(m, src)
}
func (m *ListServiceLevelObjectivesRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceLevelObjectivesRequest.Size(m)
}
func (m *ListServiceLevelObjectivesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceLevelObjectivesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceLevelObjectivesRequest proto.InternalMessageInfo

func (m *ListServiceLevelObjectivesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListServiceLevelObjectivesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListServiceLevelObjectivesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceLevelObjectivesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListServiceLevelObjectivesRequest) GetView() ServiceLevelObjective_View {
	if m != nil {
		return m.View
	}
	return ServiceLevelObjective_VIEW_UNSPECIFIED
}

// The `ListServiceLevelObjectives` response.
type ListServiceLevelObjectivesResponse struct {
	// The `ServiceLevelObjective`s matching the specified filter.
	ServiceLevelObjectives []*ServiceLevelObjective `protobuf:"bytes,1,rep,name=service_level_objectives,json=serviceLevelObjectives,proto3" json:"service_level_objectives,omitempty"`
	// If there are more results than have been returned, then this field is set
	// to a non-empty value.  To see the additional results,
	// use that value as `page_token` in the next call to this method.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceLevelObjectivesResponse) Reset()         { *m = ListServiceLevelObjectivesResponse{} }
func (m *ListServiceLevelObjectivesResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceLevelObjectivesResponse) ProtoMessage()    {}
func (*ListServiceLevelObjectivesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{9}
}

func (m *ListServiceLevelObjectivesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceLevelObjectivesResponse.Unmarshal(m, b)
}
func (m *ListServiceLevelObjectivesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceLevelObjectivesResponse.Marshal(b, m, deterministic)
}
func (m *ListServiceLevelObjectivesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceLevelObjectivesResponse.Merge(m, src)
}
func (m *ListServiceLevelObjectivesResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceLevelObjectivesResponse.Size(m)
}
func (m *ListServiceLevelObjectivesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceLevelObjectivesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceLevelObjectivesResponse proto.InternalMessageInfo

func (m *ListServiceLevelObjectivesResponse) GetServiceLevelObjectives() []*ServiceLevelObjective {
	if m != nil {
		return m.ServiceLevelObjectives
	}
	return nil
}

func (m *ListServiceLevelObjectivesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The `UpdateServiceLevelObjective` request.
type UpdateServiceLevelObjectiveRequest struct {
	// Required. The `ServiceLevelObjective` to draw updates from.
	// The given `name` specifies the resource to update.
	ServiceLevelObjective *ServiceLevelObjective `protobuf:"bytes,1,opt,name=service_level_objective,json=serviceLevelObjective,proto3" json:"service_level_objective,omitempty"`
	// A set of field paths defining which fields to use for the update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateServiceLevelObjectiveRequest) Reset()         { *m = UpdateServiceLevelObjectiveRequest{} }
func (m *UpdateServiceLevelObjectiveRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateServiceLevelObjectiveRequest) ProtoMessage()    {}
func (*UpdateServiceLevelObjectiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{10}
}

func (m *UpdateServiceLevelObjectiveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateServiceLevelObjectiveRequest.Unmarshal(m, b)
}
func (m *UpdateServiceLevelObjectiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateServiceLevelObjectiveRequest.Marshal(b, m, deterministic)
}
func (m *UpdateServiceLevelObjectiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateServiceLevelObjectiveRequest.Merge(m, src)
}
func (m *UpdateServiceLevelObjectiveRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateServiceLevelObjectiveRequest.Size(m)
}
func (m *UpdateServiceLevelObjectiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateServiceLevelObjectiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateServiceLevelObjectiveRequest proto.InternalMessageInfo

func (m *UpdateServiceLevelObjectiveRequest) GetServiceLevelObjective() *ServiceLevelObjective {
	if m != nil {
		return m.ServiceLevelObjective
	}
	return nil
}

func (m *UpdateServiceLevelObjectiveRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The `DeleteServiceLevelObjective` request.
type DeleteServiceLevelObjectiveRequest struct {
	// Required. Resource name of the `ServiceLevelObjective` to delete. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceLevelObjectiveRequest) Reset()         { *m = DeleteServiceLevelObjectiveRequest{} }
func (m *DeleteServiceLevelObjectiveRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceLevelObjectiveRequest) ProtoMessage()    {}
func (*DeleteServiceLevelObjectiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a3e551c54e1485b8, []int{11}
}

func (m *DeleteServiceLevelObjectiveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceLevelObjectiveRequest.Unmarshal(m, b)
}
func (m *DeleteServiceLevelObjectiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceLevelObjectiveRequest.Marshal(b, m, deterministic)
}
func (m *DeleteServiceLevelObjectiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceLevelObjectiveRequest.Merge(m, src)
}
func (m *DeleteServiceLevelObjectiveRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceLevelObjectiveRequest.Size(m)
}
func (m *DeleteServiceLevelObjectiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceLevelObjectiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceLevelObjectiveRequest proto.InternalMessageInfo

func (m *DeleteServiceLevelObjectiveRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateServiceRequest)(nil), "google.monitoring.v3.CreateServiceRequest")
	proto.RegisterType((*GetServiceRequest)(nil), "google.monitoring.v3.GetServiceRequest")
	proto.RegisterType((*ListServicesRequest)(nil), "google.monitoring.v3.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "google.monitoring.v3.ListServicesResponse")
	proto.RegisterType((*UpdateServiceRequest)(nil), "google.monitoring.v3.UpdateServiceRequest")
	proto.RegisterType((*DeleteServiceRequest)(nil), "google.monitoring.v3.DeleteServiceRequest")
	proto.RegisterType((*CreateServiceLevelObjectiveRequest)(nil), "google.monitoring.v3.CreateServiceLevelObjectiveRequest")
	proto.RegisterType((*GetServiceLevelObjectiveRequest)(nil), "google.monitoring.v3.GetServiceLevelObjectiveRequest")
	proto.RegisterType((*ListServiceLevelObjectivesRequest)(nil), "google.monitoring.v3.ListServiceLevelObjectivesRequest")
	proto.RegisterType((*ListServiceLevelObjectivesResponse)(nil), "google.monitoring.v3.ListServiceLevelObjectivesResponse")
	proto.RegisterType((*UpdateServiceLevelObjectiveRequest)(nil), "google.monitoring.v3.UpdateServiceLevelObjectiveRequest")
	proto.RegisterType((*DeleteServiceLevelObjectiveRequest)(nil), "google.monitoring.v3.DeleteServiceLevelObjectiveRequest")
}

func init() {
	proto.RegisterFile("google/monitoring/v3/service_service.proto", fileDescriptor_a3e551c54e1485b8)
}

var fileDescriptor_a3e551c54e1485b8 = []byte{
	// 1136 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcf, 0x6f, 0xdc, 0x44,
	0x14, 0xd6, 0x6c, 0xd2, 0xb4, 0x79, 0x25, 0xad, 0x18, 0x42, 0xb2, 0xf1, 0x12, 0x9a, 0x18, 0x04,
	0xe9, 0x12, 0x6c, 0xd8, 0x05, 0xb5, 0x24, 0x2d, 0x92, 0x93, 0x42, 0x55, 0x68, 0x44, 0xe4, 0xd2,
	0x1c, 0x50, 0xa4, 0x95, 0xb3, 0x3b, 0xd9, 0x98, 0x78, 0x6d, 0xd7, 0x9e, 0xdd, 0xa5, 0x45, 0x41,
	0x08, 0x89, 0x03, 0x12, 0x42, 0xaa, 0x38, 0xc0, 0xbf, 0x00, 0xe2, 0xc4, 0xaf, 0x3b, 0xd7, 0x72,
	0x03, 0x4e, 0x7b, 0xea, 0x81, 0x13, 0x7f, 0x42, 0x4f, 0xc8, 0xf6, 0x78, 0x6d, 0x6f, 0xc6, 0x76,
	0xdc, 0xa4, 0xa7, 0xc4, 0xf3, 0xde, 0xbc, 0x79, 0xf3, 0xbd, 0xef, 0x7b, 0x6f, 0xb4, 0x50, 0x6d,
	0x5b, 0x56, 0xdb, 0x20, 0x72, 0xc7, 0x32, 0x75, 0x6a, 0x39, 0xba, 0xd9, 0x96, 0x7b, 0x75, 0xd9,
	0x25, 0x4e, 0x4f, 0x6f, 0x92, 0x06, 0xfb, 0x2b, 0xd9, 0x8e, 0x45, 0x2d, 0x3c, 0x1d, 0xf8, 0x4a,
	0x91, 0xaf, 0xd4, 0xab, 0x0b, 0xcf, 0xb1, 0x08, 0x9a, 0xad, 0xcb, 0x9a, 0x69, 0x5a, 0x54, 0xa3,
	0xba, 0x65, 0xba, 0xc1, 0x1e, 0x61, 0x36, 0x66, 0x6d, 0x1a, 0x3a, 0x31, 0x29, 0x33, 0x5c, 0x88,
	0x19, 0x76, 0x75, 0x62, 0xb4, 0x1a, 0x3b, 0x64, 0x4f, 0xeb, 0xe9, 0x96, 0xc3, 0x1c, 0xe6, 0x62,
	0x0e, 0x0e, 0x71, 0xad, 0xae, 0x13, 0x26, 0x22, 0x88, 0x59, 0x49, 0x33, 0x9f, 0x0a, 0xf3, 0xf1,
	0xbf, 0x76, 0xba, 0xbb, 0x32, 0xe9, 0xd8, 0xf4, 0x2e, 0x33, 0x2e, 0x8c, 0x1a, 0x83, 0x0c, 0x3a,
	0x9a, 0xbb, 0x1f, 0x78, 0x88, 0xbf, 0x23, 0x98, 0x5e, 0x77, 0x88, 0x46, 0xc9, 0xad, 0x20, 0xac,
	0x4a, 0xee, 0x74, 0x89, 0x4b, 0xb1, 0x02, 0x13, 0xb6, 0xe6, 0x10, 0x93, 0x96, 0xd1, 0x02, 0x5a,
	0x9a, 0x5c, 0xbb, 0xf8, 0x50, 0x29, 0x3d, 0x52, 0x5e, 0xc0, 0x8b, 0x31, 0x54, 0x82, 0xe8, 0x9a,
	0xad, 0xbb, 0x52, 0xd3, 0xea, 0xc8, 0x61, 0x04, 0xb6, 0x11, 0xcf, 0x03, 0x84, 0x00, 0xeb, 0xad,
	0xf2, 0x98, 0x17, 0x46, 0x9d, 0x64, 0x2b, 0x37, 0x5a, 0xf8, 0x0a, 0x9c, 0x66, 0x1f, 0xe5, 0xd2,
	0x02, 0x5a, 0x3a, 0x5b, 0x9b, 0x97, 0x78, 0xc0, 0x4b, 0x2c, 0xec, 0xda, 0xd8, 0x43, 0xa5, 0xa4,
	0x86, 0x5b, 0x44, 0x15, 0x9e, 0xbe, 0x4e, 0xe8, 0x48, 0xd2, 0x57, 0x61, 0xdc, 0xd4, 0x3a, 0x24,
	0x99, 0x32, 0x1c, 0x21, 0x65, 0x7f, 0x9b, 0xf8, 0x13, 0x82, 0x67, 0x6e, 0xea, 0x6e, 0x18, 0xd5,
	0x3d, 0x41, 0x2c, 0x66, 0x60, 0x62, 0x57, 0x37, 0x28, 0x71, 0xfc, 0xbb, 0x4e, 0xaa, 0xec, 0x0b,
	0x57, 0x60, 0xd2, 0xd6, 0xda, 0xa4, 0xe1, 0xea, 0xf7, 0x88, 0x0f, 0xd1, 0x29, 0xf5, 0x8c, 0xb7,
	0x70, 0x4b, 0xbf, 0x47, 0x3c, 0x00, 0x7d, 0x23, 0xb5, 0xf6, 0x89, 0x59, 0x1e, 0x0f, 0x00, 0xf4,
	0x56, 0x3e, 0xf4, 0x16, 0xc4, 0xbb, 0x30, 0x9d, 0xcc, 0xd6, 0xb5, 0x2d, 0xd3, 0x25, 0xf8, 0x2d,
	0x38, 0xc3, 0x50, 0x72, 0xcb, 0x68, 0x61, 0x2c, 0x17, 0x59, 0x75, 0xe8, 0x8e, 0x5f, 0x82, 0xf3,
	0x26, 0xf9, 0x84, 0x36, 0x62, 0xc7, 0x06, 0xf9, 0x4e, 0x79, 0xcb, 0x9b, 0xc3, 0xa3, 0xef, 0x23,
	0x98, 0xbe, 0x6d, 0xb7, 0x0e, 0xd3, 0x26, 0x56, 0x54, 0x54, 0xb8, 0xa8, 0x78, 0x15, 0xce, 0x76,
	0xfd, 0xa8, 0x3e, 0x45, 0x19, 0x2d, 0x84, 0x30, 0x42, 0xc8, 0x62, 0xe9, 0x5d, 0x8f, 0xc5, 0x1b,
	0x9a, 0xbb, 0xaf, 0x42, 0xe0, 0xee, 0xfd, 0x2f, 0xde, 0x86, 0xe9, 0x6b, 0xc4, 0x20, 0x87, 0x52,
	0x3a, 0x26, 0x29, 0xbe, 0x29, 0x81, 0x98, 0x50, 0xc8, 0x4d, 0xd2, 0x23, 0xc6, 0x07, 0x3b, 0x1f,
	0x93, 0x26, 0xd5, 0x7b, 0x79, 0x7a, 0x81, 0x02, 0x1c, 0x59, 0x05, 0x21, 0xd4, 0x8b, 0xe1, 0x9d,
	0xd1, 0xb0, 0xc2, 0x43, 0x22, 0xfd, 0xcc, 0xba, 0xbc, 0x24, 0x6e, 0xb4, 0xf0, 0x1e, 0xcc, 0xa6,
	0x6c, 0x66, 0x30, 0xbe, 0x92, 0x59, 0x88, 0x64, 0xbc, 0xa0, 0x2c, 0xcf, 0x72, 0xcf, 0x12, 0x7f,
	0x45, 0x70, 0x21, 0x92, 0x1e, 0x1f, 0x8d, 0xf7, 0x13, 0x98, 0x5f, 0xf2, 0xb1, 0x78, 0x1d, 0xe4,
	0x5c, 0x2c, 0x46, 0xa2, 0xf9, 0x41, 0xf0, 0x35, 0x18, 0xef, 0xe9, 0xa4, 0xef, 0xdf, 0xe3, 0x5c,
	0xed, 0xb5, 0x02, 0xf7, 0x90, 0xb6, 0x74, 0xd2, 0x57, 0xfd, 0xdd, 0xe2, 0xe7, 0x25, 0x58, 0x8c,
	0xc9, 0x25, 0xe9, 0xe8, 0x9e, 0x60, 0x19, 0x9f, 0x80, 0xd4, 0x87, 0x10, 0x9c, 0x3a, 0x16, 0x04,
	0xbf, 0x20, 0x10, 0xb3, 0x20, 0x60, 0xfd, 0x83, 0x40, 0x39, 0x85, 0x4a, 0x61, 0x3f, 0x29, 0xc2,
	0x25, 0x75, 0x86, 0x4b, 0xa3, 0xa3, 0xf7, 0x9a, 0x3f, 0x11, 0x88, 0x89, 0x5e, 0xc3, 0xa7, 0x5c,
	0x86, 0x00, 0xd0, 0x89, 0x0a, 0xe0, 0x78, 0x5d, 0xea, 0x0e, 0x88, 0x89, 0x2e, 0xf5, 0xe4, 0xf5,
	0x53, 0xfb, 0xef, 0x3c, 0x94, 0x99, 0x7d, 0x63, 0x18, 0x80, 0x2d, 0xe0, 0xef, 0x10, 0x4c, 0x25,
	0xda, 0x1b, 0xae, 0xf2, 0x71, 0xe2, 0xbd, 0x12, 0x84, 0xec, 0xee, 0x2e, 0xae, 0x0e, 0x94, 0x73,
	0x81, 0x2a, 0x96, 0x19, 0x94, 0x5f, 0xfc, 0xfd, 0xef, 0xb7, 0xa5, 0x17, 0xc5, 0x39, 0xef, 0x21,
	0xf3, 0x69, 0x60, 0xba, 0x5a, 0x95, 0xab, 0x07, 0xe1, 0xab, 0xc6, 0x5d, 0x19, 0x0e, 0x83, 0xcf,
	0x00, 0xa2, 0x36, 0x83, 0x5f, 0xe6, 0x9f, 0x74, 0xe8, 0x0d, 0x90, 0x97, 0xd2, 0xd2, 0x40, 0xf1,
	0x51, 0xf1, 0x13, 0xa9, 0xe0, 0x20, 0x11, 0x6f, 0xc1, 0x4b, 0x63, 0x98, 0x85, 0x5c, 0x3d, 0xc0,
	0xf7, 0x11, 0x3c, 0x15, 0x9f, 0xaf, 0xf8, 0x22, 0x3f, 0x32, 0xe7, 0xc5, 0x20, 0x54, 0x8f, 0xe2,
	0x1a, 0xc8, 0x4d, 0xac, 0x0e, 0x14, 0xd6, 0x3a, 0x12, 0x39, 0xf1, 0xc0, 0xc1, 0xdf, 0x23, 0x98,
	0x4a, 0x68, 0x21, 0xad, 0x5a, 0xbc, 0xe1, 0x9c, 0x07, 0xcd, 0x95, 0x81, 0x72, 0x3a, 0x5e, 0xa6,
	0xe5, 0xda, 0xa2, 0x9f, 0x49, 0xf8, 0xe0, 0xe4, 0xa1, 0x14, 0x95, 0xeb, 0x00, 0xa6, 0x12, 0xc4,
	0x4e, 0xcb, 0x8c, 0x37, 0xa3, 0x85, 0x99, 0x43, 0xea, 0x79, 0xc7, 0x7b, 0xc6, 0x8e, 0x54, 0xab,
	0x9a, 0x51, 0xad, 0x47, 0x08, 0x2a, 0x19, 0x63, 0x1a, 0x5f, 0x3e, 0x02, 0xab, 0xb9, 0x5a, 0x14,
	0x8a, 0xf4, 0x0d, 0x91, 0x0e, 0x94, 0xe7, 0x93, 0x8c, 0x1f, 0xed, 0x46, 0xfe, 0x55, 0x36, 0xc4,
	0xda, 0x48, 0x91, 0xe3, 0x97, 0x91, 0xf9, 0x1d, 0x73, 0x25, 0xad, 0xc1, 0xe1, 0x3f, 0x10, 0x94,
	0xd3, 0x46, 0x32, 0x7e, 0x33, 0x4f, 0x39, 0x27, 0x70, 0x6d, 0x25, 0x5e, 0xa7, 0x37, 0x70, 0x2d,
	0xad, 0x4e, 0x29, 0x37, 0xf3, 0x0a, 0xf8, 0x0f, 0x02, 0x21, 0x7d, 0x38, 0xe1, 0x4b, 0xb9, 0x8a,
	0xe2, 0x4f, 0x74, 0xe1, 0x72, 0xf1, 0x8d, 0x4c, 0x98, 0xeb, 0x49, 0x61, 0x86, 0xd7, 0x2a, 0x54,
	0x33, 0xfc, 0x75, 0x09, 0x2a, 0x19, 0xd3, 0x2b, 0x8d, 0x97, 0xf9, 0x03, 0xaf, 0x58, 0x81, 0xbe,
	0x44, 0x03, 0x65, 0x36, 0x8b, 0x91, 0xa4, 0xf6, 0x5e, 0x5c, 0xec, 0xa3, 0x3e, 0x52, 0xa1, 0x62,
	0xa6, 0x33, 0xf5, 0x67, 0x04, 0x95, 0x8c, 0xf9, 0x97, 0x06, 0x47, 0xfe, 0xc8, 0x4c, 0x6d, 0x21,
	0x49, 0x6a, 0x56, 0x1f, 0x83, 0x9a, 0xc2, 0x0f, 0xe8, 0x81, 0x32, 0x97, 0x3a, 0x7b, 0xff, 0x52,
	0xbe, 0x42, 0x7b, 0x94, 0xda, 0xee, 0x8a, 0x2c, 0xf7, 0xfb, 0xfd, 0xd1, 0xc9, 0xac, 0x75, 0xe9,
	0x9e, 0xdc, 0x34, 0xac, 0x6e, 0xeb, 0x55, 0xdb, 0xd0, 0xe8, 0xae, 0xe5, 0x74, 0x96, 0xf3, 0xdc,
	0xa3, 0xb3, 0x0a, 0xb8, 0x4a, 0x0e, 0xd1, 0x5a, 0x6b, 0xbf, 0x21, 0x28, 0x37, 0xad, 0x0e, 0x17,
	0xc6, 0xb5, 0xf9, 0xb4, 0x67, 0xc0, 0xa6, 0x87, 0xd9, 0x26, 0xfa, 0xe8, 0x6d, 0xb6, 0xad, 0x6d,
	0x19, 0x9a, 0xd9, 0x96, 0x2c, 0xa7, 0x2d, 0xb7, 0x89, 0xe9, 0x23, 0x2a, 0x47, 0xa7, 0x27, 0x7f,
	0x90, 0x58, 0x8d, 0xbe, 0x7e, 0x2c, 0x09, 0xd7, 0x83, 0x00, 0xeb, 0xde, 0x85, 0xa5, 0xe8, 0x1c,
	0x69, 0xab, 0xfe, 0x20, 0x34, 0x6e, 0xfb, 0xc6, 0xed, 0xc8, 0xb8, 0xbd, 0x55, 0xdf, 0x99, 0xf0,
	0x0f, 0xa9, 0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x33, 0x0f, 0x0f, 0x7e, 0xa9, 0x11, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceMonitoringServiceClient is the client API for ServiceMonitoringService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ServiceMonitoringServiceClient interface {
	// Create a `Service`.
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Get the named `Service`.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// List `Service`s for this workspace.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Update this `Service`.
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Soft delete this `Service`.
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Create a `ServiceLevelObjective` for the given `Service`.
	CreateServiceLevelObjective(ctx context.Context, in *CreateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error)
	// Get a `ServiceLevelObjective` by name.
	GetServiceLevelObjective(ctx context.Context, in *GetServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error)
	// List the `ServiceLevelObjective`s for the given `Service`.
	ListServiceLevelObjectives(ctx context.Context, in *ListServiceLevelObjectivesRequest, opts ...grpc.CallOption) (*ListServiceLevelObjectivesResponse, error)
	// Update the given `ServiceLevelObjective`.
	UpdateServiceLevelObjective(ctx context.Context, in *UpdateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error)
	// Delete the given `ServiceLevelObjective`.
	DeleteServiceLevelObjective(ctx context.Context, in *DeleteServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type serviceMonitoringServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceMonitoringServiceClient(cc grpc.ClientConnInterface) ServiceMonitoringServiceClient {
	return &serviceMonitoringServiceClient{cc}
}

func (c *serviceMonitoringServiceClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/CreateService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/GetService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/UpdateService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/DeleteService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) CreateServiceLevelObjective(ctx context.Context, in *CreateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error) {
	out := new(ServiceLevelObjective)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/CreateServiceLevelObjective", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) GetServiceLevelObjective(ctx context.Context, in *GetServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error) {
	out := new(ServiceLevelObjective)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/GetServiceLevelObjective", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) ListServiceLevelObjectives(ctx context.Context, in *ListServiceLevelObjectivesRequest, opts ...grpc.CallOption) (*ListServiceLevelObjectivesResponse, error) {
	out := new(ListServiceLevelObjectivesResponse)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/ListServiceLevelObjectives", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) UpdateServiceLevelObjective(ctx context.Context, in *UpdateServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*ServiceLevelObjective, error) {
	out := new(ServiceLevelObjective)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/UpdateServiceLevelObjective", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceMonitoringServiceClient) DeleteServiceLevelObjective(ctx context.Context, in *DeleteServiceLevelObjectiveRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.ServiceMonitoringService/DeleteServiceLevelObjective", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceMonitoringServiceServer is the server API for ServiceMonitoringService service.
type ServiceMonitoringServiceServer interface {
	// Create a `Service`.
	CreateService(context.Context, *CreateServiceRequest) (*Service, error)
	// Get the named `Service`.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// List `Service`s for this workspace.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Update this `Service`.
	UpdateService(context.Context, *UpdateServiceRequest) (*Service, error)
	// Soft delete this `Service`.
	DeleteService(context.Context, *DeleteServiceRequest) (*empty.Empty, error)
	// Create a `ServiceLevelObjective` for the given `Service`.
	CreateServiceLevelObjective(context.Context, *CreateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error)
	// Get a `ServiceLevelObjective` by name.
	GetServiceLevelObjective(context.Context, *GetServiceLevelObjectiveRequest) (*ServiceLevelObjective, error)
	// List the `ServiceLevelObjective`s for the given `Service`.
	ListServiceLevelObjectives(context.Context, *ListServiceLevelObjectivesRequest) (*ListServiceLevelObjectivesResponse, error)
	// Update the given `ServiceLevelObjective`.
	UpdateServiceLevelObjective(context.Context, *UpdateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error)
	// Delete the given `ServiceLevelObjective`.
	DeleteServiceLevelObjective(context.Context, *DeleteServiceLevelObjectiveRequest) (*empty.Empty, error)
}

// UnimplementedServiceMonitoringServiceServer can be embedded to have forward compatible implementations.
type UnimplementedServiceMonitoringServiceServer struct {
}

func (*UnimplementedServiceMonitoringServiceServer) CreateService(ctx context.Context, req *CreateServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateService not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) GetService(ctx context.Context, req *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) ListServices(ctx context.Context, req *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) UpdateService(ctx context.Context, req *UpdateServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateService not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) DeleteService(ctx context.Context, req *DeleteServiceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteService not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) CreateServiceLevelObjective(ctx context.Context, req *CreateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceLevelObjective not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) GetServiceLevelObjective(ctx context.Context, req *GetServiceLevelObjectiveRequest) (*ServiceLevelObjective, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceLevelObjective not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) ListServiceLevelObjectives(ctx context.Context, req *ListServiceLevelObjectivesRequest) (*ListServiceLevelObjectivesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceLevelObjectives not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) UpdateServiceLevelObjective(ctx context.Context, req *UpdateServiceLevelObjectiveRequest) (*ServiceLevelObjective, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServiceLevelObjective not implemented")
}
func (*UnimplementedServiceMonitoringServiceServer) DeleteServiceLevelObjective(ctx context.Context, req *DeleteServiceLevelObjectiveRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceLevelObjective not implemented")
}

func RegisterServiceMonitoringServiceServer(s *grpc.Server, srv ServiceMonitoringServiceServer) {
	s.RegisterService(&_ServiceMonitoringService_serviceDesc, srv)
}

func _ServiceMonitoringService_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/CreateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).UpdateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/UpdateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).UpdateService(ctx, req.(*UpdateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/DeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_CreateServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).CreateServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/CreateServiceLevelObjective",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).CreateServiceLevelObjective(ctx, req.(*CreateServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_GetServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).GetServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/GetServiceLevelObjective",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).GetServiceLevelObjective(ctx, req.(*GetServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_ListServiceLevelObjectives_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceLevelObjectivesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).ListServiceLevelObjectives(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/ListServiceLevelObjectives",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).ListServiceLevelObjectives(ctx, req.(*ListServiceLevelObjectivesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_UpdateServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).UpdateServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/UpdateServiceLevelObjective",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).UpdateServiceLevelObjective(ctx, req.(*UpdateServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceMonitoringService_DeleteServiceLevelObjective_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceLevelObjectiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceMonitoringServiceServer).DeleteServiceLevelObjective(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.ServiceMonitoringService/DeleteServiceLevelObjective",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceMonitoringServiceServer).DeleteServiceLevelObjective(ctx, req.(*DeleteServiceLevelObjectiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceMonitoringService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.v3.ServiceMonitoringService",
	HandlerType: (*ServiceMonitoringServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateService",
			Handler:    _ServiceMonitoringService_CreateService_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _ServiceMonitoringService_GetService_Handler,
		},
		{
			MethodName: "ListServices",
			Handler:    _ServiceMonitoringService_ListServices_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _ServiceMonitoringService_UpdateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _ServiceMonitoringService_DeleteService_Handler,
		},
		{
			MethodName: "CreateServiceLevelObjective",
			Handler:    _ServiceMonitoringService_CreateServiceLevelObjective_Handler,
		},
		{
			MethodName: "GetServiceLevelObjective",
			Handler:    _ServiceMonitoringService_GetServiceLevelObjective_Handler,
		},
		{
			MethodName: "ListServiceLevelObjectives",
			Handler:    _ServiceMonitoringService_ListServiceLevelObjectives_Handler,
		},
		{
			MethodName: "UpdateServiceLevelObjective",
			Handler:    _ServiceMonitoringService_UpdateServiceLevelObjective_Handler,
		},
		{
			MethodName: "DeleteServiceLevelObjective",
			Handler:    _ServiceMonitoringService_DeleteServiceLevelObjective_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/v3/service_service.proto",
}
