/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "knative.dev/eventing/pkg/apis/legacysources/v1alpha1"
)

// FakeSinkBindings implements SinkBindingInterface
type FakeSinkBindings struct {
	Fake *FakeSourcesV1alpha1
	ns   string
}

var sinkbindingsResource = schema.GroupVersionResource{Group: "sources.eventing.knative.dev", Version: "v1alpha1", Resource: "sinkbindings"}

var sinkbindingsKind = schema.GroupVersionKind{Group: "sources.eventing.knative.dev", Version: "v1alpha1", Kind: "SinkBinding"}

// Get takes name of the sinkBinding, and returns the corresponding sinkBinding object, and an error if there is any.
func (c *FakeSinkBindings) Get(name string, options v1.GetOptions) (result *v1alpha1.SinkBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(sinkbindingsResource, c.ns, name), &v1alpha1.SinkBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SinkBinding), err
}

// List takes label and field selectors, and returns the list of SinkBindings that match those selectors.
func (c *FakeSinkBindings) List(opts v1.ListOptions) (result *v1alpha1.SinkBindingList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(sinkbindingsResource, sinkbindingsKind, c.ns, opts), &v1alpha1.SinkBindingList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.SinkBindingList{ListMeta: obj.(*v1alpha1.SinkBindingList).ListMeta}
	for _, item := range obj.(*v1alpha1.SinkBindingList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested sinkBindings.
func (c *FakeSinkBindings) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(sinkbindingsResource, c.ns, opts))

}

// Create takes the representation of a sinkBinding and creates it.  Returns the server's representation of the sinkBinding, and an error, if there is any.
func (c *FakeSinkBindings) Create(sinkBinding *v1alpha1.SinkBinding) (result *v1alpha1.SinkBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(sinkbindingsResource, c.ns, sinkBinding), &v1alpha1.SinkBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SinkBinding), err
}

// Update takes the representation of a sinkBinding and updates it. Returns the server's representation of the sinkBinding, and an error, if there is any.
func (c *FakeSinkBindings) Update(sinkBinding *v1alpha1.SinkBinding) (result *v1alpha1.SinkBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(sinkbindingsResource, c.ns, sinkBinding), &v1alpha1.SinkBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SinkBinding), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeSinkBindings) UpdateStatus(sinkBinding *v1alpha1.SinkBinding) (*v1alpha1.SinkBinding, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(sinkbindingsResource, "status", c.ns, sinkBinding), &v1alpha1.SinkBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SinkBinding), err
}

// Delete takes name of the sinkBinding and deletes it. Returns an error if one occurs.
func (c *FakeSinkBindings) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(sinkbindingsResource, c.ns, name), &v1alpha1.SinkBinding{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeSinkBindings) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(sinkbindingsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.SinkBindingList{})
	return err
}

// Patch applies the patch and returns the patched sinkBinding.
func (c *FakeSinkBindings) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.SinkBinding, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(sinkbindingsResource, c.ns, name, pt, data, subresources...), &v1alpha1.SinkBinding{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.SinkBinding), err
}
