/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/apache/camel-k/pkg/apis/camel/v1"
	scheme "github.com/apache/camel-k/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// IntegrationsGetter has a method to return a IntegrationInterface.
// A group's client should implement this interface.
type IntegrationsGetter interface {
	Integrations(namespace string) IntegrationInterface
}

// IntegrationInterface has methods to work with Integration resources.
type IntegrationInterface interface {
	Create(*v1.Integration) (*v1.Integration, error)
	Update(*v1.Integration) (*v1.Integration, error)
	UpdateStatus(*v1.Integration) (*v1.Integration, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.Integration, error)
	List(opts metav1.ListOptions) (*v1.IntegrationList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Integration, err error)
	IntegrationExpansion
}

// integrations implements IntegrationInterface
type integrations struct {
	client rest.Interface
	ns     string
}

// newIntegrations returns a Integrations
func newIntegrations(c *CamelV1Client, namespace string) *integrations {
	return &integrations{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the integration, and returns the corresponding integration object, and an error if there is any.
func (c *integrations) Get(name string, options metav1.GetOptions) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("integrations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Integrations that match those selectors.
func (c *integrations) List(opts metav1.ListOptions) (result *v1.IntegrationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.IntegrationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("integrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested integrations.
func (c *integrations) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("integrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a integration and creates it.  Returns the server's representation of the integration, and an error, if there is any.
func (c *integrations) Create(integration *v1.Integration) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("integrations").
		Body(integration).
		Do().
		Into(result)
	return
}

// Update takes the representation of a integration and updates it. Returns the server's representation of the integration, and an error, if there is any.
func (c *integrations) Update(integration *v1.Integration) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("integrations").
		Name(integration.Name).
		Body(integration).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *integrations) UpdateStatus(integration *v1.Integration) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("integrations").
		Name(integration.Name).
		SubResource("status").
		Body(integration).
		Do().
		Into(result)
	return
}

// Delete takes name of the integration and deletes it. Returns an error if one occurs.
func (c *integrations) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("integrations").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *integrations) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("integrations").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched integration.
func (c *integrations) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("integrations").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
