/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/eventing-contrib/gitlab/pkg/apis/bindings/v1alpha1"
)

// GitLabBindingLister helps list GitLabBindings.
type GitLabBindingLister interface {
	// List lists all GitLabBindings in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.GitLabBinding, err error)
	// GitLabBindings returns an object that can list and get GitLabBindings.
	GitLabBindings(namespace string) GitLabBindingNamespaceLister
	GitLabBindingListerExpansion
}

// gitLabBindingLister implements the GitLabBindingLister interface.
type gitLabBindingLister struct {
	indexer cache.Indexer
}

// NewGitLabBindingLister returns a new GitLabBindingLister.
func NewGitLabBindingLister(indexer cache.Indexer) GitLabBindingLister {
	return &gitLabBindingLister{indexer: indexer}
}

// List lists all GitLabBindings in the indexer.
func (s *gitLabBindingLister) List(selector labels.Selector) (ret []*v1alpha1.GitLabBinding, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GitLabBinding))
	})
	return ret, err
}

// GitLabBindings returns an object that can list and get GitLabBindings.
func (s *gitLabBindingLister) GitLabBindings(namespace string) GitLabBindingNamespaceLister {
	return gitLabBindingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GitLabBindingNamespaceLister helps list and get GitLabBindings.
type GitLabBindingNamespaceLister interface {
	// List lists all GitLabBindings in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.GitLabBinding, err error)
	// Get retrieves the GitLabBinding from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.GitLabBinding, error)
	GitLabBindingNamespaceListerExpansion
}

// gitLabBindingNamespaceLister implements the GitLabBindingNamespaceLister
// interface.
type gitLabBindingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GitLabBindings in the indexer for a given namespace.
func (s gitLabBindingNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.GitLabBinding, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GitLabBinding))
	})
	return ret, err
}

// Get retrieves the GitLabBinding from the indexer for a given namespace and name.
func (s gitLabBindingNamespaceLister) Get(name string) (*v1alpha1.GitLabBinding, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("gitlabbinding"), name)
	}
	return obj.(*v1alpha1.GitLabBinding), nil
}
