/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/eventing-contrib/natss/pkg/apis/messaging/v1alpha1"
	scheme "knative.dev/eventing-contrib/natss/pkg/client/clientset/versioned/scheme"
)

// NatssChannelsGetter has a method to return a NatssChannelInterface.
// A group's client should implement this interface.
type NatssChannelsGetter interface {
	NatssChannels(namespace string) NatssChannelInterface
}

// NatssChannelInterface has methods to work with NatssChannel resources.
type NatssChannelInterface interface {
	Create(*v1alpha1.NatssChannel) (*v1alpha1.NatssChannel, error)
	Update(*v1alpha1.NatssChannel) (*v1alpha1.NatssChannel, error)
	UpdateStatus(*v1alpha1.NatssChannel) (*v1alpha1.NatssChannel, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.NatssChannel, error)
	List(opts v1.ListOptions) (*v1alpha1.NatssChannelList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.NatssChannel, err error)
	NatssChannelExpansion
}

// natssChannels implements NatssChannelInterface
type natssChannels struct {
	client rest.Interface
	ns     string
}

// newNatssChannels returns a NatssChannels
func newNatssChannels(c *MessagingV1alpha1Client, namespace string) *natssChannels {
	return &natssChannels{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the natssChannel, and returns the corresponding natssChannel object, and an error if there is any.
func (c *natssChannels) Get(name string, options v1.GetOptions) (result *v1alpha1.NatssChannel, err error) {
	result = &v1alpha1.NatssChannel{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("natsschannels").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of NatssChannels that match those selectors.
func (c *natssChannels) List(opts v1.ListOptions) (result *v1alpha1.NatssChannelList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.NatssChannelList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("natsschannels").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested natssChannels.
func (c *natssChannels) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("natsschannels").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a natssChannel and creates it.  Returns the server's representation of the natssChannel, and an error, if there is any.
func (c *natssChannels) Create(natssChannel *v1alpha1.NatssChannel) (result *v1alpha1.NatssChannel, err error) {
	result = &v1alpha1.NatssChannel{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("natsschannels").
		Body(natssChannel).
		Do().
		Into(result)
	return
}

// Update takes the representation of a natssChannel and updates it. Returns the server's representation of the natssChannel, and an error, if there is any.
func (c *natssChannels) Update(natssChannel *v1alpha1.NatssChannel) (result *v1alpha1.NatssChannel, err error) {
	result = &v1alpha1.NatssChannel{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("natsschannels").
		Name(natssChannel.Name).
		Body(natssChannel).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *natssChannels) UpdateStatus(natssChannel *v1alpha1.NatssChannel) (result *v1alpha1.NatssChannel, err error) {
	result = &v1alpha1.NatssChannel{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("natsschannels").
		Name(natssChannel.Name).
		SubResource("status").
		Body(natssChannel).
		Do().
		Into(result)
	return
}

// Delete takes name of the natssChannel and deletes it. Returns an error if one occurs.
func (c *natssChannels) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("natsschannels").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *natssChannels) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("natsschannels").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched natssChannel.
func (c *natssChannels) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.NatssChannel, err error) {
	result = &v1alpha1.NatssChannel{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("natsschannels").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
