// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/attributes.proto

package v1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Attributes represents a set of typed name/value pairs. Many of Mixer's
// API either consume and/or return attributes.
//
// Istio uses attributes to control the runtime behavior of services running in the service mesh.
// Attributes are named and typed pieces of metadata describing ingress and egress traffic and the
// environment this traffic occurs in. An Istio attribute carries a specific piece
// of information such as the error code of an API request, the latency of an API request, or the
// original IP address of a TCP connection. For example:
//
// ```yaml
// request.path: xyz/abc
// request.size: 234
// request.time: 12:34:56.789 04/17/2017
// source.ip: 192.168.0.1
// target.service: example
// ```
//
// A given Istio deployment has a fixed vocabulary of attributes that it understands.
// The specific vocabulary is determined by the set of attribute producers being used
// in the deployment. The primary attribute producer in Istio is Envoy, although
// specialized Mixer adapters and services can also generate attributes.
//
// The common baseline set of attributes available in most Istio deployments is defined
// [here](https://istio.io/docs/reference/config/policy-and-telemetry/attribute-vocabulary/).
//
// Attributes are strongly typed. The supported attribute types are defined by
// [ValueType](https://github.com/istio/api/blob/master/policy/v1beta1/value_type.proto).
// Each type of value is encoded into one of the so-called transport types present
// in this message.
//
// Defines a map of attributes in uncompressed format.
// Following places may use this message:
// 1) Configure Istio/Proxy with static per-proxy attributes, such as source.uid.
// 2) Service IDL definition to extract api attributes for active requests.
// 3) Forward attributes from client proxy to server proxy for HTTP requests.
type Attributes struct {
	// A map of attribute name to its value.
	Attributes map[string]*Attributes_AttributeValue `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Attributes) Reset()      { *m = Attributes{} }
func (*Attributes) ProtoMessage() {}
func (*Attributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_6504964367320bd3, []int{0}
}
func (m *Attributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Attributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Attributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Attributes.Merge(m, src)
}
func (m *Attributes) XXX_Size() int {
	return m.Size()
}
func (m *Attributes) XXX_DiscardUnknown() {
	xxx_messageInfo_Attributes.DiscardUnknown(m)
}

var xxx_messageInfo_Attributes proto.InternalMessageInfo

// Specifies one attribute value with different type.
type Attributes_AttributeValue struct {
	// The attribute value.
	//
	// Types that are valid to be assigned to Value:
	//	*Attributes_AttributeValue_StringValue
	//	*Attributes_AttributeValue_Int64Value
	//	*Attributes_AttributeValue_DoubleValue
	//	*Attributes_AttributeValue_BoolValue
	//	*Attributes_AttributeValue_BytesValue
	//	*Attributes_AttributeValue_TimestampValue
	//	*Attributes_AttributeValue_DurationValue
	//	*Attributes_AttributeValue_StringMapValue
	Value isAttributes_AttributeValue_Value `protobuf_oneof:"value"`
}

func (m *Attributes_AttributeValue) Reset()      { *m = Attributes_AttributeValue{} }
func (*Attributes_AttributeValue) ProtoMessage() {}
func (*Attributes_AttributeValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_6504964367320bd3, []int{0, 1}
}
func (m *Attributes_AttributeValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Attributes_AttributeValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Attributes_AttributeValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Attributes_AttributeValue.Merge(m, src)
}
func (m *Attributes_AttributeValue) XXX_Size() int {
	return m.Size()
}
func (m *Attributes_AttributeValue) XXX_DiscardUnknown() {
	xxx_messageInfo_Attributes_AttributeValue.DiscardUnknown(m)
}

var xxx_messageInfo_Attributes_AttributeValue proto.InternalMessageInfo

type isAttributes_AttributeValue_Value interface {
	isAttributes_AttributeValue_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Attributes_AttributeValue_StringValue struct {
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}
type Attributes_AttributeValue_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof"`
}
type Attributes_AttributeValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=double_value,json=doubleValue,proto3,oneof"`
}
type Attributes_AttributeValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,5,opt,name=bool_value,json=boolValue,proto3,oneof"`
}
type Attributes_AttributeValue_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,6,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}
type Attributes_AttributeValue_TimestampValue struct {
	TimestampValue *types.Timestamp `protobuf:"bytes,7,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}
type Attributes_AttributeValue_DurationValue struct {
	DurationValue *types.Duration `protobuf:"bytes,8,opt,name=duration_value,json=durationValue,proto3,oneof"`
}
type Attributes_AttributeValue_StringMapValue struct {
	StringMapValue *Attributes_StringMap `protobuf:"bytes,9,opt,name=string_map_value,json=stringMapValue,proto3,oneof"`
}

func (*Attributes_AttributeValue_StringValue) isAttributes_AttributeValue_Value()    {}
func (*Attributes_AttributeValue_Int64Value) isAttributes_AttributeValue_Value()     {}
func (*Attributes_AttributeValue_DoubleValue) isAttributes_AttributeValue_Value()    {}
func (*Attributes_AttributeValue_BoolValue) isAttributes_AttributeValue_Value()      {}
func (*Attributes_AttributeValue_BytesValue) isAttributes_AttributeValue_Value()     {}
func (*Attributes_AttributeValue_TimestampValue) isAttributes_AttributeValue_Value() {}
func (*Attributes_AttributeValue_DurationValue) isAttributes_AttributeValue_Value()  {}
func (*Attributes_AttributeValue_StringMapValue) isAttributes_AttributeValue_Value() {}

func (m *Attributes_AttributeValue) GetValue() isAttributes_AttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Attributes_AttributeValue) GetStringValue() string {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Attributes_AttributeValue) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *Attributes_AttributeValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Attributes_AttributeValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *Attributes_AttributeValue) GetBytesValue() []byte {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

func (m *Attributes_AttributeValue) GetTimestampValue() *types.Timestamp {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (m *Attributes_AttributeValue) GetDurationValue() *types.Duration {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_DurationValue); ok {
		return x.DurationValue
	}
	return nil
}

func (m *Attributes_AttributeValue) GetStringMapValue() *Attributes_StringMap {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_StringMapValue); ok {
		return x.StringMapValue
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Attributes_AttributeValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Attributes_AttributeValue_OneofMarshaler, _Attributes_AttributeValue_OneofUnmarshaler, _Attributes_AttributeValue_OneofSizer, []interface{}{
		(*Attributes_AttributeValue_StringValue)(nil),
		(*Attributes_AttributeValue_Int64Value)(nil),
		(*Attributes_AttributeValue_DoubleValue)(nil),
		(*Attributes_AttributeValue_BoolValue)(nil),
		(*Attributes_AttributeValue_BytesValue)(nil),
		(*Attributes_AttributeValue_TimestampValue)(nil),
		(*Attributes_AttributeValue_DurationValue)(nil),
		(*Attributes_AttributeValue_StringMapValue)(nil),
	}
}

func _Attributes_AttributeValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Attributes_AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *Attributes_AttributeValue_StringValue:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.StringValue)
	case *Attributes_AttributeValue_Int64Value:
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Int64Value))
	case *Attributes_AttributeValue_DoubleValue:
		_ = b.EncodeVarint(4<<3 | proto.WireFixed64)
		_ = b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *Attributes_AttributeValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		_ = b.EncodeVarint(5<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Attributes_AttributeValue_BytesValue:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.BytesValue)
	case *Attributes_AttributeValue_TimestampValue:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampValue); err != nil {
			return err
		}
	case *Attributes_AttributeValue_DurationValue:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DurationValue); err != nil {
			return err
		}
	case *Attributes_AttributeValue_StringMapValue:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringMapValue); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Attributes_AttributeValue.Value has unexpected type %T", x)
	}
	return nil
}

func _Attributes_AttributeValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Attributes_AttributeValue)
	switch tag {
	case 2: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Attributes_AttributeValue_StringValue{x}
		return true, err
	case 3: // value.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Attributes_AttributeValue_Int64Value{int64(x)}
		return true, err
	case 4: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &Attributes_AttributeValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 5: // value.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Attributes_AttributeValue_BoolValue{x != 0}
		return true, err
	case 6: // value.bytes_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &Attributes_AttributeValue_BytesValue{x}
		return true, err
	case 7: // value.timestamp_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Timestamp)
		err := b.DecodeMessage(msg)
		m.Value = &Attributes_AttributeValue_TimestampValue{msg}
		return true, err
	case 8: // value.duration_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(types.Duration)
		err := b.DecodeMessage(msg)
		m.Value = &Attributes_AttributeValue_DurationValue{msg}
		return true, err
	case 9: // value.string_map_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Attributes_StringMap)
		err := b.DecodeMessage(msg)
		m.Value = &Attributes_AttributeValue_StringMapValue{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Attributes_AttributeValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Attributes_AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *Attributes_AttributeValue_StringValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *Attributes_AttributeValue_Int64Value:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *Attributes_AttributeValue_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case *Attributes_AttributeValue_BoolValue:
		n += 1 // tag and wire
		n += 1
	case *Attributes_AttributeValue_BytesValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BytesValue)))
		n += len(x.BytesValue)
	case *Attributes_AttributeValue_TimestampValue:
		s := proto.Size(x.TimestampValue)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Attributes_AttributeValue_DurationValue:
		s := proto.Size(x.DurationValue)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Attributes_AttributeValue_StringMapValue:
		s := proto.Size(x.StringMapValue)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Defines a string map.
type Attributes_StringMap struct {
	// Holds a set of name/value pairs.
	Entries map[string]string `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Attributes_StringMap) Reset()      { *m = Attributes_StringMap{} }
func (*Attributes_StringMap) ProtoMessage() {}
func (*Attributes_StringMap) Descriptor() ([]byte, []int) {
	return fileDescriptor_6504964367320bd3, []int{0, 2}
}
func (m *Attributes_StringMap) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Attributes_StringMap) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Attributes_StringMap) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Attributes_StringMap.Merge(m, src)
}
func (m *Attributes_StringMap) XXX_Size() int {
	return m.Size()
}
func (m *Attributes_StringMap) XXX_DiscardUnknown() {
	xxx_messageInfo_Attributes_StringMap.DiscardUnknown(m)
}

var xxx_messageInfo_Attributes_StringMap proto.InternalMessageInfo

// Defines a list of attributes in compressed format optimized for transport.
// Within this message, strings are referenced using integer indices into
// one of two string dictionaries. Positive integers index into the global
// deployment-wide dictionary, whereas negative integers index into the message-level
// dictionary instead. The message-level dictionary is carried by the
// `words` field of this message, the deployment-wide dictionary is determined via
// configuration.
type CompressedAttributes struct {
	// The message-level dictionary.
	Words []string `protobuf:"bytes,1,rep,name=words,proto3" json:"words,omitempty"`
	// Holds attributes of type STRING, DNS_NAME, EMAIL_ADDRESS, URI
	Strings map[int32]int32 `protobuf:"bytes,2,rep,name=strings,proto3" json:"strings,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"zigzag32,2,opt,name=value,proto3"`
	// Holds attributes of type INT64
	Int64S map[int32]int64 `protobuf:"bytes,3,rep,name=int64s,proto3" json:"int64s,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Holds attributes of type DOUBLE
	Doubles map[int32]float64 `protobuf:"bytes,4,rep,name=doubles,proto3" json:"doubles,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// Holds attributes of type BOOL
	Bools map[int32]bool `protobuf:"bytes,5,rep,name=bools,proto3" json:"bools,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Holds attributes of type TIMESTAMP
	Timestamps map[int32]time.Time `protobuf:"bytes,6,rep,name=timestamps,proto3,stdtime" json:"timestamps" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Holds attributes of type DURATION
	Durations map[int32]time.Duration `protobuf:"bytes,7,rep,name=durations,proto3,stdduration" json:"durations" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Holds attributes of type BYTES
	Bytes map[int32][]byte `protobuf:"bytes,8,rep,name=bytes,proto3" json:"bytes,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Holds attributes of type STRING_MAP
	StringMaps map[int32]StringMap `protobuf:"bytes,9,rep,name=string_maps,json=stringMaps,proto3" json:"string_maps" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *CompressedAttributes) Reset()      { *m = CompressedAttributes{} }
func (*CompressedAttributes) ProtoMessage() {}
func (*CompressedAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_6504964367320bd3, []int{1}
}
func (m *CompressedAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompressedAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *CompressedAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompressedAttributes.Merge(m, src)
}
func (m *CompressedAttributes) XXX_Size() int {
	return m.Size()
}
func (m *CompressedAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_CompressedAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_CompressedAttributes proto.InternalMessageInfo

// A map of string to string. The keys and values in this map are dictionary
// indices (see the [Attributes][istio.mixer.v1.CompressedAttributes] message for an explanation)
type StringMap struct {
	// Holds a set of name/value pairs.
	Entries map[int32]int32 `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"zigzag32,2,opt,name=value,proto3"`
}

func (m *StringMap) Reset()      { *m = StringMap{} }
func (*StringMap) ProtoMessage() {}
func (*StringMap) Descriptor() ([]byte, []int) {
	return fileDescriptor_6504964367320bd3, []int{2}
}
func (m *StringMap) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringMap) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StringMap) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringMap.Merge(m, src)
}
func (m *StringMap) XXX_Size() int {
	return m.Size()
}
func (m *StringMap) XXX_DiscardUnknown() {
	xxx_messageInfo_StringMap.DiscardUnknown(m)
}

var xxx_messageInfo_StringMap proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Attributes)(nil), "istio.mixer.v1.Attributes")
	proto.RegisterMapType((map[string]*Attributes_AttributeValue)(nil), "istio.mixer.v1.Attributes.AttributesEntry")
	proto.RegisterType((*Attributes_AttributeValue)(nil), "istio.mixer.v1.Attributes.AttributeValue")
	proto.RegisterType((*Attributes_StringMap)(nil), "istio.mixer.v1.Attributes.StringMap")
	proto.RegisterMapType((map[string]string)(nil), "istio.mixer.v1.Attributes.StringMap.EntriesEntry")
	proto.RegisterType((*CompressedAttributes)(nil), "istio.mixer.v1.CompressedAttributes")
	proto.RegisterMapType((map[int32]bool)(nil), "istio.mixer.v1.CompressedAttributes.BoolsEntry")
	proto.RegisterMapType((map[int32][]byte)(nil), "istio.mixer.v1.CompressedAttributes.BytesEntry")
	proto.RegisterMapType((map[int32]float64)(nil), "istio.mixer.v1.CompressedAttributes.DoublesEntry")
	proto.RegisterMapType((map[int32]time.Duration)(nil), "istio.mixer.v1.CompressedAttributes.DurationsEntry")
	proto.RegisterMapType((map[int32]int64)(nil), "istio.mixer.v1.CompressedAttributes.Int64sEntry")
	proto.RegisterMapType((map[int32]StringMap)(nil), "istio.mixer.v1.CompressedAttributes.StringMapsEntry")
	proto.RegisterMapType((map[int32]int32)(nil), "istio.mixer.v1.CompressedAttributes.StringsEntry")
	proto.RegisterMapType((map[int32]time.Time)(nil), "istio.mixer.v1.CompressedAttributes.TimestampsEntry")
	proto.RegisterType((*StringMap)(nil), "istio.mixer.v1.StringMap")
	proto.RegisterMapType((map[int32]int32)(nil), "istio.mixer.v1.StringMap.EntriesEntry")
}

func init() { proto.RegisterFile("mixer/v1/attributes.proto", fileDescriptor_6504964367320bd3) }

var fileDescriptor_6504964367320bd3 = []byte{
	// 816 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x96, 0xbd, 0x6f, 0xd3, 0x4e,
	0x18, 0xc7, 0x7d, 0x4d, 0xf3, 0xe2, 0x27, 0xf9, 0x25, 0xad, 0x95, 0x9f, 0xe4, 0x66, 0xb8, 0x84,
	0x82, 0x50, 0x60, 0xb0, 0xfb, 0x26, 0x54, 0xba, 0x00, 0xa1, 0x91, 0x02, 0x08, 0x09, 0x19, 0x54,
	0x5e, 0x2a, 0x81, 0x12, 0xc5, 0x04, 0x8b, 0x24, 0x8e, 0x7c, 0x4e, 0x21, 0x1b, 0x12, 0x13, 0x5b,
	0x07, 0x06, 0xfe, 0x03, 0xf8, 0x53, 0x3a, 0x76, 0xec, 0x04, 0xc4, 0x5d, 0x58, 0x90, 0x3a, 0x32,
	0x22, 0xdf, 0x9d, 0x9d, 0x4b, 0x48, 0x1b, 0x67, 0xb3, 0xef, 0x9e, 0xef, 0xc7, 0xdf, 0xbb, 0xfb,
	0xde, 0x93, 0xc0, 0x4a, 0xc7, 0x7a, 0x6f, 0x3a, 0xfa, 0xc1, 0xba, 0x5e, 0x77, 0x5d, 0xc7, 0x6a,
	0xf4, 0x5d, 0x93, 0x68, 0x3d, 0xc7, 0x76, 0x6d, 0x25, 0x6b, 0x11, 0xd7, 0xb2, 0x35, 0x5a, 0xa0,
	0x1d, 0xac, 0x17, 0xf2, 0x2d, 0xbb, 0x65, 0xd3, 0x29, 0xdd, 0x7f, 0x62, 0x55, 0x05, 0xdc, 0xb2,
	0xed, 0x56, 0xdb, 0xd4, 0xe9, 0x5b, 0xa3, 0xff, 0x5a, 0x6f, 0xf6, 0x9d, 0xba, 0x6b, 0xd9, 0x5d,
	0x3e, 0x5f, 0x9c, 0x9c, 0x77, 0xad, 0x8e, 0x49, 0xdc, 0x7a, 0xa7, 0xc7, 0x0a, 0x56, 0x3f, 0x26,
	0x00, 0xee, 0x84, 0xdf, 0x56, 0xee, 0x03, 0x8c, 0x9c, 0xa8, 0xa8, 0x14, 0x2b, 0xa7, 0x37, 0xae,
	0x6b, 0xe3, 0x56, 0xb4, 0x51, 0xbd, 0xf0, 0x58, 0xed, 0xba, 0xce, 0xc0, 0x10, 0xd4, 0x85, 0x37,
	0x90, 0x9b, 0x98, 0x56, 0x96, 0x20, 0xf6, 0xd6, 0x1c, 0xa8, 0xa8, 0x84, 0xca, 0xb2, 0xe1, 0x3f,
	0x2a, 0xb7, 0x20, 0x7e, 0x50, 0x6f, 0xf7, 0x4d, 0x75, 0xa1, 0x84, 0xca, 0xe9, 0x8d, 0x6b, 0x51,
	0xbe, 0xb5, 0xe7, 0x0b, 0x0c, 0xa6, 0xdb, 0x59, 0xd8, 0x46, 0x85, 0xaf, 0x31, 0xc8, 0x8e, 0xcf,
	0x2a, 0x97, 0x21, 0x43, 0x5c, 0xc7, 0xea, 0xb6, 0x5e, 0x8d, 0xf0, 0x72, 0x4d, 0x32, 0xd2, 0x6c,
	0x94, 0x15, 0x5d, 0x82, 0xb4, 0xd5, 0x75, 0x6f, 0x6c, 0xf1, 0x9a, 0x58, 0x09, 0x95, 0x63, 0x35,
	0xc9, 0x00, 0x3a, 0x18, 0x72, 0x9a, 0x76, 0xbf, 0xd1, 0x36, 0x79, 0xcd, 0x62, 0x09, 0x95, 0x91,
	0xcf, 0x61, 0xa3, 0xac, 0xa8, 0x08, 0xd0, 0xb0, 0xed, 0x36, 0x2f, 0x89, 0x97, 0x50, 0x39, 0x55,
	0x93, 0x0c, 0xd9, 0x1f, 0x0b, 0x3f, 0xd4, 0x18, 0xb8, 0x26, 0xe1, 0x15, 0x89, 0x12, 0x2a, 0x67,
	0xfc, 0x0f, 0xd1, 0x41, 0x56, 0x52, 0x85, 0x5c, 0x78, 0x36, 0xbc, 0x2c, 0x49, 0xb7, 0xa4, 0xa0,
	0xb1, 0x33, 0xd4, 0x82, 0x33, 0xd4, 0x9e, 0x04, 0x75, 0x35, 0xc9, 0xc8, 0x86, 0x22, 0x86, 0xa9,
	0x40, 0x36, 0x88, 0x00, 0xa7, 0xa4, 0x28, 0x65, 0xe5, 0x1f, 0xca, 0x2e, 0x2f, 0xab, 0x49, 0xc6,
	0x7f, 0x81, 0x84, 0x31, 0x1e, 0xc1, 0x12, 0xdf, 0xbb, 0x4e, 0x3d, 0xf0, 0x22, 0x53, 0xca, 0x95,
	0x0b, 0x8e, 0xe7, 0x31, 0x95, 0x3c, 0xac, 0x53, 0x57, 0x24, 0x78, 0xa1, 0xc4, 0x4a, 0x92, 0x9f,
	0x72, 0xe1, 0x33, 0x02, 0x39, 0x2c, 0x54, 0x1e, 0x40, 0xd2, 0xec, 0xba, 0x8e, 0x15, 0x46, 0x6d,
	0x3d, 0x0a, 0x5f, 0xab, 0x32, 0x0d, 0x4b, 0x5c, 0x40, 0x28, 0xec, 0x40, 0x46, 0x9c, 0x98, 0x92,
	0xb5, 0xbc, 0x98, 0x35, 0x59, 0x08, 0xd0, 0xea, 0x6f, 0x19, 0xf2, 0x77, 0xed, 0x4e, 0xcf, 0x31,
	0x09, 0x31, 0x9b, 0xc2, 0x7d, 0xc8, 0x43, 0xfc, 0x9d, 0xed, 0x34, 0x99, 0x3f, 0xd9, 0x60, 0x2f,
	0xbe, 0x6f, 0xb6, 0x40, 0xa2, 0x2e, 0x4c, 0xf7, 0x3d, 0x0d, 0xc6, 0x57, 0x10, 0xf8, 0xe6, 0x04,
	0xa5, 0x06, 0x09, 0x9a, 0x37, 0xa2, 0xc6, 0x28, 0x6b, 0x2d, 0x12, 0xeb, 0x1e, 0x95, 0x30, 0x14,
	0xd7, 0xfb, 0xb6, 0x58, 0x2a, 0x89, 0xba, 0x38, 0x87, 0xad, 0x5d, 0xa6, 0xe1, 0xb6, 0x38, 0x41,
	0xa9, 0x42, 0xdc, 0xcf, 0x2f, 0x51, 0xe3, 0x14, 0xa5, 0x47, 0x42, 0x55, 0x7c, 0x05, 0x03, 0x31,
	0xb5, 0xf2, 0x12, 0x20, 0x4c, 0x28, 0x51, 0x13, 0x94, 0xb5, 0x15, 0x89, 0x15, 0xa6, 0x9c, 0x01,
	0x2b, 0xa9, 0xa3, 0xef, 0x45, 0xe9, 0xf0, 0x47, 0x11, 0x19, 0x02, 0x51, 0xd9, 0x07, 0x39, 0x08,
	0x2f, 0x51, 0x93, 0x14, 0xbf, 0x19, 0x6d, 0xd5, 0x81, 0x4a, 0xa0, 0x7f, 0xf1, 0xe9, 0x23, 0x1e,
	0xdd, 0x03, 0xff, 0x86, 0xaa, 0xa9, 0x79, 0xf6, 0x60, 0x10, 0x76, 0x43, 0xa6, 0x56, 0xf6, 0x21,
	0x3d, 0xba, 0x4f, 0x44, 0x95, 0xe7, 0xd8, 0x84, 0x30, 0xf4, 0xdc, 0xe6, 0xa2, 0x6f, 0xd3, 0x80,
	0xf0, 0x7a, 0xd1, 0xd8, 0x8b, 0xb9, 0x12, 0x63, 0xbf, 0x3c, 0x25, 0xf6, 0xcb, 0x62, 0xdf, 0xbc,
	0x09, 0x69, 0x21, 0x47, 0xb3, 0xa4, 0x31, 0x51, 0xba, 0x03, 0x19, 0x31, 0x37, 0xb3, 0xb4, 0x48,
	0xd4, 0x6e, 0x03, 0x8c, 0x82, 0x32, 0x4b, 0x99, 0x12, 0x95, 0xcf, 0x21, 0x37, 0x11, 0x8b, 0x29,
	0xf2, 0xb5, 0xf1, 0x9f, 0x94, 0x0b, 0xfa, 0xa7, 0x88, 0x7e, 0x0a, 0xd9, 0xf1, 0x48, 0x4c, 0x21,
	0xeb, 0xe3, 0xe4, 0xf3, 0x7b, 0xea, 0xe4, 0x6a, 0x07, 0x6e, 0xc4, 0x7d, 0xca, 0x88, 0xca, 0x67,
	0x90, 0x9b, 0x38, 0xff, 0x28, 0x9e, 0x26, 0x62, 0x15, 0x12, 0xc4, 0x7e, 0xf7, 0x69, 0xac, 0x0d,
	0xdf, 0x9e, 0x6c, 0xc3, 0x57, 0xcf, 0x85, 0xcc, 0xdf, 0x7b, 0x67, 0x85, 0xb0, 0xb2, 0x77, 0x34,
	0xc4, 0xd2, 0xf1, 0x10, 0x4b, 0x27, 0x43, 0x2c, 0x9d, 0x0d, 0xb1, 0xf4, 0xc1, 0xc3, 0xe8, 0x9b,
	0x87, 0xa5, 0x23, 0x0f, 0xa3, 0x63, 0x0f, 0xa3, 0x13, 0x0f, 0xa3, 0x9f, 0x1e, 0x46, 0xbf, 0x3c,
	0x2c, 0x9d, 0x79, 0x18, 0x1d, 0x9e, 0x62, 0xe9, 0xf8, 0x14, 0x4b, 0x27, 0xa7, 0x58, 0x7a, 0xf1,
	0x3f, 0x73, 0x6a, 0xd9, 0x7a, 0xbd, 0x67, 0xe9, 0xc1, 0xdf, 0xa9, 0x3f, 0x08, 0x35, 0x12, 0xf4,
	0x54, 0x36, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0xfb, 0xc0, 0x1f, 0x1b, 0x64, 0x09, 0x00, 0x00,
}

func (m *Attributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		keysForAttributes := make([]string, 0, len(m.Attributes))
		for k, _ := range m.Attributes {
			keysForAttributes = append(keysForAttributes, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForAttributes)
		for _, k := range keysForAttributes {
			dAtA[i] = 0xa
			i++
			v := m.Attributes[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAttributes(uint64(len(k))) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintAttributes(dAtA, i, uint64(v.Size()))
				n1, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n1
			}
		}
	}
	return i, nil
}

func (m *Attributes_AttributeValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes_AttributeValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn2, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn2
	}
	return i, nil
}

func (m *Attributes_AttributeValue_StringValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintAttributes(dAtA, i, uint64(len(m.StringValue)))
	i += copy(dAtA[i:], m.StringValue)
	return i, nil
}
func (m *Attributes_AttributeValue_Int64Value) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	i = encodeVarintAttributes(dAtA, i, uint64(m.Int64Value))
	return i, nil
}
func (m *Attributes_AttributeValue_DoubleValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x21
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoubleValue))))
	i += 8
	return i, nil
}
func (m *Attributes_AttributeValue_BoolValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x28
	i++
	if m.BoolValue {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *Attributes_AttributeValue_BytesValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BytesValue != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(len(m.BytesValue)))
		i += copy(dAtA[i:], m.BytesValue)
	}
	return i, nil
}
func (m *Attributes_AttributeValue_TimestampValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TimestampValue != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(m.TimestampValue.Size()))
		n3, err := m.TimestampValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Attributes_AttributeValue_DurationValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DurationValue != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(m.DurationValue.Size()))
		n4, err := m.DurationValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Attributes_AttributeValue_StringMapValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StringMapValue != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(m.StringMapValue.Size()))
		n5, err := m.StringMapValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Attributes_StringMap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes_StringMap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		keysForEntries := make([]string, 0, len(m.Entries))
		for k, _ := range m.Entries {
			keysForEntries = append(keysForEntries, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForEntries)
		for _, k := range keysForEntries {
			dAtA[i] = 0xa
			i++
			v := m.Entries[string(k)]
			mapSize := 1 + len(k) + sovAttributes(uint64(len(k))) + 1 + len(v) + sovAttributes(uint64(len(v)))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *CompressedAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompressedAttributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Strings) > 0 {
		keysForStrings := make([]int32, 0, len(m.Strings))
		for k, _ := range m.Strings {
			keysForStrings = append(keysForStrings, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForStrings)
		for _, k := range keysForStrings {
			dAtA[i] = 0x12
			i++
			v := m.Strings[int32(k)]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(v)<<1)^uint32((v>>31))))
		}
	}
	if len(m.Int64S) > 0 {
		keysForInt64S := make([]int32, 0, len(m.Int64S))
		for k, _ := range m.Int64S {
			keysForInt64S = append(keysForInt64S, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForInt64S)
		for _, k := range keysForInt64S {
			dAtA[i] = 0x1a
			i++
			v := m.Int64S[int32(k)]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + sovAttributes(uint64(v))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(v))
		}
	}
	if len(m.Doubles) > 0 {
		keysForDoubles := make([]int32, 0, len(m.Doubles))
		for k, _ := range m.Doubles {
			keysForDoubles = append(keysForDoubles, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForDoubles)
		for _, k := range keysForDoubles {
			dAtA[i] = 0x22
			i++
			v := m.Doubles[int32(k)]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + 8
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x11
			i++
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i += 8
		}
	}
	if len(m.Bools) > 0 {
		keysForBools := make([]int32, 0, len(m.Bools))
		for k, _ := range m.Bools {
			keysForBools = append(keysForBools, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForBools)
		for _, k := range keysForBools {
			dAtA[i] = 0x2a
			i++
			v := m.Bools[int32(k)]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + 1
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			if v {
				dAtA[i] = 1
			} else {
				dAtA[i] = 0
			}
			i++
		}
	}
	if len(m.Timestamps) > 0 {
		keysForTimestamps := make([]int32, 0, len(m.Timestamps))
		for k, _ := range m.Timestamps {
			keysForTimestamps = append(keysForTimestamps, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForTimestamps)
		for _, k := range keysForTimestamps {
			dAtA[i] = 0x32
			i++
			v := m.Timestamps[int32(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = github_com_gogo_protobuf_types.SizeOfStdTime(*(&v))
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(*(&v))))
			n6, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(*(&v), dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n6
		}
	}
	if len(m.Durations) > 0 {
		keysForDurations := make([]int32, 0, len(m.Durations))
		for k, _ := range m.Durations {
			keysForDurations = append(keysForDurations, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForDurations)
		for _, k := range keysForDurations {
			dAtA[i] = 0x3a
			i++
			v := m.Durations[int32(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = github_com_gogo_protobuf_types.SizeOfStdDuration(*(&v))
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*(&v))))
			n7, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*(&v), dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n7
		}
	}
	if len(m.Bytes) > 0 {
		keysForBytes := make([]int32, 0, len(m.Bytes))
		for k, _ := range m.Bytes {
			keysForBytes = append(keysForBytes, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForBytes)
		for _, k := range keysForBytes {
			dAtA[i] = 0x42
			i++
			v := m.Bytes[int32(k)]
			byteSize := 0
			if len(v) > 0 {
				byteSize = 1 + len(v) + sovAttributes(uint64(len(v)))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + byteSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			if len(v) > 0 {
				dAtA[i] = 0x12
				i++
				i = encodeVarintAttributes(dAtA, i, uint64(len(v)))
				i += copy(dAtA[i:], v)
			}
		}
	}
	if len(m.StringMaps) > 0 {
		keysForStringMaps := make([]int32, 0, len(m.StringMaps))
		for k, _ := range m.StringMaps {
			keysForStringMaps = append(keysForStringMaps, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForStringMaps)
		for _, k := range keysForStringMaps {
			dAtA[i] = 0x4a
			i++
			v := m.StringMaps[int32(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((&v).Size()))
			n8, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n8
		}
	}
	return i, nil
}

func (m *StringMap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringMap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		keysForEntries := make([]int32, 0, len(m.Entries))
		for k, _ := range m.Entries {
			keysForEntries = append(keysForEntries, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForEntries)
		for _, k := range keysForEntries {
			dAtA[i] = 0xa
			i++
			v := m.Entries[int32(k)]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(v)<<1)^uint32((v>>31))))
		}
	}
	return i, nil
}

func encodeVarintAttributes(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Attributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for k, v := range m.Attributes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovAttributes(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovAttributes(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Attributes_AttributeValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *Attributes_AttributeValue_StringValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StringValue)
	n += 1 + l + sovAttributes(uint64(l))
	return n
}
func (m *Attributes_AttributeValue_Int64Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovAttributes(uint64(m.Int64Value))
	return n
}
func (m *Attributes_AttributeValue_DoubleValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *Attributes_AttributeValue_BoolValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *Attributes_AttributeValue_BytesValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BytesValue != nil {
		l = len(m.BytesValue)
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_AttributeValue_TimestampValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimestampValue != nil {
		l = m.TimestampValue.Size()
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_AttributeValue_DurationValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DurationValue != nil {
		l = m.DurationValue.Size()
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_AttributeValue_StringMapValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StringMapValue != nil {
		l = m.StringMapValue.Size()
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_StringMap) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for k, v := range m.Entries {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAttributes(uint64(len(k))) + 1 + len(v) + sovAttributes(uint64(len(v)))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CompressedAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			l = len(s)
			n += 1 + l + sovAttributes(uint64(l))
		}
	}
	if len(m.Strings) > 0 {
		for k, v := range m.Strings {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Int64S) > 0 {
		for k, v := range m.Int64S {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + sovAttributes(uint64(v))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Doubles) > 0 {
		for k, v := range m.Doubles {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + 8
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Bools) > 0 {
		for k, v := range m.Bools {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + 1
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Timestamps) > 0 {
		for k, v := range m.Timestamps {
			_ = k
			_ = v
			l = github_com_gogo_protobuf_types.SizeOfStdTime(v)
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + l + sovAttributes(uint64(l))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Durations) > 0 {
		for k, v := range m.Durations {
			_ = k
			_ = v
			l = github_com_gogo_protobuf_types.SizeOfStdDuration(v)
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + l + sovAttributes(uint64(l))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Bytes) > 0 {
		for k, v := range m.Bytes {
			_ = k
			_ = v
			l = 0
			if len(v) > 0 {
				l = 1 + len(v) + sovAttributes(uint64(len(v)))
			}
			mapEntrySize := 1 + sozAttributes(uint64(k)) + l
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.StringMaps) > 0 {
		for k, v := range m.StringMaps {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + l + sovAttributes(uint64(l))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *StringMap) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for k, v := range m.Entries {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func sovAttributes(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAttributes(x uint64) (n int) {
	return sovAttributes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Attributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForAttributes := make([]string, 0, len(this.Attributes))
	for k, _ := range this.Attributes {
		keysForAttributes = append(keysForAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAttributes)
	mapStringForAttributes := "map[string]*Attributes_AttributeValue{"
	for _, k := range keysForAttributes {
		mapStringForAttributes += fmt.Sprintf("%v: %v,", k, this.Attributes[k])
	}
	mapStringForAttributes += "}"
	s := strings.Join([]string{`&Attributes{`,
		`Attributes:` + mapStringForAttributes + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_StringValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_StringValue{`,
		`StringValue:` + fmt.Sprintf("%v", this.StringValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_Int64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_Int64Value{`,
		`Int64Value:` + fmt.Sprintf("%v", this.Int64Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_DoubleValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_DoubleValue{`,
		`DoubleValue:` + fmt.Sprintf("%v", this.DoubleValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_BoolValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_BoolValue{`,
		`BoolValue:` + fmt.Sprintf("%v", this.BoolValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_BytesValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_BytesValue{`,
		`BytesValue:` + fmt.Sprintf("%v", this.BytesValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_TimestampValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_TimestampValue{`,
		`TimestampValue:` + strings.Replace(fmt.Sprintf("%v", this.TimestampValue), "Timestamp", "types.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_DurationValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_DurationValue{`,
		`DurationValue:` + strings.Replace(fmt.Sprintf("%v", this.DurationValue), "Duration", "types.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_StringMapValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_StringMapValue{`,
		`StringMapValue:` + strings.Replace(fmt.Sprintf("%v", this.StringMapValue), "Attributes_StringMap", "Attributes_StringMap", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_StringMap) String() string {
	if this == nil {
		return "nil"
	}
	keysForEntries := make([]string, 0, len(this.Entries))
	for k, _ := range this.Entries {
		keysForEntries = append(keysForEntries, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForEntries)
	mapStringForEntries := "map[string]string{"
	for _, k := range keysForEntries {
		mapStringForEntries += fmt.Sprintf("%v: %v,", k, this.Entries[k])
	}
	mapStringForEntries += "}"
	s := strings.Join([]string{`&Attributes_StringMap{`,
		`Entries:` + mapStringForEntries + `,`,
		`}`,
	}, "")
	return s
}
func (this *CompressedAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForStrings := make([]int32, 0, len(this.Strings))
	for k, _ := range this.Strings {
		keysForStrings = append(keysForStrings, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForStrings)
	mapStringForStrings := "map[int32]int32{"
	for _, k := range keysForStrings {
		mapStringForStrings += fmt.Sprintf("%v: %v,", k, this.Strings[k])
	}
	mapStringForStrings += "}"
	keysForInt64S := make([]int32, 0, len(this.Int64S))
	for k, _ := range this.Int64S {
		keysForInt64S = append(keysForInt64S, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForInt64S)
	mapStringForInt64S := "map[int32]int64{"
	for _, k := range keysForInt64S {
		mapStringForInt64S += fmt.Sprintf("%v: %v,", k, this.Int64S[k])
	}
	mapStringForInt64S += "}"
	keysForDoubles := make([]int32, 0, len(this.Doubles))
	for k, _ := range this.Doubles {
		keysForDoubles = append(keysForDoubles, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForDoubles)
	mapStringForDoubles := "map[int32]float64{"
	for _, k := range keysForDoubles {
		mapStringForDoubles += fmt.Sprintf("%v: %v,", k, this.Doubles[k])
	}
	mapStringForDoubles += "}"
	keysForBools := make([]int32, 0, len(this.Bools))
	for k, _ := range this.Bools {
		keysForBools = append(keysForBools, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForBools)
	mapStringForBools := "map[int32]bool{"
	for _, k := range keysForBools {
		mapStringForBools += fmt.Sprintf("%v: %v,", k, this.Bools[k])
	}
	mapStringForBools += "}"
	keysForTimestamps := make([]int32, 0, len(this.Timestamps))
	for k, _ := range this.Timestamps {
		keysForTimestamps = append(keysForTimestamps, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForTimestamps)
	mapStringForTimestamps := "map[int32]time.Time{"
	for _, k := range keysForTimestamps {
		mapStringForTimestamps += fmt.Sprintf("%v: %v,", k, this.Timestamps[k])
	}
	mapStringForTimestamps += "}"
	keysForDurations := make([]int32, 0, len(this.Durations))
	for k, _ := range this.Durations {
		keysForDurations = append(keysForDurations, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForDurations)
	mapStringForDurations := "map[int32]time.Duration{"
	for _, k := range keysForDurations {
		mapStringForDurations += fmt.Sprintf("%v: %v,", k, this.Durations[k])
	}
	mapStringForDurations += "}"
	keysForBytes := make([]int32, 0, len(this.Bytes))
	for k, _ := range this.Bytes {
		keysForBytes = append(keysForBytes, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForBytes)
	mapStringForBytes := "map[int32][]byte{"
	for _, k := range keysForBytes {
		mapStringForBytes += fmt.Sprintf("%v: %v,", k, this.Bytes[k])
	}
	mapStringForBytes += "}"
	keysForStringMaps := make([]int32, 0, len(this.StringMaps))
	for k, _ := range this.StringMaps {
		keysForStringMaps = append(keysForStringMaps, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForStringMaps)
	mapStringForStringMaps := "map[int32]StringMap{"
	for _, k := range keysForStringMaps {
		mapStringForStringMaps += fmt.Sprintf("%v: %v,", k, this.StringMaps[k])
	}
	mapStringForStringMaps += "}"
	s := strings.Join([]string{`&CompressedAttributes{`,
		`Words:` + fmt.Sprintf("%v", this.Words) + `,`,
		`Strings:` + mapStringForStrings + `,`,
		`Int64S:` + mapStringForInt64S + `,`,
		`Doubles:` + mapStringForDoubles + `,`,
		`Bools:` + mapStringForBools + `,`,
		`Timestamps:` + mapStringForTimestamps + `,`,
		`Durations:` + mapStringForDurations + `,`,
		`Bytes:` + mapStringForBytes + `,`,
		`StringMaps:` + mapStringForStringMaps + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMap) String() string {
	if this == nil {
		return "nil"
	}
	keysForEntries := make([]int32, 0, len(this.Entries))
	for k, _ := range this.Entries {
		keysForEntries = append(keysForEntries, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForEntries)
	mapStringForEntries := "map[int32]int32{"
	for _, k := range keysForEntries {
		mapStringForEntries += fmt.Sprintf("%v: %v,", k, this.Entries[k])
	}
	mapStringForEntries += "}"
	s := strings.Join([]string{`&StringMap{`,
		`Entries:` + mapStringForEntries + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAttributes(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Attributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = make(map[string]*Attributes_AttributeValue)
			}
			var mapkey string
			var mapvalue *Attributes_AttributeValue
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAttributes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAttributes
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Attributes_AttributeValue{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attributes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Attributes_AttributeValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Attributes_AttributeValue_StringValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Value", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &Attributes_AttributeValue_Int64Value{v}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Attributes_AttributeValue_DoubleValue{float64(math.Float64frombits(v))}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Value = &Attributes_AttributeValue_BoolValue{b}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Value = &Attributes_AttributeValue_BytesValue{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Timestamp{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Attributes_AttributeValue_TimestampValue{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Duration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Attributes_AttributeValue_DurationValue{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringMapValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Attributes_StringMap{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Attributes_AttributeValue_StringMapValue{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Attributes_StringMap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entries == nil {
				m.Entries = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAttributes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAttributes
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAttributes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAttributes
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Entries[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CompressedAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CompressedAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CompressedAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Words", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Words = append(m.Words, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Strings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Strings == nil {
				m.Strings = make(map[int32]int32)
			}
			var mapkey int32
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvaluetemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapvaluetemp = int32((uint32(mapvaluetemp) >> 1) ^ uint32(((mapvaluetemp&1)<<31)>>31))
					mapvalue = int32(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Strings[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64S", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Int64S == nil {
				m.Int64S = make(map[int32]int64)
			}
			var mapkey int32
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Int64S[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Doubles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Doubles == nil {
				m.Doubles = make(map[int32]float64)
			}
			var mapkey int32
			var mapvalue float64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					mapvaluetemp = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					mapvalue = math.Float64frombits(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Doubles[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bools", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bools == nil {
				m.Bools = make(map[int32]bool)
			}
			var mapkey int32
			var mapvalue bool
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvaluetemp |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapvalue = bool(mapvaluetemp != 0)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Bools[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamps == nil {
				m.Timestamps = make(map[int32]time.Time)
			}
			var mapkey int32
			mapvalue := new(time.Time)
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(mapvalue, dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Timestamps[mapkey] = *mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Durations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Durations == nil {
				m.Durations = make(map[int32]time.Duration)
			}
			var mapkey int32
			mapvalue := new(time.Duration)
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(mapvalue, dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Durations[mapkey] = *mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bytes == nil {
				m.Bytes = make(map[int32][]byte)
			}
			var mapkey int32
			mapvalue := []byte{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapbyteLen uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapbyteLen |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intMapbyteLen := int(mapbyteLen)
					if intMapbyteLen < 0 {
						return ErrInvalidLengthAttributes
					}
					postbytesIndex := iNdEx + intMapbyteLen
					if postbytesIndex < 0 {
						return ErrInvalidLengthAttributes
					}
					if postbytesIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = make([]byte, mapbyteLen)
					copy(mapvalue, dAtA[iNdEx:postbytesIndex])
					iNdEx = postbytesIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Bytes[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringMaps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StringMaps == nil {
				m.StringMaps = make(map[int32]StringMap)
			}
			var mapkey int32
			mapvalue := &StringMap{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &StringMap{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.StringMaps[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringMap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAttributes
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entries == nil {
				m.Entries = make(map[int32]int32)
			}
			var mapkey int32
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvaluetemp |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapvaluetemp = int32((uint32(mapvaluetemp) >> 1) ^ uint32(((mapvaluetemp&1)<<31)>>31))
					mapvalue = int32(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Entries[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAttributes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAttributes
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthAttributes
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAttributes(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthAttributes
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAttributes = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAttributes   = fmt.Errorf("proto: integer overflow")
)
