// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: policy/v1beta1/cfg.proto

package v1beta1

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Header operation type.
type Rule_HeaderOperationTemplate_Operation int32

const (
	// Replace a header by name.
	REPLACE Rule_HeaderOperationTemplate_Operation = 0
	// Remove a header by name. Values are ignored.
	REMOVE Rule_HeaderOperationTemplate_Operation = 1
	// Append values to the existing header values.
	APPEND Rule_HeaderOperationTemplate_Operation = 2
)

var Rule_HeaderOperationTemplate_Operation_name = map[int32]string{
	0: "REPLACE",
	1: "REMOVE",
	2: "APPEND",
}

var Rule_HeaderOperationTemplate_Operation_value = map[string]int32{
	"REPLACE": 0,
	"REMOVE":  1,
	"APPEND":  2,
}

func (Rule_HeaderOperationTemplate_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{1, 0, 0}
}

// Fraction percentages support several fixed denominator values.
type FractionalPercent_DenominatorType int32

const (
	// 100.
	//
	// **Example**: 1/100 = 1%.
	HUNDRED FractionalPercent_DenominatorType = 0
	// 10,000.
	//
	// **Example**: 1/10000 = 0.01%.
	TEN_THOUSAND FractionalPercent_DenominatorType = 1
)

var FractionalPercent_DenominatorType_name = map[int32]string{
	0: "HUNDRED",
	1: "TEN_THOUSAND",
}

var FractionalPercent_DenominatorType_value = map[string]int32{
	"HUNDRED":      0,
	"TEN_THOUSAND": 1,
}

func (FractionalPercent_DenominatorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{9, 0}
}

// AuthHeader specifies how to pass access token with authorization header.
type Tls_AuthHeader int32

const (
	// Access token is passed in authorization header as what it is
	// (authorization: some-token).
	PLAIN Tls_AuthHeader = 0
	// Access token is passed to adapter as bearer token (i.e. authorization:
	// bearer some-token).
	BEARER Tls_AuthHeader = 1
)

var Tls_AuthHeader_name = map[int32]string{
	0: "PLAIN",
	1: "BEARER",
}

var Tls_AuthHeader_value = map[string]int32{
	"PLAIN":  0,
	"BEARER": 1,
}

func (Tls_AuthHeader) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{11, 0}
}

// AttributeManifest describes a set of Attributes produced by some component
// of an Istio deployment.
type AttributeManifest struct {
	// Optional. The revision of this document. Assigned by server.
	Revision string `protobuf:"bytes,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// Required. Name of the component producing these attributes. This can be
	// the proxy (with the canonical name `istio-proxy`) or the name of an
	// `attributes` kind adapter in Mixer.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The set of attributes this Istio component will be responsible for producing at runtime.
	// We map from attribute name to the attribute's specification. The name of an attribute,
	// which is how attributes are referred to in aspect configuration, must conform to:
	//
	//     Name = IDENT { SEPARATOR IDENT };
	//
	// Where `IDENT` must match the regular expression `[a-z][a-z0-9]+` and `SEPARATOR` must
	// match the regular expression `[\.-]`.
	//
	// Attribute names must be unique within a single Istio deployment. The set of canonical
	// attributes are described at [here](https://istio.io/docs/reference/config/policy-and-telemetry/attribute-vocabulary/).
	// Attributes not in that list should be named with a component-specific suffix such as
	// `request.count-my.component`.
	Attributes map[string]*AttributeManifest_AttributeInfo `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *AttributeManifest) Reset()      { *m = AttributeManifest{} }
func (*AttributeManifest) ProtoMessage() {}
func (*AttributeManifest) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{0}
}
func (m *AttributeManifest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeManifest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttributeManifest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttributeManifest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeManifest.Merge(m, src)
}
func (m *AttributeManifest) XXX_Size() int {
	return m.Size()
}
func (m *AttributeManifest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeManifest.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeManifest proto.InternalMessageInfo

func (m *AttributeManifest) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *AttributeManifest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AttributeManifest) GetAttributes() map[string]*AttributeManifest_AttributeInfo {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// AttributeInfo describes the schema of an Istio `Attribute`.
//
// # Istio Attributes
//
// Istio uses `attributes` to describe runtime activities of Istio services.
// An Istio attribute carries a specific piece of information about an activity,
// such as the error code of an API request, the latency of an API request, or the
// original IP address of a TCP connection. The attributes are often generated
// and consumed by different services. For example, a frontend service can
// generate an authenticated user attribute and pass it to a backend service for
// access control purpose.
//
// To simplify the system and improve developer experience, Istio uses
// shared attribute definitions across all components. For example, the same
// authenticated user attribute will be used for logging, monitoring, analytics,
// billing, access control, auditing. Many Istio components provide their
// functionality by collecting, generating, and operating on attributes.
// For example, the proxy collects the error code attribute, and the logging
// stores it into a log.
//
// # Design
//
// Each Istio attribute must conform to an `AttributeInfo` in an
// `AttributeManifest` in the current Istio deployment at runtime. An
// [`AttributeInfo`][istio.policy.v1beta1] is used to define an attribute's
// metadata: the type of its value and a detailed description that explains
// the semantics of the attribute type. Each attribute's name is globally unique;
// in other words an attribute name can only appear once across all manifests.
//
// The runtime presentation of an attribute is intentionally left out of this
// specification, because passing attribute using JSON, XML, or Protocol Buffers
// does not change the semantics of the attribute. Different implementations
// can choose different representations based on their needs.
//
// # HTTP Mapping
//
// Because many systems already have REST APIs, it makes sense to define a
// standard HTTP mapping for Istio attributes that are compatible with typical
// REST APIs. The design is to map one attribute to one HTTP header, the
// attribute name and value becomes the HTTP header name and value. The actual
// encoding scheme will be decided later.
type AttributeManifest_AttributeInfo struct {
	// Optional. A human-readable description of the attribute's purpose.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The type of data carried by this attribute.
	ValueType ValueType `protobuf:"varint,2,opt,name=value_type,json=valueType,proto3,enum=istio.policy.v1beta1.ValueType" json:"value_type,omitempty"`
}

func (m *AttributeManifest_AttributeInfo) Reset()      { *m = AttributeManifest_AttributeInfo{} }
func (*AttributeManifest_AttributeInfo) ProtoMessage() {}
func (*AttributeManifest_AttributeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{0, 0}
}
func (m *AttributeManifest_AttributeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttributeManifest_AttributeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttributeManifest_AttributeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttributeManifest_AttributeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeManifest_AttributeInfo.Merge(m, src)
}
func (m *AttributeManifest_AttributeInfo) XXX_Size() int {
	return m.Size()
}
func (m *AttributeManifest_AttributeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeManifest_AttributeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeManifest_AttributeInfo proto.InternalMessageInfo

func (m *AttributeManifest_AttributeInfo) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AttributeManifest_AttributeInfo) GetValueType() ValueType {
	if m != nil {
		return m.ValueType
	}
	return VALUE_TYPE_UNSPECIFIED
}

// A Rule is a selector and a set of intentions to be executed when the
// selector is `true`
//
// The following example instructs Mixer to invoke `prometheus-handler` handler for all services and pass it the
// instance constructed using the 'RequestCountByService' instance.
//
// ```yaml
// - match: match(destination.service.host, "*")
//   actions:
//   - handler: prometheus-handler
//     instances:
//     - RequestCountByService
// ```
type Rule struct {
	// Required. Match is an attribute based predicate. When Mixer receives a
	// request it evaluates the match expression and executes all the associated `actions`
	// if the match evaluates to true.
	//
	// A few example match:
	//
	// * an empty match evaluates to `true`
	// * `true`, a boolean literal; a rule with this match will always be executed
	// * `match(destination.service.host, "ratings.*)` selects any request targeting a service whose
	// name starts with "ratings"
	// * `attr1 == "20" && attr2 == "30"` logical AND, OR, and NOT are also available
	Match string `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// Optional. The actions that will be executed when match evaluates to `true`.
	Actions []*Action `protobuf:"bytes,2,rep,name=actions,proto3" json:"actions,omitempty"`
	// Optional. Templatized operations on the request headers using values produced by the
	// rule actions. Require the check action result to be OK.
	RequestHeaderOperations []*Rule_HeaderOperationTemplate `protobuf:"bytes,3,rep,name=request_header_operations,json=requestHeaderOperations,proto3" json:"request_header_operations,omitempty"`
	// Optional. Templatized operations on the response headers using values produced by the
	// rule actions. Require the check action result to be OK.
	ResponseHeaderOperations []*Rule_HeaderOperationTemplate `protobuf:"bytes,4,rep,name=response_header_operations,json=responseHeaderOperations,proto3" json:"response_header_operations,omitempty"`
	// $hide_from_docs
	// Optional. Provides the ability to add a sampling configuration for Mixer rules. This sampling
	// will limit the scenarios in which the `actions` of the rule are executed. The sampling will
	// only take place after a `match` predicate has evaluated to true.
	//
	// Default behavior is no sampling (the `actions` are executed for all requests).
	Sampling *Sampling `protobuf:"bytes,5,opt,name=sampling,proto3" json:"sampling,omitempty"`
}

func (m *Rule) Reset()      { *m = Rule{} }
func (*Rule) ProtoMessage() {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{1}
}
func (m *Rule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(m, src)
}
func (m *Rule) XXX_Size() int {
	return m.Size()
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

func (m *Rule) GetMatch() string {
	if m != nil {
		return m.Match
	}
	return ""
}

func (m *Rule) GetActions() []*Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

func (m *Rule) GetRequestHeaderOperations() []*Rule_HeaderOperationTemplate {
	if m != nil {
		return m.RequestHeaderOperations
	}
	return nil
}

func (m *Rule) GetResponseHeaderOperations() []*Rule_HeaderOperationTemplate {
	if m != nil {
		return m.ResponseHeaderOperations
	}
	return nil
}

func (m *Rule) GetSampling() *Sampling {
	if m != nil {
		return m.Sampling
	}
	return nil
}

// A template for an HTTP header manipulation. Values in the template are expressions
// that may reference action outputs by name. For example, if an action `x` produces an output
// with a field `f`, then the header value expressions may use attribute `x.output.f` to reference
// the field value:
//
// ```yaml
// request_header_operations:
// - name: x-istio-header
//   values:
//   - x.output.f
// ```
//
// If the header value expression evaluates to an empty string, and the operation is to either replace
// or append a header, then the operation is not applied. This permits conditional behavior on behalf of the
// adapter to optionally modify the headers.
type Rule_HeaderOperationTemplate struct {
	// Required. Header name literal value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Header value expressions.
	Values []string `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Optional. Header operation type. Default operation is to replace the value of the header by name.
	Operation Rule_HeaderOperationTemplate_Operation `protobuf:"varint,3,opt,name=operation,proto3,enum=istio.policy.v1beta1.Rule_HeaderOperationTemplate_Operation" json:"operation,omitempty"`
}

func (m *Rule_HeaderOperationTemplate) Reset()      { *m = Rule_HeaderOperationTemplate{} }
func (*Rule_HeaderOperationTemplate) ProtoMessage() {}
func (*Rule_HeaderOperationTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{1, 0}
}
func (m *Rule_HeaderOperationTemplate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule_HeaderOperationTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule_HeaderOperationTemplate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Rule_HeaderOperationTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule_HeaderOperationTemplate.Merge(m, src)
}
func (m *Rule_HeaderOperationTemplate) XXX_Size() int {
	return m.Size()
}
func (m *Rule_HeaderOperationTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule_HeaderOperationTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_Rule_HeaderOperationTemplate proto.InternalMessageInfo

func (m *Rule_HeaderOperationTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Rule_HeaderOperationTemplate) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *Rule_HeaderOperationTemplate) GetOperation() Rule_HeaderOperationTemplate_Operation {
	if m != nil {
		return m.Operation
	}
	return REPLACE
}

// Action describes which [Handler][istio.policy.v1beta1.Handler] to invoke and what data to pass to it for processing.
//
// The following example instructs Mixer to invoke 'prometheus-handler' handler and pass it the object
// constructed using the instance 'RequestCountByService'.
//
// ```yaml
//   handler: prometheus-handler
//   instances:
//   - RequestCountByService
// ```
type Action struct {
	// Required. Fully qualified name of the handler to invoke.
	// Must match the `name` of a [Handler][istio.policy.v1beta1.Handler.name].
	Handler string `protobuf:"bytes,2,opt,name=handler,proto3" json:"handler,omitempty"`
	// Required. Each value must match the fully qualified name of the
	// [Instance][istio.policy.v1beta1.Instance.name]s.
	// Referenced instances are evaluated by resolving the attributes/literals for all the fields.
	// The constructed objects are then passed to the `handler` referenced within this action.
	Instances []string `protobuf:"bytes,3,rep,name=instances,proto3" json:"instances,omitempty"`
	// Optional. A handle to refer to the results of the action.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *Action) Reset()      { *m = Action{} }
func (*Action) ProtoMessage() {}
func (*Action) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{2}
}
func (m *Action) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Action) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Action.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Action) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Action.Merge(m, src)
}
func (m *Action) XXX_Size() int {
	return m.Size()
}
func (m *Action) XXX_DiscardUnknown() {
	xxx_messageInfo_Action.DiscardUnknown(m)
}

var xxx_messageInfo_Action proto.InternalMessageInfo

func (m *Action) GetHandler() string {
	if m != nil {
		return m.Handler
	}
	return ""
}

func (m *Action) GetInstances() []string {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *Action) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// An Instance tells Mixer how to create instances for particular template.
//
// Instance is defined by the operator. Instance is defined relative to a known
// template. Their purpose is to tell Mixer how to use attributes or literals to produce
// instances of the specified template at runtime.
//
// The following example instructs Mixer to construct an instance associated with template
// 'istio.mixer.adapter.metric.Metric'. It provides a mapping from the template's fields to expressions.
// Instances produced with this instance can be referenced by [Actions][istio.policy.v1beta1.Action] using name
// 'RequestCountByService'
//
// ```yaml
// - name: RequestCountByService
//   template: istio.mixer.adapter.metric.Metric
//   params:
//     value: 1
//     dimensions:
//       source: source.name
//       destination_ip: destination.ip
// ```
type Instance struct {
	// Required. The name of this instance
	//
	// Must be unique amongst other Instances in scope. Used by [Action][istio.policy.v1beta1.Action] to refer
	// to an instance produced by this instance.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the compiled in template this instance creates instances for. For referencing non compiled-in
	// templates, use the `template` field instead.
	//
	// The value must match the name of the available template Mixer is built with.
	CompiledTemplate string `protobuf:"bytes,67794676,opt,name=compiled_template,json=compiledTemplate,proto3" json:"compiled_template,omitempty"`
	// Required. The name of the template this instance creates instances for. For referencing compiled-in
	// templates, use the `compiled_template` field instead.
	//
	// The value must match the name of the available template in scope.
	Template string `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// Required. Depends on referenced template. Struct representation of a
	// proto defined by the template; this varies depending on the value of field `template`.
	Params *types.Struct `protobuf:"bytes,3,opt,name=params,proto3" json:"params,omitempty"`
	// Optional. Defines attribute bindings to map the output of attribute-producing adapters back into
	// the attribute space. The variable `output` refers to the output template instance produced
	// by the adapter.
	// The following example derives `source.namespace` from `source.uid` in the context of Kubernetes:
	// ```yaml
	// params:
	//   # Pass the required attribute data to the adapter
	//   source_uid: source.uid | ""
	// attribute_bindings:
	//   # Fill the new attributes from the adapter produced output
	//   source.namespace: output.source_namespace
	// ```
	AttributeBindings map[string]string `protobuf:"bytes,4,rep,name=attribute_bindings,json=attributeBindings,proto3" json:"attribute_bindings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Instance) Reset()      { *m = Instance{} }
func (*Instance) ProtoMessage() {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{3}
}
func (m *Instance) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(m, src)
}
func (m *Instance) XXX_Size() int {
	return m.Size()
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetCompiledTemplate() string {
	if m != nil {
		return m.CompiledTemplate
	}
	return ""
}

func (m *Instance) GetTemplate() string {
	if m != nil {
		return m.Template
	}
	return ""
}

func (m *Instance) GetParams() *types.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Instance) GetAttributeBindings() map[string]string {
	if m != nil {
		return m.AttributeBindings
	}
	return nil
}

// Handler allows the operator to configure a specific adapter implementation.
// Each adapter implementation defines its own `params` proto.
//
// In the following example we define a `metrics` handler for the `prometheus` adapter.
// The example is in the form of a Kubernetes resource:
// * The `metadata.name` is the name of the handler
// * The `kind` refers to the adapter name
// * The `spec` block represents adapter-specific configuration as well as the connection information
//
// ```yaml
// # Sample-1: No connection specified (for compiled in adapters)
// # Note: if connection information is not specified, the adapter configuration is directly inside
// # `spec` block. This is going to be DEPRECATED in favor of Sample-2
// apiVersion: "config.istio.io/v1alpha2"
// kind: prometheus
// metadata:
//   name: handler
//   namespace: istio-system
// spec:
//   metrics:
//   - name: request_count
//     instance_name: requestcount.metric.istio-system
//     kind: COUNTER
//     label_names:
//     - source_service
//     - source_version
//     - destination_service
//     - destination_version
// ---
// # Sample-2: With connection information (for out-of-process adapters)
// # Note: Unlike sample-1, the adapter configuration is parallel to `connection` and is nested inside `param` block.
// apiVersion: "config.istio.io/v1alpha2"
// kind: prometheus
// metadata:
//   name: handler
//   namespace: istio-system
// spec:
//   param:
//     metrics:
//     - name: request_count
//       instance_name: requestcount.metric.istio-system
//       kind: COUNTER
//       label_names:
//       - source_service
//       - source_version
//       - destination_service
//       - destination_version
//   connection:
//     address: localhost:8090
// ---
// ```
type Handler struct {
	// Required. Must be unique in the entire Mixer configuration. Used by [Actions][istio.policy.v1beta1.Action.handler]
	// to refer to this handler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the compiled in adapter this handler instantiates. For referencing non compiled-in
	// adapters, use the `adapter` field instead.
	//
	// The value must match the name of the available adapter Mixer is built with. An adapter's name is typically a
	// constant in its code.
	CompiledAdapter string `protobuf:"bytes,67794676,opt,name=compiled_adapter,json=compiledAdapter,proto3" json:"compiled_adapter,omitempty"`
	// Required. The name of a specific adapter implementation. For referencing compiled-in
	// adapters, use the `compiled_adapter` field instead.
	//
	// An adapter's implementation name is typically a constant in its code.
	Adapter string `protobuf:"bytes,2,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Optional. Depends on adapter implementation. Struct representation of a
	// proto defined by the adapter implementation; this varies depending on the value of field `adapter`.
	Params *types.Struct `protobuf:"bytes,3,opt,name=params,proto3" json:"params,omitempty"`
	// Optional. Information on how to connect to the out-of-process adapter.
	// This is used if the adapter is not compiled into Mixer binary and is running as a separate process.
	Connection *Connection `protobuf:"bytes,4,opt,name=connection,proto3" json:"connection,omitempty"`
}

func (m *Handler) Reset()      { *m = Handler{} }
func (*Handler) ProtoMessage() {}
func (*Handler) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{4}
}
func (m *Handler) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Handler) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Handler.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Handler) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Handler.Merge(m, src)
}
func (m *Handler) XXX_Size() int {
	return m.Size()
}
func (m *Handler) XXX_DiscardUnknown() {
	xxx_messageInfo_Handler.DiscardUnknown(m)
}

var xxx_messageInfo_Handler proto.InternalMessageInfo

func (m *Handler) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Handler) GetCompiledAdapter() string {
	if m != nil {
		return m.CompiledAdapter
	}
	return ""
}

func (m *Handler) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *Handler) GetParams() *types.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Handler) GetConnection() *Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

// Connection allows the operator to specify the endpoint for out-of-process infrastructure backend.
// Connection is part of the handler custom resource and is specified alongside adapter specific configuration.
type Connection struct {
	// The address of the backend.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Timeout for remote calls to the backend.
	Timeout *time.Duration `protobuf:"bytes,3,opt,name=timeout,proto3,stdduration" json:"timeout,omitempty"`
	// Auth config for the connection to the backend. If omitted, plain text will
	// be used.
	Authentication *Authentication `protobuf:"bytes,4,opt,name=authentication,proto3" json:"authentication,omitempty"`
}

func (m *Connection) Reset()      { *m = Connection{} }
func (*Connection) ProtoMessage() {}
func (*Connection) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{5}
}
func (m *Connection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection.Merge(m, src)
}
func (m *Connection) XXX_Size() int {
	return m.Size()
}
func (m *Connection) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection.DiscardUnknown(m)
}

var xxx_messageInfo_Connection proto.InternalMessageInfo

func (m *Connection) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Connection) GetTimeout() *time.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *Connection) GetAuthentication() *Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

// $hide_from_docs
// Sampling provides configuration of sampling strategies for Rule actions.
// Multiple sampling strategies are supported. When multiple strategies are configured,
// a request must be selected by all configured sampling strategies.
type Sampling struct {
	// Optional. Provides filtering of actions based on random selection per request.
	Random *RandomSampling `protobuf:"bytes,1,opt,name=random,proto3" json:"random,omitempty"`
	// Optional. Provides filtering of actions based on number of requests observed within
	// a configured time window.
	RateLimit *RateLimitSampling `protobuf:"bytes,2,opt,name=rate_limit,json=rateLimit,proto3" json:"rate_limit,omitempty"`
}

func (m *Sampling) Reset()      { *m = Sampling{} }
func (*Sampling) ProtoMessage() {}
func (*Sampling) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{6}
}
func (m *Sampling) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Sampling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Sampling.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Sampling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sampling.Merge(m, src)
}
func (m *Sampling) XXX_Size() int {
	return m.Size()
}
func (m *Sampling) XXX_DiscardUnknown() {
	xxx_messageInfo_Sampling.DiscardUnknown(m)
}

var xxx_messageInfo_Sampling proto.InternalMessageInfo

func (m *Sampling) GetRandom() *RandomSampling {
	if m != nil {
		return m.Random
	}
	return nil
}

func (m *Sampling) GetRateLimit() *RateLimitSampling {
	if m != nil {
		return m.RateLimit
	}
	return nil
}

// $hide_from_docs
// RandomSampling will filter based on the comparison of a randomly-generated value
// against the threshold provided.
//
// Example: To restrict the execution of Rule actions to only 12.5% of requests, the
// `sampling_rate` would be set `12.5`.
//
// This sampling configuration is meant to closely match the access log RuntimeFilter configuration
// [supported by Envoy](https://github.com/envoyproxy/data-plane-api/blob/master/envoy/config/filter/accesslog/v2/accesslog.proto#L113)
type RandomSampling struct {
	// Specifies an attribute expression to use to override the numerator in the `percent_sampled` field.
	// If this value is set, but no value is found OR if that value is not a numeric value, then
	// the derived sampling rate will be 0 (meaning no `Action`s are executed for a `Rule`).
	AttributeExpression string `protobuf:"bytes,1,opt,name=attribute_expression,json=attributeExpression,proto3" json:"attribute_expression,omitempty"`
	// The default sampling rate, expressed as a percentage. Defaults to 0% with a denominator
	// of 100.
	PercentSampled *FractionalPercent `protobuf:"bytes,2,opt,name=percent_sampled,json=percentSampled,proto3" json:"percent_sampled,omitempty"`
	// By default sampling will be based on the value of the request header `x-request-id`.
	// This behavior will cause consistent sampling across `Rule`s and for the full trace of a
	// request through a mesh (across hosts). If that value is not present and/or
	// `use_independent_randomness` is set to true, the sampling will be done based on the value of
	// attribute specified in `attribute_epxression`. If that attribute does not exist, the system
	// will behave as if the sampling rate was 0 (meaning no `Action`s are executed for a `Rule`).
	UseIndependentRandomness bool `protobuf:"varint,3,opt,name=use_independent_randomness,json=useIndependentRandomness,proto3" json:"use_independent_randomness,omitempty"`
}

func (m *RandomSampling) Reset()      { *m = RandomSampling{} }
func (*RandomSampling) ProtoMessage() {}
func (*RandomSampling) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{7}
}
func (m *RandomSampling) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RandomSampling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RandomSampling.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RandomSampling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RandomSampling.Merge(m, src)
}
func (m *RandomSampling) XXX_Size() int {
	return m.Size()
}
func (m *RandomSampling) XXX_DiscardUnknown() {
	xxx_messageInfo_RandomSampling.DiscardUnknown(m)
}

var xxx_messageInfo_RandomSampling proto.InternalMessageInfo

func (m *RandomSampling) GetAttributeExpression() string {
	if m != nil {
		return m.AttributeExpression
	}
	return ""
}

func (m *RandomSampling) GetPercentSampled() *FractionalPercent {
	if m != nil {
		return m.PercentSampled
	}
	return nil
}

func (m *RandomSampling) GetUseIndependentRandomness() bool {
	if m != nil {
		return m.UseIndependentRandomness
	}
	return false
}

// $hide_from_docs
// RateLimitSampling provides the ability to limit the number of Rule action executions that
// occur over a period of time.
type RateLimitSampling struct {
	// Window in which to enforce the sampling rate.
	SamplingDuration time.Duration `protobuf:"bytes,1,opt,name=sampling_duration,json=samplingDuration,proto3,stdduration" json:"sampling_duration"`
	// Number of entries to allow during the `sampling_duration` before sampling is enforced.
	MaxUnsampledEntries int64 `protobuf:"varint,2,opt,name=max_unsampled_entries,json=maxUnsampledEntries,proto3" json:"max_unsampled_entries,omitempty"`
	// The rate at which to sample entries once the unsampled limit has been reached. Sampling will be enforced
	// as 1 per every `sampling_rate` entries allowed.
	SamplingRate int64 `protobuf:"varint,3,opt,name=sampling_rate,json=samplingRate,proto3" json:"sampling_rate,omitempty"`
}

func (m *RateLimitSampling) Reset()      { *m = RateLimitSampling{} }
func (*RateLimitSampling) ProtoMessage() {}
func (*RateLimitSampling) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{8}
}
func (m *RateLimitSampling) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RateLimitSampling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RateLimitSampling.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RateLimitSampling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RateLimitSampling.Merge(m, src)
}
func (m *RateLimitSampling) XXX_Size() int {
	return m.Size()
}
func (m *RateLimitSampling) XXX_DiscardUnknown() {
	xxx_messageInfo_RateLimitSampling.DiscardUnknown(m)
}

var xxx_messageInfo_RateLimitSampling proto.InternalMessageInfo

func (m *RateLimitSampling) GetSamplingDuration() time.Duration {
	if m != nil {
		return m.SamplingDuration
	}
	return 0
}

func (m *RateLimitSampling) GetMaxUnsampledEntries() int64 {
	if m != nil {
		return m.MaxUnsampledEntries
	}
	return 0
}

func (m *RateLimitSampling) GetSamplingRate() int64 {
	if m != nil {
		return m.SamplingRate
	}
	return 0
}

// $hide_from_docs
// A fractional percentage is used in cases in which for performance reasons performing floating
// point to integer conversions during randomness calculations is undesirable. The message includes
// both a numerator and denominator that together determine the final fractional value.
//
// * **Example**: 1/100 = 1%.
// * **Example**: 3/10000 = 0.03%.
type FractionalPercent struct {
	// Specifies the numerator. Defaults to 0.
	Numerator uint32 `protobuf:"varint,1,opt,name=numerator,proto3" json:"numerator,omitempty"`
	// Specifies the denominator. If the denominator specified is less than the numerator, the final
	// fractional percentage is capped at 1 (100%).
	Denominator FractionalPercent_DenominatorType `protobuf:"varint,2,opt,name=denominator,proto3,enum=istio.policy.v1beta1.FractionalPercent_DenominatorType" json:"denominator,omitempty"`
}

func (m *FractionalPercent) Reset()      { *m = FractionalPercent{} }
func (*FractionalPercent) ProtoMessage() {}
func (*FractionalPercent) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{9}
}
func (m *FractionalPercent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FractionalPercent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FractionalPercent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FractionalPercent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FractionalPercent.Merge(m, src)
}
func (m *FractionalPercent) XXX_Size() int {
	return m.Size()
}
func (m *FractionalPercent) XXX_DiscardUnknown() {
	xxx_messageInfo_FractionalPercent.DiscardUnknown(m)
}

var xxx_messageInfo_FractionalPercent proto.InternalMessageInfo

func (m *FractionalPercent) GetNumerator() uint32 {
	if m != nil {
		return m.Numerator
	}
	return 0
}

func (m *FractionalPercent) GetDenominator() FractionalPercent_DenominatorType {
	if m != nil {
		return m.Denominator
	}
	return HUNDRED
}

// Authentication allows the operator to specify the authentication of
// connections to out-of-process infrastructure backend.
type Authentication struct {
	// Types that are valid to be assigned to AuthType:
	//	*Authentication_Tls
	//	*Authentication_Mutual
	AuthType isAuthentication_AuthType `protobuf_oneof:"auth_type"`
}

func (m *Authentication) Reset()      { *m = Authentication{} }
func (*Authentication) ProtoMessage() {}
func (*Authentication) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{10}
}
func (m *Authentication) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Authentication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Authentication.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Authentication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Authentication.Merge(m, src)
}
func (m *Authentication) XXX_Size() int {
	return m.Size()
}
func (m *Authentication) XXX_DiscardUnknown() {
	xxx_messageInfo_Authentication.DiscardUnknown(m)
}

var xxx_messageInfo_Authentication proto.InternalMessageInfo

type isAuthentication_AuthType interface {
	isAuthentication_AuthType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Authentication_Tls struct {
	Tls *Tls `protobuf:"bytes,1,opt,name=tls,proto3,oneof"`
}
type Authentication_Mutual struct {
	Mutual *Mutual `protobuf:"bytes,2,opt,name=mutual,proto3,oneof"`
}

func (*Authentication_Tls) isAuthentication_AuthType()    {}
func (*Authentication_Mutual) isAuthentication_AuthType() {}

func (m *Authentication) GetAuthType() isAuthentication_AuthType {
	if m != nil {
		return m.AuthType
	}
	return nil
}

func (m *Authentication) GetTls() *Tls {
	if x, ok := m.GetAuthType().(*Authentication_Tls); ok {
		return x.Tls
	}
	return nil
}

func (m *Authentication) GetMutual() *Mutual {
	if x, ok := m.GetAuthType().(*Authentication_Mutual); ok {
		return x.Mutual
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Authentication) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Authentication_OneofMarshaler, _Authentication_OneofUnmarshaler, _Authentication_OneofSizer, []interface{}{
		(*Authentication_Tls)(nil),
		(*Authentication_Mutual)(nil),
	}
}

func _Authentication_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Authentication)
	// auth_type
	switch x := m.AuthType.(type) {
	case *Authentication_Tls:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Tls); err != nil {
			return err
		}
	case *Authentication_Mutual:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mutual); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Authentication.AuthType has unexpected type %T", x)
	}
	return nil
}

func _Authentication_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Authentication)
	switch tag {
	case 1: // auth_type.tls
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Tls)
		err := b.DecodeMessage(msg)
		m.AuthType = &Authentication_Tls{msg}
		return true, err
	case 2: // auth_type.mutual
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutual)
		err := b.DecodeMessage(msg)
		m.AuthType = &Authentication_Mutual{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Authentication_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Authentication)
	// auth_type
	switch x := m.AuthType.(type) {
	case *Authentication_Tls:
		s := proto.Size(x.Tls)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Authentication_Mutual:
		s := proto.Size(x.Mutual)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Tls let operator specify client authentication setting when TLS is used for
// connection to the backend.
type Tls struct {
	// The path to the file holding additional CA certificates to well known
	// public certs.
	CaCertificates string `protobuf:"bytes,1,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// Specifies how to get access token for client authn and authz.
	//
	// Types that are valid to be assigned to TokenSource:
	//	*Tls_TokenPath
	//	*Tls_Oauth
	TokenSource isTls_TokenSource `protobuf_oneof:"token_source"`
	// Specifies how to pass access token to the adapter backend.
	//
	// Types that are valid to be assigned to TokenType:
	//	*Tls_AuthHeader_
	//	*Tls_CustomHeader
	TokenType isTls_TokenType `protobuf_oneof:"token_type"`
	// Used to configure mixer TLS client to verify the hostname on the returned
	// certificates. It is also included in the client's handshake to support SNI.
	ServerName string `protobuf:"bytes,6,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
}

func (m *Tls) Reset()      { *m = Tls{} }
func (*Tls) ProtoMessage() {}
func (*Tls) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{11}
}
func (m *Tls) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tls) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tls.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tls) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tls.Merge(m, src)
}
func (m *Tls) XXX_Size() int {
	return m.Size()
}
func (m *Tls) XXX_DiscardUnknown() {
	xxx_messageInfo_Tls.DiscardUnknown(m)
}

var xxx_messageInfo_Tls proto.InternalMessageInfo

type isTls_TokenSource interface {
	isTls_TokenSource()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}
type isTls_TokenType interface {
	isTls_TokenType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Tls_TokenPath struct {
	TokenPath string `protobuf:"bytes,2,opt,name=token_path,json=tokenPath,proto3,oneof"`
}
type Tls_Oauth struct {
	Oauth *OAuth `protobuf:"bytes,3,opt,name=oauth,proto3,oneof"`
}
type Tls_AuthHeader_ struct {
	AuthHeader Tls_AuthHeader `protobuf:"varint,4,opt,name=auth_header,json=authHeader,proto3,enum=istio.policy.v1beta1.Tls_AuthHeader,oneof"`
}
type Tls_CustomHeader struct {
	CustomHeader string `protobuf:"bytes,5,opt,name=custom_header,json=customHeader,proto3,oneof"`
}

func (*Tls_TokenPath) isTls_TokenSource()  {}
func (*Tls_Oauth) isTls_TokenSource()      {}
func (*Tls_AuthHeader_) isTls_TokenType()  {}
func (*Tls_CustomHeader) isTls_TokenType() {}

func (m *Tls) GetTokenSource() isTls_TokenSource {
	if m != nil {
		return m.TokenSource
	}
	return nil
}
func (m *Tls) GetTokenType() isTls_TokenType {
	if m != nil {
		return m.TokenType
	}
	return nil
}

func (m *Tls) GetCaCertificates() string {
	if m != nil {
		return m.CaCertificates
	}
	return ""
}

func (m *Tls) GetTokenPath() string {
	if x, ok := m.GetTokenSource().(*Tls_TokenPath); ok {
		return x.TokenPath
	}
	return ""
}

func (m *Tls) GetOauth() *OAuth {
	if x, ok := m.GetTokenSource().(*Tls_Oauth); ok {
		return x.Oauth
	}
	return nil
}

func (m *Tls) GetAuthHeader() Tls_AuthHeader {
	if x, ok := m.GetTokenType().(*Tls_AuthHeader_); ok {
		return x.AuthHeader
	}
	return PLAIN
}

func (m *Tls) GetCustomHeader() string {
	if x, ok := m.GetTokenType().(*Tls_CustomHeader); ok {
		return x.CustomHeader
	}
	return ""
}

func (m *Tls) GetServerName() string {
	if m != nil {
		return m.ServerName
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Tls) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Tls_OneofMarshaler, _Tls_OneofUnmarshaler, _Tls_OneofSizer, []interface{}{
		(*Tls_TokenPath)(nil),
		(*Tls_Oauth)(nil),
		(*Tls_AuthHeader_)(nil),
		(*Tls_CustomHeader)(nil),
	}
}

func _Tls_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Tls)
	// token_source
	switch x := m.TokenSource.(type) {
	case *Tls_TokenPath:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.TokenPath)
	case *Tls_Oauth:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Oauth); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Tls.TokenSource has unexpected type %T", x)
	}
	// token_type
	switch x := m.TokenType.(type) {
	case *Tls_AuthHeader_:
		_ = b.EncodeVarint(4<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.AuthHeader))
	case *Tls_CustomHeader:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.CustomHeader)
	case nil:
	default:
		return fmt.Errorf("Tls.TokenType has unexpected type %T", x)
	}
	return nil
}

func _Tls_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Tls)
	switch tag {
	case 2: // token_source.token_path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.TokenSource = &Tls_TokenPath{x}
		return true, err
	case 3: // token_source.oauth
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(OAuth)
		err := b.DecodeMessage(msg)
		m.TokenSource = &Tls_Oauth{msg}
		return true, err
	case 4: // token_type.auth_header
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TokenType = &Tls_AuthHeader_{Tls_AuthHeader(x)}
		return true, err
	case 5: // token_type.custom_header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.TokenType = &Tls_CustomHeader{x}
		return true, err
	default:
		return false, nil
	}
}

func _Tls_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Tls)
	// token_source
	switch x := m.TokenSource.(type) {
	case *Tls_TokenPath:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.TokenPath)))
		n += len(x.TokenPath)
	case *Tls_Oauth:
		s := proto.Size(x.Oauth)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// token_type
	switch x := m.TokenType.(type) {
	case *Tls_AuthHeader_:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.AuthHeader))
	case *Tls_CustomHeader:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.CustomHeader)))
		n += len(x.CustomHeader)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// OAuth let operator specify config to fetch access token via oauth when using
// TLS for connection to the backend.
type OAuth struct {
	// REQUIRED. OAuth client id for mixer.
	ClientId string `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// REQUIRED. The path to the file holding the client secret for oauth.
	ClientSecret string `protobuf:"bytes,2,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
	// REQUIRED. The Resource server's token endpoint URL.
	TokenUrl string `protobuf:"bytes,3,opt,name=token_url,json=tokenUrl,proto3" json:"token_url,omitempty"`
	// List of requested permissions.
	Scopes []string `protobuf:"bytes,4,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// Additional parameters for requests to the token endpoint.
	EndpointParams map[string]string `protobuf:"bytes,5,rep,name=endpoint_params,json=endpointParams,proto3" json:"endpoint_params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *OAuth) Reset()      { *m = OAuth{} }
func (*OAuth) ProtoMessage() {}
func (*OAuth) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{12}
}
func (m *OAuth) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OAuth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OAuth.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OAuth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OAuth.Merge(m, src)
}
func (m *OAuth) XXX_Size() int {
	return m.Size()
}
func (m *OAuth) XXX_DiscardUnknown() {
	xxx_messageInfo_OAuth.DiscardUnknown(m)
}

var xxx_messageInfo_OAuth proto.InternalMessageInfo

func (m *OAuth) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *OAuth) GetClientSecret() string {
	if m != nil {
		return m.ClientSecret
	}
	return ""
}

func (m *OAuth) GetTokenUrl() string {
	if m != nil {
		return m.TokenUrl
	}
	return ""
}

func (m *OAuth) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *OAuth) GetEndpointParams() map[string]string {
	if m != nil {
		return m.EndpointParams
	}
	return nil
}

// Mutual let operator specify TLS configuration for Mixer as client if mutual TLS is used to
// secure connection to adapter backend.
type Mutual struct {
	// The path to the file holding the private key for mutual TLS. If omitted, the
	// default Mixer private key will be used.
	PrivateKey string `protobuf:"bytes,1,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// The path to the file holding client certificate for mutual TLS. If omitted, the
	// default Mixer certificates will be used.
	ClientCertificate string `protobuf:"bytes,2,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// The path to the file holding additional CA certificates that are needed to
	// verify the presented adapter certificates. By default Mixer should already
	// include Istio CA certificates and system certificates in cert pool.
	CaCertificates string `protobuf:"bytes,3,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// Used to configure mixer mutual TLS client to supply server name for SNI.
	// It is not used to verify the hostname of the peer certificate, since
	// Istio verifies whitelisted SAN fields in mutual TLS.
	ServerName string `protobuf:"bytes,4,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
}

func (m *Mutual) Reset()      { *m = Mutual{} }
func (*Mutual) ProtoMessage() {}
func (*Mutual) Descriptor() ([]byte, []int) {
	return fileDescriptor_dfb7777e81b6b919, []int{13}
}
func (m *Mutual) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Mutual) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Mutual.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Mutual) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutual.Merge(m, src)
}
func (m *Mutual) XXX_Size() int {
	return m.Size()
}
func (m *Mutual) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutual.DiscardUnknown(m)
}

var xxx_messageInfo_Mutual proto.InternalMessageInfo

func (m *Mutual) GetPrivateKey() string {
	if m != nil {
		return m.PrivateKey
	}
	return ""
}

func (m *Mutual) GetClientCertificate() string {
	if m != nil {
		return m.ClientCertificate
	}
	return ""
}

func (m *Mutual) GetCaCertificates() string {
	if m != nil {
		return m.CaCertificates
	}
	return ""
}

func (m *Mutual) GetServerName() string {
	if m != nil {
		return m.ServerName
	}
	return ""
}

func init() {
	proto.RegisterEnum("istio.policy.v1beta1.Rule_HeaderOperationTemplate_Operation", Rule_HeaderOperationTemplate_Operation_name, Rule_HeaderOperationTemplate_Operation_value)
	proto.RegisterEnum("istio.policy.v1beta1.FractionalPercent_DenominatorType", FractionalPercent_DenominatorType_name, FractionalPercent_DenominatorType_value)
	proto.RegisterEnum("istio.policy.v1beta1.Tls_AuthHeader", Tls_AuthHeader_name, Tls_AuthHeader_value)
	proto.RegisterType((*AttributeManifest)(nil), "istio.policy.v1beta1.AttributeManifest")
	proto.RegisterMapType((map[string]*AttributeManifest_AttributeInfo)(nil), "istio.policy.v1beta1.AttributeManifest.AttributesEntry")
	proto.RegisterType((*AttributeManifest_AttributeInfo)(nil), "istio.policy.v1beta1.AttributeManifest.AttributeInfo")
	proto.RegisterType((*Rule)(nil), "istio.policy.v1beta1.Rule")
	proto.RegisterType((*Rule_HeaderOperationTemplate)(nil), "istio.policy.v1beta1.Rule.HeaderOperationTemplate")
	proto.RegisterType((*Action)(nil), "istio.policy.v1beta1.Action")
	proto.RegisterType((*Instance)(nil), "istio.policy.v1beta1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "istio.policy.v1beta1.Instance.AttributeBindingsEntry")
	proto.RegisterType((*Handler)(nil), "istio.policy.v1beta1.Handler")
	proto.RegisterType((*Connection)(nil), "istio.policy.v1beta1.Connection")
	proto.RegisterType((*Sampling)(nil), "istio.policy.v1beta1.Sampling")
	proto.RegisterType((*RandomSampling)(nil), "istio.policy.v1beta1.RandomSampling")
	proto.RegisterType((*RateLimitSampling)(nil), "istio.policy.v1beta1.RateLimitSampling")
	proto.RegisterType((*FractionalPercent)(nil), "istio.policy.v1beta1.FractionalPercent")
	proto.RegisterType((*Authentication)(nil), "istio.policy.v1beta1.Authentication")
	proto.RegisterType((*Tls)(nil), "istio.policy.v1beta1.Tls")
	proto.RegisterType((*OAuth)(nil), "istio.policy.v1beta1.OAuth")
	proto.RegisterMapType((map[string]string)(nil), "istio.policy.v1beta1.OAuth.EndpointParamsEntry")
	proto.RegisterType((*Mutual)(nil), "istio.policy.v1beta1.Mutual")
}

func init() { proto.RegisterFile("policy/v1beta1/cfg.proto", fileDescriptor_dfb7777e81b6b919) }

var fileDescriptor_dfb7777e81b6b919 = []byte{
	// 1519 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xcf, 0x6f, 0x13, 0xc7,
	0x17, 0xf7, 0xc6, 0xb1, 0x13, 0x3f, 0x27, 0x8e, 0x33, 0xe4, 0x0b, 0xc6, 0x20, 0x27, 0x32, 0xdf,
	0xaf, 0xe0, 0xf0, 0xc5, 0x86, 0xa0, 0x42, 0x8b, 0x50, 0x55, 0x87, 0x98, 0x3a, 0x22, 0x24, 0xee,
	0xc4, 0xa1, 0x2d, 0x97, 0xd5, 0x64, 0x77, 0x92, 0xac, 0x58, 0xcf, 0x2e, 0xbb, 0xb3, 0x11, 0xb9,
	0xf5, 0xd0, 0xde, 0x39, 0x56, 0xea, 0xad, 0xa7, 0xf6, 0xd4, 0xff, 0xa0, 0xd7, 0x72, 0x44, 0xe2,
	0x92, 0x53, 0x5b, 0xc2, 0xa5, 0x97, 0x4a, 0x1c, 0xfa, 0x07, 0x54, 0xf3, 0x63, 0x77, 0x1d, 0xc7,
	0x46, 0x4d, 0x6f, 0x3b, 0xef, 0x7d, 0xde, 0xef, 0x37, 0xef, 0xcd, 0x42, 0xc5, 0xf7, 0x5c, 0xc7,
	0x3a, 0x6c, 0x1e, 0xdc, 0xdc, 0xa1, 0x9c, 0xdc, 0x6c, 0x5a, 0xbb, 0x7b, 0x0d, 0x3f, 0xf0, 0xb8,
	0x87, 0x16, 0x9c, 0x90, 0x3b, 0x5e, 0x43, 0xf1, 0x1b, 0x9a, 0x5f, 0x5d, 0xd8, 0xf3, 0xf6, 0x3c,
	0x09, 0x68, 0x8a, 0x2f, 0x85, 0xad, 0x5e, 0xde, 0xf3, 0xbc, 0x3d, 0x97, 0x36, 0xe5, 0x69, 0x27,
	0xda, 0x6d, 0x86, 0x3c, 0x88, 0x2c, 0xae, 0xb9, 0xb5, 0x61, 0xae, 0x1d, 0x05, 0x84, 0x3b, 0x1e,
	0xd3, 0xfc, 0xc5, 0x21, 0x1f, 0x0e, 0x88, 0x1b, 0x51, 0x93, 0x1f, 0xfa, 0x54, 0x01, 0xea, 0xdf,
	0x64, 0x61, 0xbe, 0xc5, 0x79, 0xe0, 0xec, 0x44, 0x9c, 0x3e, 0x22, 0xcc, 0xd9, 0xa5, 0x21, 0x47,
	0x55, 0x98, 0x0e, 0xe8, 0x81, 0x13, 0x3a, 0x1e, 0xab, 0x18, 0x4b, 0xc6, 0xb5, 0x02, 0x4e, 0xce,
	0x08, 0xc1, 0x24, 0x23, 0x7d, 0x5a, 0x99, 0x90, 0x74, 0xf9, 0x8d, 0x3e, 0x07, 0x20, 0xb1, 0x92,
	0xb0, 0x92, 0x5d, 0xca, 0x5e, 0x2b, 0x2e, 0xdf, 0x69, 0x8c, 0x8a, 0xb2, 0x71, 0xca, 0x58, 0x4a,
	0x09, 0xdb, 0x8c, 0x07, 0x87, 0x78, 0x40, 0x55, 0xf5, 0x19, 0xcc, 0x26, 0xec, 0x35, 0xb6, 0xeb,
	0xa1, 0x25, 0x28, 0xda, 0x34, 0xb4, 0x02, 0xc7, 0xe7, 0xa9, 0x73, 0x83, 0x24, 0xf4, 0x31, 0x40,
	0x1a, 0xa5, 0xf4, 0xb2, 0xb4, 0xbc, 0x38, 0xda, 0x97, 0xc7, 0x02, 0xd7, 0x3b, 0xf4, 0x29, 0x2e,
	0x1c, 0xc4, 0x9f, 0x55, 0x0e, 0x73, 0x43, 0x1e, 0xa1, 0x32, 0x64, 0x9f, 0xd2, 0x43, 0x6d, 0x4c,
	0x7c, 0xa2, 0x87, 0x90, 0x93, 0x12, 0x52, 0x7f, 0x71, 0xf9, 0x83, 0x33, 0xc7, 0x2a, 0x82, 0xc1,
	0x4a, 0xc7, 0xdd, 0x89, 0x0f, 0x8d, 0xfa, 0xcb, 0x49, 0x98, 0xc4, 0x91, 0x4b, 0xd1, 0x02, 0xe4,
	0xfa, 0x84, 0x5b, 0xfb, 0xda, 0x9a, 0x3a, 0xa0, 0xdb, 0x30, 0x45, 0x2c, 0x11, 0x5e, 0x58, 0x99,
	0x90, 0xd9, 0xbd, 0x3c, 0xc6, 0xa2, 0x04, 0xe1, 0x18, 0x8c, 0x18, 0x5c, 0x0c, 0xe8, 0xb3, 0x88,
	0x86, 0xdc, 0xdc, 0xa7, 0xc4, 0xa6, 0x81, 0xe9, 0xf9, 0x54, 0x75, 0x48, 0x5c, 0xa7, 0xe5, 0xd1,
	0x9a, 0x84, 0x33, 0x8d, 0x8e, 0x94, 0xd9, 0x8c, 0x45, 0x7a, 0xb4, 0xef, 0xbb, 0x84, 0x53, 0x7c,
	0x41, 0x2b, 0x1d, 0xe2, 0x87, 0xc8, 0x87, 0x6a, 0x40, 0x43, 0xdf, 0x63, 0x21, 0x1d, 0x61, 0x70,
	0xf2, 0x5f, 0x1b, 0xac, 0xc4, 0x5a, 0x4f, 0x59, 0xbc, 0x0b, 0xd3, 0x21, 0xe9, 0xfb, 0xae, 0xc3,
	0xf6, 0x2a, 0x39, 0x59, 0x8c, 0xda, 0x68, 0xfd, 0x5b, 0x1a, 0x85, 0x13, 0x7c, 0xf5, 0xb5, 0x01,
	0x17, 0xc6, 0x58, 0x4c, 0xda, 0xdc, 0x18, 0x68, 0xf3, 0xf3, 0x90, 0x97, 0x15, 0x53, 0x45, 0x28,
	0x60, 0x7d, 0x42, 0x4f, 0xa0, 0x90, 0x44, 0x59, 0xc9, 0xca, 0x8e, 0xbb, 0x77, 0xf6, 0x20, 0x1b,
	0x09, 0x05, 0xa7, 0xea, 0xea, 0x37, 0xa0, 0x90, 0xd0, 0x51, 0x11, 0xa6, 0x70, 0xbb, 0xbb, 0xde,
	0xba, 0xdf, 0x2e, 0x67, 0x10, 0x40, 0x1e, 0xb7, 0x1f, 0x6d, 0x3e, 0x6e, 0x97, 0x0d, 0xf1, 0xdd,
	0xea, 0x76, 0xdb, 0x1b, 0xab, 0xe5, 0x89, 0x7a, 0x0f, 0xf2, 0xaa, 0x0d, 0x50, 0x05, 0xa6, 0xf6,
	0x09, 0xb3, 0x5d, 0x1a, 0xe8, 0xdb, 0x1a, 0x1f, 0xd1, 0x65, 0x28, 0x38, 0x2c, 0xe4, 0x84, 0x59,
	0xfa, 0xbe, 0x16, 0x70, 0x4a, 0x48, 0x62, 0x9f, 0x4c, 0x63, 0xaf, 0xff, 0x32, 0x01, 0xd3, 0x6b,
	0x1a, 0x31, 0x32, 0x39, 0x0d, 0x98, 0xb7, 0xbc, 0xbe, 0xef, 0xb8, 0xd4, 0x36, 0xb9, 0x0e, 0xa9,
	0xf2, 0xd7, 0x9f, 0x3f, 0x2e, 0x49, 0x4c, 0x39, 0xe6, 0x25, 0x09, 0xae, 0xc2, 0x74, 0x02, 0x53,
	0xde, 0x25, 0x67, 0xd4, 0x84, 0xbc, 0x4f, 0x02, 0xd2, 0x0f, 0x65, 0x36, 0x8b, 0xcb, 0x17, 0x1a,
	0x6a, 0xce, 0x35, 0xe2, 0x39, 0xd7, 0xd8, 0x92, 0x53, 0x10, 0x6b, 0x18, 0xb2, 0x01, 0x25, 0x53,
	0xc3, 0xdc, 0x71, 0x98, 0xed, 0xb0, 0xbd, 0xb8, 0xdf, 0xc6, 0x5c, 0xce, 0x38, 0x98, 0xf4, 0x4e,
	0xae, 0x68, 0x39, 0x35, 0x86, 0xe6, 0xc9, 0x30, 0xbd, 0xba, 0x0a, 0xe7, 0x47, 0x83, 0x47, 0x4c,
	0x88, 0x85, 0xc1, 0x09, 0x51, 0x18, 0xbc, 0xea, 0x47, 0x06, 0x4c, 0x75, 0x74, 0x1d, 0x46, 0x25,
	0xf2, 0xff, 0x90, 0x24, 0xcb, 0x24, 0x36, 0xf1, 0x39, 0x0d, 0xd2, 0x3c, 0xce, 0xc5, 0xac, 0x96,
	0xe2, 0x88, 0x1a, 0xc7, 0x20, 0x5d, 0x63, 0x7d, 0x3c, 0x7b, 0x12, 0x3f, 0x01, 0xb0, 0x3c, 0xc6,
	0xa8, 0x6c, 0x1e, 0x59, 0xfc, 0xe2, 0xf2, 0xd2, 0xe8, 0xe4, 0xdd, 0x4f, 0x70, 0x78, 0x40, 0xa6,
	0xfe, 0x93, 0x01, 0x90, 0xb2, 0x94, 0x6f, 0x76, 0x40, 0xc3, 0x30, 0xf5, 0x4d, 0x1e, 0xd1, 0x47,
	0x30, 0xc5, 0x9d, 0x3e, 0xf5, 0x22, 0xae, 0x9d, 0xbb, 0x78, 0xca, 0xb9, 0x55, 0xbd, 0xc9, 0x56,
	0x26, 0xbf, 0xfd, 0x6d, 0xd1, 0xc0, 0x31, 0x1e, 0xad, 0x43, 0x89, 0x44, 0x7c, 0x9f, 0x32, 0xee,
	0x58, 0x64, 0xc0, 0xd3, 0xff, 0x8e, 0x99, 0x88, 0x27, 0xb0, 0x78, 0x48, 0xb6, 0xfe, 0xc2, 0x80,
	0xe9, 0x78, 0x32, 0xa0, 0x7b, 0x90, 0x0f, 0x08, 0xb3, 0xbd, 0xbe, 0xac, 0xc7, 0x58, 0x95, 0x58,
	0x62, 0x92, 0x79, 0xa2, 0x65, 0xd0, 0x03, 0x80, 0x80, 0x70, 0x6a, 0xba, 0x4e, 0xdf, 0xe1, 0x7a,
	0x31, 0x5c, 0x1d, 0xa7, 0x81, 0xd3, 0x75, 0x01, 0x4b, 0x94, 0x14, 0x82, 0x98, 0x54, 0x7f, 0x6d,
	0x40, 0xe9, 0xa4, 0x09, 0x74, 0x13, 0x16, 0xd2, 0xf6, 0xa6, 0xcf, 0x7d, 0x91, 0xc3, 0x74, 0xfd,
	0x9d, 0x4b, 0x78, 0xed, 0x84, 0x85, 0xba, 0x30, 0xe7, 0xd3, 0xc0, 0xa2, 0x8c, 0x9b, 0x72, 0xde,
	0x51, 0xfb, 0xfd, 0x2e, 0x3d, 0x08, 0xd4, 0xce, 0x20, 0x6e, 0x57, 0x89, 0xe1, 0x92, 0x96, 0xdf,
	0x52, 0xe2, 0xe8, 0x1e, 0x54, 0xa3, 0x90, 0x9a, 0x0e, 0xb3, 0xa9, 0x4f, 0x99, 0x2d, 0x34, 0xab,
	0xc8, 0x99, 0x28, 0xb0, 0x28, 0xe3, 0x34, 0xae, 0x44, 0x21, 0x5d, 0x4b, 0x01, 0x38, 0xe1, 0xd7,
	0x7f, 0x36, 0x60, 0xfe, 0x54, 0xd8, 0xa8, 0x0b, 0xf3, 0xf1, 0x34, 0x36, 0xe3, 0xa7, 0x8b, 0x4e,
	0xfe, 0x7b, 0x3a, 0x62, 0xfa, 0xe5, 0xaf, 0x8b, 0x19, 0xd9, 0x15, 0xe5, 0x58, 0x3a, 0xe6, 0xa1,
	0x65, 0xf8, 0x4f, 0x9f, 0x3c, 0x37, 0x23, 0xa6, 0xa3, 0x36, 0x29, 0xe3, 0x81, 0x43, 0x55, 0x07,
	0x66, 0xf1, 0xb9, 0x3e, 0x79, 0xbe, 0x1d, 0xf3, 0xda, 0x8a, 0x85, 0xae, 0xc0, 0x6c, 0xe2, 0x85,
	0xa8, 0x83, 0x0c, 0x26, 0x8b, 0x67, 0x62, 0xa2, 0xf0, 0x5b, 0x06, 0x70, 0x2a, 0x49, 0x62, 0x90,
	0xb2, 0xa8, 0x2f, 0xe6, 0xb3, 0x17, 0x48, 0xc7, 0x67, 0x71, 0x4a, 0x40, 0x5f, 0x8a, 0xd7, 0x0a,
	0xf3, 0xfa, 0x0e, 0x93, 0x7c, 0xf5, 0x18, 0xb9, 0xf3, 0x0f, 0x0b, 0xd0, 0x58, 0x4d, 0x45, 0xe5,
	0x23, 0x65, 0x50, 0x57, 0xfd, 0x06, 0xcc, 0x0d, 0xf1, 0xc5, 0x76, 0xe8, 0x6c, 0x6f, 0xac, 0xe2,
	0xf6, 0x6a, 0x39, 0x83, 0xca, 0x30, 0xd3, 0x6b, 0x6f, 0x98, 0xbd, 0xce, 0xe6, 0xf6, 0x56, 0x6b,
	0x63, 0xb5, 0x6c, 0xd4, 0xbf, 0x36, 0xa0, 0x74, 0xf2, 0x36, 0xa0, 0xeb, 0x90, 0xe5, 0x6e, 0x98,
	0x24, 0x7c, 0xa4, 0x5f, 0x3d, 0x37, 0xec, 0x64, 0xb0, 0xc0, 0xa1, 0xdb, 0x90, 0xef, 0x47, 0x3c,
	0x22, 0xae, 0x6e, 0xa5, 0x31, 0x8f, 0x90, 0x47, 0x12, 0xd3, 0xc9, 0x60, 0x8d, 0x5e, 0x29, 0x42,
	0x41, 0x5c, 0x3b, 0xf9, 0x22, 0xab, 0x1f, 0x4d, 0x40, 0xb6, 0xe7, 0x86, 0xe8, 0x2a, 0xcc, 0x59,
	0xc4, 0xb4, 0x68, 0xc0, 0x9d, 0x5d, 0xe1, 0x0f, 0x0d, 0x75, 0x3b, 0x97, 0x2c, 0x72, 0x7f, 0x80,
	0x8a, 0x16, 0x01, 0xb8, 0xf7, 0x94, 0x32, 0xd3, 0x27, 0x7c, 0x5f, 0x0d, 0x92, 0x4e, 0x06, 0x17,
	0x24, 0xad, 0x4b, 0xf8, 0x3e, 0xba, 0x05, 0x39, 0x4f, 0xe8, 0xd7, 0xa3, 0xe4, 0xd2, 0x68, 0xaf,
	0x36, 0x45, 0xec, 0x9d, 0x0c, 0x56, 0x58, 0xf4, 0x29, 0x14, 0xa5, 0x4f, 0xea, 0x95, 0x22, 0x67,
	0x48, 0x69, 0xdc, 0x85, 0xef, 0xb9, 0xa1, 0x9c, 0x23, 0x6a, 0x71, 0x77, 0x0c, 0x0c, 0x24, 0x39,
	0xa1, 0xff, 0xc1, 0xac, 0x15, 0x85, 0xdc, 0xeb, 0xc7, 0xaa, 0x72, 0xd2, 0x43, 0x03, 0xcf, 0x28,
	0xb2, 0x86, 0x2d, 0x42, 0x31, 0xa4, 0xc1, 0x01, 0x0d, 0x4c, 0x39, 0xf0, 0xf3, 0x32, 0x54, 0x50,
	0xa4, 0x0d, 0xb1, 0x60, 0xaf, 0x00, 0xa4, 0x36, 0x50, 0x01, 0x72, 0xdd, 0xf5, 0xd6, 0xda, 0x86,
	0xda, 0xf3, 0x2b, 0xed, 0x16, 0x6e, 0xe3, 0xb2, 0xb1, 0x52, 0x82, 0x19, 0x95, 0x8b, 0xd0, 0x8b,
	0x02, 0x8b, 0xae, 0xcc, 0xc4, 0xb9, 0x91, 0xa9, 0xfd, 0x6e, 0x02, 0x72, 0x32, 0x4c, 0x74, 0x09,
	0x0a, 0x96, 0xeb, 0x88, 0x2b, 0xea, 0xd8, 0xf1, 0x0b, 0x5e, 0x11, 0xd6, 0x6c, 0xd1, 0xee, 0x9a,
	0x19, 0x52, 0x2b, 0xa0, 0x5c, 0x0f, 0xe7, 0x19, 0x45, 0xdc, 0x92, 0x34, 0xa1, 0x41, 0x69, 0x8e,
	0x02, 0x57, 0x26, 0x56, 0xec, 0x67, 0x41, 0xd8, 0x0e, 0x5c, 0xf1, 0x10, 0x0a, 0x2d, 0xcf, 0xa7,
	0x6a, 0xc5, 0x16, 0xb0, 0x3e, 0xa1, 0x2f, 0x60, 0x8e, 0x32, 0xdb, 0xf7, 0x1c, 0xc6, 0x4d, 0xbd,
	0x7b, 0x72, 0x72, 0x07, 0x37, 0xdf, 0x53, 0x93, 0x46, 0x5b, 0x8b, 0x74, 0xa5, 0x84, 0xda, 0xbe,
	0x25, 0x7a, 0x82, 0x58, 0x6d, 0xc1, 0xb9, 0x11, 0xb0, 0x33, 0xed, 0xdd, 0xef, 0x0d, 0xc8, 0xab,
	0xd6, 0x14, 0xc5, 0xf0, 0x03, 0xe7, 0x40, 0x4c, 0xeb, 0x54, 0x1c, 0x34, 0xe9, 0x21, 0x3d, 0x44,
	0xd7, 0x01, 0xe9, 0x14, 0x0d, 0x34, 0xa8, 0x56, 0x39, 0xaf, 0x38, 0x03, 0x3d, 0x3a, 0xaa, 0x97,
	0xb3, 0x63, 0x7a, 0xf9, 0x44, 0x17, 0x4c, 0x0e, 0x77, 0xc1, 0xca, 0x67, 0xaf, 0xde, 0xd4, 0x32,
	0x47, 0x6f, 0x6a, 0x99, 0x77, 0x6f, 0x6a, 0xc6, 0x57, 0xc7, 0x35, 0xe3, 0x87, 0xe3, 0x9a, 0xf1,
	0xf2, 0xb8, 0x66, 0xbc, 0x3a, 0xae, 0x19, 0xbf, 0x1f, 0xd7, 0x8c, 0x3f, 0x8e, 0x6b, 0x99, 0x77,
	0xc7, 0x35, 0xe3, 0xc5, 0xdb, 0x5a, 0xe6, 0xd5, 0xdb, 0x5a, 0xe6, 0xe8, 0x6d, 0x2d, 0xf3, 0xe4,
	0x92, 0xca, 0xae, 0xe3, 0x35, 0x89, 0xef, 0x34, 0x4f, 0xfe, 0xf3, 0xed, 0xe4, 0xe5, 0x00, 0xbd,
	0xf5, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0x2a, 0x5a, 0x42, 0x6d, 0x90, 0x0e, 0x00, 0x00,
}

func (x Rule_HeaderOperationTemplate_Operation) String() string {
	s, ok := Rule_HeaderOperationTemplate_Operation_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x FractionalPercent_DenominatorType) String() string {
	s, ok := FractionalPercent_DenominatorType_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Tls_AuthHeader) String() string {
	s, ok := Tls_AuthHeader_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *AttributeManifest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AttributeManifest)
	if !ok {
		that2, ok := that.(AttributeManifest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Revision != that1.Revision {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	return true
}
func (this *AttributeManifest_AttributeInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AttributeManifest_AttributeInfo)
	if !ok {
		that2, ok := that.(AttributeManifest_AttributeInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Description != that1.Description {
		return false
	}
	if this.ValueType != that1.ValueType {
		return false
	}
	return true
}
func (this *Rule) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Rule)
	if !ok {
		that2, ok := that.(Rule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Match != that1.Match {
		return false
	}
	if len(this.Actions) != len(that1.Actions) {
		return false
	}
	for i := range this.Actions {
		if !this.Actions[i].Equal(that1.Actions[i]) {
			return false
		}
	}
	if len(this.RequestHeaderOperations) != len(that1.RequestHeaderOperations) {
		return false
	}
	for i := range this.RequestHeaderOperations {
		if !this.RequestHeaderOperations[i].Equal(that1.RequestHeaderOperations[i]) {
			return false
		}
	}
	if len(this.ResponseHeaderOperations) != len(that1.ResponseHeaderOperations) {
		return false
	}
	for i := range this.ResponseHeaderOperations {
		if !this.ResponseHeaderOperations[i].Equal(that1.ResponseHeaderOperations[i]) {
			return false
		}
	}
	if !this.Sampling.Equal(that1.Sampling) {
		return false
	}
	return true
}
func (this *Rule_HeaderOperationTemplate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Rule_HeaderOperationTemplate)
	if !ok {
		that2, ok := that.(Rule_HeaderOperationTemplate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	if this.Operation != that1.Operation {
		return false
	}
	return true
}
func (this *Action) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Action)
	if !ok {
		that2, ok := that.(Action)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Handler != that1.Handler {
		return false
	}
	if len(this.Instances) != len(that1.Instances) {
		return false
	}
	for i := range this.Instances {
		if this.Instances[i] != that1.Instances[i] {
			return false
		}
	}
	if this.Name != that1.Name {
		return false
	}
	return true
}
func (this *Instance) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Instance)
	if !ok {
		that2, ok := that.(Instance)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.CompiledTemplate != that1.CompiledTemplate {
		return false
	}
	if this.Template != that1.Template {
		return false
	}
	if !this.Params.Equal(that1.Params) {
		return false
	}
	if len(this.AttributeBindings) != len(that1.AttributeBindings) {
		return false
	}
	for i := range this.AttributeBindings {
		if this.AttributeBindings[i] != that1.AttributeBindings[i] {
			return false
		}
	}
	return true
}
func (this *Handler) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Handler)
	if !ok {
		that2, ok := that.(Handler)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.CompiledAdapter != that1.CompiledAdapter {
		return false
	}
	if this.Adapter != that1.Adapter {
		return false
	}
	if !this.Params.Equal(that1.Params) {
		return false
	}
	if !this.Connection.Equal(that1.Connection) {
		return false
	}
	return true
}
func (this *Connection) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Connection)
	if !ok {
		that2, ok := that.(Connection)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	if this.Timeout != nil && that1.Timeout != nil {
		if *this.Timeout != *that1.Timeout {
			return false
		}
	} else if this.Timeout != nil {
		return false
	} else if that1.Timeout != nil {
		return false
	}
	if !this.Authentication.Equal(that1.Authentication) {
		return false
	}
	return true
}
func (this *Sampling) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Sampling)
	if !ok {
		that2, ok := that.(Sampling)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Random.Equal(that1.Random) {
		return false
	}
	if !this.RateLimit.Equal(that1.RateLimit) {
		return false
	}
	return true
}
func (this *RandomSampling) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RandomSampling)
	if !ok {
		that2, ok := that.(RandomSampling)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.AttributeExpression != that1.AttributeExpression {
		return false
	}
	if !this.PercentSampled.Equal(that1.PercentSampled) {
		return false
	}
	if this.UseIndependentRandomness != that1.UseIndependentRandomness {
		return false
	}
	return true
}
func (this *RateLimitSampling) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RateLimitSampling)
	if !ok {
		that2, ok := that.(RateLimitSampling)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SamplingDuration != that1.SamplingDuration {
		return false
	}
	if this.MaxUnsampledEntries != that1.MaxUnsampledEntries {
		return false
	}
	if this.SamplingRate != that1.SamplingRate {
		return false
	}
	return true
}
func (this *FractionalPercent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FractionalPercent)
	if !ok {
		that2, ok := that.(FractionalPercent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Numerator != that1.Numerator {
		return false
	}
	if this.Denominator != that1.Denominator {
		return false
	}
	return true
}
func (this *Authentication) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Authentication)
	if !ok {
		that2, ok := that.(Authentication)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.AuthType == nil {
		if this.AuthType != nil {
			return false
		}
	} else if this.AuthType == nil {
		return false
	} else if !this.AuthType.Equal(that1.AuthType) {
		return false
	}
	return true
}
func (this *Authentication_Tls) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Authentication_Tls)
	if !ok {
		that2, ok := that.(Authentication_Tls)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Tls.Equal(that1.Tls) {
		return false
	}
	return true
}
func (this *Authentication_Mutual) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Authentication_Mutual)
	if !ok {
		that2, ok := that.(Authentication_Mutual)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Mutual.Equal(that1.Mutual) {
		return false
	}
	return true
}
func (this *Tls) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Tls)
	if !ok {
		that2, ok := that.(Tls)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CaCertificates != that1.CaCertificates {
		return false
	}
	if that1.TokenSource == nil {
		if this.TokenSource != nil {
			return false
		}
	} else if this.TokenSource == nil {
		return false
	} else if !this.TokenSource.Equal(that1.TokenSource) {
		return false
	}
	if that1.TokenType == nil {
		if this.TokenType != nil {
			return false
		}
	} else if this.TokenType == nil {
		return false
	} else if !this.TokenType.Equal(that1.TokenType) {
		return false
	}
	if this.ServerName != that1.ServerName {
		return false
	}
	return true
}
func (this *Tls_TokenPath) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Tls_TokenPath)
	if !ok {
		that2, ok := that.(Tls_TokenPath)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TokenPath != that1.TokenPath {
		return false
	}
	return true
}
func (this *Tls_Oauth) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Tls_Oauth)
	if !ok {
		that2, ok := that.(Tls_Oauth)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Oauth.Equal(that1.Oauth) {
		return false
	}
	return true
}
func (this *Tls_AuthHeader_) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Tls_AuthHeader_)
	if !ok {
		that2, ok := that.(Tls_AuthHeader_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.AuthHeader != that1.AuthHeader {
		return false
	}
	return true
}
func (this *Tls_CustomHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Tls_CustomHeader)
	if !ok {
		that2, ok := that.(Tls_CustomHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CustomHeader != that1.CustomHeader {
		return false
	}
	return true
}
func (this *OAuth) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OAuth)
	if !ok {
		that2, ok := that.(OAuth)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClientId != that1.ClientId {
		return false
	}
	if this.ClientSecret != that1.ClientSecret {
		return false
	}
	if this.TokenUrl != that1.TokenUrl {
		return false
	}
	if len(this.Scopes) != len(that1.Scopes) {
		return false
	}
	for i := range this.Scopes {
		if this.Scopes[i] != that1.Scopes[i] {
			return false
		}
	}
	if len(this.EndpointParams) != len(that1.EndpointParams) {
		return false
	}
	for i := range this.EndpointParams {
		if this.EndpointParams[i] != that1.EndpointParams[i] {
			return false
		}
	}
	return true
}
func (this *Mutual) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Mutual)
	if !ok {
		that2, ok := that.(Mutual)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PrivateKey != that1.PrivateKey {
		return false
	}
	if this.ClientCertificate != that1.ClientCertificate {
		return false
	}
	if this.CaCertificates != that1.CaCertificates {
		return false
	}
	if this.ServerName != that1.ServerName {
		return false
	}
	return true
}
func (this *AttributeManifest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&v1beta1.AttributeManifest{")
	s = append(s, "Revision: "+fmt.Sprintf("%#v", this.Revision)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	keysForAttributes := make([]string, 0, len(this.Attributes))
	for k, _ := range this.Attributes {
		keysForAttributes = append(keysForAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAttributes)
	mapStringForAttributes := "map[string]*AttributeManifest_AttributeInfo{"
	for _, k := range keysForAttributes {
		mapStringForAttributes += fmt.Sprintf("%#v: %#v,", k, this.Attributes[k])
	}
	mapStringForAttributes += "}"
	if this.Attributes != nil {
		s = append(s, "Attributes: "+mapStringForAttributes+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AttributeManifest_AttributeInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&v1beta1.AttributeManifest_AttributeInfo{")
	s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	s = append(s, "ValueType: "+fmt.Sprintf("%#v", this.ValueType)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Rule) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&v1beta1.Rule{")
	s = append(s, "Match: "+fmt.Sprintf("%#v", this.Match)+",\n")
	if this.Actions != nil {
		s = append(s, "Actions: "+fmt.Sprintf("%#v", this.Actions)+",\n")
	}
	if this.RequestHeaderOperations != nil {
		s = append(s, "RequestHeaderOperations: "+fmt.Sprintf("%#v", this.RequestHeaderOperations)+",\n")
	}
	if this.ResponseHeaderOperations != nil {
		s = append(s, "ResponseHeaderOperations: "+fmt.Sprintf("%#v", this.ResponseHeaderOperations)+",\n")
	}
	if this.Sampling != nil {
		s = append(s, "Sampling: "+fmt.Sprintf("%#v", this.Sampling)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Rule_HeaderOperationTemplate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&v1beta1.Rule_HeaderOperationTemplate{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	s = append(s, "Operation: "+fmt.Sprintf("%#v", this.Operation)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Action) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&v1beta1.Action{")
	s = append(s, "Handler: "+fmt.Sprintf("%#v", this.Handler)+",\n")
	s = append(s, "Instances: "+fmt.Sprintf("%#v", this.Instances)+",\n")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Instance) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&v1beta1.Instance{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "CompiledTemplate: "+fmt.Sprintf("%#v", this.CompiledTemplate)+",\n")
	s = append(s, "Template: "+fmt.Sprintf("%#v", this.Template)+",\n")
	if this.Params != nil {
		s = append(s, "Params: "+fmt.Sprintf("%#v", this.Params)+",\n")
	}
	keysForAttributeBindings := make([]string, 0, len(this.AttributeBindings))
	for k, _ := range this.AttributeBindings {
		keysForAttributeBindings = append(keysForAttributeBindings, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAttributeBindings)
	mapStringForAttributeBindings := "map[string]string{"
	for _, k := range keysForAttributeBindings {
		mapStringForAttributeBindings += fmt.Sprintf("%#v: %#v,", k, this.AttributeBindings[k])
	}
	mapStringForAttributeBindings += "}"
	if this.AttributeBindings != nil {
		s = append(s, "AttributeBindings: "+mapStringForAttributeBindings+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Handler) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&v1beta1.Handler{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "CompiledAdapter: "+fmt.Sprintf("%#v", this.CompiledAdapter)+",\n")
	s = append(s, "Adapter: "+fmt.Sprintf("%#v", this.Adapter)+",\n")
	if this.Params != nil {
		s = append(s, "Params: "+fmt.Sprintf("%#v", this.Params)+",\n")
	}
	if this.Connection != nil {
		s = append(s, "Connection: "+fmt.Sprintf("%#v", this.Connection)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Connection) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&v1beta1.Connection{")
	s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	s = append(s, "Timeout: "+fmt.Sprintf("%#v", this.Timeout)+",\n")
	if this.Authentication != nil {
		s = append(s, "Authentication: "+fmt.Sprintf("%#v", this.Authentication)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Sampling) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&v1beta1.Sampling{")
	if this.Random != nil {
		s = append(s, "Random: "+fmt.Sprintf("%#v", this.Random)+",\n")
	}
	if this.RateLimit != nil {
		s = append(s, "RateLimit: "+fmt.Sprintf("%#v", this.RateLimit)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RandomSampling) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&v1beta1.RandomSampling{")
	s = append(s, "AttributeExpression: "+fmt.Sprintf("%#v", this.AttributeExpression)+",\n")
	if this.PercentSampled != nil {
		s = append(s, "PercentSampled: "+fmt.Sprintf("%#v", this.PercentSampled)+",\n")
	}
	s = append(s, "UseIndependentRandomness: "+fmt.Sprintf("%#v", this.UseIndependentRandomness)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RateLimitSampling) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&v1beta1.RateLimitSampling{")
	s = append(s, "SamplingDuration: "+fmt.Sprintf("%#v", this.SamplingDuration)+",\n")
	s = append(s, "MaxUnsampledEntries: "+fmt.Sprintf("%#v", this.MaxUnsampledEntries)+",\n")
	s = append(s, "SamplingRate: "+fmt.Sprintf("%#v", this.SamplingRate)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FractionalPercent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&v1beta1.FractionalPercent{")
	s = append(s, "Numerator: "+fmt.Sprintf("%#v", this.Numerator)+",\n")
	s = append(s, "Denominator: "+fmt.Sprintf("%#v", this.Denominator)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Authentication) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&v1beta1.Authentication{")
	if this.AuthType != nil {
		s = append(s, "AuthType: "+fmt.Sprintf("%#v", this.AuthType)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Authentication_Tls) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&v1beta1.Authentication_Tls{` +
		`Tls:` + fmt.Sprintf("%#v", this.Tls) + `}`}, ", ")
	return s
}
func (this *Authentication_Mutual) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&v1beta1.Authentication_Mutual{` +
		`Mutual:` + fmt.Sprintf("%#v", this.Mutual) + `}`}, ", ")
	return s
}
func (this *Tls) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&v1beta1.Tls{")
	s = append(s, "CaCertificates: "+fmt.Sprintf("%#v", this.CaCertificates)+",\n")
	if this.TokenSource != nil {
		s = append(s, "TokenSource: "+fmt.Sprintf("%#v", this.TokenSource)+",\n")
	}
	if this.TokenType != nil {
		s = append(s, "TokenType: "+fmt.Sprintf("%#v", this.TokenType)+",\n")
	}
	s = append(s, "ServerName: "+fmt.Sprintf("%#v", this.ServerName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Tls_TokenPath) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&v1beta1.Tls_TokenPath{` +
		`TokenPath:` + fmt.Sprintf("%#v", this.TokenPath) + `}`}, ", ")
	return s
}
func (this *Tls_Oauth) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&v1beta1.Tls_Oauth{` +
		`Oauth:` + fmt.Sprintf("%#v", this.Oauth) + `}`}, ", ")
	return s
}
func (this *Tls_AuthHeader_) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&v1beta1.Tls_AuthHeader_{` +
		`AuthHeader:` + fmt.Sprintf("%#v", this.AuthHeader) + `}`}, ", ")
	return s
}
func (this *Tls_CustomHeader) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&v1beta1.Tls_CustomHeader{` +
		`CustomHeader:` + fmt.Sprintf("%#v", this.CustomHeader) + `}`}, ", ")
	return s
}
func (this *OAuth) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&v1beta1.OAuth{")
	s = append(s, "ClientId: "+fmt.Sprintf("%#v", this.ClientId)+",\n")
	s = append(s, "ClientSecret: "+fmt.Sprintf("%#v", this.ClientSecret)+",\n")
	s = append(s, "TokenUrl: "+fmt.Sprintf("%#v", this.TokenUrl)+",\n")
	s = append(s, "Scopes: "+fmt.Sprintf("%#v", this.Scopes)+",\n")
	keysForEndpointParams := make([]string, 0, len(this.EndpointParams))
	for k, _ := range this.EndpointParams {
		keysForEndpointParams = append(keysForEndpointParams, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForEndpointParams)
	mapStringForEndpointParams := "map[string]string{"
	for _, k := range keysForEndpointParams {
		mapStringForEndpointParams += fmt.Sprintf("%#v: %#v,", k, this.EndpointParams[k])
	}
	mapStringForEndpointParams += "}"
	if this.EndpointParams != nil {
		s = append(s, "EndpointParams: "+mapStringForEndpointParams+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Mutual) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&v1beta1.Mutual{")
	s = append(s, "PrivateKey: "+fmt.Sprintf("%#v", this.PrivateKey)+",\n")
	s = append(s, "ClientCertificate: "+fmt.Sprintf("%#v", this.ClientCertificate)+",\n")
	s = append(s, "CaCertificates: "+fmt.Sprintf("%#v", this.CaCertificates)+",\n")
	s = append(s, "ServerName: "+fmt.Sprintf("%#v", this.ServerName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringCfg(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *AttributeManifest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeManifest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Revision) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Revision)))
		i += copy(dAtA[i:], m.Revision)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Attributes) > 0 {
		for k, _ := range m.Attributes {
			dAtA[i] = 0x1a
			i++
			v := m.Attributes[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovCfg(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovCfg(uint64(len(k))) + msgSize
			i = encodeVarintCfg(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCfg(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintCfg(dAtA, i, uint64(v.Size()))
				n1, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n1
			}
		}
	}
	return i, nil
}

func (m *AttributeManifest_AttributeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeManifest_AttributeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Description) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.ValueType != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.ValueType))
	}
	return i, nil
}

func (m *Rule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Match) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Match)))
		i += copy(dAtA[i:], m.Match)
	}
	if len(m.Actions) > 0 {
		for _, msg := range m.Actions {
			dAtA[i] = 0x12
			i++
			i = encodeVarintCfg(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RequestHeaderOperations) > 0 {
		for _, msg := range m.RequestHeaderOperations {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintCfg(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeaderOperations) > 0 {
		for _, msg := range m.ResponseHeaderOperations {
			dAtA[i] = 0x22
			i++
			i = encodeVarintCfg(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Sampling != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Sampling.Size()))
		n2, err := m.Sampling.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *Rule_HeaderOperationTemplate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule_HeaderOperationTemplate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Operation != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Operation))
	}
	return i, nil
}

func (m *Action) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Action) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Handler) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Handler)))
		i += copy(dAtA[i:], m.Handler)
	}
	if len(m.Instances) > 0 {
		for _, s := range m.Instances {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Instance) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Instance) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Template) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Template)))
		i += copy(dAtA[i:], m.Template)
	}
	if m.Params != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Params.Size()))
		n3, err := m.Params.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.AttributeBindings) > 0 {
		for k, _ := range m.AttributeBindings {
			dAtA[i] = 0x22
			i++
			v := m.AttributeBindings[k]
			mapSize := 1 + len(k) + sovCfg(uint64(len(k))) + 1 + len(v) + sovCfg(uint64(len(v)))
			i = encodeVarintCfg(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCfg(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintCfg(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.CompiledTemplate) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0xef
		i++
		dAtA[i] = 0xce
		i++
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.CompiledTemplate)))
		i += copy(dAtA[i:], m.CompiledTemplate)
	}
	return i, nil
}

func (m *Handler) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Handler) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Adapter) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Adapter)))
		i += copy(dAtA[i:], m.Adapter)
	}
	if m.Params != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Params.Size()))
		n4, err := m.Params.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Connection != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Connection.Size()))
		n5, err := m.Connection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.CompiledAdapter) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0xef
		i++
		dAtA[i] = 0xce
		i++
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.CompiledAdapter)))
		i += copy(dAtA[i:], m.CompiledAdapter)
	}
	return i, nil
}

func (m *Connection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Address) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.Timeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCfg(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)))
		n6, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Timeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Authentication != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Authentication.Size()))
		n7, err := m.Authentication.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *Sampling) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sampling) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Random != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Random.Size()))
		n8, err := m.Random.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.RateLimit != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.RateLimit.Size()))
		n9, err := m.RateLimit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *RandomSampling) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RandomSampling) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AttributeExpression) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.AttributeExpression)))
		i += copy(dAtA[i:], m.AttributeExpression)
	}
	if m.PercentSampled != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.PercentSampled.Size()))
		n10, err := m.PercentSampled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.UseIndependentRandomness {
		dAtA[i] = 0x18
		i++
		if m.UseIndependentRandomness {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RateLimitSampling) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimitSampling) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintCfg(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.SamplingDuration)))
	n11, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.SamplingDuration, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	if m.MaxUnsampledEntries != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.MaxUnsampledEntries))
	}
	if m.SamplingRate != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.SamplingRate))
	}
	return i, nil
}

func (m *FractionalPercent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FractionalPercent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Numerator != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Numerator))
	}
	if m.Denominator != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Denominator))
	}
	return i, nil
}

func (m *Authentication) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Authentication) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AuthType != nil {
		nn12, err := m.AuthType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn12
	}
	return i, nil
}

func (m *Authentication_Tls) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Tls != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Tls.Size()))
		n13, err := m.Tls.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *Authentication_Mutual) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Mutual != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Mutual.Size()))
		n14, err := m.Mutual.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *Tls) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tls) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.CaCertificates) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.CaCertificates)))
		i += copy(dAtA[i:], m.CaCertificates)
	}
	if m.TokenSource != nil {
		nn15, err := m.TokenSource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn15
	}
	if m.TokenType != nil {
		nn16, err := m.TokenType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn16
	}
	if len(m.ServerName) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.ServerName)))
		i += copy(dAtA[i:], m.ServerName)
	}
	return i, nil
}

func (m *Tls_TokenPath) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintCfg(dAtA, i, uint64(len(m.TokenPath)))
	i += copy(dAtA[i:], m.TokenPath)
	return i, nil
}
func (m *Tls_Oauth) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Oauth != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCfg(dAtA, i, uint64(m.Oauth.Size()))
		n17, err := m.Oauth.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *Tls_AuthHeader_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x20
	i++
	i = encodeVarintCfg(dAtA, i, uint64(m.AuthHeader))
	return i, nil
}
func (m *Tls_CustomHeader) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x2a
	i++
	i = encodeVarintCfg(dAtA, i, uint64(len(m.CustomHeader)))
	i += copy(dAtA[i:], m.CustomHeader)
	return i, nil
}
func (m *OAuth) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OAuth) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClientId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.ClientId)))
		i += copy(dAtA[i:], m.ClientId)
	}
	if len(m.ClientSecret) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.ClientSecret)))
		i += copy(dAtA[i:], m.ClientSecret)
	}
	if len(m.TokenUrl) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.TokenUrl)))
		i += copy(dAtA[i:], m.TokenUrl)
	}
	if len(m.Scopes) > 0 {
		for _, s := range m.Scopes {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.EndpointParams) > 0 {
		for k, _ := range m.EndpointParams {
			dAtA[i] = 0x2a
			i++
			v := m.EndpointParams[k]
			mapSize := 1 + len(k) + sovCfg(uint64(len(k))) + 1 + len(v) + sovCfg(uint64(len(v)))
			i = encodeVarintCfg(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCfg(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintCfg(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *Mutual) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mutual) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.PrivateKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.PrivateKey)))
		i += copy(dAtA[i:], m.PrivateKey)
	}
	if len(m.ClientCertificate) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.ClientCertificate)))
		i += copy(dAtA[i:], m.ClientCertificate)
	}
	if len(m.CaCertificates) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.CaCertificates)))
		i += copy(dAtA[i:], m.CaCertificates)
	}
	if len(m.ServerName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCfg(dAtA, i, uint64(len(m.ServerName)))
		i += copy(dAtA[i:], m.ServerName)
	}
	return i, nil
}

func encodeVarintCfg(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *AttributeManifest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Revision)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if len(m.Attributes) > 0 {
		for k, v := range m.Attributes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovCfg(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovCfg(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovCfg(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *AttributeManifest_AttributeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.ValueType != 0 {
		n += 1 + sovCfg(uint64(m.ValueType))
	}
	return n
}

func (m *Rule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Match)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if len(m.Actions) > 0 {
		for _, e := range m.Actions {
			l = e.Size()
			n += 1 + l + sovCfg(uint64(l))
		}
	}
	if len(m.RequestHeaderOperations) > 0 {
		for _, e := range m.RequestHeaderOperations {
			l = e.Size()
			n += 1 + l + sovCfg(uint64(l))
		}
	}
	if len(m.ResponseHeaderOperations) > 0 {
		for _, e := range m.ResponseHeaderOperations {
			l = e.Size()
			n += 1 + l + sovCfg(uint64(l))
		}
	}
	if m.Sampling != nil {
		l = m.Sampling.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}

func (m *Rule_HeaderOperationTemplate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovCfg(uint64(l))
		}
	}
	if m.Operation != 0 {
		n += 1 + sovCfg(uint64(m.Operation))
	}
	return n
}

func (m *Action) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Handler)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if len(m.Instances) > 0 {
		for _, s := range m.Instances {
			l = len(s)
			n += 1 + l + sovCfg(uint64(l))
		}
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}

func (m *Instance) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.Template)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.Params != nil {
		l = m.Params.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	if len(m.AttributeBindings) > 0 {
		for k, v := range m.AttributeBindings {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovCfg(uint64(len(k))) + 1 + len(v) + sovCfg(uint64(len(v)))
			n += mapEntrySize + 1 + sovCfg(uint64(mapEntrySize))
		}
	}
	l = len(m.CompiledTemplate)
	if l > 0 {
		n += 5 + l + sovCfg(uint64(l))
	}
	return n
}

func (m *Handler) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.Adapter)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.Params != nil {
		l = m.Params.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.Connection != nil {
		l = m.Connection.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.CompiledAdapter)
	if l > 0 {
		n += 5 + l + sovCfg(uint64(l))
	}
	return n
}

func (m *Connection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.Timeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.Authentication != nil {
		l = m.Authentication.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}

func (m *Sampling) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Random != nil {
		l = m.Random.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.RateLimit != nil {
		l = m.RateLimit.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}

func (m *RandomSampling) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AttributeExpression)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.PercentSampled != nil {
		l = m.PercentSampled.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.UseIndependentRandomness {
		n += 2
	}
	return n
}

func (m *RateLimitSampling) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.SamplingDuration)
	n += 1 + l + sovCfg(uint64(l))
	if m.MaxUnsampledEntries != 0 {
		n += 1 + sovCfg(uint64(m.MaxUnsampledEntries))
	}
	if m.SamplingRate != 0 {
		n += 1 + sovCfg(uint64(m.SamplingRate))
	}
	return n
}

func (m *FractionalPercent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Numerator != 0 {
		n += 1 + sovCfg(uint64(m.Numerator))
	}
	if m.Denominator != 0 {
		n += 1 + sovCfg(uint64(m.Denominator))
	}
	return n
}

func (m *Authentication) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AuthType != nil {
		n += m.AuthType.Size()
	}
	return n
}

func (m *Authentication_Tls) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Tls != nil {
		l = m.Tls.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}
func (m *Authentication_Mutual) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mutual != nil {
		l = m.Mutual.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}
func (m *Tls) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CaCertificates)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if m.TokenSource != nil {
		n += m.TokenSource.Size()
	}
	if m.TokenType != nil {
		n += m.TokenType.Size()
	}
	l = len(m.ServerName)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}

func (m *Tls_TokenPath) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TokenPath)
	n += 1 + l + sovCfg(uint64(l))
	return n
}
func (m *Tls_Oauth) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Oauth != nil {
		l = m.Oauth.Size()
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}
func (m *Tls_AuthHeader_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovCfg(uint64(m.AuthHeader))
	return n
}
func (m *Tls_CustomHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CustomHeader)
	n += 1 + l + sovCfg(uint64(l))
	return n
}
func (m *OAuth) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClientId)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.ClientSecret)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.TokenUrl)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	if len(m.Scopes) > 0 {
		for _, s := range m.Scopes {
			l = len(s)
			n += 1 + l + sovCfg(uint64(l))
		}
	}
	if len(m.EndpointParams) > 0 {
		for k, v := range m.EndpointParams {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovCfg(uint64(len(k))) + 1 + len(v) + sovCfg(uint64(len(v)))
			n += mapEntrySize + 1 + sovCfg(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Mutual) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PrivateKey)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.ClientCertificate)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.CaCertificates)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	l = len(m.ServerName)
	if l > 0 {
		n += 1 + l + sovCfg(uint64(l))
	}
	return n
}

func sovCfg(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCfg(x uint64) (n int) {
	return sovCfg(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *AttributeManifest) String() string {
	if this == nil {
		return "nil"
	}
	keysForAttributes := make([]string, 0, len(this.Attributes))
	for k, _ := range this.Attributes {
		keysForAttributes = append(keysForAttributes, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAttributes)
	mapStringForAttributes := "map[string]*AttributeManifest_AttributeInfo{"
	for _, k := range keysForAttributes {
		mapStringForAttributes += fmt.Sprintf("%v: %v,", k, this.Attributes[k])
	}
	mapStringForAttributes += "}"
	s := strings.Join([]string{`&AttributeManifest{`,
		`Revision:` + fmt.Sprintf("%v", this.Revision) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Attributes:` + mapStringForAttributes + `,`,
		`}`,
	}, "")
	return s
}
func (this *AttributeManifest_AttributeInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AttributeManifest_AttributeInfo{`,
		`Description:` + fmt.Sprintf("%v", this.Description) + `,`,
		`ValueType:` + fmt.Sprintf("%v", this.ValueType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Rule) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Rule{`,
		`Match:` + fmt.Sprintf("%v", this.Match) + `,`,
		`Actions:` + strings.Replace(fmt.Sprintf("%v", this.Actions), "Action", "Action", 1) + `,`,
		`RequestHeaderOperations:` + strings.Replace(fmt.Sprintf("%v", this.RequestHeaderOperations), "Rule_HeaderOperationTemplate", "Rule_HeaderOperationTemplate", 1) + `,`,
		`ResponseHeaderOperations:` + strings.Replace(fmt.Sprintf("%v", this.ResponseHeaderOperations), "Rule_HeaderOperationTemplate", "Rule_HeaderOperationTemplate", 1) + `,`,
		`Sampling:` + strings.Replace(fmt.Sprintf("%v", this.Sampling), "Sampling", "Sampling", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Rule_HeaderOperationTemplate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Rule_HeaderOperationTemplate{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Values:` + fmt.Sprintf("%v", this.Values) + `,`,
		`Operation:` + fmt.Sprintf("%v", this.Operation) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Action) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Action{`,
		`Handler:` + fmt.Sprintf("%v", this.Handler) + `,`,
		`Instances:` + fmt.Sprintf("%v", this.Instances) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Instance) String() string {
	if this == nil {
		return "nil"
	}
	keysForAttributeBindings := make([]string, 0, len(this.AttributeBindings))
	for k, _ := range this.AttributeBindings {
		keysForAttributeBindings = append(keysForAttributeBindings, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForAttributeBindings)
	mapStringForAttributeBindings := "map[string]string{"
	for _, k := range keysForAttributeBindings {
		mapStringForAttributeBindings += fmt.Sprintf("%v: %v,", k, this.AttributeBindings[k])
	}
	mapStringForAttributeBindings += "}"
	s := strings.Join([]string{`&Instance{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Template:` + fmt.Sprintf("%v", this.Template) + `,`,
		`Params:` + strings.Replace(fmt.Sprintf("%v", this.Params), "Struct", "types.Struct", 1) + `,`,
		`AttributeBindings:` + mapStringForAttributeBindings + `,`,
		`CompiledTemplate:` + fmt.Sprintf("%v", this.CompiledTemplate) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Handler) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Handler{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Adapter:` + fmt.Sprintf("%v", this.Adapter) + `,`,
		`Params:` + strings.Replace(fmt.Sprintf("%v", this.Params), "Struct", "types.Struct", 1) + `,`,
		`Connection:` + strings.Replace(fmt.Sprintf("%v", this.Connection), "Connection", "Connection", 1) + `,`,
		`CompiledAdapter:` + fmt.Sprintf("%v", this.CompiledAdapter) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Connection) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Connection{`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`Timeout:` + strings.Replace(fmt.Sprintf("%v", this.Timeout), "Duration", "types.Duration", 1) + `,`,
		`Authentication:` + strings.Replace(fmt.Sprintf("%v", this.Authentication), "Authentication", "Authentication", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Sampling) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Sampling{`,
		`Random:` + strings.Replace(fmt.Sprintf("%v", this.Random), "RandomSampling", "RandomSampling", 1) + `,`,
		`RateLimit:` + strings.Replace(fmt.Sprintf("%v", this.RateLimit), "RateLimitSampling", "RateLimitSampling", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RandomSampling) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RandomSampling{`,
		`AttributeExpression:` + fmt.Sprintf("%v", this.AttributeExpression) + `,`,
		`PercentSampled:` + strings.Replace(fmt.Sprintf("%v", this.PercentSampled), "FractionalPercent", "FractionalPercent", 1) + `,`,
		`UseIndependentRandomness:` + fmt.Sprintf("%v", this.UseIndependentRandomness) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RateLimitSampling) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RateLimitSampling{`,
		`SamplingDuration:` + strings.Replace(strings.Replace(this.SamplingDuration.String(), "Duration", "types.Duration", 1), `&`, ``, 1) + `,`,
		`MaxUnsampledEntries:` + fmt.Sprintf("%v", this.MaxUnsampledEntries) + `,`,
		`SamplingRate:` + fmt.Sprintf("%v", this.SamplingRate) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FractionalPercent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FractionalPercent{`,
		`Numerator:` + fmt.Sprintf("%v", this.Numerator) + `,`,
		`Denominator:` + fmt.Sprintf("%v", this.Denominator) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Authentication) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Authentication{`,
		`AuthType:` + fmt.Sprintf("%v", this.AuthType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Authentication_Tls) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Authentication_Tls{`,
		`Tls:` + strings.Replace(fmt.Sprintf("%v", this.Tls), "Tls", "Tls", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Authentication_Mutual) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Authentication_Mutual{`,
		`Mutual:` + strings.Replace(fmt.Sprintf("%v", this.Mutual), "Mutual", "Mutual", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Tls) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Tls{`,
		`CaCertificates:` + fmt.Sprintf("%v", this.CaCertificates) + `,`,
		`TokenSource:` + fmt.Sprintf("%v", this.TokenSource) + `,`,
		`TokenType:` + fmt.Sprintf("%v", this.TokenType) + `,`,
		`ServerName:` + fmt.Sprintf("%v", this.ServerName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Tls_TokenPath) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Tls_TokenPath{`,
		`TokenPath:` + fmt.Sprintf("%v", this.TokenPath) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Tls_Oauth) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Tls_Oauth{`,
		`Oauth:` + strings.Replace(fmt.Sprintf("%v", this.Oauth), "OAuth", "OAuth", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Tls_AuthHeader_) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Tls_AuthHeader_{`,
		`AuthHeader:` + fmt.Sprintf("%v", this.AuthHeader) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Tls_CustomHeader) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Tls_CustomHeader{`,
		`CustomHeader:` + fmt.Sprintf("%v", this.CustomHeader) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OAuth) String() string {
	if this == nil {
		return "nil"
	}
	keysForEndpointParams := make([]string, 0, len(this.EndpointParams))
	for k, _ := range this.EndpointParams {
		keysForEndpointParams = append(keysForEndpointParams, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForEndpointParams)
	mapStringForEndpointParams := "map[string]string{"
	for _, k := range keysForEndpointParams {
		mapStringForEndpointParams += fmt.Sprintf("%v: %v,", k, this.EndpointParams[k])
	}
	mapStringForEndpointParams += "}"
	s := strings.Join([]string{`&OAuth{`,
		`ClientId:` + fmt.Sprintf("%v", this.ClientId) + `,`,
		`ClientSecret:` + fmt.Sprintf("%v", this.ClientSecret) + `,`,
		`TokenUrl:` + fmt.Sprintf("%v", this.TokenUrl) + `,`,
		`Scopes:` + fmt.Sprintf("%v", this.Scopes) + `,`,
		`EndpointParams:` + mapStringForEndpointParams + `,`,
		`}`,
	}, "")
	return s
}
func (this *Mutual) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Mutual{`,
		`PrivateKey:` + fmt.Sprintf("%v", this.PrivateKey) + `,`,
		`ClientCertificate:` + fmt.Sprintf("%v", this.ClientCertificate) + `,`,
		`CaCertificates:` + fmt.Sprintf("%v", this.CaCertificates) + `,`,
		`ServerName:` + fmt.Sprintf("%v", this.ServerName) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringCfg(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *AttributeManifest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeManifest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeManifest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Revision = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = make(map[string]*AttributeManifest_AttributeInfo)
			}
			var mapkey string
			var mapvalue *AttributeManifest_AttributeInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCfg
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCfg
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCfg
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthCfg
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCfg
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCfg
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthCfg
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &AttributeManifest_AttributeInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCfg(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCfg
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attributes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeManifest_AttributeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueType", wireType)
			}
			m.ValueType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValueType |= ValueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Match = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Actions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Actions = append(m.Actions, &Action{})
			if err := m.Actions[len(m.Actions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeaderOperations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeaderOperations = append(m.RequestHeaderOperations, &Rule_HeaderOperationTemplate{})
			if err := m.RequestHeaderOperations[len(m.RequestHeaderOperations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeaderOperations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeaderOperations = append(m.ResponseHeaderOperations, &Rule_HeaderOperationTemplate{})
			if err := m.ResponseHeaderOperations[len(m.ResponseHeaderOperations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sampling", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sampling == nil {
				m.Sampling = &Sampling{}
			}
			if err := m.Sampling.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rule_HeaderOperationTemplate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderOperationTemplate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderOperationTemplate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			m.Operation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Operation |= Rule_HeaderOperationTemplate_Operation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Action) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Action: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Action: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Handler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Instance) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Instance: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Instance: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Template", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Template = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Params == nil {
				m.Params = &types.Struct{}
			}
			if err := m.Params.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeBindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AttributeBindings == nil {
				m.AttributeBindings = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCfg
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCfg
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCfg
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthCfg
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCfg
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthCfg
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthCfg
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCfg(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCfg
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AttributeBindings[mapkey] = mapvalue
			iNdEx = postIndex
		case 67794676:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompiledTemplate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompiledTemplate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Handler) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Handler: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Handler: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Adapter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Adapter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Params == nil {
				m.Params = &types.Struct{}
			}
			if err := m.Params.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Connection == nil {
				m.Connection = &Connection{}
			}
			if err := m.Connection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 67794676:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompiledAdapter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompiledAdapter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Timeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authentication", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Authentication == nil {
				m.Authentication = &Authentication{}
			}
			if err := m.Authentication.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Sampling) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Sampling: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Sampling: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Random", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Random == nil {
				m.Random = &RandomSampling{}
			}
			if err := m.Random.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RateLimit == nil {
				m.RateLimit = &RateLimitSampling{}
			}
			if err := m.RateLimit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RandomSampling) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RandomSampling: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RandomSampling: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeExpression", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttributeExpression = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PercentSampled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PercentSampled == nil {
				m.PercentSampled = &FractionalPercent{}
			}
			if err := m.PercentSampled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseIndependentRandomness", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseIndependentRandomness = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimitSampling) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RateLimitSampling: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RateLimitSampling: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SamplingDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.SamplingDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxUnsampledEntries", wireType)
			}
			m.MaxUnsampledEntries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxUnsampledEntries |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SamplingRate", wireType)
			}
			m.SamplingRate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SamplingRate |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FractionalPercent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FractionalPercent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FractionalPercent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Numerator", wireType)
			}
			m.Numerator = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Numerator |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Denominator", wireType)
			}
			m.Denominator = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Denominator |= FractionalPercent_DenominatorType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Authentication) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Authentication: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Authentication: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Tls{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.AuthType = &Authentication_Tls{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutual", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Mutual{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.AuthType = &Authentication_Mutual{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tls) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tls: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tls: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificates", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificates = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TokenPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TokenSource = &Tls_TokenPath{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Oauth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &OAuth{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TokenSource = &Tls_Oauth{v}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthHeader", wireType)
			}
			var v Tls_AuthHeader
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= Tls_AuthHeader(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TokenType = &Tls_AuthHeader_{v}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomHeader", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TokenType = &Tls_CustomHeader{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OAuth) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OAuth: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OAuth: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientSecret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientSecret = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TokenUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TokenUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scopes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scopes = append(m.Scopes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndpointParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndpointParams == nil {
				m.EndpointParams = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCfg
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCfg
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCfg
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthCfg
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCfg
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthCfg
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthCfg
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCfg(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCfg
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.EndpointParams[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mutual) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mutual: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mutual: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertificate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertificate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificates", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificates = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCfg
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCfg
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCfg(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCfg
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCfg(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCfg
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCfg
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCfg
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthCfg
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCfg
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCfg(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthCfg
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCfg = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCfg   = fmt.Errorf("proto: integer overflow")
)
