/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/serving-operator/pkg/apis/serving/v1alpha1"
)

// KnativeServingLister helps list KnativeServings.
type KnativeServingLister interface {
	// List lists all KnativeServings in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.KnativeServing, err error)
	// KnativeServings returns an object that can list and get KnativeServings.
	KnativeServings(namespace string) KnativeServingNamespaceLister
	KnativeServingListerExpansion
}

// knativeServingLister implements the KnativeServingLister interface.
type knativeServingLister struct {
	indexer cache.Indexer
}

// NewKnativeServingLister returns a new KnativeServingLister.
func NewKnativeServingLister(indexer cache.Indexer) KnativeServingLister {
	return &knativeServingLister{indexer: indexer}
}

// List lists all KnativeServings in the indexer.
func (s *knativeServingLister) List(selector labels.Selector) (ret []*v1alpha1.KnativeServing, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.KnativeServing))
	})
	return ret, err
}

// KnativeServings returns an object that can list and get KnativeServings.
func (s *knativeServingLister) KnativeServings(namespace string) KnativeServingNamespaceLister {
	return knativeServingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// KnativeServingNamespaceLister helps list and get KnativeServings.
type KnativeServingNamespaceLister interface {
	// List lists all KnativeServings in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.KnativeServing, err error)
	// Get retrieves the KnativeServing from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.KnativeServing, error)
	KnativeServingNamespaceListerExpansion
}

// knativeServingNamespaceLister implements the KnativeServingNamespaceLister
// interface.
type knativeServingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all KnativeServings in the indexer for a given namespace.
func (s knativeServingNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.KnativeServing, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.KnativeServing))
	})
	return ret, err
}

// Get retrieves the KnativeServing from the indexer for a given namespace and name.
func (s knativeServingNamespaceLister) Get(name string) (*v1alpha1.KnativeServing, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("knativeserving"), name)
	}
	return obj.(*v1alpha1.KnativeServing), nil
}
