// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/api/v2/route/route.proto

package envoy_api_v2_route

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/golang/protobuf/ptypes"

	core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = ptypes.DynamicAny{}

	_ = core.RoutingPriority(0)

	_ = core.RequestMethod(0)
)

// define the regex for a UUID once up-front
var _route_uuidPattern = regexp.MustCompile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")

// Validate checks the field values on VirtualHost with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *VirtualHost) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return VirtualHostValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
	}

	if len(m.GetDomains()) < 1 {
		return VirtualHostValidationError{
			field:  "Domains",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetRoutes() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("Routes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for RequireTls

	for idx, item := range m.GetVirtualClusters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("VirtualClusters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRateLimits() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("RateLimits[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetRequestHeadersToAdd()) > 1000 {
		return VirtualHostValidationError{
			field:  "RequestHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetResponseHeadersToAdd()) > 1000 {
		return VirtualHostValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetCors()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "Cors",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for key, val := range m.GetPerFilterConfig() {
		_ = val

		// no validation rules for PerFilterConfig[key]

		if v, ok := interface{}(val).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("PerFilterConfig[%v]", key),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for key, val := range m.GetTypedPerFilterConfig() {
		_ = val

		// no validation rules for TypedPerFilterConfig[key]

		if v, ok := interface{}(val).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for IncludeRequestAttemptCount

	if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetHedgePolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "HedgePolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPerRequestBufferLimitBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				field:  "PerRequestBufferLimitBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// VirtualHostValidationError is the validation error returned by
// VirtualHost.Validate if the designated constraints aren't met.
type VirtualHostValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e VirtualHostValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e VirtualHostValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e VirtualHostValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e VirtualHostValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e VirtualHostValidationError) ErrorName() string { return "VirtualHostValidationError" }

// Error satisfies the builtin error interface
func (e VirtualHostValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sVirtualHost.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = VirtualHostValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = VirtualHostValidationError{}

// Validate checks the field values on Route with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Route) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Name

	if m.GetMatch() == nil {
		return RouteValidationError{
			field:  "Match",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Match",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetDecorator()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Decorator",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for key, val := range m.GetPerFilterConfig() {
		_ = val

		// no validation rules for PerFilterConfig[key]

		if v, ok := interface{}(val).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  fmt.Sprintf("PerFilterConfig[%v]", key),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for key, val := range m.GetTypedPerFilterConfig() {
		_ = val

		// no validation rules for TypedPerFilterConfig[key]

		if v, ok := interface{}(val).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetRequestHeadersToAdd()) > 1000 {
		return RouteValidationError{
			field:  "RequestHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetResponseHeadersToAdd()) > 1000 {
		return RouteValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPerRequestBufferLimitBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				field:  "PerRequestBufferLimitBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.Action.(type) {

	case *Route_Route:

		if v, ok := interface{}(m.GetRoute()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "Route",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Route_Redirect:

		if v, ok := interface{}(m.GetRedirect()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "Redirect",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Route_DirectResponse:

		if v, ok := interface{}(m.GetDirectResponse()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					field:  "DirectResponse",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return RouteValidationError{
			field:  "Action",
			reason: "value is required",
		}

	}

	return nil
}

// RouteValidationError is the validation error returned by Route.Validate if
// the designated constraints aren't met.
type RouteValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteValidationError) ErrorName() string { return "RouteValidationError" }

// Error satisfies the builtin error interface
func (e RouteValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRoute.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteValidationError{}

// Validate checks the field values on WeightedCluster with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *WeightedCluster) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetClusters()) < 1 {
		return WeightedClusterValidationError{
			field:  "Clusters",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetClusters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedClusterValidationError{
					field:  fmt.Sprintf("Clusters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if wrapper := m.GetTotalWeight(); wrapper != nil {

		if wrapper.GetValue() < 1 {
			return WeightedClusterValidationError{
				field:  "TotalWeight",
				reason: "value must be greater than or equal to 1",
			}
		}

	}

	// no validation rules for RuntimeKeyPrefix

	return nil
}

// WeightedClusterValidationError is the validation error returned by
// WeightedCluster.Validate if the designated constraints aren't met.
type WeightedClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WeightedClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WeightedClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WeightedClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WeightedClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WeightedClusterValidationError) ErrorName() string { return "WeightedClusterValidationError" }

// Error satisfies the builtin error interface
func (e WeightedClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWeightedCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WeightedClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WeightedClusterValidationError{}

// Validate checks the field values on RouteMatch with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RouteMatch) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetCaseSensitive()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "CaseSensitive",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRuntimeFraction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "RuntimeFraction",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetQueryParameters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  fmt.Sprintf("QueryParameters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetGrpc()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "Grpc",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTlsContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				field:  "TlsContext",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.PathSpecifier.(type) {

	case *RouteMatch_Prefix:
		// no validation rules for Prefix

	case *RouteMatch_Path:
		// no validation rules for Path

	case *RouteMatch_Regex:

		if len(m.GetRegex()) > 1024 {
			return RouteMatchValidationError{
				field:  "Regex",
				reason: "value length must be at most 1024 bytes",
			}
		}

	case *RouteMatch_SafeRegex:

		if m.GetSafeRegex() == nil {
			return RouteMatchValidationError{
				field:  "SafeRegex",
				reason: "value is required",
			}
		}

		if v, ok := interface{}(m.GetSafeRegex()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					field:  "SafeRegex",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return RouteMatchValidationError{
			field:  "PathSpecifier",
			reason: "value is required",
		}

	}

	return nil
}

// RouteMatchValidationError is the validation error returned by
// RouteMatch.Validate if the designated constraints aren't met.
type RouteMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteMatchValidationError) ErrorName() string { return "RouteMatchValidationError" }

// Error satisfies the builtin error interface
func (e RouteMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteMatchValidationError{}

// Validate checks the field values on CorsPolicy with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *CorsPolicy) Validate() error {
	if m == nil {
		return nil
	}

	for idx, item := range m.GetAllowOriginRegex() {
		_, _ = idx, item

		if len(item) > 1024 {
			return CorsPolicyValidationError{
				field:  fmt.Sprintf("AllowOriginRegex[%v]", idx),
				reason: "value length must be at most 1024 bytes",
			}
		}

	}

	for idx, item := range m.GetAllowOriginStringMatch() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CorsPolicyValidationError{
					field:  fmt.Sprintf("AllowOriginStringMatch[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for AllowMethods

	// no validation rules for AllowHeaders

	// no validation rules for ExposeHeaders

	// no validation rules for MaxAge

	if v, ok := interface{}(m.GetAllowCredentials()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				field:  "AllowCredentials",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetShadowEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				field:  "ShadowEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.EnabledSpecifier.(type) {

	case *CorsPolicy_Enabled:

		if v, ok := interface{}(m.GetEnabled()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CorsPolicyValidationError{
					field:  "Enabled",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *CorsPolicy_FilterEnabled:

		if v, ok := interface{}(m.GetFilterEnabled()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CorsPolicyValidationError{
					field:  "FilterEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// CorsPolicyValidationError is the validation error returned by
// CorsPolicy.Validate if the designated constraints aren't met.
type CorsPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CorsPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CorsPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CorsPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CorsPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CorsPolicyValidationError) ErrorName() string { return "CorsPolicyValidationError" }

// Error satisfies the builtin error interface
func (e CorsPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCorsPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CorsPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CorsPolicyValidationError{}

// Validate checks the field values on RouteAction with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RouteAction) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := RouteAction_ClusterNotFoundResponseCode_name[int32(m.GetClusterNotFoundResponseCode())]; !ok {
		return RouteActionValidationError{
			field:  "ClusterNotFoundResponseCode",
			reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetMetadataMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "MetadataMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for PrefixRewrite

	if v, ok := interface{}(m.GetTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "Timeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetIdleTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "IdleTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRequestMirrorPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "RequestMirrorPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := core.RoutingPriority_name[int32(m.GetPriority())]; !ok {
		return RouteActionValidationError{
			field:  "Priority",
			reason: "value must be one of the defined enum values",
		}
	}

	for idx, item := range m.GetRateLimits() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  fmt.Sprintf("RateLimits[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetIncludeVhRateLimits()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "IncludeVhRateLimits",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetHashPolicy() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  fmt.Sprintf("HashPolicy[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetCors()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "Cors",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMaxGrpcTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "MaxGrpcTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetGrpcTimeoutOffset()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "GrpcTimeoutOffset",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetUpgradeConfigs() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  fmt.Sprintf("UpgradeConfigs[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for InternalRedirectAction

	if v, ok := interface{}(m.GetHedgePolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				field:  "HedgePolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.ClusterSpecifier.(type) {

	case *RouteAction_Cluster:

		if len(m.GetCluster()) < 1 {
			return RouteActionValidationError{
				field:  "Cluster",
				reason: "value length must be at least 1 bytes",
			}
		}

	case *RouteAction_ClusterHeader:

		if len(m.GetClusterHeader()) < 1 {
			return RouteActionValidationError{
				field:  "ClusterHeader",
				reason: "value length must be at least 1 bytes",
			}
		}

	case *RouteAction_WeightedClusters:

		if v, ok := interface{}(m.GetWeightedClusters()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  "WeightedClusters",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return RouteActionValidationError{
			field:  "ClusterSpecifier",
			reason: "value is required",
		}

	}

	switch m.HostRewriteSpecifier.(type) {

	case *RouteAction_HostRewrite:
		// no validation rules for HostRewrite

	case *RouteAction_AutoHostRewrite:

		if v, ok := interface{}(m.GetAutoHostRewrite()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					field:  "AutoHostRewrite",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_AutoHostRewriteHeader:
		// no validation rules for AutoHostRewriteHeader

	}

	return nil
}

// RouteActionValidationError is the validation error returned by
// RouteAction.Validate if the designated constraints aren't met.
type RouteActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteActionValidationError) ErrorName() string { return "RouteActionValidationError" }

// Error satisfies the builtin error interface
func (e RouteActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteActionValidationError{}

// Validate checks the field values on RetryPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RetryPolicy) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for RetryOn

	if v, ok := interface{}(m.GetNumRetries()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "NumRetries",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPerTryTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "PerTryTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRetryPriority()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "RetryPriority",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetRetryHostPredicate() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetryHostPredicate[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for HostSelectionRetryMaxAttempts

	if v, ok := interface{}(m.GetRetryBackOff()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RetryPolicyValidationError{
				field:  "RetryBackOff",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetRetriableHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetriableHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRetriableRequestHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicyValidationError{
					field:  fmt.Sprintf("RetriableRequestHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// RetryPolicyValidationError is the validation error returned by
// RetryPolicy.Validate if the designated constraints aren't met.
type RetryPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicyValidationError) ErrorName() string { return "RetryPolicyValidationError" }

// Error satisfies the builtin error interface
func (e RetryPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicyValidationError{}

// Validate checks the field values on HedgePolicy with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *HedgePolicy) Validate() error {
	if m == nil {
		return nil
	}

	if wrapper := m.GetInitialRequests(); wrapper != nil {

		if wrapper.GetValue() < 1 {
			return HedgePolicyValidationError{
				field:  "InitialRequests",
				reason: "value must be greater than or equal to 1",
			}
		}

	}

	if v, ok := interface{}(m.GetAdditionalRequestChance()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HedgePolicyValidationError{
				field:  "AdditionalRequestChance",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for HedgeOnPerTryTimeout

	return nil
}

// HedgePolicyValidationError is the validation error returned by
// HedgePolicy.Validate if the designated constraints aren't met.
type HedgePolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HedgePolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HedgePolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HedgePolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HedgePolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HedgePolicyValidationError) ErrorName() string { return "HedgePolicyValidationError" }

// Error satisfies the builtin error interface
func (e HedgePolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHedgePolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HedgePolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HedgePolicyValidationError{}

// Validate checks the field values on RedirectAction with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RedirectAction) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for HostRedirect

	// no validation rules for PortRedirect

	if _, ok := RedirectAction_RedirectResponseCode_name[int32(m.GetResponseCode())]; !ok {
		return RedirectActionValidationError{
			field:  "ResponseCode",
			reason: "value must be one of the defined enum values",
		}
	}

	// no validation rules for StripQuery

	switch m.SchemeRewriteSpecifier.(type) {

	case *RedirectAction_HttpsRedirect:
		// no validation rules for HttpsRedirect

	case *RedirectAction_SchemeRedirect:
		// no validation rules for SchemeRedirect

	}

	switch m.PathRewriteSpecifier.(type) {

	case *RedirectAction_PathRedirect:
		// no validation rules for PathRedirect

	case *RedirectAction_PrefixRewrite:
		// no validation rules for PrefixRewrite

	}

	return nil
}

// RedirectActionValidationError is the validation error returned by
// RedirectAction.Validate if the designated constraints aren't met.
type RedirectActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedirectActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedirectActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedirectActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedirectActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedirectActionValidationError) ErrorName() string { return "RedirectActionValidationError" }

// Error satisfies the builtin error interface
func (e RedirectActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedirectAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedirectActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedirectActionValidationError{}

// Validate checks the field values on DirectResponseAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DirectResponseAction) Validate() error {
	if m == nil {
		return nil
	}

	if val := m.GetStatus(); val < 100 || val >= 600 {
		return DirectResponseActionValidationError{
			field:  "Status",
			reason: "value must be inside range [100, 600)",
		}
	}

	if v, ok := interface{}(m.GetBody()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DirectResponseActionValidationError{
				field:  "Body",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// DirectResponseActionValidationError is the validation error returned by
// DirectResponseAction.Validate if the designated constraints aren't met.
type DirectResponseActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DirectResponseActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DirectResponseActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DirectResponseActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DirectResponseActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DirectResponseActionValidationError) ErrorName() string {
	return "DirectResponseActionValidationError"
}

// Error satisfies the builtin error interface
func (e DirectResponseActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDirectResponseAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DirectResponseActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DirectResponseActionValidationError{}

// Validate checks the field values on Decorator with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Decorator) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetOperation()) < 1 {
		return DecoratorValidationError{
			field:  "Operation",
			reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// DecoratorValidationError is the validation error returned by
// Decorator.Validate if the designated constraints aren't met.
type DecoratorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DecoratorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DecoratorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DecoratorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DecoratorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DecoratorValidationError) ErrorName() string { return "DecoratorValidationError" }

// Error satisfies the builtin error interface
func (e DecoratorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecorator.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DecoratorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DecoratorValidationError{}

// Validate checks the field values on Tracing with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Tracing) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetClientSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TracingValidationError{
				field:  "ClientSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRandomSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TracingValidationError{
				field:  "RandomSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetOverallSampling()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TracingValidationError{
				field:  "OverallSampling",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// TracingValidationError is the validation error returned by Tracing.Validate
// if the designated constraints aren't met.
type TracingValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TracingValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TracingValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TracingValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TracingValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TracingValidationError) ErrorName() string { return "TracingValidationError" }

// Error satisfies the builtin error interface
func (e TracingValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTracing.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TracingValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TracingValidationError{}

// Validate checks the field values on VirtualCluster with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *VirtualCluster) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetPattern()) > 1024 {
		return VirtualClusterValidationError{
			field:  "Pattern",
			reason: "value length must be at most 1024 bytes",
		}
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualClusterValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetName()) < 1 {
		return VirtualClusterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for Method

	return nil
}

// VirtualClusterValidationError is the validation error returned by
// VirtualCluster.Validate if the designated constraints aren't met.
type VirtualClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e VirtualClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e VirtualClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e VirtualClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e VirtualClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e VirtualClusterValidationError) ErrorName() string { return "VirtualClusterValidationError" }

// Error satisfies the builtin error interface
func (e VirtualClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sVirtualCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = VirtualClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = VirtualClusterValidationError{}

// Validate checks the field values on RateLimit with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RateLimit) Validate() error {
	if m == nil {
		return nil
	}

	if wrapper := m.GetStage(); wrapper != nil {

		if wrapper.GetValue() > 10 {
			return RateLimitValidationError{
				field:  "Stage",
				reason: "value must be less than or equal to 10",
			}
		}

	}

	// no validation rules for DisableKey

	if len(m.GetActions()) < 1 {
		return RateLimitValidationError{
			field:  "Actions",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetActions() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitValidationError{
					field:  fmt.Sprintf("Actions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// RateLimitValidationError is the validation error returned by
// RateLimit.Validate if the designated constraints aren't met.
type RateLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimitValidationError) ErrorName() string { return "RateLimitValidationError" }

// Error satisfies the builtin error interface
func (e RateLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimitValidationError{}

// Validate checks the field values on HeaderMatcher with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *HeaderMatcher) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return HeaderMatcherValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for InvertMatch

	switch m.HeaderMatchSpecifier.(type) {

	case *HeaderMatcher_ExactMatch:
		// no validation rules for ExactMatch

	case *HeaderMatcher_RegexMatch:

		if len(m.GetRegexMatch()) > 1024 {
			return HeaderMatcherValidationError{
				field:  "RegexMatch",
				reason: "value length must be at most 1024 bytes",
			}
		}

	case *HeaderMatcher_SafeRegexMatch:

		if v, ok := interface{}(m.GetSafeRegexMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMatcherValidationError{
					field:  "SafeRegexMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HeaderMatcher_RangeMatch:

		if v, ok := interface{}(m.GetRangeMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMatcherValidationError{
					field:  "RangeMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *HeaderMatcher_PresentMatch:
		// no validation rules for PresentMatch

	case *HeaderMatcher_PrefixMatch:

		if len(m.GetPrefixMatch()) < 1 {
			return HeaderMatcherValidationError{
				field:  "PrefixMatch",
				reason: "value length must be at least 1 bytes",
			}
		}

	case *HeaderMatcher_SuffixMatch:

		if len(m.GetSuffixMatch()) < 1 {
			return HeaderMatcherValidationError{
				field:  "SuffixMatch",
				reason: "value length must be at least 1 bytes",
			}
		}

	}

	return nil
}

// HeaderMatcherValidationError is the validation error returned by
// HeaderMatcher.Validate if the designated constraints aren't met.
type HeaderMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HeaderMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HeaderMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HeaderMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HeaderMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HeaderMatcherValidationError) ErrorName() string { return "HeaderMatcherValidationError" }

// Error satisfies the builtin error interface
func (e HeaderMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HeaderMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HeaderMatcherValidationError{}

// Validate checks the field values on QueryParameterMatcher with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *QueryParameterMatcher) Validate() error {
	if m == nil {
		return nil
	}

	if l := len(m.GetName()); l < 1 || l > 1024 {
		return QueryParameterMatcherValidationError{
			field:  "Name",
			reason: "value length must be between 1 and 1024 bytes, inclusive",
		}
	}

	// no validation rules for Value

	if v, ok := interface{}(m.GetRegex()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return QueryParameterMatcherValidationError{
				field:  "Regex",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.QueryParameterMatchSpecifier.(type) {

	case *QueryParameterMatcher_StringMatch:

		if m.GetStringMatch() == nil {
			return QueryParameterMatcherValidationError{
				field:  "StringMatch",
				reason: "value is required",
			}
		}

		if v, ok := interface{}(m.GetStringMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return QueryParameterMatcherValidationError{
					field:  "StringMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *QueryParameterMatcher_PresentMatch:
		// no validation rules for PresentMatch

	}

	return nil
}

// QueryParameterMatcherValidationError is the validation error returned by
// QueryParameterMatcher.Validate if the designated constraints aren't met.
type QueryParameterMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e QueryParameterMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e QueryParameterMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e QueryParameterMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e QueryParameterMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e QueryParameterMatcherValidationError) ErrorName() string {
	return "QueryParameterMatcherValidationError"
}

// Error satisfies the builtin error interface
func (e QueryParameterMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sQueryParameterMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = QueryParameterMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = QueryParameterMatcherValidationError{}

// Validate checks the field values on WeightedCluster_ClusterWeight with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *WeightedCluster_ClusterWeight) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return WeightedCluster_ClusterWeightValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
	}

	if v, ok := interface{}(m.GetWeight()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WeightedCluster_ClusterWeightValidationError{
				field:  "Weight",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMetadataMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WeightedCluster_ClusterWeightValidationError{
				field:  "MetadataMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetRequestHeadersToAdd()) > 1000 {
		return WeightedCluster_ClusterWeightValidationError{
			field:  "RequestHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetResponseHeadersToAdd()) > 1000 {
		return WeightedCluster_ClusterWeightValidationError{
			field:  "ResponseHeadersToAdd",
			reason: "value must contain no more than 1000 item(s)",
		}
	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for key, val := range m.GetPerFilterConfig() {
		_ = val

		// no validation rules for PerFilterConfig[key]

		if v, ok := interface{}(val).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					field:  fmt.Sprintf("PerFilterConfig[%v]", key),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for key, val := range m.GetTypedPerFilterConfig() {
		_ = val

		// no validation rules for TypedPerFilterConfig[key]

		if v, ok := interface{}(val).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					field:  fmt.Sprintf("TypedPerFilterConfig[%v]", key),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// WeightedCluster_ClusterWeightValidationError is the validation error
// returned by WeightedCluster_ClusterWeight.Validate if the designated
// constraints aren't met.
type WeightedCluster_ClusterWeightValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WeightedCluster_ClusterWeightValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WeightedCluster_ClusterWeightValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WeightedCluster_ClusterWeightValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WeightedCluster_ClusterWeightValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WeightedCluster_ClusterWeightValidationError) ErrorName() string {
	return "WeightedCluster_ClusterWeightValidationError"
}

// Error satisfies the builtin error interface
func (e WeightedCluster_ClusterWeightValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWeightedCluster_ClusterWeight.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WeightedCluster_ClusterWeightValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WeightedCluster_ClusterWeightValidationError{}

// Validate checks the field values on RouteMatch_GrpcRouteMatchOptions with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *RouteMatch_GrpcRouteMatchOptions) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// RouteMatch_GrpcRouteMatchOptionsValidationError is the validation error
// returned by RouteMatch_GrpcRouteMatchOptions.Validate if the designated
// constraints aren't met.
type RouteMatch_GrpcRouteMatchOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) ErrorName() string {
	return "RouteMatch_GrpcRouteMatchOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e RouteMatch_GrpcRouteMatchOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch_GrpcRouteMatchOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteMatch_GrpcRouteMatchOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteMatch_GrpcRouteMatchOptionsValidationError{}

// Validate checks the field values on RouteMatch_TlsContextMatchOptions with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *RouteMatch_TlsContextMatchOptions) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetPresented()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatch_TlsContextMatchOptionsValidationError{
				field:  "Presented",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// RouteMatch_TlsContextMatchOptionsValidationError is the validation error
// returned by RouteMatch_TlsContextMatchOptions.Validate if the designated
// constraints aren't met.
type RouteMatch_TlsContextMatchOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteMatch_TlsContextMatchOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteMatch_TlsContextMatchOptionsValidationError) ErrorName() string {
	return "RouteMatch_TlsContextMatchOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e RouteMatch_TlsContextMatchOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch_TlsContextMatchOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteMatch_TlsContextMatchOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteMatch_TlsContextMatchOptionsValidationError{}

// Validate checks the field values on RouteAction_RequestMirrorPolicy with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_RequestMirrorPolicy) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetCluster()) < 1 {
		return RouteAction_RequestMirrorPolicyValidationError{
			field:  "Cluster",
			reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for RuntimeKey

	if v, ok := interface{}(m.GetRuntimeFraction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_RequestMirrorPolicyValidationError{
				field:  "RuntimeFraction",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// RouteAction_RequestMirrorPolicyValidationError is the validation error
// returned by RouteAction_RequestMirrorPolicy.Validate if the designated
// constraints aren't met.
type RouteAction_RequestMirrorPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_RequestMirrorPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_RequestMirrorPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_RequestMirrorPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_RequestMirrorPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_RequestMirrorPolicyValidationError) ErrorName() string {
	return "RouteAction_RequestMirrorPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_RequestMirrorPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_RequestMirrorPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_RequestMirrorPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_RequestMirrorPolicyValidationError{}

// Validate checks the field values on RouteAction_HashPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_HashPolicy) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Terminal

	switch m.PolicySpecifier.(type) {

	case *RouteAction_HashPolicy_Header_:

		if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_Cookie_:

		if v, ok := interface{}(m.GetCookie()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "Cookie",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_ConnectionProperties_:

		if v, ok := interface{}(m.GetConnectionProperties()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					field:  "ConnectionProperties",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return RouteAction_HashPolicyValidationError{
			field:  "PolicySpecifier",
			reason: "value is required",
		}

	}

	return nil
}

// RouteAction_HashPolicyValidationError is the validation error returned by
// RouteAction_HashPolicy.Validate if the designated constraints aren't met.
type RouteAction_HashPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicyValidationError) ErrorName() string {
	return "RouteAction_HashPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicyValidationError{}

// Validate checks the field values on RouteAction_UpgradeConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_UpgradeConfig) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for UpgradeType

	if v, ok := interface{}(m.GetEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_UpgradeConfigValidationError{
				field:  "Enabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// RouteAction_UpgradeConfigValidationError is the validation error returned by
// RouteAction_UpgradeConfig.Validate if the designated constraints aren't met.
type RouteAction_UpgradeConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_UpgradeConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_UpgradeConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_UpgradeConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_UpgradeConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_UpgradeConfigValidationError) ErrorName() string {
	return "RouteAction_UpgradeConfigValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_UpgradeConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_UpgradeConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_UpgradeConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_UpgradeConfigValidationError{}

// Validate checks the field values on RouteAction_HashPolicy_Header with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_HashPolicy_Header) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetHeaderName()) < 1 {
		return RouteAction_HashPolicy_HeaderValidationError{
			field:  "HeaderName",
			reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// RouteAction_HashPolicy_HeaderValidationError is the validation error
// returned by RouteAction_HashPolicy_Header.Validate if the designated
// constraints aren't met.
type RouteAction_HashPolicy_HeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_HeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_HeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_HeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_HeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_HeaderValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_HeaderValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_HeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_Header.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_HeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_HeaderValidationError{}

// Validate checks the field values on RouteAction_HashPolicy_Cookie with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_HashPolicy_Cookie) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return RouteAction_HashPolicy_CookieValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
	}

	if v, ok := interface{}(m.GetTtl()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_HashPolicy_CookieValidationError{
				field:  "Ttl",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Path

	return nil
}

// RouteAction_HashPolicy_CookieValidationError is the validation error
// returned by RouteAction_HashPolicy_Cookie.Validate if the designated
// constraints aren't met.
type RouteAction_HashPolicy_CookieValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_CookieValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_CookieValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_CookieValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_CookieValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_CookieValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_CookieValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_CookieValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_Cookie.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_CookieValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_CookieValidationError{}

// Validate checks the field values on
// RouteAction_HashPolicy_ConnectionProperties with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RouteAction_HashPolicy_ConnectionProperties) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for SourceIp

	return nil
}

// RouteAction_HashPolicy_ConnectionPropertiesValidationError is the validation
// error returned by RouteAction_HashPolicy_ConnectionProperties.Validate if
// the designated constraints aren't met.
type RouteAction_HashPolicy_ConnectionPropertiesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) ErrorName() string {
	return "RouteAction_HashPolicy_ConnectionPropertiesValidationError"
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_ConnectionProperties.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RouteAction_HashPolicy_ConnectionPropertiesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RouteAction_HashPolicy_ConnectionPropertiesValidationError{}

// Validate checks the field values on RetryPolicy_RetryPriority with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RetryPolicy_RetryPriority) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return RetryPolicy_RetryPriorityValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
	}

	switch m.ConfigType.(type) {

	case *RetryPolicy_RetryPriority_Config:

		if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryPriorityValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RetryPolicy_RetryPriority_TypedConfig:

		if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryPriorityValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// RetryPolicy_RetryPriorityValidationError is the validation error returned by
// RetryPolicy_RetryPriority.Validate if the designated constraints aren't met.
type RetryPolicy_RetryPriorityValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryPriorityValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryPriorityValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryPriorityValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryPriorityValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryPriorityValidationError) ErrorName() string {
	return "RetryPolicy_RetryPriorityValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryPriorityValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryPriority.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryPriorityValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryPriorityValidationError{}

// Validate checks the field values on RetryPolicy_RetryHostPredicate with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RetryPolicy_RetryHostPredicate) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return RetryPolicy_RetryHostPredicateValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
	}

	switch m.ConfigType.(type) {

	case *RetryPolicy_RetryHostPredicate_Config:

		if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryHostPredicateValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RetryPolicy_RetryHostPredicate_TypedConfig:

		if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RetryPolicy_RetryHostPredicateValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// RetryPolicy_RetryHostPredicateValidationError is the validation error
// returned by RetryPolicy_RetryHostPredicate.Validate if the designated
// constraints aren't met.
type RetryPolicy_RetryHostPredicateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryHostPredicateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryHostPredicateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryHostPredicateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryHostPredicateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryHostPredicateValidationError) ErrorName() string {
	return "RetryPolicy_RetryHostPredicateValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryHostPredicateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryHostPredicate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryHostPredicateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryHostPredicateValidationError{}

// Validate checks the field values on RetryPolicy_RetryBackOff with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RetryPolicy_RetryBackOff) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetBaseInterval() == nil {
		return RetryPolicy_RetryBackOffValidationError{
			field:  "BaseInterval",
			reason: "value is required",
		}
	}

	if d := m.GetBaseInterval(); d != nil {
		dur, err := ptypes.Duration(d)
		if err != nil {
			return RetryPolicy_RetryBackOffValidationError{
				field:  "BaseInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return RetryPolicy_RetryBackOffValidationError{
				field:  "BaseInterval",
				reason: "value must be greater than 0s",
			}
		}

	}

	if d := m.GetMaxInterval(); d != nil {
		dur, err := ptypes.Duration(d)
		if err != nil {
			return RetryPolicy_RetryBackOffValidationError{
				field:  "MaxInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
		}

		gt := time.Duration(0*time.Second + 0*time.Nanosecond)

		if dur <= gt {
			return RetryPolicy_RetryBackOffValidationError{
				field:  "MaxInterval",
				reason: "value must be greater than 0s",
			}
		}

	}

	return nil
}

// RetryPolicy_RetryBackOffValidationError is the validation error returned by
// RetryPolicy_RetryBackOff.Validate if the designated constraints aren't met.
type RetryPolicy_RetryBackOffValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RetryPolicy_RetryBackOffValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RetryPolicy_RetryBackOffValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RetryPolicy_RetryBackOffValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RetryPolicy_RetryBackOffValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RetryPolicy_RetryBackOffValidationError) ErrorName() string {
	return "RetryPolicy_RetryBackOffValidationError"
}

// Error satisfies the builtin error interface
func (e RetryPolicy_RetryBackOffValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRetryPolicy_RetryBackOff.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RetryPolicy_RetryBackOffValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RetryPolicy_RetryBackOffValidationError{}

// Validate checks the field values on RateLimit_Action with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *RateLimit_Action) Validate() error {
	if m == nil {
		return nil
	}

	switch m.ActionSpecifier.(type) {

	case *RateLimit_Action_SourceCluster_:

		if v, ok := interface{}(m.GetSourceCluster()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "SourceCluster",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_DestinationCluster_:

		if v, ok := interface{}(m.GetDestinationCluster()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "DestinationCluster",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_RequestHeaders_:

		if v, ok := interface{}(m.GetRequestHeaders()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "RequestHeaders",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_RemoteAddress_:

		if v, ok := interface{}(m.GetRemoteAddress()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "RemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_GenericKey_:

		if v, ok := interface{}(m.GetGenericKey()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "GenericKey",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RateLimit_Action_HeaderValueMatch_:

		if v, ok := interface{}(m.GetHeaderValueMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					field:  "HeaderValueMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return RateLimit_ActionValidationError{
			field:  "ActionSpecifier",
			reason: "value is required",
		}

	}

	return nil
}

// RateLimit_ActionValidationError is the validation error returned by
// RateLimit_Action.Validate if the designated constraints aren't met.
type RateLimit_ActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_ActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_ActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_ActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_ActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_ActionValidationError) ErrorName() string { return "RateLimit_ActionValidationError" }

// Error satisfies the builtin error interface
func (e RateLimit_ActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_ActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_ActionValidationError{}

// Validate checks the field values on RateLimit_Action_SourceCluster with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_SourceCluster) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// RateLimit_Action_SourceClusterValidationError is the validation error
// returned by RateLimit_Action_SourceCluster.Validate if the designated
// constraints aren't met.
type RateLimit_Action_SourceClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_SourceClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_SourceClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_SourceClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_SourceClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_SourceClusterValidationError) ErrorName() string {
	return "RateLimit_Action_SourceClusterValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_SourceClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_SourceCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_SourceClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_SourceClusterValidationError{}

// Validate checks the field values on RateLimit_Action_DestinationCluster with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *RateLimit_Action_DestinationCluster) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// RateLimit_Action_DestinationClusterValidationError is the validation error
// returned by RateLimit_Action_DestinationCluster.Validate if the designated
// constraints aren't met.
type RateLimit_Action_DestinationClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_DestinationClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_DestinationClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_DestinationClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_DestinationClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_DestinationClusterValidationError) ErrorName() string {
	return "RateLimit_Action_DestinationClusterValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_DestinationClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_DestinationCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_DestinationClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_DestinationClusterValidationError{}

// Validate checks the field values on RateLimit_Action_RequestHeaders with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_RequestHeaders) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetHeaderName()) < 1 {
		return RateLimit_Action_RequestHeadersValidationError{
			field:  "HeaderName",
			reason: "value length must be at least 1 bytes",
		}
	}

	if len(m.GetDescriptorKey()) < 1 {
		return RateLimit_Action_RequestHeadersValidationError{
			field:  "DescriptorKey",
			reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// RateLimit_Action_RequestHeadersValidationError is the validation error
// returned by RateLimit_Action_RequestHeaders.Validate if the designated
// constraints aren't met.
type RateLimit_Action_RequestHeadersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_RequestHeadersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_RequestHeadersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_RequestHeadersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_RequestHeadersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_RequestHeadersValidationError) ErrorName() string {
	return "RateLimit_Action_RequestHeadersValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_RequestHeadersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_RequestHeaders.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_RequestHeadersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_RequestHeadersValidationError{}

// Validate checks the field values on RateLimit_Action_RemoteAddress with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_RemoteAddress) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// RateLimit_Action_RemoteAddressValidationError is the validation error
// returned by RateLimit_Action_RemoteAddress.Validate if the designated
// constraints aren't met.
type RateLimit_Action_RemoteAddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_RemoteAddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_RemoteAddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_RemoteAddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_RemoteAddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_RemoteAddressValidationError) ErrorName() string {
	return "RateLimit_Action_RemoteAddressValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_RemoteAddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_RemoteAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_RemoteAddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_RemoteAddressValidationError{}

// Validate checks the field values on RateLimit_Action_GenericKey with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_GenericKey) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetDescriptorValue()) < 1 {
		return RateLimit_Action_GenericKeyValidationError{
			field:  "DescriptorValue",
			reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// RateLimit_Action_GenericKeyValidationError is the validation error returned
// by RateLimit_Action_GenericKey.Validate if the designated constraints
// aren't met.
type RateLimit_Action_GenericKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_GenericKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_GenericKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_GenericKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_GenericKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_GenericKeyValidationError) ErrorName() string {
	return "RateLimit_Action_GenericKeyValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_GenericKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_GenericKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_GenericKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_GenericKeyValidationError{}

// Validate checks the field values on RateLimit_Action_HeaderValueMatch with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *RateLimit_Action_HeaderValueMatch) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetDescriptorValue()) < 1 {
		return RateLimit_Action_HeaderValueMatchValidationError{
			field:  "DescriptorValue",
			reason: "value length must be at least 1 bytes",
		}
	}

	if v, ok := interface{}(m.GetExpectMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimit_Action_HeaderValueMatchValidationError{
				field:  "ExpectMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetHeaders()) < 1 {
		return RateLimit_Action_HeaderValueMatchValidationError{
			field:  "Headers",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_Action_HeaderValueMatchValidationError{
					field:  fmt.Sprintf("Headers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// RateLimit_Action_HeaderValueMatchValidationError is the validation error
// returned by RateLimit_Action_HeaderValueMatch.Validate if the designated
// constraints aren't met.
type RateLimit_Action_HeaderValueMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RateLimit_Action_HeaderValueMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RateLimit_Action_HeaderValueMatchValidationError) ErrorName() string {
	return "RateLimit_Action_HeaderValueMatchValidationError"
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_HeaderValueMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_HeaderValueMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RateLimit_Action_HeaderValueMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RateLimit_Action_HeaderValueMatchValidationError{}
