/*
Copyright 2019 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"encoding/json"
	"net/http"

	"github.com/knative/serving/test"
)

type Response struct {
	ProtoMajor int `json:"protoMajor"`
	ProtoMinor int `json:"protoMinor"`
}

func handler(w http.ResponseWriter, r *http.Request) {
	response := Response{ProtoMajor: r.ProtoMajor, ProtoMinor: r.ProtoMinor}

	json, err := json.Marshal(response)
	if err != nil {
		http.Error(w, err.Error(), http.StatusInternalServerError)
		return
	}

	w.Write(json)
}

func main() {
	test.ListenAndServeGracefully(":8080", handler)
}
