/*
Copyright 2020 The hostpath provisioner operator Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	hostpathprovisionerv1alpha1 "kubevirt.io/hostpath-provisioner-operator/pkg/apis/hostpathprovisioner/v1alpha1"
	versioned "kubevirt.io/hostpath-provisioner-operator/pkg/client/clientset/versioned"
	internalinterfaces "kubevirt.io/hostpath-provisioner-operator/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "kubevirt.io/hostpath-provisioner-operator/pkg/client/listers/hostpathprovisioner/v1alpha1"
)

// HostPathProvisionerInformer provides access to a shared informer and lister for
// HostPathProvisioners.
type HostPathProvisionerInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.HostPathProvisionerLister
}

type hostPathProvisionerInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewHostPathProvisionerInformer constructs a new informer for HostPathProvisioner type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewHostPathProvisionerInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredHostPathProvisionerInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredHostPathProvisionerInformer constructs a new informer for HostPathProvisioner type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredHostPathProvisionerInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.HostpathprovisionerV1alpha1().HostPathProvisioners().List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.HostpathprovisionerV1alpha1().HostPathProvisioners().Watch(context.TODO(), options)
			},
		},
		&hostpathprovisionerv1alpha1.HostPathProvisioner{},
		resyncPeriod,
		indexers,
	)
}

func (f *hostPathProvisionerInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredHostPathProvisionerInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *hostPathProvisionerInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&hostpathprovisionerv1alpha1.HostPathProvisioner{}, f.defaultInformer)
}

func (f *hostPathProvisionerInformer) Lister() v1alpha1.HostPathProvisionerLister {
	return v1alpha1.NewHostPathProvisionerLister(f.Informer().GetIndexer())
}
