/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	kubevirtv1 "github.com/MarSik/kubevirt-ssp-operator/pkg/apis/kubevirt/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeKubevirtCommonTemplatesBundles implements KubevirtCommonTemplatesBundleInterface
type FakeKubevirtCommonTemplatesBundles struct {
	Fake *FakeKubevirtV1
	ns   string
}

var kubevirtcommontemplatesbundlesResource = schema.GroupVersionResource{Group: "kubevirt.io", Version: "v1", Resource: "kubevirtcommontemplatesbundles"}

var kubevirtcommontemplatesbundlesKind = schema.GroupVersionKind{Group: "kubevirt.io", Version: "v1", Kind: "KubevirtCommonTemplatesBundle"}

// Get takes name of the kubevirtCommonTemplatesBundle, and returns the corresponding kubevirtCommonTemplatesBundle object, and an error if there is any.
func (c *FakeKubevirtCommonTemplatesBundles) Get(name string, options v1.GetOptions) (result *kubevirtv1.KubevirtCommonTemplatesBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(kubevirtcommontemplatesbundlesResource, c.ns, name), &kubevirtv1.KubevirtCommonTemplatesBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtCommonTemplatesBundle), err
}

// List takes label and field selectors, and returns the list of KubevirtCommonTemplatesBundles that match those selectors.
func (c *FakeKubevirtCommonTemplatesBundles) List(opts v1.ListOptions) (result *kubevirtv1.KubevirtCommonTemplatesBundleList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(kubevirtcommontemplatesbundlesResource, kubevirtcommontemplatesbundlesKind, c.ns, opts), &kubevirtv1.KubevirtCommonTemplatesBundleList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &kubevirtv1.KubevirtCommonTemplatesBundleList{ListMeta: obj.(*kubevirtv1.KubevirtCommonTemplatesBundleList).ListMeta}
	for _, item := range obj.(*kubevirtv1.KubevirtCommonTemplatesBundleList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kubevirtCommonTemplatesBundles.
func (c *FakeKubevirtCommonTemplatesBundles) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(kubevirtcommontemplatesbundlesResource, c.ns, opts))

}

// Create takes the representation of a kubevirtCommonTemplatesBundle and creates it.  Returns the server's representation of the kubevirtCommonTemplatesBundle, and an error, if there is any.
func (c *FakeKubevirtCommonTemplatesBundles) Create(kubevirtCommonTemplatesBundle *kubevirtv1.KubevirtCommonTemplatesBundle) (result *kubevirtv1.KubevirtCommonTemplatesBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(kubevirtcommontemplatesbundlesResource, c.ns, kubevirtCommonTemplatesBundle), &kubevirtv1.KubevirtCommonTemplatesBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtCommonTemplatesBundle), err
}

// Update takes the representation of a kubevirtCommonTemplatesBundle and updates it. Returns the server's representation of the kubevirtCommonTemplatesBundle, and an error, if there is any.
func (c *FakeKubevirtCommonTemplatesBundles) Update(kubevirtCommonTemplatesBundle *kubevirtv1.KubevirtCommonTemplatesBundle) (result *kubevirtv1.KubevirtCommonTemplatesBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(kubevirtcommontemplatesbundlesResource, c.ns, kubevirtCommonTemplatesBundle), &kubevirtv1.KubevirtCommonTemplatesBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtCommonTemplatesBundle), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKubevirtCommonTemplatesBundles) UpdateStatus(kubevirtCommonTemplatesBundle *kubevirtv1.KubevirtCommonTemplatesBundle) (*kubevirtv1.KubevirtCommonTemplatesBundle, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kubevirtcommontemplatesbundlesResource, "status", c.ns, kubevirtCommonTemplatesBundle), &kubevirtv1.KubevirtCommonTemplatesBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtCommonTemplatesBundle), err
}

// Delete takes name of the kubevirtCommonTemplatesBundle and deletes it. Returns an error if one occurs.
func (c *FakeKubevirtCommonTemplatesBundles) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(kubevirtcommontemplatesbundlesResource, c.ns, name), &kubevirtv1.KubevirtCommonTemplatesBundle{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKubevirtCommonTemplatesBundles) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(kubevirtcommontemplatesbundlesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &kubevirtv1.KubevirtCommonTemplatesBundleList{})
	return err
}

// Patch applies the patch and returns the patched kubevirtCommonTemplatesBundle.
func (c *FakeKubevirtCommonTemplatesBundles) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *kubevirtv1.KubevirtCommonTemplatesBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kubevirtcommontemplatesbundlesResource, c.ns, name, data, subresources...), &kubevirtv1.KubevirtCommonTemplatesBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtCommonTemplatesBundle), err
}
