/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/MarSik/kubevirt-ssp-operator/pkg/apis/kubevirt/v1"
	scheme "github.com/MarSik/kubevirt-ssp-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KubevirtMetricsAggregationsGetter has a method to return a KubevirtMetricsAggregationInterface.
// A group's client should implement this interface.
type KubevirtMetricsAggregationsGetter interface {
	KubevirtMetricsAggregations(namespace string) KubevirtMetricsAggregationInterface
}

// KubevirtMetricsAggregationInterface has methods to work with KubevirtMetricsAggregation resources.
type KubevirtMetricsAggregationInterface interface {
	Create(*v1.KubevirtMetricsAggregation) (*v1.KubevirtMetricsAggregation, error)
	Update(*v1.KubevirtMetricsAggregation) (*v1.KubevirtMetricsAggregation, error)
	UpdateStatus(*v1.KubevirtMetricsAggregation) (*v1.KubevirtMetricsAggregation, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.KubevirtMetricsAggregation, error)
	List(opts metav1.ListOptions) (*v1.KubevirtMetricsAggregationList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubevirtMetricsAggregation, err error)
	KubevirtMetricsAggregationExpansion
}

// kubevirtMetricsAggregations implements KubevirtMetricsAggregationInterface
type kubevirtMetricsAggregations struct {
	client rest.Interface
	ns     string
}

// newKubevirtMetricsAggregations returns a KubevirtMetricsAggregations
func newKubevirtMetricsAggregations(c *KubevirtV1Client, namespace string) *kubevirtMetricsAggregations {
	return &kubevirtMetricsAggregations{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the kubevirtMetricsAggregation, and returns the corresponding kubevirtMetricsAggregation object, and an error if there is any.
func (c *kubevirtMetricsAggregations) Get(name string, options metav1.GetOptions) (result *v1.KubevirtMetricsAggregation, err error) {
	result = &v1.KubevirtMetricsAggregation{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KubevirtMetricsAggregations that match those selectors.
func (c *kubevirtMetricsAggregations) List(opts metav1.ListOptions) (result *v1.KubevirtMetricsAggregationList, err error) {
	result = &v1.KubevirtMetricsAggregationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kubevirtMetricsAggregations.
func (c *kubevirtMetricsAggregations) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a kubevirtMetricsAggregation and creates it.  Returns the server's representation of the kubevirtMetricsAggregation, and an error, if there is any.
func (c *kubevirtMetricsAggregations) Create(kubevirtMetricsAggregation *v1.KubevirtMetricsAggregation) (result *v1.KubevirtMetricsAggregation, err error) {
	result = &v1.KubevirtMetricsAggregation{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		Body(kubevirtMetricsAggregation).
		Do().
		Into(result)
	return
}

// Update takes the representation of a kubevirtMetricsAggregation and updates it. Returns the server's representation of the kubevirtMetricsAggregation, and an error, if there is any.
func (c *kubevirtMetricsAggregations) Update(kubevirtMetricsAggregation *v1.KubevirtMetricsAggregation) (result *v1.KubevirtMetricsAggregation, err error) {
	result = &v1.KubevirtMetricsAggregation{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		Name(kubevirtMetricsAggregation.Name).
		Body(kubevirtMetricsAggregation).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *kubevirtMetricsAggregations) UpdateStatus(kubevirtMetricsAggregation *v1.KubevirtMetricsAggregation) (result *v1.KubevirtMetricsAggregation, err error) {
	result = &v1.KubevirtMetricsAggregation{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		Name(kubevirtMetricsAggregation.Name).
		SubResource("status").
		Body(kubevirtMetricsAggregation).
		Do().
		Into(result)
	return
}

// Delete takes name of the kubevirtMetricsAggregation and deletes it. Returns an error if one occurs.
func (c *kubevirtMetricsAggregations) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kubevirtMetricsAggregations) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched kubevirtMetricsAggregation.
func (c *kubevirtMetricsAggregations) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubevirtMetricsAggregation, err error) {
	result = &v1.KubevirtMetricsAggregation{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("kubevirtmetricsaggregations").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
