/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/MarSik/kubevirt-ssp-operator/pkg/apis/kubevirt/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// KubevirtNodeLabellerBundleLister helps list KubevirtNodeLabellerBundles.
type KubevirtNodeLabellerBundleLister interface {
	// List lists all KubevirtNodeLabellerBundles in the indexer.
	List(selector labels.Selector) (ret []*v1.KubevirtNodeLabellerBundle, err error)
	// KubevirtNodeLabellerBundles returns an object that can list and get KubevirtNodeLabellerBundles.
	KubevirtNodeLabellerBundles(namespace string) KubevirtNodeLabellerBundleNamespaceLister
	KubevirtNodeLabellerBundleListerExpansion
}

// kubevirtNodeLabellerBundleLister implements the KubevirtNodeLabellerBundleLister interface.
type kubevirtNodeLabellerBundleLister struct {
	indexer cache.Indexer
}

// NewKubevirtNodeLabellerBundleLister returns a new KubevirtNodeLabellerBundleLister.
func NewKubevirtNodeLabellerBundleLister(indexer cache.Indexer) KubevirtNodeLabellerBundleLister {
	return &kubevirtNodeLabellerBundleLister{indexer: indexer}
}

// List lists all KubevirtNodeLabellerBundles in the indexer.
func (s *kubevirtNodeLabellerBundleLister) List(selector labels.Selector) (ret []*v1.KubevirtNodeLabellerBundle, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.KubevirtNodeLabellerBundle))
	})
	return ret, err
}

// KubevirtNodeLabellerBundles returns an object that can list and get KubevirtNodeLabellerBundles.
func (s *kubevirtNodeLabellerBundleLister) KubevirtNodeLabellerBundles(namespace string) KubevirtNodeLabellerBundleNamespaceLister {
	return kubevirtNodeLabellerBundleNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// KubevirtNodeLabellerBundleNamespaceLister helps list and get KubevirtNodeLabellerBundles.
type KubevirtNodeLabellerBundleNamespaceLister interface {
	// List lists all KubevirtNodeLabellerBundles in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.KubevirtNodeLabellerBundle, err error)
	// Get retrieves the KubevirtNodeLabellerBundle from the indexer for a given namespace and name.
	Get(name string) (*v1.KubevirtNodeLabellerBundle, error)
	KubevirtNodeLabellerBundleNamespaceListerExpansion
}

// kubevirtNodeLabellerBundleNamespaceLister implements the KubevirtNodeLabellerBundleNamespaceLister
// interface.
type kubevirtNodeLabellerBundleNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all KubevirtNodeLabellerBundles in the indexer for a given namespace.
func (s kubevirtNodeLabellerBundleNamespaceLister) List(selector labels.Selector) (ret []*v1.KubevirtNodeLabellerBundle, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.KubevirtNodeLabellerBundle))
	})
	return ret, err
}

// Get retrieves the KubevirtNodeLabellerBundle from the indexer for a given namespace and name.
func (s kubevirtNodeLabellerBundleNamespaceLister) Get(name string) (*v1.KubevirtNodeLabellerBundle, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("kubevirtnodelabellerbundle"), name)
	}
	return obj.(*v1.KubevirtNodeLabellerBundle), nil
}
