/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by "stringer -type=loadRestrictions"; DO NOT EDIT.

package loader

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[unknown-0]
	_ = x[rootOnly-1]
	_ = x[none-2]
}

const _loadRestrictions_name = "unknownrootOnlynone"

var _loadRestrictions_index = [...]uint8{0, 7, 15, 19}

func (i loadRestrictions) String() string {
	if i < 0 || i >= loadRestrictions(len(_loadRestrictions_index)-1) {
		return "loadRestrictions(" + strconv.FormatInt(int64(i), 10) + ")"
	}
	return _loadRestrictions_name[_loadRestrictions_index[i]:_loadRestrictions_index[i+1]]
}
