// Code generated by go-swagger; DO NOT EDIT.

package package_appr

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewShowPackageReleasesParams creates a new ShowPackageReleasesParams object
// with the default values initialized.
func NewShowPackageReleasesParams() *ShowPackageReleasesParams {
	var ()
	return &ShowPackageReleasesParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewShowPackageReleasesParamsWithTimeout creates a new ShowPackageReleasesParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewShowPackageReleasesParamsWithTimeout(timeout time.Duration) *ShowPackageReleasesParams {
	var ()
	return &ShowPackageReleasesParams{

		timeout: timeout,
	}
}

// NewShowPackageReleasesParamsWithContext creates a new ShowPackageReleasesParams object
// with the default values initialized, and the ability to set a context for a request
func NewShowPackageReleasesParamsWithContext(ctx context.Context) *ShowPackageReleasesParams {
	var ()
	return &ShowPackageReleasesParams{

		Context: ctx,
	}
}

// NewShowPackageReleasesParamsWithHTTPClient creates a new ShowPackageReleasesParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewShowPackageReleasesParamsWithHTTPClient(client *http.Client) *ShowPackageReleasesParams {
	var ()
	return &ShowPackageReleasesParams{
		HTTPClient: client,
	}
}

/*ShowPackageReleasesParams contains all the parameters to send to the API endpoint
for the show package releases operation typically these are written to a http.Request
*/
type ShowPackageReleasesParams struct {

	/*MediaType
	  Filter by media-type

	*/
	MediaType *string
	/*Namespace
	  namespace

	*/
	Namespace string
	/*Package
	  package name

	*/
	Package string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the show package releases params
func (o *ShowPackageReleasesParams) WithTimeout(timeout time.Duration) *ShowPackageReleasesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the show package releases params
func (o *ShowPackageReleasesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the show package releases params
func (o *ShowPackageReleasesParams) WithContext(ctx context.Context) *ShowPackageReleasesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the show package releases params
func (o *ShowPackageReleasesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the show package releases params
func (o *ShowPackageReleasesParams) WithHTTPClient(client *http.Client) *ShowPackageReleasesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the show package releases params
func (o *ShowPackageReleasesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithMediaType adds the mediaType to the show package releases params
func (o *ShowPackageReleasesParams) WithMediaType(mediaType *string) *ShowPackageReleasesParams {
	o.SetMediaType(mediaType)
	return o
}

// SetMediaType adds the mediaType to the show package releases params
func (o *ShowPackageReleasesParams) SetMediaType(mediaType *string) {
	o.MediaType = mediaType
}

// WithNamespace adds the namespace to the show package releases params
func (o *ShowPackageReleasesParams) WithNamespace(namespace string) *ShowPackageReleasesParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the show package releases params
func (o *ShowPackageReleasesParams) SetNamespace(namespace string) {
	o.Namespace = namespace
}

// WithPackage adds the packageVar to the show package releases params
func (o *ShowPackageReleasesParams) WithPackage(packageVar string) *ShowPackageReleasesParams {
	o.SetPackage(packageVar)
	return o
}

// SetPackage adds the package to the show package releases params
func (o *ShowPackageReleasesParams) SetPackage(packageVar string) {
	o.Package = packageVar
}

// WriteToRequest writes these params to a swagger request
func (o *ShowPackageReleasesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.MediaType != nil {

		// query param media_type
		var qrMediaType string
		if o.MediaType != nil {
			qrMediaType = *o.MediaType
		}
		qMediaType := qrMediaType
		if qMediaType != "" {
			if err := r.SetQueryParam("media_type", qMediaType); err != nil {
				return err
			}
		}

	}

	// path param namespace
	if err := r.SetPathParam("namespace", o.Namespace); err != nil {
		return err
	}

	// path param package
	if err := r.SetPathParam("package", o.Package); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
