// Code generated by go-swagger; DO NOT EDIT.

package channel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewDeleteChannelParams creates a new DeleteChannelParams object
// with the default values initialized.
func NewDeleteChannelParams() *DeleteChannelParams {
	var ()
	return &DeleteChannelParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteChannelParamsWithTimeout creates a new DeleteChannelParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDeleteChannelParamsWithTimeout(timeout time.Duration) *DeleteChannelParams {
	var ()
	return &DeleteChannelParams{

		timeout: timeout,
	}
}

// NewDeleteChannelParamsWithContext creates a new DeleteChannelParams object
// with the default values initialized, and the ability to set a context for a request
func NewDeleteChannelParamsWithContext(ctx context.Context) *DeleteChannelParams {
	var ()
	return &DeleteChannelParams{

		Context: ctx,
	}
}

// NewDeleteChannelParamsWithHTTPClient creates a new DeleteChannelParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDeleteChannelParamsWithHTTPClient(client *http.Client) *DeleteChannelParams {
	var ()
	return &DeleteChannelParams{
		HTTPClient: client,
	}
}

/*DeleteChannelParams contains all the parameters to send to the API endpoint
for the delete channel operation typically these are written to a http.Request
*/
type DeleteChannelParams struct {

	/*Channel
	  channel name

	*/
	Channel string
	/*Namespace
	  namespace

	*/
	Namespace string
	/*Package
	  full package name

	*/
	Package string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the delete channel params
func (o *DeleteChannelParams) WithTimeout(timeout time.Duration) *DeleteChannelParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete channel params
func (o *DeleteChannelParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete channel params
func (o *DeleteChannelParams) WithContext(ctx context.Context) *DeleteChannelParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete channel params
func (o *DeleteChannelParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete channel params
func (o *DeleteChannelParams) WithHTTPClient(client *http.Client) *DeleteChannelParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete channel params
func (o *DeleteChannelParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithChannel adds the channel to the delete channel params
func (o *DeleteChannelParams) WithChannel(channel string) *DeleteChannelParams {
	o.SetChannel(channel)
	return o
}

// SetChannel adds the channel to the delete channel params
func (o *DeleteChannelParams) SetChannel(channel string) {
	o.Channel = channel
}

// WithNamespace adds the namespace to the delete channel params
func (o *DeleteChannelParams) WithNamespace(namespace string) *DeleteChannelParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the delete channel params
func (o *DeleteChannelParams) SetNamespace(namespace string) {
	o.Namespace = namespace
}

// WithPackage adds the packageVar to the delete channel params
func (o *DeleteChannelParams) WithPackage(packageVar string) *DeleteChannelParams {
	o.SetPackage(packageVar)
	return o
}

// SetPackage adds the package to the delete channel params
func (o *DeleteChannelParams) SetPackage(packageVar string) {
	o.Package = packageVar
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteChannelParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param channel
	if err := r.SetPathParam("channel", o.Channel); err != nil {
		return err
	}

	// path param namespace
	if err := r.SetPathParam("namespace", o.Namespace); err != nil {
		return err
	}

	// path param package
	if err := r.SetPathParam("package", o.Package); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
