/*
Copyright 2022 The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1alpha1 "kubevirt.io/api/flavor/v1alpha1"
	scheme "kubevirt.io/client-go/generated/kubevirt/clientset/versioned/scheme"
)

// VirtualMachineFlavorsGetter has a method to return a VirtualMachineFlavorInterface.
// A group's client should implement this interface.
type VirtualMachineFlavorsGetter interface {
	VirtualMachineFlavors(namespace string) VirtualMachineFlavorInterface
}

// VirtualMachineFlavorInterface has methods to work with VirtualMachineFlavor resources.
type VirtualMachineFlavorInterface interface {
	Create(ctx context.Context, virtualMachineFlavor *v1alpha1.VirtualMachineFlavor, opts v1.CreateOptions) (*v1alpha1.VirtualMachineFlavor, error)
	Update(ctx context.Context, virtualMachineFlavor *v1alpha1.VirtualMachineFlavor, opts v1.UpdateOptions) (*v1alpha1.VirtualMachineFlavor, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.VirtualMachineFlavor, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.VirtualMachineFlavorList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineFlavor, err error)
	VirtualMachineFlavorExpansion
}

// virtualMachineFlavors implements VirtualMachineFlavorInterface
type virtualMachineFlavors struct {
	client rest.Interface
	ns     string
}

// newVirtualMachineFlavors returns a VirtualMachineFlavors
func newVirtualMachineFlavors(c *FlavorV1alpha1Client, namespace string) *virtualMachineFlavors {
	return &virtualMachineFlavors{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the virtualMachineFlavor, and returns the corresponding virtualMachineFlavor object, and an error if there is any.
func (c *virtualMachineFlavors) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.VirtualMachineFlavor, err error) {
	result = &v1alpha1.VirtualMachineFlavor{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of VirtualMachineFlavors that match those selectors.
func (c *virtualMachineFlavors) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VirtualMachineFlavorList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.VirtualMachineFlavorList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested virtualMachineFlavors.
func (c *virtualMachineFlavors) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a virtualMachineFlavor and creates it.  Returns the server's representation of the virtualMachineFlavor, and an error, if there is any.
func (c *virtualMachineFlavors) Create(ctx context.Context, virtualMachineFlavor *v1alpha1.VirtualMachineFlavor, opts v1.CreateOptions) (result *v1alpha1.VirtualMachineFlavor, err error) {
	result = &v1alpha1.VirtualMachineFlavor{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(virtualMachineFlavor).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a virtualMachineFlavor and updates it. Returns the server's representation of the virtualMachineFlavor, and an error, if there is any.
func (c *virtualMachineFlavors) Update(ctx context.Context, virtualMachineFlavor *v1alpha1.VirtualMachineFlavor, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachineFlavor, err error) {
	result = &v1alpha1.VirtualMachineFlavor{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		Name(virtualMachineFlavor.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(virtualMachineFlavor).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the virtualMachineFlavor and deletes it. Returns an error if one occurs.
func (c *virtualMachineFlavors) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *virtualMachineFlavors) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched virtualMachineFlavor.
func (c *virtualMachineFlavors) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineFlavor, err error) {
	result = &v1alpha1.VirtualMachineFlavor{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("virtualmachineflavors").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
