// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by deepcopy-gen. DO NOT EDIT.

package v1

import (
	rookio "github.com/rook/rook/pkg/apis/rook.io"
	corev1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in AnnotationsSpec) DeepCopyInto(out *AnnotationsSpec) {
	{
		in := &in
		*out = make(AnnotationsSpec, len(*in))
		for key, val := range *in {
			var outVal map[string]string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make(rookio.Annotations, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
			(*out)[key] = outVal
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AnnotationsSpec.
func (in AnnotationsSpec) DeepCopy() AnnotationsSpec {
	if in == nil {
		return nil
	}
	out := new(AnnotationsSpec)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BucketHealthCheckSpec) DeepCopyInto(out *BucketHealthCheckSpec) {
	*out = *in
	in.Bucket.DeepCopyInto(&out.Bucket)
	if in.LivenessProbe != nil {
		in, out := &in.LivenessProbe, &out.LivenessProbe
		*out = new(ProbeSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BucketHealthCheckSpec.
func (in *BucketHealthCheckSpec) DeepCopy() *BucketHealthCheckSpec {
	if in == nil {
		return nil
	}
	out := new(BucketHealthCheckSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BucketStatus) DeepCopyInto(out *BucketStatus) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BucketStatus.
func (in *BucketStatus) DeepCopy() *BucketStatus {
	if in == nil {
		return nil
	}
	out := new(BucketStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Capacity) DeepCopyInto(out *Capacity) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Capacity.
func (in *Capacity) DeepCopy() *Capacity {
	if in == nil {
		return nil
	}
	out := new(Capacity)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephBlockPool) DeepCopyInto(out *CephBlockPool) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(CephBlockPoolStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephBlockPool.
func (in *CephBlockPool) DeepCopy() *CephBlockPool {
	if in == nil {
		return nil
	}
	out := new(CephBlockPool)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephBlockPool) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephBlockPoolList) DeepCopyInto(out *CephBlockPoolList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephBlockPool, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephBlockPoolList.
func (in *CephBlockPoolList) DeepCopy() *CephBlockPoolList {
	if in == nil {
		return nil
	}
	out := new(CephBlockPoolList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephBlockPoolList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephBlockPoolStatus) DeepCopyInto(out *CephBlockPoolStatus) {
	*out = *in
	if in.MirroringStatus != nil {
		in, out := &in.MirroringStatus, &out.MirroringStatus
		*out = new(MirroringStatusSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.MirroringInfo != nil {
		in, out := &in.MirroringInfo, &out.MirroringInfo
		*out = new(MirroringInfoSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.SnapshotScheduleStatus != nil {
		in, out := &in.SnapshotScheduleStatus, &out.SnapshotScheduleStatus
		*out = new(SnapshotScheduleStatusSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Info != nil {
		in, out := &in.Info, &out.Info
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephBlockPoolStatus.
func (in *CephBlockPoolStatus) DeepCopy() *CephBlockPoolStatus {
	if in == nil {
		return nil
	}
	out := new(CephBlockPoolStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephClient) DeepCopyInto(out *CephClient) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(CephClientStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephClient.
func (in *CephClient) DeepCopy() *CephClient {
	if in == nil {
		return nil
	}
	out := new(CephClient)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephClient) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephClientList) DeepCopyInto(out *CephClientList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephClient, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephClientList.
func (in *CephClientList) DeepCopy() *CephClientList {
	if in == nil {
		return nil
	}
	out := new(CephClientList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephClientList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephClientStatus) DeepCopyInto(out *CephClientStatus) {
	*out = *in
	if in.Info != nil {
		in, out := &in.Info, &out.Info
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephClientStatus.
func (in *CephClientStatus) DeepCopy() *CephClientStatus {
	if in == nil {
		return nil
	}
	out := new(CephClientStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephCluster) DeepCopyInto(out *CephCluster) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephCluster.
func (in *CephCluster) DeepCopy() *CephCluster {
	if in == nil {
		return nil
	}
	out := new(CephCluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephCluster) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephClusterHealthCheckSpec) DeepCopyInto(out *CephClusterHealthCheckSpec) {
	*out = *in
	in.DaemonHealth.DeepCopyInto(&out.DaemonHealth)
	if in.LivenessProbe != nil {
		in, out := &in.LivenessProbe, &out.LivenessProbe
		*out = make(map[rookio.KeyType]*ProbeSpec, len(*in))
		for key, val := range *in {
			var outVal *ProbeSpec
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = new(ProbeSpec)
				(*in).DeepCopyInto(*out)
			}
			(*out)[key] = outVal
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephClusterHealthCheckSpec.
func (in *CephClusterHealthCheckSpec) DeepCopy() *CephClusterHealthCheckSpec {
	if in == nil {
		return nil
	}
	out := new(CephClusterHealthCheckSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephClusterList) DeepCopyInto(out *CephClusterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephCluster, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephClusterList.
func (in *CephClusterList) DeepCopy() *CephClusterList {
	if in == nil {
		return nil
	}
	out := new(CephClusterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephClusterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephDaemonsVersions) DeepCopyInto(out *CephDaemonsVersions) {
	*out = *in
	if in.Mon != nil {
		in, out := &in.Mon, &out.Mon
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Mgr != nil {
		in, out := &in.Mgr, &out.Mgr
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Osd != nil {
		in, out := &in.Osd, &out.Osd
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Rgw != nil {
		in, out := &in.Rgw, &out.Rgw
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Mds != nil {
		in, out := &in.Mds, &out.Mds
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.RbdMirror != nil {
		in, out := &in.RbdMirror, &out.RbdMirror
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.CephFSMirror != nil {
		in, out := &in.CephFSMirror, &out.CephFSMirror
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Overall != nil {
		in, out := &in.Overall, &out.Overall
		*out = make(map[string]int, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephDaemonsVersions.
func (in *CephDaemonsVersions) DeepCopy() *CephDaemonsVersions {
	if in == nil {
		return nil
	}
	out := new(CephDaemonsVersions)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephFilesystem) DeepCopyInto(out *CephFilesystem) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(CephFilesystemStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephFilesystem.
func (in *CephFilesystem) DeepCopy() *CephFilesystem {
	if in == nil {
		return nil
	}
	out := new(CephFilesystem)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephFilesystem) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephFilesystemList) DeepCopyInto(out *CephFilesystemList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephFilesystem, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephFilesystemList.
func (in *CephFilesystemList) DeepCopy() *CephFilesystemList {
	if in == nil {
		return nil
	}
	out := new(CephFilesystemList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephFilesystemList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephFilesystemMirror) DeepCopyInto(out *CephFilesystemMirror) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(Status)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephFilesystemMirror.
func (in *CephFilesystemMirror) DeepCopy() *CephFilesystemMirror {
	if in == nil {
		return nil
	}
	out := new(CephFilesystemMirror)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephFilesystemMirror) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephFilesystemMirrorList) DeepCopyInto(out *CephFilesystemMirrorList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephFilesystemMirror, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephFilesystemMirrorList.
func (in *CephFilesystemMirrorList) DeepCopy() *CephFilesystemMirrorList {
	if in == nil {
		return nil
	}
	out := new(CephFilesystemMirrorList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephFilesystemMirrorList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephFilesystemStatus) DeepCopyInto(out *CephFilesystemStatus) {
	*out = *in
	if in.SnapshotScheduleStatus != nil {
		in, out := &in.SnapshotScheduleStatus, &out.SnapshotScheduleStatus
		*out = new(FilesystemSnapshotScheduleStatusSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.Info != nil {
		in, out := &in.Info, &out.Info
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.MirroringStatus != nil {
		in, out := &in.MirroringStatus, &out.MirroringStatus
		*out = new(FilesystemMirroringInfoSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephFilesystemStatus.
func (in *CephFilesystemStatus) DeepCopy() *CephFilesystemStatus {
	if in == nil {
		return nil
	}
	out := new(CephFilesystemStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephHealthMessage) DeepCopyInto(out *CephHealthMessage) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephHealthMessage.
func (in *CephHealthMessage) DeepCopy() *CephHealthMessage {
	if in == nil {
		return nil
	}
	out := new(CephHealthMessage)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephNFS) DeepCopyInto(out *CephNFS) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(Status)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephNFS.
func (in *CephNFS) DeepCopy() *CephNFS {
	if in == nil {
		return nil
	}
	out := new(CephNFS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephNFS) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephNFSList) DeepCopyInto(out *CephNFSList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephNFS, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephNFSList.
func (in *CephNFSList) DeepCopy() *CephNFSList {
	if in == nil {
		return nil
	}
	out := new(CephNFSList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephNFSList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectRealm) DeepCopyInto(out *CephObjectRealm) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(Status)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectRealm.
func (in *CephObjectRealm) DeepCopy() *CephObjectRealm {
	if in == nil {
		return nil
	}
	out := new(CephObjectRealm)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectRealm) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectRealmList) DeepCopyInto(out *CephObjectRealmList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephObjectRealm, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectRealmList.
func (in *CephObjectRealmList) DeepCopy() *CephObjectRealmList {
	if in == nil {
		return nil
	}
	out := new(CephObjectRealmList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectRealmList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectStore) DeepCopyInto(out *CephObjectStore) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(ObjectStoreStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectStore.
func (in *CephObjectStore) DeepCopy() *CephObjectStore {
	if in == nil {
		return nil
	}
	out := new(CephObjectStore)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectStore) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectStoreList) DeepCopyInto(out *CephObjectStoreList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephObjectStore, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectStoreList.
func (in *CephObjectStoreList) DeepCopy() *CephObjectStoreList {
	if in == nil {
		return nil
	}
	out := new(CephObjectStoreList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectStoreList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectStoreUser) DeepCopyInto(out *CephObjectStoreUser) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(ObjectStoreUserStatus)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectStoreUser.
func (in *CephObjectStoreUser) DeepCopy() *CephObjectStoreUser {
	if in == nil {
		return nil
	}
	out := new(CephObjectStoreUser)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectStoreUser) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectStoreUserList) DeepCopyInto(out *CephObjectStoreUserList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephObjectStoreUser, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectStoreUserList.
func (in *CephObjectStoreUserList) DeepCopy() *CephObjectStoreUserList {
	if in == nil {
		return nil
	}
	out := new(CephObjectStoreUserList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectStoreUserList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectZone) DeepCopyInto(out *CephObjectZone) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(Status)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectZone.
func (in *CephObjectZone) DeepCopy() *CephObjectZone {
	if in == nil {
		return nil
	}
	out := new(CephObjectZone)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectZone) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectZoneGroup) DeepCopyInto(out *CephObjectZoneGroup) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(Status)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectZoneGroup.
func (in *CephObjectZoneGroup) DeepCopy() *CephObjectZoneGroup {
	if in == nil {
		return nil
	}
	out := new(CephObjectZoneGroup)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectZoneGroup) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectZoneGroupList) DeepCopyInto(out *CephObjectZoneGroupList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephObjectZoneGroup, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectZoneGroupList.
func (in *CephObjectZoneGroupList) DeepCopy() *CephObjectZoneGroupList {
	if in == nil {
		return nil
	}
	out := new(CephObjectZoneGroupList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectZoneGroupList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephObjectZoneList) DeepCopyInto(out *CephObjectZoneList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephObjectZone, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephObjectZoneList.
func (in *CephObjectZoneList) DeepCopy() *CephObjectZoneList {
	if in == nil {
		return nil
	}
	out := new(CephObjectZoneList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephObjectZoneList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephRBDMirror) DeepCopyInto(out *CephRBDMirror) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	if in.Status != nil {
		in, out := &in.Status, &out.Status
		*out = new(Status)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephRBDMirror.
func (in *CephRBDMirror) DeepCopy() *CephRBDMirror {
	if in == nil {
		return nil
	}
	out := new(CephRBDMirror)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephRBDMirror) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephRBDMirrorList) DeepCopyInto(out *CephRBDMirrorList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CephRBDMirror, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephRBDMirrorList.
func (in *CephRBDMirrorList) DeepCopy() *CephRBDMirrorList {
	if in == nil {
		return nil
	}
	out := new(CephRBDMirrorList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CephRBDMirrorList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephStatus) DeepCopyInto(out *CephStatus) {
	*out = *in
	if in.Details != nil {
		in, out := &in.Details, &out.Details
		*out = make(map[string]CephHealthMessage, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	out.Capacity = in.Capacity
	if in.Versions != nil {
		in, out := &in.Versions, &out.Versions
		*out = new(CephDaemonsVersions)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephStatus.
func (in *CephStatus) DeepCopy() *CephStatus {
	if in == nil {
		return nil
	}
	out := new(CephStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephStorage) DeepCopyInto(out *CephStorage) {
	*out = *in
	if in.DeviceClasses != nil {
		in, out := &in.DeviceClasses, &out.DeviceClasses
		*out = make([]DeviceClasses, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephStorage.
func (in *CephStorage) DeepCopy() *CephStorage {
	if in == nil {
		return nil
	}
	out := new(CephStorage)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CephVersionSpec) DeepCopyInto(out *CephVersionSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CephVersionSpec.
func (in *CephVersionSpec) DeepCopy() *CephVersionSpec {
	if in == nil {
		return nil
	}
	out := new(CephVersionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CleanupPolicySpec) DeepCopyInto(out *CleanupPolicySpec) {
	*out = *in
	out.SanitizeDisks = in.SanitizeDisks
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CleanupPolicySpec.
func (in *CleanupPolicySpec) DeepCopy() *CleanupPolicySpec {
	if in == nil {
		return nil
	}
	out := new(CleanupPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClientSpec) DeepCopyInto(out *ClientSpec) {
	*out = *in
	if in.Caps != nil {
		in, out := &in.Caps, &out.Caps
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClientSpec.
func (in *ClientSpec) DeepCopy() *ClientSpec {
	if in == nil {
		return nil
	}
	out := new(ClientSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSpec) DeepCopyInto(out *ClusterSpec) {
	*out = *in
	out.CephVersion = in.CephVersion
	in.Storage.DeepCopyInto(&out.Storage)
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(AnnotationsSpec, len(*in))
		for key, val := range *in {
			var outVal map[string]string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make(rookio.Annotations, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
			(*out)[key] = outVal
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(LabelsSpec, len(*in))
		for key, val := range *in {
			var outVal map[string]string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make(rookio.Labels, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
			(*out)[key] = outVal
		}
	}
	if in.Placement != nil {
		in, out := &in.Placement, &out.Placement
		*out = make(PlacementSpec, len(*in))
		for key, val := range *in {
			(*out)[key] = *val.DeepCopy()
		}
	}
	in.Network.DeepCopyInto(&out.Network)
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = make(ResourceSpec, len(*in))
		for key, val := range *in {
			(*out)[key] = *val.DeepCopy()
		}
	}
	if in.PriorityClassNames != nil {
		in, out := &in.PriorityClassNames, &out.PriorityClassNames
		*out = make(PriorityClassNamesSpec, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	out.DisruptionManagement = in.DisruptionManagement
	in.Mon.DeepCopyInto(&out.Mon)
	out.CrashCollector = in.CrashCollector
	out.Dashboard = in.Dashboard
	in.Monitoring.DeepCopyInto(&out.Monitoring)
	out.External = in.External
	in.Mgr.DeepCopyInto(&out.Mgr)
	out.CleanupPolicy = in.CleanupPolicy
	in.HealthCheck.DeepCopyInto(&out.HealthCheck)
	in.Security.DeepCopyInto(&out.Security)
	out.LogCollector = in.LogCollector
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSpec.
func (in *ClusterSpec) DeepCopy() *ClusterSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterStatus) DeepCopyInto(out *ClusterStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.CephStatus != nil {
		in, out := &in.CephStatus, &out.CephStatus
		*out = new(CephStatus)
		(*in).DeepCopyInto(*out)
	}
	if in.CephStorage != nil {
		in, out := &in.CephStorage, &out.CephStorage
		*out = new(CephStorage)
		(*in).DeepCopyInto(*out)
	}
	if in.CephVersion != nil {
		in, out := &in.CephVersion, &out.CephVersion
		*out = new(ClusterVersion)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterStatus.
func (in *ClusterStatus) DeepCopy() *ClusterStatus {
	if in == nil {
		return nil
	}
	out := new(ClusterStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterVersion) DeepCopyInto(out *ClusterVersion) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterVersion.
func (in *ClusterVersion) DeepCopy() *ClusterVersion {
	if in == nil {
		return nil
	}
	out := new(ClusterVersion)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Condition) DeepCopyInto(out *Condition) {
	*out = *in
	in.LastHeartbeatTime.DeepCopyInto(&out.LastHeartbeatTime)
	in.LastTransitionTime.DeepCopyInto(&out.LastTransitionTime)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Condition.
func (in *Condition) DeepCopy() *Condition {
	if in == nil {
		return nil
	}
	out := new(Condition)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CrashCollectorSpec) DeepCopyInto(out *CrashCollectorSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CrashCollectorSpec.
func (in *CrashCollectorSpec) DeepCopy() *CrashCollectorSpec {
	if in == nil {
		return nil
	}
	out := new(CrashCollectorSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DaemonHealthSpec) DeepCopyInto(out *DaemonHealthSpec) {
	*out = *in
	in.Status.DeepCopyInto(&out.Status)
	in.Monitor.DeepCopyInto(&out.Monitor)
	in.ObjectStorageDaemon.DeepCopyInto(&out.ObjectStorageDaemon)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DaemonHealthSpec.
func (in *DaemonHealthSpec) DeepCopy() *DaemonHealthSpec {
	if in == nil {
		return nil
	}
	out := new(DaemonHealthSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DashboardSpec) DeepCopyInto(out *DashboardSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DashboardSpec.
func (in *DashboardSpec) DeepCopy() *DashboardSpec {
	if in == nil {
		return nil
	}
	out := new(DashboardSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Device) DeepCopyInto(out *Device) {
	*out = *in
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Device.
func (in *Device) DeepCopy() *Device {
	if in == nil {
		return nil
	}
	out := new(Device)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DeviceClasses) DeepCopyInto(out *DeviceClasses) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DeviceClasses.
func (in *DeviceClasses) DeepCopy() *DeviceClasses {
	if in == nil {
		return nil
	}
	out := new(DeviceClasses)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DisruptionManagementSpec) DeepCopyInto(out *DisruptionManagementSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DisruptionManagementSpec.
func (in *DisruptionManagementSpec) DeepCopy() *DisruptionManagementSpec {
	if in == nil {
		return nil
	}
	out := new(DisruptionManagementSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ErasureCodedSpec) DeepCopyInto(out *ErasureCodedSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ErasureCodedSpec.
func (in *ErasureCodedSpec) DeepCopy() *ErasureCodedSpec {
	if in == nil {
		return nil
	}
	out := new(ErasureCodedSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalSpec) DeepCopyInto(out *ExternalSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalSpec.
func (in *ExternalSpec) DeepCopy() *ExternalSpec {
	if in == nil {
		return nil
	}
	out := new(ExternalSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FSMirroringSpec) DeepCopyInto(out *FSMirroringSpec) {
	*out = *in
	if in.Peers != nil {
		in, out := &in.Peers, &out.Peers
		*out = new(MirroringPeerSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.SnapshotSchedules != nil {
		in, out := &in.SnapshotSchedules, &out.SnapshotSchedules
		*out = make([]SnapshotScheduleSpec, len(*in))
		copy(*out, *in)
	}
	if in.SnapshotRetention != nil {
		in, out := &in.SnapshotRetention, &out.SnapshotRetention
		*out = make([]SnapshotScheduleRetentionSpec, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FSMirroringSpec.
func (in *FSMirroringSpec) DeepCopy() *FSMirroringSpec {
	if in == nil {
		return nil
	}
	out := new(FSMirroringSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemMirrorInfoPeerSpec) DeepCopyInto(out *FilesystemMirrorInfoPeerSpec) {
	*out = *in
	if in.Remote != nil {
		in, out := &in.Remote, &out.Remote
		*out = new(PeerRemoteSpec)
		**out = **in
	}
	if in.Stats != nil {
		in, out := &in.Stats, &out.Stats
		*out = new(PeerStatSpec)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemMirrorInfoPeerSpec.
func (in *FilesystemMirrorInfoPeerSpec) DeepCopy() *FilesystemMirrorInfoPeerSpec {
	if in == nil {
		return nil
	}
	out := new(FilesystemMirrorInfoPeerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemMirroringInfo) DeepCopyInto(out *FilesystemMirroringInfo) {
	*out = *in
	if in.Filesystems != nil {
		in, out := &in.Filesystems, &out.Filesystems
		*out = make([]FilesystemsSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemMirroringInfo.
func (in *FilesystemMirroringInfo) DeepCopy() *FilesystemMirroringInfo {
	if in == nil {
		return nil
	}
	out := new(FilesystemMirroringInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemMirroringInfoSpec) DeepCopyInto(out *FilesystemMirroringInfoSpec) {
	*out = *in
	if in.FilesystemMirroringAllInfo != nil {
		in, out := &in.FilesystemMirroringAllInfo, &out.FilesystemMirroringAllInfo
		*out = make([]FilesystemMirroringInfo, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemMirroringInfoSpec.
func (in *FilesystemMirroringInfoSpec) DeepCopy() *FilesystemMirroringInfoSpec {
	if in == nil {
		return nil
	}
	out := new(FilesystemMirroringInfoSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemMirroringSpec) DeepCopyInto(out *FilesystemMirroringSpec) {
	*out = *in
	in.Placement.DeepCopyInto(&out.Placement)
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(rookio.Annotations, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(rookio.Labels, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemMirroringSpec.
func (in *FilesystemMirroringSpec) DeepCopy() *FilesystemMirroringSpec {
	if in == nil {
		return nil
	}
	out := new(FilesystemMirroringSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemSnapshotScheduleStatusRetention) DeepCopyInto(out *FilesystemSnapshotScheduleStatusRetention) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemSnapshotScheduleStatusRetention.
func (in *FilesystemSnapshotScheduleStatusRetention) DeepCopy() *FilesystemSnapshotScheduleStatusRetention {
	if in == nil {
		return nil
	}
	out := new(FilesystemSnapshotScheduleStatusRetention)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemSnapshotScheduleStatusSpec) DeepCopyInto(out *FilesystemSnapshotScheduleStatusSpec) {
	*out = *in
	if in.SnapshotSchedules != nil {
		in, out := &in.SnapshotSchedules, &out.SnapshotSchedules
		*out = make([]FilesystemSnapshotSchedulesSpec, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemSnapshotScheduleStatusSpec.
func (in *FilesystemSnapshotScheduleStatusSpec) DeepCopy() *FilesystemSnapshotScheduleStatusSpec {
	if in == nil {
		return nil
	}
	out := new(FilesystemSnapshotScheduleStatusSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemSnapshotSchedulesSpec) DeepCopyInto(out *FilesystemSnapshotSchedulesSpec) {
	*out = *in
	out.Retention = in.Retention
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemSnapshotSchedulesSpec.
func (in *FilesystemSnapshotSchedulesSpec) DeepCopy() *FilesystemSnapshotSchedulesSpec {
	if in == nil {
		return nil
	}
	out := new(FilesystemSnapshotSchedulesSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemSpec) DeepCopyInto(out *FilesystemSpec) {
	*out = *in
	in.MetadataPool.DeepCopyInto(&out.MetadataPool)
	if in.DataPools != nil {
		in, out := &in.DataPools, &out.DataPools
		*out = make([]PoolSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	in.MetadataServer.DeepCopyInto(&out.MetadataServer)
	if in.Mirroring != nil {
		in, out := &in.Mirroring, &out.Mirroring
		*out = new(FSMirroringSpec)
		(*in).DeepCopyInto(*out)
	}
	in.StatusCheck.DeepCopyInto(&out.StatusCheck)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemSpec.
func (in *FilesystemSpec) DeepCopy() *FilesystemSpec {
	if in == nil {
		return nil
	}
	out := new(FilesystemSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FilesystemsSpec) DeepCopyInto(out *FilesystemsSpec) {
	*out = *in
	if in.Peers != nil {
		in, out := &in.Peers, &out.Peers
		*out = make([]FilesystemMirrorInfoPeerSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FilesystemsSpec.
func (in *FilesystemsSpec) DeepCopy() *FilesystemsSpec {
	if in == nil {
		return nil
	}
	out := new(FilesystemsSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GaneshaRADOSSpec) DeepCopyInto(out *GaneshaRADOSSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GaneshaRADOSSpec.
func (in *GaneshaRADOSSpec) DeepCopy() *GaneshaRADOSSpec {
	if in == nil {
		return nil
	}
	out := new(GaneshaRADOSSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GaneshaServerSpec) DeepCopyInto(out *GaneshaServerSpec) {
	*out = *in
	in.Placement.DeepCopyInto(&out.Placement)
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(rookio.Annotations, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(rookio.Labels, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GaneshaServerSpec.
func (in *GaneshaServerSpec) DeepCopy() *GaneshaServerSpec {
	if in == nil {
		return nil
	}
	out := new(GaneshaServerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GatewaySpec) DeepCopyInto(out *GatewaySpec) {
	*out = *in
	in.Placement.DeepCopyInto(&out.Placement)
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(rookio.Annotations, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(rookio.Labels, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
	if in.ExternalRgwEndpoints != nil {
		in, out := &in.ExternalRgwEndpoints, &out.ExternalRgwEndpoints
		*out = make([]corev1.EndpointAddress, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Service != nil {
		in, out := &in.Service, &out.Service
		*out = new(RGWServiceSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GatewaySpec.
func (in *GatewaySpec) DeepCopy() *GatewaySpec {
	if in == nil {
		return nil
	}
	out := new(GatewaySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HealthCheckSpec) DeepCopyInto(out *HealthCheckSpec) {
	*out = *in
	if in.Interval != nil {
		in, out := &in.Interval, &out.Interval
		*out = new(metav1.Duration)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HealthCheckSpec.
func (in *HealthCheckSpec) DeepCopy() *HealthCheckSpec {
	if in == nil {
		return nil
	}
	out := new(HealthCheckSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HybridStorageSpec) DeepCopyInto(out *HybridStorageSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HybridStorageSpec.
func (in *HybridStorageSpec) DeepCopy() *HybridStorageSpec {
	if in == nil {
		return nil
	}
	out := new(HybridStorageSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KeyManagementServiceSpec) DeepCopyInto(out *KeyManagementServiceSpec) {
	*out = *in
	if in.ConnectionDetails != nil {
		in, out := &in.ConnectionDetails, &out.ConnectionDetails
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KeyManagementServiceSpec.
func (in *KeyManagementServiceSpec) DeepCopy() *KeyManagementServiceSpec {
	if in == nil {
		return nil
	}
	out := new(KeyManagementServiceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in LabelsSpec) DeepCopyInto(out *LabelsSpec) {
	{
		in := &in
		*out = make(LabelsSpec, len(*in))
		for key, val := range *in {
			var outVal map[string]string
			if val == nil {
				(*out)[key] = nil
			} else {
				in, out := &val, &outVal
				*out = make(rookio.Labels, len(*in))
				for key, val := range *in {
					(*out)[key] = val
				}
			}
			(*out)[key] = outVal
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LabelsSpec.
func (in LabelsSpec) DeepCopy() LabelsSpec {
	if in == nil {
		return nil
	}
	out := new(LabelsSpec)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LogCollectorSpec) DeepCopyInto(out *LogCollectorSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new LogCollectorSpec.
func (in *LogCollectorSpec) DeepCopy() *LogCollectorSpec {
	if in == nil {
		return nil
	}
	out := new(LogCollectorSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MetadataServerSpec) DeepCopyInto(out *MetadataServerSpec) {
	*out = *in
	in.Placement.DeepCopyInto(&out.Placement)
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(rookio.Annotations, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(rookio.Labels, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MetadataServerSpec.
func (in *MetadataServerSpec) DeepCopy() *MetadataServerSpec {
	if in == nil {
		return nil
	}
	out := new(MetadataServerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MgrSpec) DeepCopyInto(out *MgrSpec) {
	*out = *in
	if in.Modules != nil {
		in, out := &in.Modules, &out.Modules
		*out = make([]Module, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MgrSpec.
func (in *MgrSpec) DeepCopy() *MgrSpec {
	if in == nil {
		return nil
	}
	out := new(MgrSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MirrorHealthCheckSpec) DeepCopyInto(out *MirrorHealthCheckSpec) {
	*out = *in
	in.Mirror.DeepCopyInto(&out.Mirror)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MirrorHealthCheckSpec.
func (in *MirrorHealthCheckSpec) DeepCopy() *MirrorHealthCheckSpec {
	if in == nil {
		return nil
	}
	out := new(MirrorHealthCheckSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MirroringInfoSpec) DeepCopyInto(out *MirroringInfoSpec) {
	*out = *in
	if in.PoolMirroringInfo != nil {
		in, out := &in.PoolMirroringInfo, &out.PoolMirroringInfo
		*out = new(PoolMirroringInfo)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MirroringInfoSpec.
func (in *MirroringInfoSpec) DeepCopy() *MirroringInfoSpec {
	if in == nil {
		return nil
	}
	out := new(MirroringInfoSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MirroringPeerSpec) DeepCopyInto(out *MirroringPeerSpec) {
	*out = *in
	if in.SecretNames != nil {
		in, out := &in.SecretNames, &out.SecretNames
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MirroringPeerSpec.
func (in *MirroringPeerSpec) DeepCopy() *MirroringPeerSpec {
	if in == nil {
		return nil
	}
	out := new(MirroringPeerSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MirroringSpec) DeepCopyInto(out *MirroringSpec) {
	*out = *in
	if in.SnapshotSchedules != nil {
		in, out := &in.SnapshotSchedules, &out.SnapshotSchedules
		*out = make([]SnapshotScheduleSpec, len(*in))
		copy(*out, *in)
	}
	if in.Peers != nil {
		in, out := &in.Peers, &out.Peers
		*out = new(MirroringPeerSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MirroringSpec.
func (in *MirroringSpec) DeepCopy() *MirroringSpec {
	if in == nil {
		return nil
	}
	out := new(MirroringSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MirroringStatusSpec) DeepCopyInto(out *MirroringStatusSpec) {
	*out = *in
	in.PoolMirroringStatus.DeepCopyInto(&out.PoolMirroringStatus)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MirroringStatusSpec.
func (in *MirroringStatusSpec) DeepCopy() *MirroringStatusSpec {
	if in == nil {
		return nil
	}
	out := new(MirroringStatusSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Module) DeepCopyInto(out *Module) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Module.
func (in *Module) DeepCopy() *Module {
	if in == nil {
		return nil
	}
	out := new(Module)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MonSpec) DeepCopyInto(out *MonSpec) {
	*out = *in
	if in.StretchCluster != nil {
		in, out := &in.StretchCluster, &out.StretchCluster
		*out = new(StretchClusterSpec)
		(*in).DeepCopyInto(*out)
	}
	if in.VolumeClaimTemplate != nil {
		in, out := &in.VolumeClaimTemplate, &out.VolumeClaimTemplate
		*out = new(corev1.PersistentVolumeClaim)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MonSpec.
func (in *MonSpec) DeepCopy() *MonSpec {
	if in == nil {
		return nil
	}
	out := new(MonSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MonitoringSpec) DeepCopyInto(out *MonitoringSpec) {
	*out = *in
	if in.ExternalMgrEndpoints != nil {
		in, out := &in.ExternalMgrEndpoints, &out.ExternalMgrEndpoints
		*out = make([]corev1.EndpointAddress, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MonitoringSpec.
func (in *MonitoringSpec) DeepCopy() *MonitoringSpec {
	if in == nil {
		return nil
	}
	out := new(MonitoringSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NFSGaneshaSpec) DeepCopyInto(out *NFSGaneshaSpec) {
	*out = *in
	out.RADOS = in.RADOS
	in.Server.DeepCopyInto(&out.Server)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NFSGaneshaSpec.
func (in *NFSGaneshaSpec) DeepCopy() *NFSGaneshaSpec {
	if in == nil {
		return nil
	}
	out := new(NFSGaneshaSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NetworkSpec) DeepCopyInto(out *NetworkSpec) {
	*out = *in
	if in.Selectors != nil {
		in, out := &in.Selectors, &out.Selectors
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NetworkSpec.
func (in *NetworkSpec) DeepCopy() *NetworkSpec {
	if in == nil {
		return nil
	}
	out := new(NetworkSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Node) DeepCopyInto(out *Node) {
	*out = *in
	in.Resources.DeepCopyInto(&out.Resources)
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Selection.DeepCopyInto(&out.Selection)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Node.
func (in *Node) DeepCopy() *Node {
	if in == nil {
		return nil
	}
	out := new(Node)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in NodesByName) DeepCopyInto(out *NodesByName) {
	{
		in := &in
		*out = make(NodesByName, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodesByName.
func (in NodesByName) DeepCopy() NodesByName {
	if in == nil {
		return nil
	}
	out := new(NodesByName)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectRealmSpec) DeepCopyInto(out *ObjectRealmSpec) {
	*out = *in
	out.Pull = in.Pull
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectRealmSpec.
func (in *ObjectRealmSpec) DeepCopy() *ObjectRealmSpec {
	if in == nil {
		return nil
	}
	out := new(ObjectRealmSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectStoreSpec) DeepCopyInto(out *ObjectStoreSpec) {
	*out = *in
	in.MetadataPool.DeepCopyInto(&out.MetadataPool)
	in.DataPool.DeepCopyInto(&out.DataPool)
	in.Gateway.DeepCopyInto(&out.Gateway)
	out.Zone = in.Zone
	in.HealthCheck.DeepCopyInto(&out.HealthCheck)
	if in.Security != nil {
		in, out := &in.Security, &out.Security
		*out = new(SecuritySpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectStoreSpec.
func (in *ObjectStoreSpec) DeepCopy() *ObjectStoreSpec {
	if in == nil {
		return nil
	}
	out := new(ObjectStoreSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectStoreStatus) DeepCopyInto(out *ObjectStoreStatus) {
	*out = *in
	if in.BucketStatus != nil {
		in, out := &in.BucketStatus, &out.BucketStatus
		*out = new(BucketStatus)
		**out = **in
	}
	if in.Info != nil {
		in, out := &in.Info, &out.Info
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectStoreStatus.
func (in *ObjectStoreStatus) DeepCopy() *ObjectStoreStatus {
	if in == nil {
		return nil
	}
	out := new(ObjectStoreStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectStoreUserSpec) DeepCopyInto(out *ObjectStoreUserSpec) {
	*out = *in
	if in.Capabilities != nil {
		in, out := &in.Capabilities, &out.Capabilities
		*out = new(ObjectUserCapSpec)
		**out = **in
	}
	if in.Quotas != nil {
		in, out := &in.Quotas, &out.Quotas
		*out = new(ObjectUserQuotaSpec)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectStoreUserSpec.
func (in *ObjectStoreUserSpec) DeepCopy() *ObjectStoreUserSpec {
	if in == nil {
		return nil
	}
	out := new(ObjectStoreUserSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectStoreUserStatus) DeepCopyInto(out *ObjectStoreUserStatus) {
	*out = *in
	if in.Info != nil {
		in, out := &in.Info, &out.Info
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectStoreUserStatus.
func (in *ObjectStoreUserStatus) DeepCopy() *ObjectStoreUserStatus {
	if in == nil {
		return nil
	}
	out := new(ObjectStoreUserStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectUserCapSpec) DeepCopyInto(out *ObjectUserCapSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectUserCapSpec.
func (in *ObjectUserCapSpec) DeepCopy() *ObjectUserCapSpec {
	if in == nil {
		return nil
	}
	out := new(ObjectUserCapSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectUserQuotaSpec) DeepCopyInto(out *ObjectUserQuotaSpec) {
	*out = *in
	if in.MaxBuckets != nil {
		in, out := &in.MaxBuckets, &out.MaxBuckets
		*out = new(int)
		**out = **in
	}
	if in.MaxSize != nil {
		in, out := &in.MaxSize, &out.MaxSize
		x := (*in).DeepCopy()
		*out = &x
	}
	if in.MaxObjects != nil {
		in, out := &in.MaxObjects, &out.MaxObjects
		*out = new(int64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectUserQuotaSpec.
func (in *ObjectUserQuotaSpec) DeepCopy() *ObjectUserQuotaSpec {
	if in == nil {
		return nil
	}
	out := new(ObjectUserQuotaSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectZoneGroupSpec) DeepCopyInto(out *ObjectZoneGroupSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectZoneGroupSpec.
func (in *ObjectZoneGroupSpec) DeepCopy() *ObjectZoneGroupSpec {
	if in == nil {
		return nil
	}
	out := new(ObjectZoneGroupSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectZoneSpec) DeepCopyInto(out *ObjectZoneSpec) {
	*out = *in
	in.MetadataPool.DeepCopyInto(&out.MetadataPool)
	in.DataPool.DeepCopyInto(&out.DataPool)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectZoneSpec.
func (in *ObjectZoneSpec) DeepCopy() *ObjectZoneSpec {
	if in == nil {
		return nil
	}
	out := new(ObjectZoneSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PeerRemoteSpec) DeepCopyInto(out *PeerRemoteSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PeerRemoteSpec.
func (in *PeerRemoteSpec) DeepCopy() *PeerRemoteSpec {
	if in == nil {
		return nil
	}
	out := new(PeerRemoteSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PeerStatSpec) DeepCopyInto(out *PeerStatSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PeerStatSpec.
func (in *PeerStatSpec) DeepCopy() *PeerStatSpec {
	if in == nil {
		return nil
	}
	out := new(PeerStatSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PeersSpec) DeepCopyInto(out *PeersSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PeersSpec.
func (in *PeersSpec) DeepCopy() *PeersSpec {
	if in == nil {
		return nil
	}
	out := new(PeersSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Placement) DeepCopyInto(out *Placement) {
	*out = *in
	if in.NodeAffinity != nil {
		in, out := &in.NodeAffinity, &out.NodeAffinity
		*out = new(corev1.NodeAffinity)
		(*in).DeepCopyInto(*out)
	}
	if in.PodAffinity != nil {
		in, out := &in.PodAffinity, &out.PodAffinity
		*out = new(corev1.PodAffinity)
		(*in).DeepCopyInto(*out)
	}
	if in.PodAntiAffinity != nil {
		in, out := &in.PodAntiAffinity, &out.PodAntiAffinity
		*out = new(corev1.PodAntiAffinity)
		(*in).DeepCopyInto(*out)
	}
	if in.Tolerations != nil {
		in, out := &in.Tolerations, &out.Tolerations
		*out = make([]corev1.Toleration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TopologySpreadConstraints != nil {
		in, out := &in.TopologySpreadConstraints, &out.TopologySpreadConstraints
		*out = make([]corev1.TopologySpreadConstraint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Placement.
func (in *Placement) DeepCopy() *Placement {
	if in == nil {
		return nil
	}
	out := new(Placement)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in PlacementSpec) DeepCopyInto(out *PlacementSpec) {
	{
		in := &in
		*out = make(PlacementSpec, len(*in))
		for key, val := range *in {
			(*out)[key] = *val.DeepCopy()
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PlacementSpec.
func (in PlacementSpec) DeepCopy() PlacementSpec {
	if in == nil {
		return nil
	}
	out := new(PlacementSpec)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PoolMirroringInfo) DeepCopyInto(out *PoolMirroringInfo) {
	*out = *in
	if in.Peers != nil {
		in, out := &in.Peers, &out.Peers
		*out = make([]PeersSpec, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PoolMirroringInfo.
func (in *PoolMirroringInfo) DeepCopy() *PoolMirroringInfo {
	if in == nil {
		return nil
	}
	out := new(PoolMirroringInfo)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PoolMirroringStatus) DeepCopyInto(out *PoolMirroringStatus) {
	*out = *in
	if in.Summary != nil {
		in, out := &in.Summary, &out.Summary
		*out = new(PoolMirroringStatusSummarySpec)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PoolMirroringStatus.
func (in *PoolMirroringStatus) DeepCopy() *PoolMirroringStatus {
	if in == nil {
		return nil
	}
	out := new(PoolMirroringStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PoolMirroringStatusSummarySpec) DeepCopyInto(out *PoolMirroringStatusSummarySpec) {
	*out = *in
	out.States = in.States
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PoolMirroringStatusSummarySpec.
func (in *PoolMirroringStatusSummarySpec) DeepCopy() *PoolMirroringStatusSummarySpec {
	if in == nil {
		return nil
	}
	out := new(PoolMirroringStatusSummarySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PoolSpec) DeepCopyInto(out *PoolSpec) {
	*out = *in
	in.Replicated.DeepCopyInto(&out.Replicated)
	out.ErasureCoded = in.ErasureCoded
	if in.Parameters != nil {
		in, out := &in.Parameters, &out.Parameters
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Mirroring.DeepCopyInto(&out.Mirroring)
	in.StatusCheck.DeepCopyInto(&out.StatusCheck)
	in.Quotas.DeepCopyInto(&out.Quotas)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PoolSpec.
func (in *PoolSpec) DeepCopy() *PoolSpec {
	if in == nil {
		return nil
	}
	out := new(PoolSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in PriorityClassNamesSpec) DeepCopyInto(out *PriorityClassNamesSpec) {
	{
		in := &in
		*out = make(PriorityClassNamesSpec, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PriorityClassNamesSpec.
func (in PriorityClassNamesSpec) DeepCopy() PriorityClassNamesSpec {
	if in == nil {
		return nil
	}
	out := new(PriorityClassNamesSpec)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProbeSpec) DeepCopyInto(out *ProbeSpec) {
	*out = *in
	if in.Probe != nil {
		in, out := &in.Probe, &out.Probe
		*out = new(corev1.Probe)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProbeSpec.
func (in *ProbeSpec) DeepCopy() *ProbeSpec {
	if in == nil {
		return nil
	}
	out := new(ProbeSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PullSpec) DeepCopyInto(out *PullSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PullSpec.
func (in *PullSpec) DeepCopy() *PullSpec {
	if in == nil {
		return nil
	}
	out := new(PullSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *QuotaSpec) DeepCopyInto(out *QuotaSpec) {
	*out = *in
	if in.MaxBytes != nil {
		in, out := &in.MaxBytes, &out.MaxBytes
		*out = new(uint64)
		**out = **in
	}
	if in.MaxSize != nil {
		in, out := &in.MaxSize, &out.MaxSize
		*out = new(string)
		**out = **in
	}
	if in.MaxObjects != nil {
		in, out := &in.MaxObjects, &out.MaxObjects
		*out = new(uint64)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new QuotaSpec.
func (in *QuotaSpec) DeepCopy() *QuotaSpec {
	if in == nil {
		return nil
	}
	out := new(QuotaSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RBDMirroringSpec) DeepCopyInto(out *RBDMirroringSpec) {
	*out = *in
	in.Peers.DeepCopyInto(&out.Peers)
	in.Placement.DeepCopyInto(&out.Placement)
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(rookio.Annotations, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(rookio.Labels, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Resources.DeepCopyInto(&out.Resources)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RBDMirroringSpec.
func (in *RBDMirroringSpec) DeepCopy() *RBDMirroringSpec {
	if in == nil {
		return nil
	}
	out := new(RBDMirroringSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RGWServiceSpec) DeepCopyInto(out *RGWServiceSpec) {
	*out = *in
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(rookio.Annotations, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RGWServiceSpec.
func (in *RGWServiceSpec) DeepCopy() *RGWServiceSpec {
	if in == nil {
		return nil
	}
	out := new(RGWServiceSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ReplicatedSpec) DeepCopyInto(out *ReplicatedSpec) {
	*out = *in
	if in.HybridStorage != nil {
		in, out := &in.HybridStorage, &out.HybridStorage
		*out = new(HybridStorageSpec)
		**out = **in
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ReplicatedSpec.
func (in *ReplicatedSpec) DeepCopy() *ReplicatedSpec {
	if in == nil {
		return nil
	}
	out := new(ReplicatedSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in ResourceSpec) DeepCopyInto(out *ResourceSpec) {
	{
		in := &in
		*out = make(ResourceSpec, len(*in))
		for key, val := range *in {
			(*out)[key] = *val.DeepCopy()
		}
		return
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ResourceSpec.
func (in ResourceSpec) DeepCopy() ResourceSpec {
	if in == nil {
		return nil
	}
	out := new(ResourceSpec)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SanitizeDisksSpec) DeepCopyInto(out *SanitizeDisksSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SanitizeDisksSpec.
func (in *SanitizeDisksSpec) DeepCopy() *SanitizeDisksSpec {
	if in == nil {
		return nil
	}
	out := new(SanitizeDisksSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SecuritySpec) DeepCopyInto(out *SecuritySpec) {
	*out = *in
	in.KeyManagementService.DeepCopyInto(&out.KeyManagementService)
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SecuritySpec.
func (in *SecuritySpec) DeepCopy() *SecuritySpec {
	if in == nil {
		return nil
	}
	out := new(SecuritySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Selection) DeepCopyInto(out *Selection) {
	*out = *in
	if in.UseAllDevices != nil {
		in, out := &in.UseAllDevices, &out.UseAllDevices
		*out = new(bool)
		**out = **in
	}
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = make([]Device, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.VolumeClaimTemplates != nil {
		in, out := &in.VolumeClaimTemplates, &out.VolumeClaimTemplates
		*out = make([]corev1.PersistentVolumeClaim, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Selection.
func (in *Selection) DeepCopy() *Selection {
	if in == nil {
		return nil
	}
	out := new(Selection)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnapshotSchedule) DeepCopyInto(out *SnapshotSchedule) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnapshotSchedule.
func (in *SnapshotSchedule) DeepCopy() *SnapshotSchedule {
	if in == nil {
		return nil
	}
	out := new(SnapshotSchedule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnapshotScheduleRetentionSpec) DeepCopyInto(out *SnapshotScheduleRetentionSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnapshotScheduleRetentionSpec.
func (in *SnapshotScheduleRetentionSpec) DeepCopy() *SnapshotScheduleRetentionSpec {
	if in == nil {
		return nil
	}
	out := new(SnapshotScheduleRetentionSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnapshotScheduleSpec) DeepCopyInto(out *SnapshotScheduleSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnapshotScheduleSpec.
func (in *SnapshotScheduleSpec) DeepCopy() *SnapshotScheduleSpec {
	if in == nil {
		return nil
	}
	out := new(SnapshotScheduleSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnapshotScheduleStatusSpec) DeepCopyInto(out *SnapshotScheduleStatusSpec) {
	*out = *in
	if in.SnapshotSchedules != nil {
		in, out := &in.SnapshotSchedules, &out.SnapshotSchedules
		*out = make([]SnapshotSchedulesSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnapshotScheduleStatusSpec.
func (in *SnapshotScheduleStatusSpec) DeepCopy() *SnapshotScheduleStatusSpec {
	if in == nil {
		return nil
	}
	out := new(SnapshotScheduleStatusSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnapshotSchedulesSpec) DeepCopyInto(out *SnapshotSchedulesSpec) {
	*out = *in
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SnapshotSchedule, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnapshotSchedulesSpec.
func (in *SnapshotSchedulesSpec) DeepCopy() *SnapshotSchedulesSpec {
	if in == nil {
		return nil
	}
	out := new(SnapshotSchedulesSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StatesSpec) DeepCopyInto(out *StatesSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StatesSpec.
func (in *StatesSpec) DeepCopy() *StatesSpec {
	if in == nil {
		return nil
	}
	out := new(StatesSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Status) DeepCopyInto(out *Status) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Status.
func (in *Status) DeepCopy() *Status {
	if in == nil {
		return nil
	}
	out := new(Status)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StorageClassDeviceSet) DeepCopyInto(out *StorageClassDeviceSet) {
	*out = *in
	in.Resources.DeepCopyInto(&out.Resources)
	in.Placement.DeepCopyInto(&out.Placement)
	if in.PreparePlacement != nil {
		in, out := &in.PreparePlacement, &out.PreparePlacement
		*out = new(Placement)
		(*in).DeepCopyInto(*out)
	}
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.VolumeClaimTemplates != nil {
		in, out := &in.VolumeClaimTemplates, &out.VolumeClaimTemplates
		*out = make([]corev1.PersistentVolumeClaim, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StorageClassDeviceSet.
func (in *StorageClassDeviceSet) DeepCopy() *StorageClassDeviceSet {
	if in == nil {
		return nil
	}
	out := new(StorageClassDeviceSet)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StorageScopeSpec) DeepCopyInto(out *StorageScopeSpec) {
	*out = *in
	if in.Nodes != nil {
		in, out := &in.Nodes, &out.Nodes
		*out = make([]Node, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	in.Selection.DeepCopyInto(&out.Selection)
	if in.StorageClassDeviceSets != nil {
		in, out := &in.StorageClassDeviceSets, &out.StorageClassDeviceSets
		*out = make([]StorageClassDeviceSet, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StorageScopeSpec.
func (in *StorageScopeSpec) DeepCopy() *StorageScopeSpec {
	if in == nil {
		return nil
	}
	out := new(StorageScopeSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StretchClusterSpec) DeepCopyInto(out *StretchClusterSpec) {
	*out = *in
	if in.Zones != nil {
		in, out := &in.Zones, &out.Zones
		*out = make([]StretchClusterZoneSpec, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StretchClusterSpec.
func (in *StretchClusterSpec) DeepCopy() *StretchClusterSpec {
	if in == nil {
		return nil
	}
	out := new(StretchClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *StretchClusterZoneSpec) DeepCopyInto(out *StretchClusterZoneSpec) {
	*out = *in
	if in.VolumeClaimTemplate != nil {
		in, out := &in.VolumeClaimTemplate, &out.VolumeClaimTemplate
		*out = new(corev1.PersistentVolumeClaim)
		(*in).DeepCopyInto(*out)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new StretchClusterZoneSpec.
func (in *StretchClusterZoneSpec) DeepCopy() *StretchClusterZoneSpec {
	if in == nil {
		return nil
	}
	out := new(StretchClusterZoneSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ZoneSpec) DeepCopyInto(out *ZoneSpec) {
	*out = *in
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ZoneSpec.
func (in *ZoneSpec) DeepCopy() *ZoneSpec {
	if in == nil {
		return nil
	}
	out := new(ZoneSpec)
	in.DeepCopyInto(out)
	return out
}
