/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.IQueryPreprocessor;
import com.metamatrix.connector.xml.SAXFilterProvider;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.exception.LicenseException;
import java.util.Properties;

public abstract class XMLConnectorStateImpl
implements Cloneable,
XMLConnectorState {
    private int m_cacheTimeout;
    private int m_maxMemoryCacheSize;
    private int m_maxInMemoryStringSize;
    private int m_maxFileCacheSize;
    private boolean m_preprocess;
    private boolean m_cacheEnabled;
    private boolean m_performanceCacheEnabled;
    private String m_cacheLocation;
    private String m_saxProviderClass;
    private String m_queryPreprocessorClass;
    private boolean m_errorOnRecreateDoc;
    private boolean m_logRequestResponse;
    private String m_pluggableInputStreamFilterClass;
    private static final int SECONDS_TO_MILLIS = 1000;
    private static final int KB_TO_BYTES = 1000;
    public static final String CACHE_TIMEOUT = "CacheTimeout";
    public static final String CACHE_ENABLED = "CacheEnabled";
    public static final String MAX_IN_MEMORY_STRING_SIZE = "MaxInMemoryStringSize";
    public static final String MAX_MEMORY_CACHE_SIZE = "MaxMemoryCacheSize";
    public static final String MAX_FILE_CACHE_SIZE = "MaxFileCacheSize";
    public static final String FILE_CACHE_LOCATION = "FileCacheLocation";
    public static final String THROW_ERROR_ON_RECREATE = "ExceptionOnIntraQueryCacheExpiration";
    public static final String LOG_REQUEST_RESPONSE_DOCS = "LogRequestResponseDocs";
    public static final String SAX_FILTER_PROVIDER_CLASS = "SaxFilterProviderClass";
    public static final String QUERY_PREPROCESS_CLASS = "QueryPreprocessorClass";
    public static final String INPUT_STREAM_FILTER_CLASS = "InputStreamFilterClass";
    public static final String SAX_FILTER_PROVIDER_CLASS_DEFAULT = "com.metamatrix.connector.xml.base.NoExtendedFilters";
    public static final String QUERY_PREPROCESS_CLASS_DEFAULT = "com.metamatrix.connector.xml.base.NoQueryPreprocessing";
    private static final String INPUT_STREAM_FILTER_CLASS_DEFAULT = "com.metamatrix.connector.xml.base.PluggableInputStreamFilterImpl";
    public static final String CONNECTOR_CAPABILITES = "ConnectorCapabilities";
    private static final String PERFORMANCE_CACHING = "PerformanceCaching";
    private String DQP_KEY = "MetaMatrix DQP";
    private String XML_CONNECTOR_KEY = "Connector/XML";
    private String VERSION_4_2 = "4.2";
    private String VERSION_4_3 = "4.3";
    private String VERSION_5_0 = "5.0";
    private String VERSION_5_5 = "5.5";
    protected ConnectorLogger logger;
    private IQueryPreprocessor preprocessor;
    private SAXFilterProvider provider;
    private ConnectorCapabilities capabilites;
    private String capabilitiesClass;

    public XMLConnectorStateImpl() {
        int defaultCacheTimeoutMillis = 60000;
        int defaultMemoryCacheSize = 512;
        int defaultFileCacheSize = -1;
        this.setCacheTimeoutMillis(60000);
        this.setMaxMemoryCacheSizeKB(512);
        this.setMaxInMemoryStringSize(131072);
        this.setMaxFileCacheSizeKB(-1);
        this.setPreprocess(true);
        this.setErrorOnRecreateDoc(true);
        this.setLogRequestResponse(false);
        this.setSaxProviderClass(SAX_FILTER_PROVIDER_CLASS_DEFAULT);
        this.setQueryPreprocessorClass(QUERY_PREPROCESS_CLASS_DEFAULT);
        this.setPluggableInputStreamFilterClass(INPUT_STREAM_FILTER_CLASS_DEFAULT);
    }

    public void setState(Properties props) throws ConnectorException {
        String capabilitesClass;
        String logReqRes;
        String cacheLoc;
        String maxFCache;
        String maxStringSize;
        String maxMCache;
        if (this.logger == null) {
            throw new ConnectorException("Internal Exception: logger is null");
        }
        String cache = props.getProperty(CACHE_TIMEOUT);
        if (cache != null) {
            this.setCacheTimeoutSeconds(Integer.parseInt(cache));
        }
        if ((maxMCache = props.getProperty(MAX_MEMORY_CACHE_SIZE)) != null) {
            this.setMaxMemoryCacheSizeKB(Integer.parseInt(maxMCache));
        }
        if ((maxStringSize = props.getProperty(MAX_IN_MEMORY_STRING_SIZE)) != null) {
            this.setMaxInMemoryStringSize(Integer.parseInt(maxStringSize) * 1024);
        }
        if ((maxFCache = props.getProperty(MAX_FILE_CACHE_SIZE)) != null) {
            this.setMaxFileCacheSizeKB(Integer.parseInt(maxFCache));
        }
        if ((cacheLoc = props.getProperty(FILE_CACHE_LOCATION)) != null) {
            this.setCacheLocation(cacheLoc);
        } else {
            String temp = System.getProperty("java.io.tmpdir");
            this.setCacheLocation(temp);
        }
        String throwError = props.getProperty(THROW_ERROR_ON_RECREATE);
        if (throwError != null) {
            this.setErrorOnRecreateDoc(Boolean.valueOf(throwError));
        }
        if ((logReqRes = props.getProperty(LOG_REQUEST_RESPONSE_DOCS)) != null) {
            this.setLogRequestResponse(Boolean.valueOf(logReqRes));
        }
        if ((capabilitesClass = props.getProperty(CONNECTOR_CAPABILITES)) == null || capabilitesClass.equals("")) {
            throw new ConnectorException("The Connector Capabilities Class is null or empty");
        }
        this.setConnectorCapabilitiesClass(capabilitesClass);
        this.setCapabilites(this.loadConnectorCapabilities(this.getConnectorCapabilitiesClass()));
        String provider = props.getProperty(SAX_FILTER_PROVIDER_CLASS);
        if (provider == null || provider.equals("")) {
            throw new ConnectorException("The SAX Filter Privider Class is null or empty");
        }
        this.setSaxProviderClass(provider);
        this.setSAXFilterProvider(this.loadSAXFilter(this.getSaxProviderClass()));
        String preprocessor = props.getProperty(QUERY_PREPROCESS_CLASS);
        if (preprocessor == null || preprocessor.equals("")) {
            throw new ConnectorException("The Query Preprocessor Class is null or empty");
        }
        this.setQueryPreprocessorClass(preprocessor);
        this.setPreprocessor(this.loadPreprocessor(this.getQueryPreprocessorClass()));
        String streamFilter = props.getProperty(INPUT_STREAM_FILTER_CLASS);
        if (streamFilter != null && !streamFilter.equals("")) {
            this.setPluggableInputStreamFilterClass(streamFilter);
        }
    }

    private ConnectorCapabilities loadConnectorCapabilities(String connectorCapabilitiesClass) throws ConnectorException {
        ConnectorCapabilities caps = null;
        try {
            caps = (ConnectorCapabilities)Class.forName(connectorCapabilitiesClass).newInstance();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), (Throwable)e);
            throw new ConnectorException((Throwable)e);
        }
        return caps;
    }

    private void setConnectorCapabilitiesClass(String capabilitesClass) {
        this.capabilitiesClass = capabilitesClass;
    }

    private String getConnectorCapabilitiesClass() {
        return this.capabilitiesClass;
    }

    public void setLogger(ConnectorLogger logger) {
        this.logger = logger;
    }

    public ConnectorLogger getLogger() {
        return this.logger;
    }

    public Properties getState() {
        Properties props = new Properties();
        props.setProperty(CACHE_TIMEOUT, Integer.toString(this.getCacheTimeoutSeconds()));
        props.setProperty(MAX_MEMORY_CACHE_SIZE, Integer.toString(this.getMaxMemoryCacheSizeKB()));
        props.setProperty(MAX_IN_MEMORY_STRING_SIZE, Integer.toString(this.getMaxInMemoryStringSize()));
        props.setProperty(MAX_FILE_CACHE_SIZE, Integer.toString(this.getMaxFileCacheSizeKB()));
        props.setProperty(LOG_REQUEST_RESPONSE_DOCS, Boolean.toString(this.isLogRequestResponse()));
        String location = this.getCacheLocation();
        if (location == null) {
            location = "";
        }
        props.setProperty(FILE_CACHE_LOCATION, location);
        props.setProperty(THROW_ERROR_ON_RECREATE, Boolean.toString(this.isErrorOnRecreateDoc()));
        props.setProperty(SAX_FILTER_PROVIDER_CLASS, this.getSaxProviderClass());
        props.setProperty(QUERY_PREPROCESS_CLASS, this.getQueryPreprocessorClass());
        return props;
    }

    protected boolean isNotNullOrEmpty(String value) {
        return value != null && !value.equals("");
    }

    private final void setCacheTimeoutSeconds(int cacheTimeoutseconds) {
        this.m_cacheTimeout = cacheTimeoutseconds * 1000;
    }

    private final void setCacheTimeoutMillis(int cacheTimeoutmillis) {
        this.m_cacheTimeout = cacheTimeoutmillis;
    }

    public final int getCacheTimeoutSeconds() {
        return this.m_cacheTimeout / 1000;
    }

    public final int getCacheTimeoutMillis() {
        return this.m_cacheTimeout;
    }

    private void setPreprocess(boolean preprocess) {
        this.m_preprocess = preprocess;
    }

    public boolean isPreprocess() {
        return this.m_preprocess;
    }

    public void checkLicense() throws ConnectorException {
        try {
            LicenseChecker.checkProductLicense((String)this.XML_CONNECTOR_KEY, (String)this.VERSION_5_5, (boolean)false);
        }
        catch (LicenseException x) {
            try {
                LicenseChecker.checkProductLicense((String)this.XML_CONNECTOR_KEY, (String)this.VERSION_5_0, (boolean)false);
            }
            catch (LicenseException e) {
                try {
                    LicenseChecker.checkProductLicense((String)this.DQP_KEY, (String)this.VERSION_4_2, (boolean)false);
                }
                catch (LicenseException ex) {
                    try {
                        LicenseChecker.checkProductLicense((String)this.DQP_KEY, (String)this.VERSION_4_3, (boolean)false);
                    }
                    catch (LicenseException lie) {
                        Object[] params = new Object[]{"Connector/Custom"};
                        String msg = Messages.getString("XMLConnector.NoLicense");
                        msg = msg.concat(" " + params);
                        ConnectorException ce = new ConnectorException((Throwable)ex, msg);
                        throw ce;
                    }
                }
            }
        }
    }

    public ConnectorCapabilities getConnectorCapabilities() {
        return this.capabilites;
    }

    private void setCapabilites(ConnectorCapabilities capabilities) {
        this.capabilites = capabilities;
    }

    private void setMaxMemoryCacheSizeKB(int maxMemoryCacheSizeKB) {
        this.m_maxMemoryCacheSize = maxMemoryCacheSizeKB * 1000;
    }

    private void setMaxMemoryCacheSizeBytes(int maxMemoryCacheSizeByte) {
        this.m_maxMemoryCacheSize = maxMemoryCacheSizeByte;
    }

    public int getMaxMemoryCacheSizeByte() {
        return this.m_maxMemoryCacheSize;
    }

    public int getMaxMemoryCacheSizeKB() {
        return this.m_maxMemoryCacheSize / 1000;
    }

    private void setMaxInMemoryStringSize(int maxInMemoryStringSize) {
        this.m_maxInMemoryStringSize = maxInMemoryStringSize;
    }

    public int getMaxInMemoryStringSize() {
        return this.m_maxInMemoryStringSize;
    }

    private void setMaxFileCacheSizeByte(int maxFileCacheSize) {
        this.m_maxFileCacheSize = maxFileCacheSize;
    }

    private void setMaxFileCacheSizeKB(int maxFileCacheSize) {
        this.m_maxFileCacheSize = maxFileCacheSize * 1000;
    }

    public int getMaxFileCacheSizeKB() {
        return this.m_maxFileCacheSize / 1000;
    }

    public int getMaxFileCacheSizeByte() {
        return this.m_maxFileCacheSize;
    }

    private void setCacheLocation(String cacheLocation) {
        this.m_cacheLocation = cacheLocation;
    }

    public String getCacheLocation() {
        return this.m_cacheLocation;
    }

    protected void setErrorOnRecreateDoc(boolean errorOnRecreateDoc) {
        this.m_errorOnRecreateDoc = errorOnRecreateDoc;
    }

    public boolean isErrorOnRecreateDoc() {
        return this.m_errorOnRecreateDoc;
    }

    private void setLogRequestResponse(boolean logRequestResponse) {
        this.m_logRequestResponse = logRequestResponse;
    }

    public boolean isLogRequestResponse() {
        return this.m_logRequestResponse;
    }

    private void setSaxProviderClass(String m_saxProviderClass) {
        this.m_saxProviderClass = m_saxProviderClass;
    }

    private String getSaxProviderClass() {
        return this.m_saxProviderClass;
    }

    private void setSAXFilterProvider(SAXFilterProvider provider) {
        this.provider = provider;
    }

    public SAXFilterProvider getSAXFilterProvider() {
        return this.provider;
    }

    private void setQueryPreprocessorClass(String preprocessor) {
        this.m_queryPreprocessorClass = preprocessor;
    }

    private String getQueryPreprocessorClass() {
        return this.m_queryPreprocessorClass;
    }

    public IQueryPreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    private void setPreprocessor(IQueryPreprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    private IQueryPreprocessor loadPreprocessor(String queryPreprocessorClass) throws ConnectorException {
        IQueryPreprocessor pre = null;
        try {
            pre = (IQueryPreprocessor)Class.forName(queryPreprocessorClass).newInstance();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), (Throwable)e);
            throw new ConnectorException((Throwable)e);
        }
        return pre;
    }

    private SAXFilterProvider loadSAXFilter(String SAXFilterClass) throws ConnectorException {
        SAXFilterProvider filter = null;
        try {
            filter = (SAXFilterProvider)Class.forName(SAXFilterClass).newInstance();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage(), (Throwable)e);
            throw new ConnectorException((Throwable)e);
        }
        return filter;
    }

    public void setPluggableInputStreamFilterClass(String filterClass) {
        this.m_pluggableInputStreamFilterClass = filterClass;
    }

    public String getPluggableInputStreamFilterClass() {
        return this.m_pluggableInputStreamFilterClass;
    }
}

