/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.cache.CachedObjectRecord;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.cache.RequestRecord;
import com.metamatrix.data.api.ConnectorLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RequestPartRecord {
    RequestRecord parent;
    String partID;
    Map cacheRecords = new HashMap();

    public RequestPartRecord(String partID, String sourceRequestID, String cacheKey, RequestRecord parent) {
        this.partID = partID;
        this.parent = parent;
        this.addCacheRecord(sourceRequestID, cacheKey);
    }

    public void addCacheRecord(String sourceRequestID, String cacheKey) {
        CachedObjectRecord record = (CachedObjectRecord)this.cacheRecords.get(sourceRequestID);
        if (null != record) {
            throw new RuntimeException("Error - Cannot add a CacheRecord to a RequestPartRecord with an existing key");
        }
        record = new CachedObjectRecord(sourceRequestID, cacheKey);
        this.cacheRecords.put(sourceRequestID, record);
    }

    public void deleteCacheItems(ConnectorLogger logger, String requestID) {
        Collection records = this.cacheRecords.values();
        Iterator iter = records.iterator();
        while (iter.hasNext()) {
            CachedObjectRecord record = (CachedObjectRecord)iter.next();
            String cacheKey = record.getCacheKey();
            ((IDocumentCache)this.parent.getCache()).release(cacheKey, requestID, this.partID);
            logger.logTrace("Releasing cache item with key " + cacheKey + " and Request Identifier " + requestID + " and Part Identifier " + this.partID);
        }
        this.cacheRecords.clear();
    }
}

