/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.http;

import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.base.TrustedPayloadBridge;
import com.metamatrix.connector.xml.http.HTTPConnectorState;
import com.metamatrix.connector.xml.http.HTTPTrustDeserializer;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.CredentialMap;
import java.io.Serializable;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class DefaultTrustDeserializer
extends TrustedPayloadBridge
implements HTTPTrustDeserializer {
    private Serializable m_trust = null;
    private Serializable m_process = null;
    private ConnectorLogger m_logger = null;
    protected HTTPConnectorState m_state;
    private String m_credentialedUser;
    private String m_credentialedPassword;
    private String m_systemName;

    public void setConnectorState(XMLConnectorState state) {
        this.m_state = (HTTPConnectorState)state;
    }

    public void setTrustedPayload(Serializable payload) {
        this.m_trust = payload;
    }

    public void setExecutionPayload(Serializable payload) {
        this.m_process = payload;
    }

    public void processPayloads() throws Exception {
        if (this.m_trust instanceof CredentialMap) {
            CredentialMap map = (CredentialMap)this.m_process;
            this.m_credentialedUser = map.getUser(this.m_systemName);
            this.m_credentialedPassword = map.getPassword(this.m_systemName);
        }
    }

    public void modifyRequest(HttpClient client, HttpMethod method) throws ConnectorException {
        if (this.m_logger != null) {
            if (this.m_trust != null) {
                this.m_logger.logInfo(Messages.getString("DefaultTrustDeserializer.trust.not.processed"));
            }
            if (this.m_process != null) {
                this.m_logger.logInfo(Messages.getString("DefaultTrustDeserializer.process.not.processed"));
            }
        }
        if (this.m_credentialedUser != null) {
            this.updateCredentials(client, method, this.m_credentialedUser, this.m_credentialedPassword);
        }
    }

    public void setLogger(ConnectorLogger logger) {
        this.m_logger = logger;
    }

    protected void updateCredentials(HttpClient client, HttpMethod method, String user, String password) throws ConnectorException {
        if (!this.m_state.useHttpBasicAuth()) {
            throw new ConnectorException(Messages.getString("HTTPExecutor.bad.security.configuration"));
        }
        AuthScope authScope = new AuthScope(null, -1);
        UsernamePasswordCredentials defCred = new UsernamePasswordCredentials(user, password);
        client.getState().setCredentials(authScope, (Credentials)defCred);
        this.m_logger.logInfo(Messages.getString("DefaultTrustDeserializer.trust.processed"));
    }
}

