/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.ui;

import com.metamatrix.core.CoreConstants;
import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.SynchEventBroker;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.notification.util.INotificationHelper;
import com.metamatrix.modeler.core.notification.util.NotificationUtilities;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotification;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotificationListener;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.ui.PluginConstants;
import com.metamatrix.modeler.internal.ui.editors.ModelEditorProjectListener;
import com.metamatrix.modeler.internal.ui.favorites.EObjectModelerCache;
import com.metamatrix.modeler.internal.ui.settings.ModelerDialogSettingsInitializer;
import com.metamatrix.modeler.internal.ui.table.EObjectPropertiesOrderPreferences;
import com.metamatrix.modeler.internal.ui.undo.ModelerUndoManager;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelerNotificationHelper;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.ui.actions.ModelerActionService;
import com.metamatrix.modeler.ui.event.ModelResourceEvent;
import com.metamatrix.modeler.ui.product.IModelerProductContexts;
import com.metamatrix.ui.AbstractUiPlugin;
import com.metamatrix.ui.PreferenceKeyAndDefaultValue;
import com.metamatrix.ui.actions.ActionService;
import com.metamatrix.ui.internal.product.ProductCustomizerMgr;
import com.metamatrix.ui.internal.util.UiUtil;
import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.BundleContext;

public final class UiPlugin
extends AbstractUiPlugin
implements CoreConstants.Debug,
PluginConstants,
UiConstants,
UiConstants.ProductInfo,
UiConstants.ProductInfo.Capabilities,
IModelerProductContexts {
    private static UiPlugin plugin;
    private EventBroker eventBroker;
    private EObjectModelerCache eObjCache;
    private ISelection cachedSelection = null;
    private ImageDescriptor errorDecoratorImage;
    private ImageDescriptor warningDecoratorImage;
    private ImageDescriptor projectImage;
    private ImageDescriptor simpleProjectImage;
    private ModelEditorProjectListener projectListener = new ModelEditorProjectListener();
    private EObjectPropertiesOrderPreferences eObjectPropertiesOrderPreferences;

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static MultiStatus createMultiStatus(String desc) {
        return new MultiStatus("com.metamatrix.modeler.ui", 0, desc, null);
    }

    public static void addStatus(MultiStatus parent, String msg, int severity, Throwable throwable) {
        if (parent != null) {
            Status child = new Status(severity, "com.metamatrix.modeler.ui", 0, msg, throwable);
            parent.add((IStatus)child);
        }
    }

    public static void addStatus(MultiStatus parent, String msg, int severity) {
        if (parent != null) {
            Status child = new Status(severity, "com.metamatrix.modeler.ui", 0, msg, null);
            parent.add((IStatus)child);
        }
    }

    public UiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        UiConstants.Util.debug("pluginActivation", "Plug-in " + ((Object)((Object)this)).getClass().getName() + " activated.");
        super.start(context);
        ((PluginUtilImpl)UiConstants.Util).initializePlatformLogger((Plugin)this);
        try {
            LicensePlugin.checkLicense((String)"Modeler", (String)"5.0");
            LicenseChecker.checkProductLicenseForExpiring((String)"Modeler", (String)"5.0");
        }
        catch (CoreException ce) {
            String sMessage = UiConstants.Util.getString("UiPlugin.terminate_on_license_problem_msg");
            UiConstants.Util.log(4, (Throwable)ce, sMessage);
            System.exit(0);
            throw ce;
        }
        try {
            UiUtil.runInSwtThread((Runnable)new Runnable(){

                public void run() {
                    UiPlugin.this.errorDecoratorImage = UiPlugin.this.getImageDescriptor("icons/full/ovr16/error_co.gif");
                    UiPlugin.this.warningDecoratorImage = UiPlugin.this.getImageDescriptor("icons/full/ovr16/warning_co.gif");
                    UiPlugin.this.projectImage = UiPlugin.this.getImageDescriptor("icons/full/obj16/ModelProject.gif");
                    UiPlugin.this.simpleProjectImage = UiPlugin.this.getImageDescriptor("icons/full/obj16/SimpleProject.gif");
                }
            }, (boolean)true);
        }
        catch (Throwable err) {
            throw new CoreException((IStatus)new Status(4, "com.metamatrix.modeler.ui", 0, err.getLocalizedMessage(), err));
        }
        try {
            ProductCustomizerMgr.getInstance().loadCustomizations();
        }
        catch (Exception theException) {
            UiConstants.Util.log((Throwable)theException);
        }
        ModelerUndoManager.getInstance();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.projectListener);
        NotificationUtilities.setNotificationHelper((INotificationHelper)new ModelerNotificationHelper());
        ModelWorkspaceManager.getModelWorkspaceManager();
        ModelWorkspaceNotificationListener modelWsListener = new ModelWorkspaceNotificationListener(){

            public void notifyAdd(ModelWorkspaceNotification notification) {
                ModelResource modelResource;
                if (notification.isPostChange() && (modelResource = this.getModelResource((Notification)notification)) != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 7, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyRemove(ModelWorkspaceNotification notification) {
                Object notifier;
                if (notification.isPostChange() && (notifier = notification.getNotifier()) instanceof IResource) {
                    IResource srcFile = (IResource)notifier;
                    ModelResourceEvent event = new ModelResourceEvent(srcFile, 8, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyRename(ModelWorkspaceNotification notification) {
                ModelResource modelResource;
                if (notification.isPostChange() && (modelResource = this.getModelResource((Notification)notification)) != null) {
                    IPath oldPath = notification.getDelta().getMovedFromPath();
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 9, (Object)this, oldPath);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyMove(ModelWorkspaceNotification notification) {
                ModelResource modelResource;
                if (notification.isPostChange() && (modelResource = this.getModelResource((Notification)notification)) != null) {
                    IPath oldPath = notification.getDelta().getMovedFromPath();
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 9, (Object)this, oldPath);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyOpen(ModelWorkspaceNotification notification) {
                ModelResource modelResource = this.getModelResource((Notification)notification);
                if (modelResource != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 1, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyClosing(ModelWorkspaceNotification notification) {
                ModelResource modelResource = this.getModelResource((Notification)notification);
                if (modelResource != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 2, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyChanged(Notification notification) {
                ModelResource modelResource;
                if (notification instanceof ModelWorkspaceNotification && ((ModelWorkspaceNotification)notification).isPreAutoBuild() && (modelResource = this.getModelResource(notification)) != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 4, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyReloaded(ModelWorkspaceNotification notification) {
                ModelResource modelResource = this.getModelResource((Notification)notification);
                if (modelResource != null) {
                    ModelResourceEvent event = new ModelResourceEvent(modelResource, 6, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }

            public void notifyClean(IProject proj) {
            }

            protected ModelResource getModelResource(Notification notification) {
                IResource resource = (IResource)notification.getNotifier();
                return ModelerCore.getModelWorkspace().findModelResource(resource);
            }
        };
        ModelerCore.getModelWorkspace().addNotificationListener(modelWsListener);
        this.storeDefaultPreferenceValues();
        this.initializeModelTableColumnUtilsFromPreferenceStore();
        this.initializeDialogSettings();
    }

    private void initializeModelTableColumnUtilsFromPreferenceStore() {
        this.getEObjectPropertiesOrderPreferences().initializeFromString(this.getPreferenceStore().getString("columnOrder"));
    }

    private void initializeDialogSettings() {
        ModelerDialogSettingsInitializer initializer = new ModelerDialogSettingsInitializer();
        initializer.initialize();
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        page.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)new ViewSelectionCache());
        return new ModelerActionService(page);
    }

    public PluginUtil getPluginUtil() {
        return UiConstants.Util;
    }

    public EventBroker getEventBroker() {
        if (this.eventBroker == null) {
            this.eventBroker = new SynchEventBroker();
        }
        return this.eventBroker;
    }

    public EObjectModelerCache getEObjectCache() {
        if (this.eObjCache == null) {
            this.eObjCache = new EObjectModelerCache();
        }
        return this.eObjCache;
    }

    public boolean isModelerCapabilityLicensed(String theCapability) {
        if (this.isProductContextValueSupported(IModelerProductContexts.License.CAPABILITY, theCapability)) {
            return LicensePlugin.isCapabilityLicensed((String)"Modeler", (String)theCapability, (String)"5.0");
        }
        return false;
    }

    public boolean isModelerLicensed() {
        return LicensePlugin.isProductLicensed((String)"Modeler", (String)"5.0");
    }

    private void storeDefaultPreferenceValues() {
        IPreferenceStore preferenceStore = UiPlugin.getDefault().getPreferenceStore();
        for (int i = 0; i < PluginConstants.Prefs.General.PREFERENCES.length; ++i) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.General.PREFERENCES[i]);
        }
        UiPlugin.getDefault().savePluginPreferences();
    }

    public ImageDescriptor getErrorDecoratorImage() {
        return this.errorDecoratorImage;
    }

    public ImageDescriptor getWarningDecoratorImage() {
        return this.warningDecoratorImage;
    }

    public ImageDescriptor getProjectImage() {
        return this.projectImage;
    }

    public ImageDescriptor getSimpleProjectImage() {
        return this.simpleProjectImage;
    }

    public ISelection getPreviousViewSelection() {
        return this.cachedSelection;
    }

    public EObjectPropertiesOrderPreferences getEObjectPropertiesOrderPreferences() {
        if (this.eObjectPropertiesOrderPreferences == null) {
            this.eObjectPropertiesOrderPreferences = new EObjectPropertiesOrderPreferences();
        }
        return this.eObjectPropertiesOrderPreferences;
    }

    public void shutdown() throws CoreException {
        this.extractModelTableColumnUtilsToPreferenceStore();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.projectListener);
        super.shutdown();
    }

    private void extractModelTableColumnUtilsToPreferenceStore() {
        this.getPreferenceStore().setValue("columnOrder", this.getEObjectPropertiesOrderPreferences().toString());
    }

    class ViewSelectionCache
    implements ISelectionListener {
        ViewSelectionCache() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(part instanceof IEditorPart)) {
                UiPlugin.this.cachedSelection = selection;
            }
        }
    }
}

