/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metabase.repository.jdbc.commands;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.core.util.SqlResourceBundle;
import com.metamatrix.metabase.repository.RepositoryCommand;
import com.metamatrix.metabase.repository.RepositoryCommandFactory;
import com.metamatrix.metabase.repository.RepositoryParameters;
import com.metamatrix.metabase.repository.RepositoryPlugin;
import com.metamatrix.metabase.repository.internal.interceptor.JdbcConnectionContextFactory;
import com.metamatrix.metabase.repository.jdbc.commands.AddCommand;
import com.metamatrix.metabase.repository.jdbc.commands.CheckinCommand;
import com.metamatrix.metabase.repository.jdbc.commands.CheckoutCommand;
import com.metamatrix.metabase.repository.jdbc.commands.CreateFolderCommand;
import com.metamatrix.metabase.repository.jdbc.commands.ExistsCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetChildrenCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetExistingPartOfPathCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetHistoryCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetItemByIdCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetItemInfoByIdCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetItemInfoByPathCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetItemLabelsByIdCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetItemPathByIdCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetLatestCommand;
import com.metamatrix.metabase.repository.jdbc.commands.GetVersionCommand;
import com.metamatrix.metabase.repository.jdbc.commands.LabelCommand;
import com.metamatrix.metabase.repository.jdbc.commands.PutEntryCommand;
import com.metamatrix.metabase.repository.jdbc.commands.PutEntryLabelCommand;
import com.metamatrix.metabase.repository.jdbc.commands.PutItemCommand;
import com.metamatrix.metabase.repository.jdbc.commands.RemoveCommand;
import com.metamatrix.metabase.repository.jdbc.commands.RemoveEntryCommand;
import com.metamatrix.metabase.repository.jdbc.commands.RemoveItemCommand;
import com.metamatrix.metabase.repository.jdbc.commands.RemoveItemVersionCommand;
import com.metamatrix.metabase.repository.jdbc.commands.UndoCheckoutCommand;
import com.metamatrix.metabase.repository.jdbc.commands.UpdateEntryDetailsCommand;
import com.metamatrix.metabase.repository.jdbc.commands.UpdateLockInfoCommand;
import java.util.ArrayList;

public class JDBCCommandFactory
implements RepositoryCommandFactory {
    public static final String SQL_RESOURCE_BUNDLE_BASE_NAME = "com.metamatrix.metabase.repository.jdbc.sql.sql";
    private JdbcConnectionContextFactory connectionContextFactory;
    private SqlResourceBundle bundle;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$JDBCCommandFactory;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$AddCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$CheckinCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$CheckoutCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$CreateFolderCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetChildrenCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetItemByIdCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByIdCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByPathCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetLatestCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetVersionCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetHistoryCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$LabelCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetItemLabelsByIdCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryLabelCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$PutItemCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$RemoveCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$RemoveEntryCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemVersionCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$UndoCheckoutCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$UpdateEntryDetailsCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$UpdateLockInfoCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetExistingPartOfPathCommand;

    public JDBCCommandFactory(String dbms, JdbcConnectionContextFactory connectionContextFactory) {
        this(dbms != null ? SqlResourceBundle.getBundle((String)SQL_RESOURCE_BUNDLE_BASE_NAME, (String)dbms, (ClassLoader)(class$com$metamatrix$metabase$repository$jdbc$commands$JDBCCommandFactory == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$JDBCCommandFactory = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.JDBCCommandFactory")) : class$com$metamatrix$metabase$repository$jdbc$commands$JDBCCommandFactory).getClassLoader()) : SqlResourceBundle.getBundle((String)SQL_RESOURCE_BUNDLE_BASE_NAME, (ClassLoader)(class$com$metamatrix$metabase$repository$jdbc$commands$JDBCCommandFactory == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$JDBCCommandFactory = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.JDBCCommandFactory")) : class$com$metamatrix$metabase$repository$jdbc$commands$JDBCCommandFactory).getClassLoader()), connectionContextFactory);
    }

    public JDBCCommandFactory(SqlResourceBundle bundle, JdbcConnectionContextFactory connectionContextFactory) {
        this.connectionContextFactory = connectionContextFactory;
        this.bundle = bundle;
    }

    public SqlResourceBundle getSqlResourceBundle() {
        return this.bundle;
    }

    public RepositoryCommand createCheckout(RepositoryParameters params) {
        return new CheckoutCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createGetItemInfoByPath(RepositoryParameters params) {
        return new GetItemInfoByPathCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createCheckin(RepositoryParameters params) {
        return new CheckinCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createAdd(RepositoryParameters params) {
        if (params.hasContents()) {
            return new AddCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        return new CreateFolderCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createGetCheckoutStatus(RepositoryParameters params) {
        if (params.getId() == null) {
            return new GetItemInfoByPathCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        return new GetItemInfoByIdCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createGetHistory(RepositoryParameters params) {
        return new GetHistoryCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createGetLatest(RepositoryParameters params) {
        return new GetLatestCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createGetVersion(RepositoryParameters params) {
        return new GetVersionCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createGetChildren(RepositoryParameters params) {
        return new GetChildrenCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createUndoCheckout(RepositoryParameters params) {
        return new UndoCheckoutCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createLabel(RepositoryParameters params) {
        return new LabelCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createModelDependencies(RepositoryParameters params) {
        return null;
    }

    public RepositoryCommand createRemove(RepositoryParameters params) {
        return new RemoveCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createExists(RepositoryParameters params) {
        return new ExistsCommand(this.bundle, params, this.connectionContextFactory.create());
    }

    public RepositoryCommand createCommand(String name, RepositoryParameters params) {
        if (name.equalsIgnoreCase("add")) {
            return this.createAdd(params);
        }
        if (name.equalsIgnoreCase("checkin")) {
            return this.createCheckin(params);
        }
        if (name.equalsIgnoreCase("checkout")) {
            return this.createCheckout(params);
        }
        if (name.equalsIgnoreCase("getChildren")) {
            return this.createGetChildren(params);
        }
        if (name.equalsIgnoreCase("getLatest")) {
            return this.createGetLatest(params);
        }
        if (name.equalsIgnoreCase("getVersion")) {
            return this.createGetVersion(params);
        }
        if (name.equalsIgnoreCase("getStatus")) {
            return this.createGetCheckoutStatus(params);
        }
        if (name.equalsIgnoreCase("remove")) {
            return this.createRemove(params);
        }
        if (name.equalsIgnoreCase("undoCheckout")) {
            return this.createUndoCheckout(params);
        }
        if (name.equalsIgnoreCase("getHistory")) {
            return this.createGetHistory(params);
        }
        if (name.equalsIgnoreCase("label")) {
            return this.createLabel(params);
        }
        if (name.equalsIgnoreCase("exists")) {
            return this.createExists(params);
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$AddCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$AddCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.AddCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$AddCommand).getName())) {
            return new AddCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$CheckinCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$CheckinCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.CheckinCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$CheckinCommand).getName())) {
            return new CheckinCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$CheckoutCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$CheckoutCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.CheckoutCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$CheckoutCommand).getName())) {
            return new CheckoutCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$CreateFolderCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$CreateFolderCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.CreateFolderCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$CreateFolderCommand).getName())) {
            return new CreateFolderCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetChildrenCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetChildrenCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetChildrenCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetChildrenCommand).getName())) {
            return new GetChildrenCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetItemByIdCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemByIdCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetItemByIdCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetItemByIdCommand).getName())) {
            return new GetItemByIdCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByIdCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByIdCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetItemInfoByIdCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByIdCommand).getName())) {
            return new GetItemInfoByIdCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByPathCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByPathCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetItemInfoByPathCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetItemInfoByPathCommand).getName())) {
            return new GetItemInfoByPathCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetLatestCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetLatestCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetLatestCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetLatestCommand).getName())) {
            return new GetLatestCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetVersionCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetVersionCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetVersionCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetVersionCommand).getName())) {
            return new GetVersionCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetHistoryCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetHistoryCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetHistoryCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetHistoryCommand).getName())) {
            return new GetHistoryCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$LabelCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$LabelCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.LabelCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$LabelCommand).getName())) {
            return new LabelCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetItemLabelsByIdCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemLabelsByIdCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetItemLabelsByIdCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetItemLabelsByIdCommand).getName())) {
            return new GetItemLabelsByIdCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryLabelCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryLabelCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.PutEntryLabelCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryLabelCommand).getName())) {
            return new PutEntryLabelCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.PutEntryCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$PutEntryCommand).getName())) {
            return new PutEntryCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$PutItemCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$PutItemCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.PutItemCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$PutItemCommand).getName())) {
            return new PutItemCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$RemoveCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$RemoveCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.RemoveCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$RemoveCommand).getName())) {
            return new RemoveCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$RemoveEntryCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$RemoveEntryCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.RemoveEntryCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$RemoveEntryCommand).getName())) {
            return new RemoveEntryCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.RemoveItemCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemCommand).getName())) {
            return new RemoveItemCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemVersionCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemVersionCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.RemoveItemVersionCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$RemoveItemVersionCommand).getName())) {
            return new RemoveItemVersionCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$UndoCheckoutCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$UndoCheckoutCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.UndoCheckoutCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$UndoCheckoutCommand).getName())) {
            return new UndoCheckoutCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$UpdateEntryDetailsCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$UpdateEntryDetailsCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.UpdateEntryDetailsCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$UpdateEntryDetailsCommand).getName())) {
            return new UpdateEntryDetailsCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$UpdateLockInfoCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$UpdateLockInfoCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.UpdateLockInfoCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$UpdateLockInfoCommand).getName())) {
            return new UpdateLockInfoCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetItemPathByIdCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand).getName())) {
            return new GetItemPathByIdCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        if (name.equalsIgnoreCase((class$com$metamatrix$metabase$repository$jdbc$commands$GetExistingPartOfPathCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetExistingPartOfPathCommand = JDBCCommandFactory.class$("com.metamatrix.metabase.repository.jdbc.commands.GetExistingPartOfPathCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetExistingPartOfPathCommand).getName())) {
            return new GetExistingPartOfPathCommand(this.bundle, params, this.connectionContextFactory.create());
        }
        ArrayList<Object> ctorObjs = new ArrayList<Object>(1);
        ctorObjs.add(this.bundle);
        ctorObjs.add(params);
        try {
            Object cmd = ReflectionHelper.create((String)name, ctorObjs, (ClassLoader)this.getClass().getClassLoader());
            if (cmd != null && cmd instanceof RepositoryCommand) {
                return (RepositoryCommand)cmd;
            }
            RepositoryPlugin.Util.log(4, RepositoryPlugin.Util.getString("JDBCCommandFactory.Error_creating_instance_of_1", (Object)name));
        }
        catch (MetaMatrixCoreException e) {
            RepositoryPlugin.Util.log((Throwable)e);
        }
        throw new MetaMatrixRuntimeException(RepositoryPlugin.Util.getString("JDBCCommandFactory.Error_creating_instance_of_1", (Object)name));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DBMS {
        public static final String ORACLE = "oracle";
        public static final String DB2 = "db2";
        public static final String SQL_SERVER = "sqlserver";
        public static final String DERBY = "derby";
        public static final String SYBASE = "sybase";
    }
}

