/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;

public abstract class XSDFacetImpl
extends XSDComponentImpl
implements XSDFacet {
    protected static final String LEXICAL_VALUE_EDEFAULT = null;
    protected String lexicalValue = LEXICAL_VALUE_EDEFAULT;
    protected static final String FACET_NAME_EDEFAULT = null;
    protected static final Object EFFECTIVE_VALUE_EDEFAULT = null;
    protected XSDAnnotation annotation = null;

    protected XSDFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDFacet();
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    public void setLexicalValue(String newLexicalValue) {
        String oldLexicalValue = this.lexicalValue;
        this.lexicalValue = newLexicalValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldLexicalValue, (Object)this.lexicalValue));
        }
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkComplexContent("annotated", "http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), theElement);
        }
        this.validateValue();
    }

    protected void validateValue() {
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement.hasAttributeNS(null, "value")) {
            String newLexicalValue = changedElement.getAttributeNS(null, "value");
            if (newLexicalValue == null || !newLexicalValue.equals(this.getLexicalValue())) {
                this.setLexicalValue(newLexicalValue);
            }
        } else if (this.getLexicalValue() != null) {
            this.setLexicalValue(null);
        }
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
        if (XSDConstants.nodeType(child) == 1) {
            XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
            newContents.add(xsdAnnotation);
        }
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.eINSTANCE.getXSDFacet_Annotation(), newContents, remainingContents);
    }

    protected void changeAttribute(EAttribute eAttribute) {
        if (this.isReconciling) {
            return;
        }
        super.changeAttribute(eAttribute);
        Element theElement = this.getElement();
        if (theElement != null && (eAttribute == null || eAttribute == XSDPackage.eINSTANCE.getXSDFacet_LexicalValue())) {
            this.niceSetAttribute(theElement, "value", this.getLexicalValue());
        }
    }

    public String getFacetName() {
        String name = this.eClass().getName();
        return Character.toLowerCase(name.charAt(3)) + name.substring(4, name.length() - 5);
    }

    public Object getEffectiveValue() {
        return null;
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public XSDSimpleTypeDefinition getSimpleTypeDefinition() {
        XSDConcreteComponent result = this.getContainer();
        return result instanceof XSDSimpleTypeDefinition ? (XSDSimpleTypeDefinition)result : null;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (lexicalValue: ");
        result.append(this.lexicalValue);
        result.append(')');
        return result.toString();
    }
}

