/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.printing;

import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditor;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorUtil;
import com.metamatrix.modeler.diagram.ui.preferences.DiagramPrintPreferencePage;
import com.metamatrix.modeler.diagram.ui.printing.DiagramPrintSummaryDialog;
import com.metamatrix.modeler.diagram.ui.printing.DiagramPrintingAnalyzer;
import com.metamatrix.modeler.diagram.ui.printing.PrintSettings;
import com.metamatrix.ui.graphics.GlobalUiColorManager;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.widget.Dialog;
import com.metamatrix.ui.internal.widget.Label;
import com.metamatrix.ui.internal.widget.Spinner;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DiagramPrintSummaryDialog
extends Dialog
implements DiagramUiConstants {
    Control pnlSummary;
    Control pnlPageSetup;
    Color color1 = GlobalUiColorManager.getColor((RGB)new RGB(0, 0, 255));
    Color color2 = GlobalUiColorManager.getColor((RGB)new RGB(0, 255, 0));
    Color color3 = GlobalUiColorManager.getColor((RGB)new RGB(255, 0, 0));
    private static final int DEFAULT_LABEL_WIDTH = 235;
    private static final String LABEL_INIT_STRING = "............................................................................................................";
    private static final String TITLE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.title");
    private static final String APPLY_BUTTON_TEXT = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.applyButton.text");
    private static final String RESTORE_DEFAULTS_BUTTON_TEXT = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.restoreDefaultsButton.text");
    private static final String SUMMARY_TAB_TITLE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.summaryTabTitle.text");
    private static final String SUMMARY_TAB_TOOLTIP = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.summaryTabTooltip.text");
    private static final String PAGE_SETUP_TAB_TITLE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.pageSetupTabTitle.text");
    private static final String PAGE_SETUP_TAB_TOOLTIP = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.pageSetupTabTooltip.text");
    private TabFolder tabFolder;
    private TabItem tabSummary;
    private TabItem tabPageSetup;
    private SelectionAdapter tabListener;
    private static final String DIAGRAM_TITLE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.diagram.title");
    private static final String PROJECT_NAME = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.projectName.text");
    private static final String MODEL_NAME = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.modelName.text");
    private static final String DIAGRAM_TYPE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.diagramType.text");
    private CLabel lblProjectName;
    private CLabel lblModelName;
    private CLabel lblDiagramType;
    private static final String PAGE_SETUP_TITLE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.pageSetup.title");
    private static final String ORIENTATION = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.orientation.text");
    private static final String PORTRAIT = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.portrait.text");
    private static final String LANDSCAPE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.landscape.text");
    private static final String SCALING = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.scaling.text");
    private static final String ADJUST_TO = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.adjustTo.text");
    private static final String PERCENT_NORMAL_SIZE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.percentNormalSize.text");
    private static final String FIT_TO_ONE_PAGE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.fitToOnePage.text");
    private static final String FIT_TO_ONE_PAGE_HIGH = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.fitToOnePageHigh.text");
    private static final String FIT_TO_ONE_PAGE_WIDE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.fitToOnePageWide.text");
    private static final String MARGINS = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.margins.text");
    private static final String TOP = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.top.text");
    private static final String RIGHT = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.right.text");
    private static final String BOTTOM = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.bottom.text");
    private static final String LEFT = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.left.text");
    private static final String PAGE_ORDER = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.pageOrder.text");
    private static final String OVER_THEN_DOWN = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.overThenDown.text");
    private static final String DOWN_THEN_OVER = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.downThenOver.text");
    private CLabel lblOrientation;
    private CLabel lblScaling;
    private CLabel lblMargins;
    private CLabel lblPageOrder;
    private static final String PAGE_RANGE_TITLE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.pageRange.title");
    private static final String ALL_PAGES = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.allPages.text");
    private static final String RANGE_FROM = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.rangeFrom.text");
    private static final String RANGE_TO = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.rangeTo.text");
    private Button radioAllPages;
    private Button radioPagesInRange;
    private Spinner spinRangeFrom;
    private Spinner spinRangeTo;
    private static final String TOTAL_PAGES_TITLE = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.totalPages.title");
    private static final String PAGES_TO_PRINT = DiagramUiConstants.Util.getString("DiagramPrintSummaryDialog.pagesToPrint.text");
    private CLabel lblTotalPages;
    private Button btnApply;
    private Button btnRestoreDefaults;
    private Button btnOk;
    private DiagramPrintPreferencePage preferencePage;
    private PrintSettings psSettings;
    private DiagramPrintingAnalyzer analyzer;

    public DiagramPrintSummaryDialog(Shell shell, PrintSettings psSettings, DiagramPrintingAnalyzer analyzer) {
        super(shell, TITLE);
        this.psSettings = psSettings;
        this.analyzer = analyzer;
        this.init();
    }

    public PrintSettings getSettings() {
        return this.psSettings;
    }

    private void init() {
        this.setTitle(TITLE);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layComp = new GridLayout();
        composite.setLayout((Layout)layComp);
        GridData gdComp = new GridData(1808);
        composite.setLayoutData((Object)gdComp);
        this.tabFolder = new TabFolder(parent, 0);
        GridLayout layTabFolder = new GridLayout();
        this.tabFolder.setLayout((Layout)layTabFolder);
        GridData gdTabFolder = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gdTabFolder);
        this.tabSummary = new TabItem(this.tabFolder, 0);
        this.pnlSummary = this.createSummaryPanel((Composite)this.tabFolder);
        this.tabSummary.setControl(this.pnlSummary);
        this.tabSummary.setText(SUMMARY_TAB_TITLE);
        this.tabSummary.setToolTipText(SUMMARY_TAB_TOOLTIP);
        this.tabPageSetup = new TabItem(this.tabFolder, 0);
        Composite pnlTest = new Composite((Composite)this.tabFolder, 0);
        GridLayout layComp2 = new GridLayout();
        pnlTest.setLayout((Layout)layComp2);
        GridData gdComp2 = new GridData(1808);
        pnlTest.setLayoutData((Object)gdComp2);
        this.pnlPageSetup = this.createPreferencePage(pnlTest);
        this.tabPageSetup.setControl((Control)pnlTest);
        this.tabPageSetup.setText(PAGE_SETUP_TAB_TITLE);
        this.tabPageSetup.setToolTipText(PAGE_SETUP_TAB_TOOLTIP);
        this.initModifiableSummaryValuesOnSummaryPanel();
        this.updateValuesOnSummaryPanel();
        this.addListeners();
        composite.pack();
        this.tabSummary.getControl().pack();
        this.tabPageSetup.getControl().pack();
        return composite;
    }

    private Composite createSummaryPanel(Composite theParent) {
        1 pnlOuter = new /* Unavailable Anonymous Inner Class!! */;
        GridLayout layOuter = new GridLayout();
        pnlOuter.setLayout((Layout)layOuter);
        GridData gdOuter = new GridData(1808);
        pnlOuter.setLayoutData((Object)gdOuter);
        Group grpDiagram = new Group((Composite)pnlOuter, 0);
        grpDiagram.setText(DIAGRAM_TITLE);
        GridData gdDiagram = new GridData(768);
        grpDiagram.setLayoutData((Object)gdDiagram);
        GridLayout layDiagram = new GridLayout();
        grpDiagram.setLayout((Layout)layDiagram);
        layDiagram.numColumns = 2;
        Label lblTemp = WidgetFactory.createLabel((Composite)grpDiagram, (String)PROJECT_NAME);
        lblTemp.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.lblProjectName = WidgetFactory.createLabel((Composite)grpDiagram);
        this.lblProjectName.setLayoutData((Object)this.createDefaultDataLabelGridData());
        lblTemp = WidgetFactory.createLabel((Composite)grpDiagram, (String)MODEL_NAME);
        lblTemp.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.lblModelName = WidgetFactory.createLabel((Composite)grpDiagram);
        this.lblModelName.setLayoutData((Object)this.createDefaultDataLabelGridData());
        lblTemp = WidgetFactory.createLabel((Composite)grpDiagram, (String)DIAGRAM_TYPE);
        lblTemp.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.lblDiagramType = WidgetFactory.createLabel((Composite)grpDiagram);
        this.lblDiagramType.setLayoutData((Object)this.createDefaultDataLabelGridData());
        Group grpPageSetup = new Group((Composite)pnlOuter, 0);
        grpPageSetup.setText(PAGE_SETUP_TITLE);
        GridData gdPageSetup = new GridData(768);
        grpPageSetup.setLayoutData((Object)gdPageSetup);
        GridLayout layPageSetup = new GridLayout();
        grpPageSetup.setLayout((Layout)layPageSetup);
        layPageSetup.numColumns = 2;
        lblTemp = WidgetFactory.createLabel((Composite)grpPageSetup, (String)ORIENTATION);
        GridData gdTemp = new GridData(0x1000008, 0x1000000, false, false);
        lblTemp.setLayoutData((Object)gdTemp);
        this.lblOrientation = WidgetFactory.createLabel((Composite)grpPageSetup, (String)LABEL_INIT_STRING);
        this.lblOrientation.setLayoutData((Object)this.createDefaultDataLabelGridData());
        lblTemp = WidgetFactory.createLabel((Composite)grpPageSetup, (String)SCALING);
        gdTemp = new GridData(0x1000008, 0x1000000, false, false);
        lblTemp.setLayoutData((Object)gdTemp);
        this.lblScaling = WidgetFactory.createLabel((Composite)grpPageSetup, (String)LABEL_INIT_STRING);
        this.lblScaling.setLayoutData((Object)this.createDefaultDataLabelGridData());
        lblTemp = WidgetFactory.createLabel((Composite)grpPageSetup, (String)MARGINS);
        gdTemp = new GridData(0x1000008, 0x1000000, false, false);
        lblTemp.setLayoutData((Object)gdTemp);
        this.lblMargins = WidgetFactory.createLabel((Composite)grpPageSetup, (String)LABEL_INIT_STRING);
        this.lblMargins.setLayoutData((Object)this.createDefaultDataLabelGridData());
        lblTemp = WidgetFactory.createLabel((Composite)grpPageSetup, (String)PAGE_ORDER);
        gdTemp = new GridData(0x1000008, 0x1000000, false, false);
        lblTemp.setLayoutData((Object)gdTemp);
        this.lblPageOrder = WidgetFactory.createLabel((Composite)grpPageSetup, (String)LABEL_INIT_STRING);
        this.lblPageOrder.setLayoutData((Object)this.createDefaultDataLabelGridData());
        Group grpPageRange = new Group((Composite)pnlOuter, 0);
        grpPageRange.setText(PAGE_RANGE_TITLE);
        GridData gdPageRange = new GridData(768);
        grpPageRange.setLayoutData((Object)gdPageRange);
        GridLayout layPageRange = new GridLayout();
        grpPageRange.setLayout((Layout)layPageRange);
        layPageRange.numColumns = 4;
        this.radioAllPages = WidgetFactory.createRadioButton((Composite)grpPageRange, (String)ALL_PAGES);
        GridData gdRadioAllPages = new GridData(768);
        gdRadioAllPages.horizontalSpan = 4;
        this.radioAllPages.setLayoutData((Object)gdRadioAllPages);
        this.radioPagesInRange = WidgetFactory.createRadioButton((Composite)grpPageRange, (String)RANGE_FROM);
        int iPossiblePageCount = this.getTotalPossiblePageCount();
        this.spinRangeFrom = new Spinner((Composite)grpPageRange, (List)this.getPageSelectPossibleValues(1, iPossiblePageCount));
        this.spinRangeFrom.setWrap(false);
        WidgetFactory.createLabel((Composite)grpPageRange, (String)RANGE_TO);
        this.spinRangeTo = new Spinner((Composite)grpPageRange, (List)this.getPageSelectPossibleValues(1, iPossiblePageCount));
        this.spinRangeTo.setWrap(false);
        Group grpTotalPages = new Group((Composite)pnlOuter, 0);
        grpTotalPages.setText(TOTAL_PAGES_TITLE);
        GridData gdTotalPages = new GridData(768);
        grpTotalPages.setLayoutData((Object)gdTotalPages);
        GridLayout layTotalPages = new GridLayout();
        grpTotalPages.setLayout((Layout)layTotalPages);
        layTotalPages.numColumns = 2;
        lblTemp = WidgetFactory.createLabel((Composite)grpTotalPages, (String)PAGES_TO_PRINT);
        lblTemp.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.lblTotalPages = WidgetFactory.createLabel((Composite)grpTotalPages, (String)LABEL_INIT_STRING);
        this.lblTotalPages.setLayoutData((Object)this.createDefaultDataLabelGridData());
        return pnlOuter;
    }

    private void addListeners() {
        this.tabListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramPrintSummaryDialog.this.tabSelected();
            }
        };
        this.tabFolder.addSelectionListener((SelectionListener)this.tabListener);
        this.radioAllPages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DiagramPrintSummaryDialog.this.lblTotalPages.setText(String.valueOf(DiagramPrintSummaryDialog.this.getTotalActualPageCount()));
                DiagramPrintSummaryDialog.this.spinRangeFrom.setEnabled(DiagramPrintSummaryDialog.this.radioPagesInRange.getSelection());
                DiagramPrintSummaryDialog.this.spinRangeTo.setEnabled(DiagramPrintSummaryDialog.this.radioPagesInRange.getSelection());
                DiagramPrintSummaryDialog.this.applyModifiableSummaryValuesTo();
            }
        });
        this.radioPagesInRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                DiagramPrintSummaryDialog.this.spinRangeFrom.setEnabled(DiagramPrintSummaryDialog.this.radioPagesInRange.getSelection());
                DiagramPrintSummaryDialog.this.spinRangeTo.setEnabled(DiagramPrintSummaryDialog.this.radioPagesInRange.getSelection());
                DiagramPrintSummaryDialog.this.applyModifiableSummaryValuesTo();
                DiagramPrintSummaryDialog.this.lblTotalPages.setText(String.valueOf(DiagramPrintSummaryDialog.this.getTotalActualPageCount()));
            }
        });
        this.spinRangeTo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DiagramPrintSummaryDialog.this.applyModifiableSummaryValuesTo();
                DiagramPrintSummaryDialog.this.lblTotalPages.setText(String.valueOf(DiagramPrintSummaryDialog.this.getTotalActualPageCount()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.spinRangeFrom.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int iCurrentToValue = DiagramPrintSummaryDialog.this.getToPage();
                ArrayList arylVals = DiagramPrintSummaryDialog.this.getPageSelectPossibleValues(DiagramPrintSummaryDialog.this.getFromPage(), DiagramPrintSummaryDialog.this.getTotalPossiblePageCount());
                if (arylVals != null && arylVals.size() > 0) {
                    DiagramPrintSummaryDialog.this.spinRangeTo.setPossibleValues((List)arylVals);
                    int iToLower = (Integer)DiagramPrintSummaryDialog.this.spinRangeTo.getLowerBound();
                    int iToUpper = (Integer)DiagramPrintSummaryDialog.this.spinRangeTo.getUpperBound();
                    if (iCurrentToValue >= iToLower && iCurrentToValue <= iToUpper) {
                        DiagramPrintSummaryDialog.this.spinRangeTo.setValue((Object)new Integer(iCurrentToValue));
                    } else {
                        DiagramPrintSummaryDialog.this.spinRangeTo.setValue((Object)new Integer(iToLower));
                    }
                }
                DiagramPrintSummaryDialog.this.applyModifiableSummaryValuesTo();
                DiagramPrintSummaryDialog.this.lblTotalPages.setText(String.valueOf(DiagramPrintSummaryDialog.this.getTotalActualPageCount()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void applyModifiableSummaryValuesTo() {
        if (this.radioAllPages.getSelection()) {
            this.psSettings.setSetting("scope", (Object)new Integer(0));
        }
        if (this.radioPagesInRange.getSelection()) {
            this.psSettings.setSetting("scope", (Object)new Integer(1));
            Integer IFrom = (Integer)this.spinRangeFrom.getValue();
            this.psSettings.setSetting("startPage", (Object)IFrom);
            Integer ITo = (Integer)this.spinRangeTo.getValue();
            this.psSettings.setSetting("endPage", (Object)ITo);
        }
    }

    private void tabSelected() {
        TabItem[] tab = this.tabFolder.getSelection();
        if (tab[0] == this.tabSummary) {
            if (this.preferencePage != null) {
                this.preferencePage.performOk();
            }
            this.analyzer.reAnalyze();
            int iPossiblePageCount = this.getTotalPossiblePageCount();
            this.psSettings.setSetting("startPage", (Object)new Integer(1));
            this.psSettings.setSetting("endPage", (Object)new Integer(iPossiblePageCount));
            this.updateValuesOnSummaryPanel();
            this.spinRangeFrom.setValue((Object)new Integer(1));
            this.spinRangeTo.setValue((Object)new Integer(iPossiblePageCount));
            this.applyModifiableSummaryValuesTo();
            this.lblTotalPages.setText(String.valueOf(iPossiblePageCount));
        }
    }

    private GridData createDefaultDataLabelGridData() {
        GridData gdTemp = new GridData(1, 0x1000000, true, false);
        gdTemp.widthHint = 235;
        return gdTemp;
    }

    private ArrayList getPageSelectPossibleValues(int iMin, int iMax) {
        ArrayList<Integer> arylPctPossibleValues = new ArrayList<Integer>();
        for (int i = iMin; i <= iMax; ++i) {
            arylPctPossibleValues.add(new Integer(i));
        }
        return arylPctPossibleValues;
    }

    private int getTotalActualPageCount() {
        int iTotalPages = 0;
        if (this.radioAllPages.getSelection()) {
            iTotalPages = this.getTotalPossiblePageCount();
        } else {
            int iFromPage = (Integer)this.spinRangeFrom.getValue();
            int iToPage = (Integer)this.spinRangeTo.getValue();
            iTotalPages = 1 + iToPage - iFromPage;
        }
        return iTotalPages;
    }

    private int getTotalPossiblePageCount() {
        return this.analyzer.getNumberOfPages();
    }

    private int getFromPage() {
        Integer IValue = (Integer)this.spinRangeFrom.getValue();
        return IValue;
    }

    private int getToPage() {
        Integer IValue = (Integer)this.spinRangeTo.getValue();
        return IValue;
    }

    private Control createPreferencePage(Composite parent) {
        Composite pnlOuter = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(290, 250);
            }
        };
        GridLayout layOuter = new GridLayout();
        layOuter.numColumns = 1;
        pnlOuter.setLayout((Layout)layOuter);
        GridData gdOuter = new GridData(1808);
        pnlOuter.setLayoutData((Object)gdOuter);
        this.preferencePage = new DiagramPrintPreferencePage();
        this.preferencePage.createContents(pnlOuter);
        Composite pnlButtons = new Composite(pnlOuter, 0);
        GridData gdButtons = new GridData(768);
        pnlButtons.setLayoutData((Object)gdButtons);
        GridLayout layButtons = new GridLayout();
        layButtons.numColumns = 3;
        pnlButtons.setLayout((Layout)layButtons);
        this.btnApply = WidgetFactory.createButton((Composite)pnlButtons, (String)APPLY_BUTTON_TEXT);
        this.btnApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramPrintSummaryDialog.this.preferencePage.performOk();
            }
        });
        this.btnRestoreDefaults = WidgetFactory.createButton((Composite)pnlButtons, (String)RESTORE_DEFAULTS_BUTTON_TEXT);
        this.btnRestoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramPrintSummaryDialog.this.preferencePage.performDefaults();
            }
        });
        return pnlOuter;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOk = this.createButton(parent, 10991, IDialogConstants.OK_LABEL, true);
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramPrintSummaryDialog.this.preferencePage.performOk();
                DiagramPrintSummaryDialog.this.okPressed();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    private void updateValuesOnSummaryPanel() {
        DiagramEditor editor = this.getActiveDiagramEditor();
        if (editor != null) {
            String sProject = editor.getCurrentModelResource().getModelProject().getPath().toString();
            this.lblProjectName.setText(sProject);
            this.lblModelName.setText(editor.getCurrentModelResource().getItemName());
            this.lblDiagramType.setText(editor.getCurrentModel().getDisplayString());
        } else {
            this.lblProjectName.setText("...");
            this.lblModelName.setText("...");
            this.lblDiagramType.setText("...");
        }
        Boolean BTemp = (Boolean)this.psSettings.getSetting("portrait");
        if (BTemp.booleanValue()) {
            this.lblOrientation.setText(PORTRAIT);
        }
        if ((BTemp = (Boolean)this.psSettings.getSetting("landscape")).booleanValue()) {
            this.lblOrientation.setText(LANDSCAPE);
        }
        if ((BTemp = (Boolean)this.psSettings.getSetting("fitToOnePage")).booleanValue()) {
            this.lblScaling.setText(FIT_TO_ONE_PAGE);
        }
        if ((BTemp = (Boolean)this.psSettings.getSetting("fitToOnePageHigh")).booleanValue()) {
            this.lblScaling.setText(FIT_TO_ONE_PAGE_HIGH);
        }
        if ((BTemp = (Boolean)this.psSettings.getSetting("fitToOnePageWide")).booleanValue()) {
            this.lblScaling.setText(FIT_TO_ONE_PAGE_WIDE);
        }
        if ((BTemp = (Boolean)this.psSettings.getSetting("adjustToPercent")).booleanValue()) {
            this.lblScaling.setText(ADJUST_TO + " " + this.getScalingPercentage() + PERCENT_NORMAL_SIZE);
        }
        Double DTop = (Double)this.psSettings.getSetting("top");
        Double DRight = (Double)this.psSettings.getSetting("right");
        Double DBottom = (Double)this.psSettings.getSetting("bottom");
        Double DLeft = (Double)this.psSettings.getSetting("left");
        String sMarginPhrase = TOP + ": " + DTop.toString();
        sMarginPhrase = sMarginPhrase + " | " + RIGHT + ": " + DRight.toString();
        sMarginPhrase = sMarginPhrase + " | " + BOTTOM + ": " + DBottom.toString();
        sMarginPhrase = sMarginPhrase + " | " + LEFT + ": " + DLeft.toString();
        this.lblMargins.setText(sMarginPhrase);
        BTemp = (Boolean)this.psSettings.getSetting("overThenDown");
        if (BTemp.booleanValue()) {
            this.lblPageOrder.setText(OVER_THEN_DOWN);
        }
        if ((BTemp = (Boolean)this.psSettings.getSetting("downThenOver")).booleanValue()) {
            this.lblPageOrder.setText(DOWN_THEN_OVER);
        }
        int iPossiblePageCount = this.getTotalPossiblePageCount();
        Integer IScope = (Integer)this.psSettings.getSetting("scope");
        if (IScope == 0) {
            this.radioAllPages.setSelection(true);
            this.radioPagesInRange.setSelection(false);
            this.spinRangeFrom.setPossibleValues((List)this.getPageSelectPossibleValues(1, iPossiblePageCount));
            this.spinRangeFrom.setValue((Object)new Integer(1));
            this.spinRangeTo.setPossibleValues((List)this.getPageSelectPossibleValues(this.getFromPage(), iPossiblePageCount));
            this.spinRangeTo.setValue((Object)new Integer(iPossiblePageCount));
            this.spinRangeFrom.setEnabled(this.radioPagesInRange.getSelection());
            this.spinRangeTo.setEnabled(this.radioPagesInRange.getSelection());
        }
        if (IScope == 1) {
            this.radioAllPages.setSelection(false);
            this.radioPagesInRange.setSelection(true);
            this.spinRangeFrom.setPossibleValues((List)this.getPageSelectPossibleValues(1, iPossiblePageCount));
            if (this.psSettings.getSetting("startPage") != null && (Integer)this.psSettings.getSetting("startPage") > -1) {
                this.spinRangeFrom.setValue(this.psSettings.getSetting("startPage"));
            } else {
                this.spinRangeFrom.setValue((Object)new Integer(1));
            }
            this.spinRangeTo.setPossibleValues((List)this.getPageSelectPossibleValues(1, iPossiblePageCount));
            if (this.psSettings.getSetting("endPage") != null && (Integer)this.psSettings.getSetting("endPage") > -1) {
                this.spinRangeTo.setValue(this.psSettings.getSetting("endPage"));
            } else {
                this.spinRangeTo.setValue((Object)new Integer(1));
            }
            this.spinRangeFrom.setEnabled(this.radioPagesInRange.getSelection());
            this.spinRangeTo.setEnabled(this.radioPagesInRange.getSelection());
        }
        this.lblTotalPages.setText(String.valueOf(this.getTotalActualPageCount()));
    }

    private String getScalingPercentage() {
        Integer IScalingPercent = (Integer)this.psSettings.getSetting("scalingPercentage");
        return IScalingPercent.toString();
    }

    private DiagramEditor getActiveDiagramEditor() {
        return DiagramEditorUtil.getVisibleDiagramEditor();
    }

    private void initModifiableSummaryValuesOnSummaryPanel() {
        int iPossiblePageCount = this.getTotalActualPageCount();
        Integer IScope = (Integer)this.psSettings.getSetting("scope");
        if (IScope == 0) {
            this.radioAllPages.setSelection(true);
            this.radioPagesInRange.setSelection(false);
            this.spinRangeFrom.setValue((Object)new Integer(1));
            this.spinRangeTo.setValue((Object)new Integer(iPossiblePageCount));
            Integer IFrom = (Integer)this.spinRangeFrom.getValue();
            this.psSettings.setSetting("startPage", (Object)IFrom);
            Integer ITo = (Integer)this.spinRangeTo.getValue();
            this.psSettings.setSetting("endPage", (Object)ITo);
            this.lblTotalPages.setText(String.valueOf(this.getTotalActualPageCount()));
        }
        if (IScope == 1) {
            this.radioAllPages.setSelection(false);
            this.radioPagesInRange.setSelection(true);
            this.spinRangeFrom.setValue(this.psSettings.getSetting("startPage"));
            this.spinRangeTo.setValue(this.psSettings.getSetting("endPage"));
        }
    }
}

