/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.refactor.ModelResourceCollectorVisitor;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.transformation.util.SqlConstants;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlTransformationStatusChangeEvent;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.sql.lang.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.MappingHelper;

public class SqlMappingRootCache
implements SqlConstants {
    public static int EITHER_STATUS = 0;
    public static int USER_STATUS = 1;
    private static HashMap selectSqlCache = new HashMap();
    private static HashMap insertSqlCache = new HashMap();
    private static HashMap updateSqlCache = new HashMap();
    private static HashMap deleteSqlCache = new HashMap();
    private static List eventListeners;
    private static final SqlMappingRootCache INSTANCE;

    public static SqlMappingRootCache getInstance() {
        return INSTANCE;
    }

    public static void invalidateCache() {
        SqlMappingRootCache.getCache(0).clear();
        SqlMappingRootCache.getCache(1).clear();
        SqlMappingRootCache.getCache(2).clear();
        SqlMappingRootCache.getCache(3).clear();
    }

    public static void invalidateSelectStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateSelectStatus(transMappingRoot, notifyListeners, source, false);
    }

    public static void invalidateSelectStatus(Object transMappingRoot, boolean notifyListeners, Object source, boolean overwriteDirty) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 0, notifyListeners, source, overwriteDirty);
    }

    public static void invalidateInsertStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 1, notifyListeners, source, false);
    }

    public static void invalidateUpdateStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 2, notifyListeners, source, false);
    }

    public static void invalidateDeleteStatus(Object transMappingRoot, boolean notifyListeners, Object source) {
        SqlMappingRootCache.invalidateStatus(transMappingRoot, 3, notifyListeners, source, false);
    }

    public static void invalidateRootsWithSourceGroups(Set sourceGroups) {
        HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
        Iterator selectIter = currentSelectSqlCache.keySet().iterator();
        while (selectIter.hasNext()) {
            EObject selectRoot = (EObject)selectIter.next();
            boolean invalidateRoot = false;
            Iterator grpIter = sourceGroups.iterator();
            while (grpIter.hasNext()) {
                SqlTransformationResult deleteStatus;
                SqlTransformationResult updateStatus;
                SqlTransformationResult insertStatus;
                Object sourceGroup = grpIter.next();
                if (TransformationHelper.isSqlProcedureResultSet(sourceGroup)) {
                    sourceGroup = TransformationHelper.getSqlProcedureForResultSet(sourceGroup);
                }
                if (!SqlMappingRootCache.containsStatus(selectRoot, 0)) continue;
                SqlTransformationResult selectStatus = SqlMappingRootCache.getStatus(selectRoot, 0, EITHER_STATUS, false);
                if (selectStatus != null && selectStatus.hasSourceGroup(sourceGroup)) {
                    invalidateRoot = true;
                    break;
                }
                if (SqlMappingRootCache.containsStatus(selectRoot, 1) && (insertStatus = SqlMappingRootCache.getStatus(selectRoot, 1, EITHER_STATUS, false)) != null && insertStatus.hasSourceGroup(sourceGroup)) {
                    invalidateRoot = true;
                    break;
                }
                if (SqlMappingRootCache.containsStatus(selectRoot, 2) && (updateStatus = SqlMappingRootCache.getStatus(selectRoot, 2, EITHER_STATUS, false)) != null && updateStatus.hasSourceGroup(sourceGroup)) {
                    invalidateRoot = true;
                    break;
                }
                if (!SqlMappingRootCache.containsStatus(selectRoot, 3) || (deleteStatus = SqlMappingRootCache.getStatus(selectRoot, 3, EITHER_STATUS, false)) == null || !deleteStatus.hasSourceGroup(sourceGroup)) continue;
                invalidateRoot = true;
                break;
            }
            if (!invalidateRoot) continue;
            SqlMappingRootCache.invalidateSelectStatus(selectRoot, true, null);
        }
    }

    public static void invalidateRootsWithTargetGroups(Set groups) {
        HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
        Iterator selectIter = currentSelectSqlCache.keySet().iterator();
        while (selectIter.hasNext()) {
            EObject mappingRoot = (EObject)selectIter.next();
            if (!SqlMappingRootCache.containsStatus(mappingRoot, 0)) continue;
            EObject targetGrp = TransformationHelper.getTransformationLinkTarget(mappingRoot);
            if (groups == null || !groups.contains(targetGrp)) continue;
            SqlMappingRootCache.invalidateSelectStatus(mappingRoot, true, null);
        }
    }

    public static void invalidateCacheForProject(IProject proj) {
        if (proj != null && proj.isOpen()) {
            ArrayList modelResources = new ArrayList();
            ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
            try {
                proj.getProject().accept((IResourceVisitor)visitor);
                modelResources.addAll(visitor.getModelResources());
            }
            catch (CoreException e) {
                return;
            }
            HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
            Iterator selectIter = currentSelectSqlCache.keySet().iterator();
            while (selectIter.hasNext()) {
                EObject mappingRoot = (EObject)selectIter.next();
                ModelResource mdlRsrc = ModelerCore.getModelEditor().findModelResource(mappingRoot);
                if (mdlRsrc == null || !mdlRsrc.exists() || !modelResources.contains(mdlRsrc)) continue;
                SqlMappingRootCache.invalidateSelectStatus(mappingRoot, true, null);
            }
        }
    }

    public static void invalidateRootsOnProjectOrModelRemove() {
        HashMap currentSelectSqlCache = new HashMap(SqlMappingRootCache.getCache(0));
        Iterator selectIter = currentSelectSqlCache.keySet().iterator();
        while (selectIter.hasNext()) {
            EObject selectRoot = (EObject)selectIter.next();
            EObject realEObj = null;
            if (selectRoot != null && selectRoot.eResource() != null) {
                realEObj = selectRoot;
            }
            ModelResource mdlRsrc = null;
            boolean invalidateRoot = false;
            if (realEObj == null) {
                invalidateRoot = true;
            } else {
                mdlRsrc = ModelerCore.getModelEditor().findModelResource(selectRoot);
                if (mdlRsrc == null || !mdlRsrc.exists()) {
                    invalidateRoot = true;
                } else if (SqlMappingRootCache.containsStatus(selectRoot, 0)) {
                    SqlTransformationResult selectStatus = SqlMappingRootCache.getStatus(selectRoot, 0, EITHER_STATUS, false);
                    if (selectStatus != null && (SqlMappingRootCache.areAnySourceGroupsProxies(selectStatus) || !selectStatus.areSrcGroupMdlResourcesValid())) {
                        invalidateRoot = true;
                    } else {
                        SqlTransformationResult deleteStatus;
                        SqlTransformationResult updateStatus;
                        SqlTransformationResult insertStatus;
                        if (SqlMappingRootCache.containsStatus(selectRoot, 1) && (insertStatus = SqlMappingRootCache.getStatus(selectRoot, 1, EITHER_STATUS, false)) != null && !insertStatus.areSrcGroupMdlResourcesValid()) {
                            invalidateRoot = true;
                        }
                        if (!invalidateRoot && SqlMappingRootCache.containsStatus(selectRoot, 2) && (updateStatus = SqlMappingRootCache.getStatus(selectRoot, 2, EITHER_STATUS, false)) != null && !updateStatus.areSrcGroupMdlResourcesValid()) {
                            invalidateRoot = true;
                        }
                        if (!invalidateRoot && SqlMappingRootCache.containsStatus(selectRoot, 3) && (deleteStatus = SqlMappingRootCache.getStatus(selectRoot, 3, EITHER_STATUS, false)) != null && !deleteStatus.areSrcGroupMdlResourcesValid()) {
                            invalidateRoot = true;
                        }
                    }
                }
            }
            if (!invalidateRoot) continue;
            SqlMappingRootCache.invalidateSelectStatus(selectRoot, true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areAnySourceGroupsProxies(SqlTransformationResult status) {
        Object[] srcGroups = null;
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"SqlMappingRootCache_ProxyCheck", (Object)status);
        boolean succeeded = false;
        try {
            srcGroups = status.getSourceGroups().toArray();
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        for (int i = 0; i < srcGroups.length; ++i) {
            EObject eoj = (EObject)srcGroups[i];
            if (!eoj.eIsProxy()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelectParsable(Object transMappingRoot) {
        return SqlMappingRootCache.isParsable(transMappingRoot, 0);
    }

    public static boolean isSelectResolvable(Object transMappingRoot) {
        return SqlMappingRootCache.isResolvable(transMappingRoot, 0);
    }

    public static boolean isSelectValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 0);
    }

    public static boolean isInsertValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 1);
    }

    public static boolean isUpdateValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 2);
    }

    public static boolean isDeleteValid(Object transMappingRoot) {
        return SqlMappingRootCache.isValid(transMappingRoot, 3);
    }

    public static Command getSelectCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 0);
    }

    public static Command getInsertCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 1);
    }

    public static Command getUpdateCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 2);
    }

    public static Command getDeleteCommand(Object transMappingRoot) {
        return SqlMappingRootCache.getCommand(transMappingRoot, 3);
    }

    public static String getSelectSql(EObject transMappingRoot) {
        return SqlMappingRootCache.getSqlString(transMappingRoot, 0);
    }

    public static boolean isSqlDifferent(Object transMappingRoot, int cmdType, String userSql, String uuidSql) {
        boolean isDifferent = true;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && SqlMappingRootCache.containsStatus((EObject)transMappingRoot, cmdType)) {
            HashMap cache = SqlMappingRootCache.getCache(cmdType);
            SqlTransformationResult status = (SqlTransformationResult)cache.get(transMappingRoot);
            String cachedSql = status.getSqlString();
            isDifferent = status.isUUIDStatus() ? SqlMappingRootCache.stringsDifferent(uuidSql, cachedSql) : SqlMappingRootCache.stringsDifferent(userSql, cachedSql);
        }
        return isDifferent;
    }

    private static boolean stringsDifferent(String newSql, String oldSql) {
        boolean isDifferent = true;
        if (newSql == null) {
            if (oldSql == null) {
                isDifferent = false;
            }
        } else if (oldSql != null) {
            StringBuffer newSb = new StringBuffer(newSql.trim());
            StringBuffer oldSb = new StringBuffer(oldSql.trim());
            StringUtil.replaceAll((StringBuffer)newSb, (String)"\n", (String)"");
            StringUtil.replaceAll((StringBuffer)newSb, (String)"\t", (String)"");
            StringUtil.replaceAll((StringBuffer)newSb, (String)"  ", (String)" ");
            StringUtil.replaceAll((StringBuffer)oldSb, (String)"\n", (String)"");
            StringUtil.replaceAll((StringBuffer)oldSb, (String)"\t", (String)"");
            StringUtil.replaceAll((StringBuffer)oldSb, (String)"  ", (String)" ");
            if (newSb.toString().equals(oldSb.toString())) {
                isDifferent = false;
            }
        }
        return isDifferent;
    }

    private static synchronized void invalidateStatus(Object transMappingRoot, int cmdType, boolean notifyListeners, Object source, boolean overwriteDirty) {
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            if (SqlMappingRootCache.containsStatus((EObject)transMappingRoot, cmdType)) {
                SqlMappingRootCache.removeStatus((EObject)transMappingRoot, cmdType);
                if (cmdType == 0) {
                    SqlMappingRootCache.removeStatus((EObject)transMappingRoot, 1);
                    SqlMappingRootCache.removeStatus((EObject)transMappingRoot, 2);
                    SqlMappingRootCache.removeStatus((EObject)transMappingRoot, 3);
                }
                if (source == null) {
                    source = SqlMappingRootCache.getInstance();
                }
            }
            if (notifyListeners) {
                SqlMappingRootCache.notifyEventListeners((EventObject)new SqlTransformationStatusChangeEvent((EObject)transMappingRoot, source, overwriteDirty));
            }
        }
    }

    public static boolean isParsable(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isParsable = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            isParsable = status.isParsable();
        }
        return isParsable;
    }

    public static boolean isResolvable(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isResolvable = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            isResolvable = status.isResolvable();
        }
        return isResolvable;
    }

    public static boolean isValid(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isValid = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            isValid = status.isValidatable();
        }
        return isValid;
    }

    public static boolean hasSourceGroup(Object transMappingRoot, Object sourceGroup, int cmdType) {
        Collection sourceGroups;
        SqlTransformationResult status;
        boolean hasSourceGroup = false;
        if (transMappingRoot != null && sourceGroup != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && TransformationHelper.isSqlTable(sourceGroup) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null && (sourceGroups = status.getSourceGroups()).contains(sourceGroup)) {
            hasSourceGroup = true;
        }
        return hasSourceGroup;
    }

    public static boolean isTargetValid(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        boolean isTargetValid = false;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            isTargetValid = status.isTargetValid();
        }
        return isTargetValid;
    }

    public static IStatus getTargetValidStatus(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        IStatus targetValidStatus = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            targetValidStatus = status.getTargetValidStatus();
        }
        return targetValidStatus;
    }

    public static SqlTransformationResult getSqlTransformationStatus(SqlTransformationMappingRoot transMappingRoot, int cmdType, int statusType, boolean restrictSearch, ValidationContext context) {
        ArgCheck.isNotNull((Object)transMappingRoot);
        return SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, statusType, restrictSearch, context);
    }

    public static Command getCommand(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        Command command = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            command = status.getCommand();
        }
        return command;
    }

    public static Map getExternalMetadataMap(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        Map map = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            map = status.getExternalMetadataMap();
        }
        return map;
    }

    public static Map getExternalMapForCreateUpdateProc(Object transMappingRoot, int cmdType) {
        Command command;
        SqlTransformationResult status;
        Map map = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null && (command = status.getCommand()) != null && command.getType() == 7) {
            map = status.getExternalMetadataMap();
        }
        return map;
    }

    public static String getSqlString(Object transMappingRoot, int cmdType) {
        SqlTransformationResult status;
        String sqlString = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot) && (status = SqlMappingRootCache.getStatus((EObject)transMappingRoot, cmdType, USER_STATUS, false)) != null) {
            sqlString = status.getSqlString();
        }
        return sqlString;
    }

    public static boolean containsStatus(EObject transMappingRoot, int cmdType) {
        HashMap cache = SqlMappingRootCache.getCache(cmdType);
        return cache.containsKey(transMappingRoot);
    }

    private static void removeStatus(EObject transMappingRoot, int cmdType) {
        HashMap cache = SqlMappingRootCache.getCache(cmdType);
        cache.remove(transMappingRoot);
    }

    private static SqlTransformationResult createStatus(EObject transMappingRoot, int cmdType, int statusType, boolean restrictSearch, ValidationContext context) {
        SqlTransformationResult status = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            TransformationValidator validator;
            String uuidSql = SqlMappingRootCache.getSqlUUIDString(transMappingRoot, cmdType);
            String userSql = null;
            TransformationValidator transformationValidator = validator = context != null ? new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, context, true, restrictSearch) : new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, true, restrictSearch);
            if (statusType == EITHER_STATUS) {
                if (uuidSql != null) {
                    status = (SqlTransformationResult)validator.validateSql(uuidSql, cmdType, true, false);
                    if (status != null && !status.isValidatable() && (userSql = SqlMappingRootCache.getConvertedSqlString(transMappingRoot, cmdType, statusType, restrictSearch, context)) != null) {
                        status = (SqlTransformationResult)validator.validateSql(userSql, cmdType, false, false);
                    }
                } else {
                    userSql = SqlMappingRootCache.getSqlUserString(transMappingRoot, cmdType);
                    if (userSql != null) {
                        status = (SqlTransformationResult)validator.validateSql(userSql, cmdType, false, false);
                    }
                }
            } else if (statusType == USER_STATUS && (userSql = SqlMappingRootCache.getConvertedSqlString(transMappingRoot, cmdType, statusType, restrictSearch, context)) != null) {
                status = (SqlTransformationResult)validator.validateSql(userSql, cmdType, false, false);
            }
        }
        return status;
    }

    public static void setStatus(EObject transMappingRoot, int cmdType, SqlTransformationResult status) {
        HashMap cache = SqlMappingRootCache.getCache(cmdType);
        if (status != null) {
            cache.put(transMappingRoot, status);
        } else {
            SqlMappingRootCache.removeStatus(transMappingRoot, cmdType);
        }
    }

    private static synchronized SqlTransformationResult getStatus(EObject transMappingRoot, int cmdType, int statusType, boolean restrictSearch) {
        return SqlMappingRootCache.getStatus(transMappingRoot, cmdType, statusType, restrictSearch, null);
    }

    private static synchronized SqlTransformationResult getStatus(EObject transMappingRoot, int cmdType, int statusType, boolean restrictSearch, ValidationContext context) {
        HashMap cache;
        SqlTransformationResult status;
        SqlTransformationResult statusResult = null;
        if (SqlMappingRootCache.containsStatus(transMappingRoot, cmdType) && (status = (SqlTransformationResult)(cache = SqlMappingRootCache.getCache(cmdType)).get(transMappingRoot)) != null && (statusType == EITHER_STATUS || statusType == USER_STATUS && !status.isUUIDStatus())) {
            statusResult = status;
        }
        if (statusResult == null) {
            statusResult = SqlMappingRootCache.createStatus(transMappingRoot, cmdType, statusType, restrictSearch, context);
            if (context == null || context.cacheMappingRootResults()) {
                SqlMappingRootCache.setStatus(transMappingRoot, cmdType, statusResult);
            }
        }
        return statusResult;
    }

    private static HashMap getCache(int cmdType) {
        switch (cmdType) {
            case 0: {
                return selectSqlCache;
            }
            case 1: {
                return insertSqlCache;
            }
            case 2: {
                return updateSqlCache;
            }
            case 3: {
                return deleteSqlCache;
            }
        }
        return null;
    }

    private static String getConvertedSqlString(Object transMappingRoot, int cmdType, int statusType, boolean restrictSearch, ValidationContext context) {
        String result = null;
        String sqlUUIDString = SqlMappingRootCache.getSqlUUIDString(transMappingRoot, cmdType);
        if (!StringUtil.isEmpty((String)sqlUUIDString)) {
            boolean fullyConverted;
            String sqlStatementConverted = SqlConverter.convertToString((String)sqlUUIDString, (EObject)((EObject)transMappingRoot), (int)cmdType, (boolean)restrictSearch, (ValidationContext)context);
            boolean bl = fullyConverted = sqlStatementConverted.indexOf("mmuuid:") == -1;
            if (fullyConverted) {
                result = sqlStatementConverted;
            }
        }
        if (result == null && statusType == USER_STATUS) {
            result = SqlMappingRootCache.getSqlUserString(transMappingRoot, cmdType);
        }
        return result;
    }

    private static String getSqlUUIDString(Object transMappingRoot, int cmdType) {
        switch (cmdType) {
            case 0: {
                return SqlMappingRootCache.getSelectSqlUUIDString(transMappingRoot);
            }
            case 1: {
                return SqlMappingRootCache.getInsertSqlUUIDString(transMappingRoot);
            }
            case 2: {
                return SqlMappingRootCache.getUpdateSqlUUIDString(transMappingRoot);
            }
            case 3: {
                return SqlMappingRootCache.getDeleteSqlUUIDString(transMappingRoot);
            }
        }
        return SqlMappingRootCache.getSelectSqlUUIDString(transMappingRoot);
    }

    private static String getSelectSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getSelectSql();
        }
        return result;
    }

    private static String getInsertSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getInsertSql();
        }
        return result;
    }

    private static String getUpdateSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getUpdateSql();
        }
        return result;
    }

    private static String getDeleteSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getDeleteSql();
        }
        return result;
    }

    private static String getSqlUserString(Object transMappingRoot, int cmdType) {
        switch (cmdType) {
            case 0: {
                return SqlMappingRootCache.getSelectSqlUserString(transMappingRoot);
            }
            case 1: {
                return SqlMappingRootCache.getInsertSqlUserString(transMappingRoot);
            }
            case 2: {
                return SqlMappingRootCache.getUpdateSqlUserString(transMappingRoot);
            }
            case 3: {
                return SqlMappingRootCache.getDeleteSqlUserString(transMappingRoot);
            }
        }
        return SqlMappingRootCache.getSelectSqlUserString(transMappingRoot);
    }

    private static String getSelectSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getSelectSql();
        }
        return result;
    }

    private static String getInsertSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getInsertSql();
        }
        return result;
    }

    private static String getUpdateSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getUpdateSql();
        }
        return result;
    }

    private static String getDeleteSqlUserString(Object transMappingRoot) {
        SqlTransformation userSqlTransformation = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (userSqlTransformation != null) {
            result = userSqlTransformation.getDeleteSql();
        }
        return result;
    }

    public static void addEventListener(EventObjectListener listener) {
        if (eventListeners == null) {
            eventListeners = new ArrayList();
        }
        if (!eventListeners.contains(listener)) {
            eventListeners.add(listener);
        }
    }

    public static void removeEventListener(EventObjectListener listener) {
        if (eventListeners != null) {
            eventListeners.remove(listener);
        }
    }

    private static void notifyEventListeners(EventObject event) {
        if (eventListeners != null) {
            Iterator iterator = eventListeners.iterator();
            while (iterator.hasNext()) {
                EventObjectListener listener = (EventObjectListener)iterator.next();
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }

    static {
        INSTANCE = new SqlMappingRootCache();
    }
}

