/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.validator;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.c.c;
import com.metamatrix.query.o.d;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.j.af;
import com.metamatrix.query.o.j.ag;
import com.metamatrix.query.o.j.g;
import com.metamatrix.query.o.j.i;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.x;
import java.util.Collection;
import java.util.Iterator;

public class ModelVisibilityValidationVisitor
extends c {
    private VDBService vdbService;
    private String vdbName;
    private String vdbVersion;

    public ModelVisibilityValidationVisitor(VDBService vdbService, String vdbName, String vdbVersion) {
        this.vdbService = vdbService;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
    }

    public void visit(i obj) {
        this.validateModelVisibility(obj);
    }

    public void visit(af obj) {
        this.validateModelVisibility(obj);
    }

    public void visit(ag obj) {
        this.validateModelVisibility((l)obj);
    }

    public void visit(g obj) {
        this.validateModelVisibility(obj);
    }

    public void visit(x obj) {
        this.validateModelVisibility(obj);
    }

    protected void validateModelVisibility(l obj) {
        Collection groups = com.metamatrix.query.o.h.d.ek((d)obj, true);
        try {
            Iterator groupIter = groups.iterator();
            while (groupIter.hasNext()) {
                f group = (f)groupIter.next();
                Object modelID = null;
                modelID = obj instanceof x ? ((x)obj).ia() : this.getMetadata().getModelID(group.aq());
                if (modelID instanceof com.metamatrix.query.m.d) {
                    return;
                }
                String modelName = this.getMetadata().getFullName(modelID);
                int visibility = this.vdbService.getModelVisibility(this.vdbName, this.vdbVersion, modelName);
                if (visibility == 0) continue;
                this.handleValidationError(DQPPlugin.Util.getString("ERR.018.005.0088", (Object)this.getMetadata().getFullName(group.aq())));
            }
        }
        catch (QueryMetadataException e2) {
            this.handleException((MetaMatrixException)((Object)e2), (d)obj);
        }
        catch (MetaMatrixComponentException e3) {
            this.handleException((MetaMatrixException)((Object)e3), (d)obj);
        }
    }
}

