/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.AssertionException;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.ImportsAspect;
import com.metamatrix.modeler.core.refactor.OrganizeImportHandler;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.search.ModelWorkspaceSearch;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDImport;

public class OrganizeImportCommandFinderHelper {
    private Resource resource;
    private Map refactoredPaths = new HashMap();
    static /* synthetic */ Class class$com$metamatrix$modeler$core$workspace$ModelResource;

    protected OrganizeImportCommandFinderHelper() {
    }

    protected void setRefactoredPaths(Map paths) {
        this.refactoredPaths = paths != null ? paths : new HashMap();
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
    }

    protected URI findModelUri(URI uri, Resource resource) {
        Assertion.isNotNull((Object)uri);
        String path = URI.decode((String)uri.toString());
        if (resource != null) {
            return this.getModelUri(resource, path);
        }
        return this.getModelUri(uri);
    }

    private URI getModelUri(Resource resource, String path) {
        String resourcePath = WorkspaceResourceFinderUtil.getWorkspaceUri(resource);
        if (resourcePath != null) {
            path = resourcePath;
        } else if (resource instanceof EmfResource) {
            try {
                ObjectID objectID = ((EmfResource)resource).getUuid();
                resourcePath = this.findResourcePathByUUID(objectID);
                if (resourcePath == null) {
                    return null;
                }
                path = resourcePath;
            }
            catch (Exception e2) {
                ModelerCore.Util.log((Throwable)e2);
            }
        }
        return URI.createURI((String)path);
    }

    protected String findResourcePathByUUID(ObjectID objectID) throws CoreException {
        String path = null;
        if (objectID != null) {
            Resource systemModels = ModelerCore.getModelContainer().getResourceFinder().findByUUID(objectID, false);
            path = WorkspaceResourceFinderUtil.getWorkspaceUri(systemModels);
        }
        return path;
    }

    private URI getModelUri(URI uri) {
        String path = null;
        IResource iResource = WorkspaceResourceFinderUtil.findIResource(uri);
        if (iResource != null) {
            path = iResource.getFullPath().toString();
        } else {
            iResource = this.findResourceInProjectByName(uri.lastSegment());
            if (iResource == null) {
                return null;
            }
            path = iResource.getFullPath().toString();
        }
        return URI.createURI((String)path);
    }

    protected IResource findResourceInProjectByName(String name) {
        if (name == null) {
            return null;
        }
        IResource iResource = null;
        IResource[] iResources = WorkspaceResourceFinderUtil.findIResourceByName(name);
        if (iResources.length == 0) {
            return null;
        }
        if (iResources.length == 1) {
            iResource = iResources[0];
        } else {
            IResource iRes = WorkspaceResourceFinderUtil.findIResource(this.resource.getURI());
            IProject project = iRes.getProject();
            for (int idx = 0; idx < iResources.length; ++idx) {
                if (iResources[idx].getProject() != project) continue;
                iResource = iResources[idx];
                break;
            }
            if (iResource == null) {
                iResource = iResources[0];
            }
        }
        return iResource;
    }

    protected Resource findResourceWithObject(Collection refs, List problems, OrganizeImportHandler handler) {
        ModelWorkspaceSearch search = new ModelWorkspaceSearch();
        ModelWorkspaceManager workspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
        LinkedList<ModelResource> modelReferences = new LinkedList<ModelResource>();
        HashSet<String> searchedFragments = new HashSet<String>();
        HashSet<ObjectID> searchedIDs = new HashSet<ObjectID>();
        if (refs.size() != 0) {
            Iterator iter = refs.iterator();
            while (iter.hasNext()) {
                IPath[] modelPaths;
                EObject reference = (EObject)iter.next();
                InternalEObject internalEObject = (InternalEObject)reference;
                URI proxyUri = internalEObject.eProxyURI();
                String fragment = proxyUri.fragment();
                if (fragment == null) continue;
                ObjectID id = null;
                try {
                    id = IDGenerator.getInstance().stringToObject(fragment);
                }
                catch (InvalidIDException e2) {
                    // empty catch block
                }
                if (id == null && searchedFragments.contains(fragment) || searchedIDs.contains(id)) continue;
                IPath[] iPathArray = modelPaths = id == null ? search.getResourcesContainingObjectId(fragment) : search.getResourcesContainingObjectId(id);
                if (modelPaths != null && modelPaths.length > 0) {
                    try {
                        for (int i2 = 0; i2 < modelPaths.length; ++i2) {
                            IPath resourcePath = modelPaths[i2];
                            ModelResource mResource = (ModelResource)workspaceManager.findModelWorkspaceItem(resourcePath, 1);
                            if (mResource == null || modelReferences.contains(mResource)) continue;
                            modelReferences.add(mResource);
                        }
                    }
                    catch (ModelWorkspaceException e1) {
                        int code = 1010;
                        Object[] params = new Object[]{modelPaths[0]};
                        String msg = ModelerCore.Util.getString("OrganizeImportCommand.Error_while_finding_resource_for_path_1", params);
                        problems.add(new Status(4, "com.metamatrix.modeler.core", 1010, msg, null));
                    }
                }
                if (id != null) {
                    searchedIDs.add(id);
                    continue;
                }
                searchedFragments.add(fragment);
            }
        }
        Resource result = null;
        if (!modelReferences.isEmpty()) {
            String msg;
            Object[] params;
            ModelResource mResource = null;
            if (modelReferences.size() == 1) {
                mResource = (ModelResource)modelReferences.get(0);
            } else {
                OrganizeImportHandler theHandler = handler;
                if (theHandler != null) {
                    Object choice = handler.choose(modelReferences);
                    if (choice instanceof ModelResource) {
                        mResource = (ModelResource)choice;
                    } else if (choice != null) {
                        params = new Object[]{choice.getClass().getName(), (class$com$metamatrix$modeler$core$workspace$ModelResource == null ? (class$com$metamatrix$modeler$core$workspace$ModelResource = OrganizeImportCommandFinderHelper.class$("com.metamatrix.modeler.core.workspace.ModelResource")) : class$com$metamatrix$modeler$core$workspace$ModelResource).getName()};
                        msg = ModelerCore.Util.getString("OrganizeImportCommand.Unexpected_choice", params);
                        throw new AssertionException(msg);
                    }
                }
            }
            if (mResource != null) {
                try {
                    result = mResource.getEmfResource();
                }
                catch (ModelWorkspaceException e1) {
                    int code = 1010;
                    params = new Object[]{mResource};
                    msg = ModelerCore.Util.getString("OrganizeImportCommand.error_getting_resource", params);
                    problems.add(new Status(4, "com.metamatrix.modeler.core", 1010, msg, null));
                }
            }
        }
        return result;
    }

    protected Resource findRefactoredResource(Resource eResource, URI externalResourceURI, IProgressMonitor monitor, List problems) {
        Container cntr;
        ResourceSet eResourceSet = eResource.getResourceSet();
        Resource externalResource = eResourceSet.getResource(externalResourceURI, false);
        if (externalResource == null && (cntr = ModelerCore.getContainer((Resource)eResource)) != null) {
            Resource[] eResources = cntr.getResourceFinder().findByName(externalResourceURI.lastSegment(), false, true);
            if (eResources.length == 0) {
                return null;
            }
            if (eResources.length == 1) {
                return eResources[0];
            }
            ArrayList<Resource> matches = new ArrayList<Resource>(eResources.length);
            String parentUriString = eResource.getURI().trimSegments(1).toString();
            for (int i2 = 0; i2 != eResources.length; ++i2) {
                Resource r2 = eResources[i2];
                String uriString = r2.getURI().trimSegments(1).toString();
                if (!parentUriString.startsWith(uriString) && !uriString.startsWith(parentUriString)) continue;
                matches.add(r2);
            }
            externalResource = matches.size() == 0 ? eResources[0] : (matches.size() == 1 ? (Resource)matches.get(0) : eResources[0]);
        }
        return externalResource;
    }

    protected IPath findFromRefactoredPaths(String uriPath) {
        if (this.refactoredPaths != null) {
            Set keys = this.refactoredPaths.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String oldPath = iter.next().toString();
                if (!uriPath.endsWith(oldPath)) continue;
                return new Path(oldPath);
            }
        }
        return new Path(uriPath);
    }

    protected IPath findPath(EObject eobject, ImportsAspect importsAspect) {
        IPath importPath = importsAspect.getModelPath(eobject);
        if (importPath == null) {
            return this.createPath(eobject);
        }
        return importPath;
    }

    private IPath createPath(EObject eobject) {
        if (eobject instanceof XSDImport) {
            String schemaLocation = ((XSDImport)eobject).getSchemaLocation();
            return this.getNewPathInfo(schemaLocation);
        }
        return null;
    }

    private IPath getNewPathInfo(String schemaLocation) {
        if (schemaLocation == null) {
            return null;
        }
        Path currentPath = new Path(schemaLocation);
        Iterator iter = this.refactoredPaths.keySet().iterator();
        while (iter.hasNext()) {
            String oldPath = iter.next().toString();
            Path oldPathRef = new Path(oldPath);
            if (!oldPathRef.lastSegment().equals(currentPath.lastSegment())) continue;
            String newPath = this.refactoredPaths.get(oldPath).toString();
            return new Path(newPath);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

