/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLVisitor;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class OperationSignature {
    private boolean isDocumentStyle = false;
    private boolean isCreated = false;
    private boolean isFault = false;
    protected List signature = new LinkedList();
    private Element firstBody = null;

    public OperationSignature(Document doc) {
        Element body = XMLUtils.findChildElement(doc.getDocumentElement(), WSITag.ELEM_SOAP_BODY);
        this.processParts(body, false);
        this.isDocumentStyle |= this.signature.size() > 1;
    }

    public OperationSignature(List parts, Document wsdlDocument, TypesRegistry registry, boolean partial) {
        if (parts != null) {
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                Part part = (Part)it.next();
                String localName = partial ? part.getName() : null;
                QName typeName = part.getTypeName();
                QName elementName = part.getElementName();
                String namespace = "";
                if (typeName != null) {
                    namespace = "";
                    if (localName == null) {
                        localName = typeName.getLocalPart();
                    }
                } else if (elementName != null) {
                    namespace = elementName.getNamespaceURI();
                    if (localName == null) {
                        localName = elementName.getLocalPart();
                    }
                }
                this.signature.add(new QName(namespace, localName));
            }
        }
        this.isCreated = true;
    }

    public void createRPCSignature() {
        this.isCreated = false;
        if (this.firstBody == null) {
            return;
        }
        this.processParts(this.firstBody, true);
        this.isDocumentStyle = false;
    }

    private void processParts(Node parent, boolean processWrapper) {
        if (parent != null) {
            Node n = parent.getFirstChild();
            boolean isFirst = true;
            while (n != null) {
                if (1 == n.getNodeType()) {
                    if (isFirst && this.firstBody == null) {
                        isFirst = false;
                        this.firstBody = (Element)n;
                        if (XMLUtils.equals(n, WSITag.ELEM_SOAP_FAULT)) {
                            this.isFault = true;
                            this.isCreated = false;
                            return;
                        }
                    }
                    String namespace = n.getNamespaceURI();
                    String localName = n.getLocalName();
                    if (!this.isDocumentStyle && processWrapper) {
                        namespace = "";
                    }
                    if ((namespace == null || namespace.length() == 0) && this.isDocumentStyle) {
                        Node it = n.getFirstChild();
                        while (it != null && !(it instanceof Element)) {
                            it = it.getNextSibling();
                        }
                        if (it != null) {
                            namespace = it.getNamespaceURI();
                        }
                    }
                    if (namespace != null && namespace.length() == 0) {
                        namespace = null;
                    }
                    this.signature.add(new QName(namespace, localName));
                }
                n = n.getNextSibling();
            }
        } else {
            this.isCreated = false;
            return;
        }
        this.isCreated = true;
    }

    public boolean isDocumentStyle() {
        return this.isDocumentStyle;
    }

    public boolean isFault() {
        return this.isFault;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public List getSignature() {
        return this.signature;
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof OperationSignature) {
            return this.signature.equals(((OperationSignature)o).getSignature());
        }
        return false;
    }

    public static OperationMatch matchOperation(Document inputMessage, String soapAction, Binding binding, TypesRegistry registry) {
        return OperationSignature.matchOperation(inputMessage, soapAction, binding, registry, true);
    }

    public static OperationMatch matchOperation(Document inputMessage, String soapAction, Binding binding, TypesRegistry registry, boolean soapActionRequired) {
        OperationSignature signature = new OperationSignature(inputMessage);
        if (!signature.isCreated()) {
            return null;
        }
        OperationSignature operationSignature = signature;
        operationSignature.getClass();
        Visitor resolver = operationSignature.new Visitor("document", registry);
        if (soapAction != null && soapAction.length() > 1 && soapAction.charAt(0) == '\"' && soapAction.charAt(soapAction.length() - 1) == '\"') {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        if (soapAction != null) {
            signature.getSignature().add(0, soapAction);
        }
        if (soapActionRequired) {
            resolver.setSOAPActionRequired();
        }
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(resolver);
        traversal.visitSOAPBinding(true);
        traversal.visitSOAPBody(true);
        traversal.visitSOAPOperation(true);
        traversal.ignoreReferences();
        traversal.ignoreBindingOutput();
        traversal.traverse(binding);
        BindingOperation operation = resolver.getMatchedOperation();
        if (operation == null && !signature.isDocumentStyle()) {
            resolver.setRequiredStyle("rpc");
            signature.createRPCSignature();
            traversal.traverse(binding);
            operation = resolver.getMatchedOperation();
            if (operation == null) {
                return null;
            }
        }
        return new OperationMatch(resolver.requiredStyle, signature.getSignature(), resolver.getMatchedOperation());
    }

    public static final class OperationMatch {
        private final String style;
        private final BindingOperation operation;
        private final List signature;

        protected OperationMatch(String style, List signature, BindingOperation operation) {
            this.style = style;
            this.signature = signature;
            this.operation = operation;
        }

        public String getOperationStyle() {
            return this.style;
        }

        public BindingOperation getOperation() {
            return this.operation;
        }

        public List getSignature() {
            return this.signature;
        }
    }

    public final class Visitor
    implements WSDLVisitor {
        private String requiredStyle = null;
        private String soapAction = null;
        private BindingOperation operation = null;
        private TypesRegistry registry = null;
        private boolean isSOAPActionRequired = false;

        public void visit(Part obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Service obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Types obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Operation obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Input obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Output obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Fault obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Binding obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(BindingOperation obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(BindingInput obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(BindingOutput obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(BindingFault obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Import obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Element obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Message obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Port obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(PortType obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(Definition obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(ExtensibilityElement obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(SOAPHeader obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(SOAPHeaderFault obj, Object parent, WSDLTraversalContext ctx) {
        }

        public void visit(SOAPFault obj, Object parent, WSDLTraversalContext ctx) {
        }

        public Visitor() {
        }

        public Visitor(String requiredStyle, TypesRegistry registry) {
            this.requiredStyle = requiredStyle;
            this.registry = registry;
        }

        public BindingOperation getMatchedOperation() {
            return this.operation;
        }

        public void setRequiredStyle(String requiredStyle) {
            this.requiredStyle = requiredStyle;
        }

        public boolean isSOAPActionRequired() {
            return this.isSOAPActionRequired;
        }

        public void setSOAPActionRequired() {
            this.isSOAPActionRequired = true;
        }

        public void visit(SOAPBinding binding, Object parent, WSDLTraversalContext ctx) {
            String style = binding.getStyle() == null ? "document" : binding.getStyle();
            ctx.addParameter("style", style);
        }

        public void visit(SOAPOperation operation, Object parent, WSDLTraversalContext ctx) {
            this.soapAction = null;
            String style = operation.getStyle();
            if (style == null) {
                style = (String)ctx.getParameter("style");
            }
            if (!this.requiredStyle.equals(style)) {
                ctx.cancelBindingOperationProcessing();
            } else {
                this.soapAction = operation.getSoapActionURI();
            }
        }

        public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
            BindingOperation bop = ctx.getBindingOperation();
            if (bop.getOperation() == null || bop.getOperation().getInput() == null || bop.getOperation().getInput().getMessage() == null) {
                return;
            }
            Message msg = bop.getOperation().getInput().getMessage();
            List parts = WSDLUtil.getParts(bop.getOperation(), msg, body, this.requiredStyle);
            QName additionalName = null;
            if ("rpc".equals(this.requiredStyle)) {
                String namespace = body.getNamespaceURI();
                if (namespace == null || namespace.length() == 0) {
                    namespace = ctx.getBinding().getQName().getNamespaceURI();
                }
                additionalName = new QName(namespace, ctx.getBindingOperation().getName());
            }
            OperationSignature op = new OperationSignature(parts, null, this.registry, false);
            if (additionalName != null) {
                op.getSignature().add(0, additionalName);
            }
            if (this.isSOAPActionRequired && this.soapAction != null) {
                op.getSignature().add(0, this.soapAction);
            }
            if (op.getSignature().equals(OperationSignature.this.signature)) {
                this.operation = ctx.getBindingOperation();
                ctx.cancelBindingOperationProcessing();
                ctx.cancelBindingProcessing();
            } else {
                op = new OperationSignature(parts, null, this.registry, true);
                if (additionalName != null) {
                    op.getSignature().add(0, additionalName);
                }
                if (this.isSOAPActionRequired && this.soapAction != null) {
                    op.getSignature().add(0, this.soapAction);
                }
                if (op.getSignature().equals(OperationSignature.this.signature)) {
                    this.operation = ctx.getBindingOperation();
                    ctx.cancelBindingOperationProcessing();
                    ctx.cancelBindingProcessing();
                }
            }
        }
    }
}

