/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.batch;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.BaseProcessorPlan;
import com.metamatrix.query.processor.DescribableUtil;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchedUpdatePlan
extends BaseProcessorPlan {
    private ProcessorPlan[] updatePlans;
    private boolean[] planOpened;
    private List[] updateCounts;
    private int planIndex = 0;
    private int commandIndex = 0;

    public BatchedUpdatePlan(List childPlans, int commandsInBatch) {
        this.updatePlans = childPlans.toArray(new ProcessorPlan[childPlans.size()]);
        this.planOpened = new boolean[this.updatePlans.length];
        this.updateCounts = new List[commandsInBatch];
    }

    public Object clone() {
        ArrayList<Object> clonedPlans = new ArrayList<Object>(this.updatePlans.length);
        for (int i = 0; i < this.updatePlans.length; ++i) {
            clonedPlans.add(this.updatePlans[i].clone());
        }
        return new BatchedUpdatePlan(clonedPlans, this.updateCounts.length);
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        for (int i = 0; i < this.updatePlans.length; ++i) {
            this.updatePlans[i].initialize(context, dataMgr, bufferMgr);
        }
    }

    public boolean connectTupleSource(TupleSource source, int dataRequestID) {
        for (int i = 0; i < this.updatePlans.length; ++i) {
            if (!this.updatePlans[i].canHandleData(dataRequestID)) continue;
            return this.updatePlans[i].connectTupleSource(source, dataRequestID);
        }
        throw new MetaMatrixRuntimeException(QueryExecPlugin.Util.getString("BatchedUpdatePlan.cannot_connect_tuplesource", dataRequestID));
    }

    public boolean canHandleData(int dataRequestID) {
        return true;
    }

    public List getOutputElements() {
        return Command.getUpdateCommandSymbol();
    }

    public void open() throws MetaMatrixComponentException {
        this.updatePlans[0].open();
        this.planOpened[0] = true;
    }

    public TupleBatch nextBatch() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        while (this.planIndex < this.updatePlans.length) {
            if (!this.planOpened[this.planIndex]) {
                this.updatePlans[this.planIndex].open();
                this.planOpened[this.planIndex] = true;
            }
            List[] currentBatch = this.updatePlans[this.planIndex].nextBatch().getAllTuples();
            int i = 0;
            while (i < currentBatch.length) {
                this.updateCounts[this.commandIndex] = currentBatch[i];
                ++i;
                ++this.commandIndex;
            }
            this.updatePlans[this.planIndex].close();
            ++this.planIndex;
        }
        TupleBatch batch = new TupleBatch(1, this.updateCounts);
        batch.setTerminationFlag(true);
        return batch;
    }

    public void close() throws MetaMatrixComponentException {
    }

    public void reset() {
        int i;
        super.reset();
        for (i = 0; i < this.updatePlans.length; ++i) {
            this.updatePlans[i].reset();
            this.planOpened[i] = false;
        }
        for (i = 0; i < this.updateCounts.length; ++i) {
            this.updateCounts[i] = null;
        }
        this.planIndex = 0;
        this.commandIndex = 0;
    }

    public Map getDescriptionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", "Batched Update Plan");
        ArrayList<Map> children = new ArrayList<Map>();
        for (int i = 0; i < this.updatePlans.length; ++i) {
            children.add(this.updatePlans[i].getDescriptionProperties());
        }
        props.put("children", children);
        props.put("outputCols", DescribableUtil.getOutputColumnProperties((List)this.getOutputElements()));
        return props;
    }

    public String toString() {
        StringBuffer val = new StringBuffer("BatchedUpdatePlan {\n");
        for (int i = 0; i < this.updatePlans.length; ++i) {
            val.append(this.updatePlans[i]).append("\n");
        }
        val.append("}\n");
        return val.toString();
    }

    public List getUpdatePlans() {
        return Arrays.asList(this.updatePlans);
    }

    public Collection getChildPlans() {
        return Arrays.asList(this.updatePlans);
    }
}

