/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class StringTokenizer {
    private char[] spaceDel;
    private char[] del;
    private char[] allDel;

    public StringTokenizer(char[] spaceDelimiters, char[] delimiters) {
        if (spaceDelimiters != null) {
            this.spaceDel = new char[spaceDelimiters.length];
            System.arraycopy(spaceDelimiters, 0, this.spaceDel, 0, spaceDelimiters.length);
            StringTokenizer.sort(this.spaceDel);
        } else {
            this.spaceDel = null;
        }
        if (delimiters != null) {
            this.del = new char[delimiters.length];
            System.arraycopy(delimiters, 0, this.del, 0, delimiters.length);
            StringTokenizer.sort(this.del);
        } else {
            this.del = null;
        }
        if (this.del != null && this.spaceDel != null) {
            this.allDel = new char[this.del.length + this.spaceDel.length];
            System.arraycopy(this.del, 0, this.allDel, 0, this.del.length);
            System.arraycopy(this.spaceDel, 0, this.allDel, this.del.length, this.spaceDel.length);
        } else {
            this.allDel = this.del != null ? this.del : this.spaceDel;
        }
        StringTokenizer.sort(this.allDel);
    }

    public Enumeration parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("StringTokenizer : String cannot be NULL");
        }
        return new StringTokenizerEnumeration(s.toCharArray());
    }

    private static boolean contain(char c, char[] a) {
        if (a == null) {
            return false;
        }
        int l = 0;
        int r = a.length - 1;
        while (l < r) {
            int center = (l + r) / 2;
            if (c > a[center]) {
                l = center + 1;
                continue;
            }
            r = center;
        }
        return a[l] == c;
    }

    private static void sort(char[] c) {
        if (c != null) {
            char ci;
            int j;
            int k;
            int i = 1;
            while (i < c.length) {
                k = i;
                j = (k - 1) / 2;
                ci = c[i];
                while (k > 0 && c[j] < ci) {
                    c[k] = c[j];
                    k = j;
                    j = (k - 1) / 2;
                }
                c[k] = ci;
                ++i;
            }
            i = c.length - 1;
            while (i > 0) {
                j = 2;
                k = 0;
                ci = c[0];
                while (j <= i) {
                    c[k] = c[j - 1] > c[j] ? c[--j] : c[j];
                    k = j;
                    j = (k + 1) * 2;
                }
                c[k] = c[i];
                c[i] = ci;
                --i;
            }
        }
    }

    private class StringTokenizerEnumeration
    implements Enumeration {
        private final char[] str;
        private final int size;
        private int index;

        StringTokenizerEnumeration(char[] s) {
            this.str = s;
            this.size = this.str.length;
            this.index = 0;
            while (this.index < this.size && StringTokenizer.contain(this.str[this.index], StringTokenizer.this.spaceDel)) {
                ++this.index;
            }
        }

        public boolean hasMoreElements() {
            return this.index < this.size;
        }

        public Object nextElement() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("StringTokenizer enumeration");
            }
            int begStr = this.index;
            if (this.index < this.size && StringTokenizer.contain(this.str[this.index], StringTokenizer.this.del)) {
                ++this.index;
            }
            if (begStr == this.index) {
                while (this.index < this.size && !StringTokenizer.contain(this.str[this.index], StringTokenizer.this.allDel)) {
                    ++this.index;
                }
            }
            int endStr = this.index;
            while (this.index < this.size && StringTokenizer.contain(this.str[this.index], StringTokenizer.this.spaceDel)) {
                ++this.index;
            }
            return String.copyValueOf(this.str, begStr, endStr - begStr);
        }

        public String toString() {
            int i = this.index;
            String s = (String)this.nextElement();
            this.index = i;
            return s;
        }
    }
}

