/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.KeyedReference;

public final class UDDIUtils {
    public static final FindQualifiers EXACT_NAME_MATCH_QUALIFIER;
    static final String WS_I_CONFORMANCE_TMODEL_NAME = "ws-i-org:conformsTo:2002_12";
    private static Hashtable wsiConformanceTable;

    static {
        Vector<FindQualifier> vector = new Vector<FindQualifier>();
        EXACT_NAME_MATCH_QUALIFIER = new FindQualifiers();
        vector.add(new FindQualifier("exactNameMatch"));
        vector.add(new FindQualifier("sortByNameAsc"));
        EXACT_NAME_MATCH_QUALIFIER.setFindQualifierVector(vector);
        wsiConformanceTable = new Hashtable();
    }

    public static BusinessService getBusinessServiceByKey(UDDIProxy proxy, String key) throws TransportException, UDDIException {
        Vector v;
        BusinessService result = null;
        ServiceDetail sd = proxy.get_serviceDetail(key);
        if (sd != null && (v = sd.getBusinessServiceVector()) != null && v.size() > 0) {
            result = (BusinessService)v.firstElement();
        }
        return result;
    }

    public static BusinessEntity getBusinessByKey(UDDIProxy proxy, String key) throws TransportException, UDDIException {
        Vector v;
        BusinessEntity result = null;
        BusinessDetail bd = proxy.get_businessDetail(key);
        if (bd != null && (v = bd.getBusinessEntityVector()) != null && v.size() > 0) {
            result = (BusinessEntity)v.firstElement();
        }
        return result;
    }

    public static TModel getTModelByKey(UDDIProxy proxy, String key) {
        TModel result = null;
        try {
            Vector v;
            TModelDetail bd = proxy.get_tModelDetail(key);
            if (bd != null && (v = bd.getTModelVector()) != null && v.size() > 0) {
                result = (TModel)v.firstElement();
            }
        }
        catch (Throwable throwable) {}
        return result;
    }

    public static String getWSIConformanceTModelKey(UDDIProxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("UDDI proxy cannot be null.");
        }
        String result = null;
        if (wsiConformanceTable.containsKey(proxy)) {
            result = wsiConformanceTable.get(proxy).toString();
        } else {
            result = UDDIUtils.getTModelKeyByName(proxy, WS_I_CONFORMANCE_TMODEL_NAME);
            if (result == null) {
                throw new IllegalStateException("WS-I conformance taxonomy tModel was not found");
            }
            wsiConformanceTable.put(proxy, result);
        }
        return result;
    }

    public static String getTModelKeyByName(UDDIProxy proxy, String name) {
        String result = null;
        try {
            TModelList list = proxy.find_tModel(name, null, null, EXACT_NAME_MATCH_QUALIFIER, 1);
            TModelInfo info = (TModelInfo)list.getTModelInfos().getTModelInfoVector().firstElement();
            result = info.getTModelKey();
        }
        catch (Throwable throwable) {}
        return result;
    }

    public static String bindingTemplateToString(BindingTemplate bindingTemplate) {
        String returnString = "";
        if (bindingTemplate == null) {
            returnString = "null";
        } else {
            returnString = "accessPoint: " + (bindingTemplate.getAccessPoint() == null ? "null" : bindingTemplate.getAccessPoint().getText());
            if (bindingTemplate.getTModelInstanceDetails() == null || bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfoVector() == null) {
                returnString = String.valueOf(returnString) + ", [no tModel reference]";
            } else {
                Iterator iterator = bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfoVector().iterator();
                int infoCount = 1;
                while (iterator.hasNext()) {
                    TModelInstanceInfo info = (TModelInstanceInfo)iterator.next();
                    returnString = String.valueOf(returnString) + ", [" + infoCount++ + "] tModelKey: " + info.getTModelKey();
                }
            }
        }
        return returnString;
    }

    public static String tModelToString(TModel tModel) {
        String returnString = "";
        returnString = tModel == null ? "null" : "name: " + tModel.getNameString() + ", categoryBag: " + (tModel.getCategoryBag() == null ? "null" : UDDIUtils.categoryBagToString(tModel.getCategoryBag())) + ", overviewURL: " + (tModel.getOverviewDoc() == null ? "null" : tModel.getOverviewDoc().getOverviewURLString());
        return returnString;
    }

    public static String categoryBagToString(CategoryBag categoryBag) {
        String returnString = "";
        if (categoryBag == null) {
            returnString = String.valueOf(returnString) + "null";
        } else {
            returnString = String.valueOf(returnString) + "KeyedReferenceList: ";
            Vector krList = null;
            krList = categoryBag.getKeyedReferenceVector();
            if (krList == null) {
                returnString = String.valueOf(returnString) + "null";
            } else if (krList.size() == 0) {
                returnString = String.valueOf(returnString) + "empty";
            } else {
                KeyedReference kr = null;
                Iterator iterator = krList.iterator();
                while (iterator.hasNext()) {
                    kr = (KeyedReference)iterator.next();
                    returnString = String.valueOf(returnString) + "tModelKey: " + kr.getTModelKey() + ", keyName: " + kr.getKeyName() + ", keyValue: " + kr.getKeyValue();
                }
            }
        }
        return returnString;
    }

    public static TModel findTModel(UDDIProxy uddiProxy, BindingTemplate bindingTemplate, boolean verboseOption) throws WSIException {
        TModel tModel = null;
        Iterator iterator = bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfoVector().iterator();
        Vector<String> tModelKeyList = new Vector<String>();
        while (iterator.hasNext()) {
            TModelInstanceInfo tModelInstanceInfo = (TModelInstanceInfo)iterator.next();
            tModelKeyList.add(tModelInstanceInfo.getTModelKey());
        }
        if (tModelKeyList.size() > 0) {
            try {
                TModelDetail tModelDetail = uddiProxy.get_tModelDetail(tModelKeyList);
                Iterator tModelIterator = tModelDetail.getTModelVector().iterator();
                TModel nextTModel = null;
                while (tModelIterator.hasNext() && tModel == null) {
                    nextTModel = (TModel)tModelIterator.next();
                    if (verboseOption) {
                        System.err.println("      TModel referenced from bindingTemplate - " + UDDIUtils.tModelToString(nextTModel));
                    }
                    if (!UDDIUtils.isWsdlSpec(nextTModel)) continue;
                    tModel = nextTModel;
                }
            }
            catch (Exception e) {
                throw new WSIException("Could not get tModel details.", e);
            }
        }
        return tModel;
    }

    public static boolean isWsdlSpec(TModel tModel) {
        boolean tModelFound = false;
        CategoryBag categoryBag = null;
        Iterator categoryBagIterator = null;
        categoryBag = tModel.getCategoryBag();
        if (categoryBag != null) {
            categoryBagIterator = categoryBag.getKeyedReferenceVector().iterator();
            KeyedReference keyedReference = null;
            while (categoryBagIterator.hasNext() && !tModelFound) {
                keyedReference = (KeyedReference)categoryBagIterator.next();
                if (!keyedReference.getTModelKey().equalsIgnoreCase("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4") || !"wsdlSpec".equals(keyedReference.getKeyValue())) continue;
                tModelFound = true;
            }
        }
        return tModelFound;
    }

    public static String getOverviewURL(TModel tModel) {
        if (tModel != null && tModel.getOverviewDoc() != null && tModel.getOverviewDoc().getOverviewURL() != null) {
            return tModel.getOverviewDoc().getOverviewURL().getText();
        }
        return null;
    }

    public static String getWSDLLocation(String wsdlLocation) {
        int index = wsdlLocation.indexOf("#");
        if (index > -1) {
            wsdlLocation = wsdlLocation.substring(0, index);
        }
        return wsdlLocation;
    }

    public static Binding getBinding(String overviewURL, WSDLDocument wsdlDocument) {
        int index;
        Binding[] bindings = wsdlDocument.getBindings();
        if (bindings == null || bindings.length == 0) {
            return null;
        }
        if (overviewURL != null && (index = overviewURL.indexOf("#")) > -1) {
            String nameAttribute = "@name=";
            int nameIndex = overviewURL.substring(index + 1).indexOf(nameAttribute);
            if (nameIndex > -1) {
                int firstQuoteIndex = index + 1 + nameIndex + nameAttribute.length();
                String quote = overviewURL.substring(firstQuoteIndex, firstQuoteIndex + 1);
                String urlPart = overviewURL.substring(firstQuoteIndex + 1);
                int nextQuoteIndex = urlPart.indexOf(quote);
                if (nextQuoteIndex > -1) {
                    String bindingName = urlPart.substring(0, nextQuoteIndex);
                    int i = 0;
                    while (i < bindings.length) {
                        if (bindingName.equals(bindings[i].getQName().getLocalPart())) {
                            return bindings[i];
                        }
                        ++i;
                    }
                }
            }
        }
        return bindings[0];
    }
}

