/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.webservice.ui.wizard;

import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.core.io.FileUrl;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.FileSeparatorUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.wsdl.io.WsdlHelper;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.webservice.ui.IInternalUiConstants;
import com.metamatrix.modeler.internal.webservice.ui.wizard.WsdlUrlDialog;
import com.metamatrix.modeler.ui.viewsupport.ModelingResourceFilter;
import com.metamatrix.modeler.webservice.IWebServiceModelBuilder;
import com.metamatrix.modeler.webservice.IWebServiceResource;
import com.metamatrix.modeler.webservice.ui.IUiConstants;
import com.metamatrix.modeler.webservice.ui.util.WebServiceUiUtil;
import com.metamatrix.ui.internal.product.ProductCustomizerMgr;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.util.WizardUtil;
import com.metamatrix.ui.internal.viewsupport.StatusInfo;
import com.metamatrix.ui.internal.viewsupport.UiBusyIndicator;
import com.metamatrix.ui.internal.widget.ListMessageDialog;
import com.metamatrix.ui.internal.wizard.AbstractWizardPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.jdom.JDOMException;

public final class WsdlSelectionPage
extends AbstractWizardPage
implements FileUtils.Constants,
IInternalUiConstants,
IInternalUiConstants.HelpContexts,
IInternalUiConstants.Images {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$webservice$ui$wizard$WsdlSelectionPage == null ? (class$com$metamatrix$modeler$internal$webservice$ui$wizard$WsdlSelectionPage = WsdlSelectionPage.class$("com.metamatrix.modeler.internal.webservice.ui.wizard.WsdlSelectionPage")) : class$com$metamatrix$modeler$internal$webservice$ui$wizard$WsdlSelectionPage));
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private static final String WSDL_SUFFIX = ".wsdl";
    private Text nameText;
    private IWebServiceModelBuilder builder;
    private Map urlMap;
    private Map wsdlValidationMessages = new HashMap();
    private IAction copyAction;
    private IBaseLabelProvider labelProvider;
    private Object[] startupWsdls;
    private IAction removeWsdlAction;
    private IAction viewWsdlAction;
    private IPath modelLocationPath;
    private boolean displayModelNameTextField;
    private ViewerFilter wsdlFilter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParentElement, Object theElement) {
            boolean result = false;
            if (theElement instanceof IContainer) {
                IProject project = ((IContainer)theElement).getProject();
                if (project.isOpen()) {
                    try {
                        if (project.getNature("com.metamatrix.modeler.core.modelNature") != null) {
                            result = true;
                        }
                    }
                    catch (CoreException theException) {
                        IInternalUiConstants.UTIL.log((Throwable)theException);
                    }
                }
            } else if (theElement instanceof IFile) {
                result = WebServiceUiUtil.isWsdlFile((IFile)((IFile)theElement));
            } else if (theElement instanceof File) {
                return ((File)theElement).isDirectory() || WebServiceUiUtil.isWsdlFile((File)((File)theElement));
            }
            return result;
        }
    };
    private Map wsdlMap;
    private ISelectionStatusValidator wsdlValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] theSelection) {
            StatusInfo result = null;
            boolean valid = true;
            if (theSelection != null && theSelection.length > 0) {
                for (int i = 0; i < theSelection.length; ++i) {
                    if (theSelection[i] instanceof IFile && WebServiceUiUtil.isWsdlFile((IFile)((IFile)theSelection[i]))) continue;
                    valid = false;
                    break;
                }
            } else {
                valid = false;
            }
            result = valid ? new StatusInfo(IUiConstants.PLUGIN_ID) : new StatusInfo(IUiConstants.PLUGIN_ID, 4, WsdlSelectionPage.getString("msg.selectionIsNotWsdl"));
            return result;
        }
    };
    private Button btnFileSystemAdd;
    private Button btnURLAdd;
    private Button btnWorkspaceAdd;
    private TableViewer viewer;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$webservice$ui$wizard$WsdlSelectionPage;

    public WsdlSelectionPage(IWebServiceModelBuilder theBuilder, boolean displayModelNameTextField) {
        super(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$internal$webservice$ui$wizard$WsdlSelectionPage == null ? (class$com$metamatrix$modeler$internal$webservice$ui$wizard$WsdlSelectionPage = WsdlSelectionPage.class$("com.metamatrix.modeler.internal.webservice.ui.wizard.WsdlSelectionPage")) : class$com$metamatrix$modeler$internal$webservice$ui$wizard$WsdlSelectionPage)), WsdlSelectionPage.getString("title"));
        this.builder = theBuilder;
        this.wsdlMap = new HashMap();
        this.displayModelNameTextField = displayModelNameTextField;
        this.setImageDescriptor(WebServiceUiUtil.getImageDescriptor((String)"icons/full/wizban/WebService.gif"));
    }

    public void addWsdlFiles(final Object[] theFiles, final boolean theWorkspaceResourceFlag) {
        UiBusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add WSDL Files", (Object)this);
                boolean succeeded = false;
                try {
                    WsdlSelectionPage.this.addWsdlFilesInternal(theFiles, theWorkspaceResourceFlag);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        });
    }

    private void addWsdlFilesInternal(Object[] theFiles, boolean theWorkspaceResourceFlag) {
        IWebServiceModelBuilder modelBuilder = this.getBuilder();
        modelBuilder.setModelPath(this.getModelLocationPath());
        Map map = this.getWsdlMap();
        ArrayList<Object> problems = null;
        ArrayList<Object> newWsdls = new ArrayList<Object>(theFiles.length);
        for (int i = 0; i < theFiles.length; ++i) {
            boolean okToAdd = true;
            String newPath = null;
            Iterator itr = map.keySet().iterator();
            newPath = theWorkspaceResourceFlag ? ((IFile)theFiles[i]).getLocation().toOSString() : (theFiles[i] instanceof FileUrl ? ((FileUrl)theFiles[i]).getOriginalUrlString() : ((File)theFiles[i]).getAbsolutePath());
            while (itr.hasNext()) {
                Object wsdl = itr.next();
                String path = null;
                if (wsdl instanceof IFile) {
                    path = ((IFile)wsdl).getLocation().toOSString();
                } else if (wsdl instanceof FileUrl) {
                    path = ((FileUrl)wsdl).getOriginalUrlString();
                } else if (wsdl instanceof File) {
                    path = ((File)wsdl).getAbsolutePath();
                } else {
                    Assertion.failed((String)("Unexpected WSDL object type of " + wsdl.getClass()));
                }
                if (!path.equals(newPath)) continue;
                okToAdd = false;
                if (problems == null) {
                    problems = new ArrayList();
                }
                problems.add(theFiles[i]);
                break;
            }
            if (!okToAdd) continue;
            IWebServiceResource resource = null;
            try {
                resource = theWorkspaceResourceFlag ? modelBuilder.addResource((IFile)theFiles[i]) : modelBuilder.addResource((File)theFiles[i]);
                map.put(theFiles[i], resource);
                newWsdls.add(theFiles[i]);
                this.validateWSDL(resource);
                continue;
            }
            catch (CoreException theException) {
                IInternalUiConstants.UTIL.log((Throwable)theException);
                if (problems == null) {
                    problems = new ArrayList<Object>();
                }
                problems.add(theFiles[i]);
            }
        }
        if (!newWsdls.isEmpty()) {
            this.getViewer().refresh();
            this.getViewer().setSelection((ISelection)new StructuredSelection(newWsdls), true);
            this.setPageStatus();
        }
        if (problems != null) {
            ListMessageDialog.openInformation((Shell)this.getShell(), (String)WsdlSelectionPage.getString("dialog.problems.title"), null, (String)WsdlSelectionPage.getString("dialog.problems.msg"), problems, (IBaseLabelProvider)this.getLabelProvider());
        }
    }

    private void validateWSDL(IWebServiceResource resource) {
        WSDLValidator validator = new WSDLValidator();
        IValidationReport report = null;
        try {
            report = validator.validate(resource.getFile().toURI().toString(), (InputStream)new FileInputStream(resource.getFile()), new WSDLValidationConfiguration());
        }
        catch (FileNotFoundException err) {
            // empty catch block
        }
        if (report != null && !report.isWSDLValid()) {
            this.wsdlValidationMessages.put(resource, report);
        }
    }

    public Map getWsdlValidationMessages() {
        return this.wsdlValidationMessages;
    }

    public void createControl(Composite theParent) {
        boolean COLUMNS = true;
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, IInternalUiConstants.HelpContexts.WSDL_SELECTION_PAGE);
        this.createFileAndLocationPanel(pnlMain);
        this.createButtonPanel(pnlMain);
        this.createTablePanel(pnlMain);
    }

    public boolean canFlipToNextPage() {
        return this.viewer.getTable().getItemCount() > 0 && super.canFlipToNextPage();
    }

    private void createFileAndLocationPanel(Composite theParent) {
        int COLUMNS = 2;
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(2, false));
        WidgetFactory.createLabel((Composite)pnl, (String)WsdlSelectionPage.getString("modelName"));
        this.nameText = WidgetFactory.createTextField((Composite)pnl, (int)768, (int)1);
        if (!this.displayModelNameTextField) {
            this.nameText.setEditable(false);
            String modelName = this.getModelLocationPath().removeFileExtension().lastSegment();
            this.nameText.setText(modelName);
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WsdlSelectionPage.this.nameModified();
            }
        });
    }

    private void createButtonPanel(Composite theParent) {
        int COLUMNS = 3;
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4);
        pnl.setLayout((Layout)new GridLayout(COLUMNS, false));
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            this.btnWorkspaceAdd = WidgetFactory.createButton((Composite)pnl, (String)WsdlSelectionPage.getString("button.addWsdlFile.workspace"), (int)768);
            this.btnWorkspaceAdd.setToolTipText(WsdlSelectionPage.getString("button.addWsdlFile.workspace.tip"));
            this.btnWorkspaceAdd.setSize(300, 100);
            this.btnWorkspaceAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent theEvent) {
                    WsdlSelectionPage.this.handleAddWorkspaceWsdlFile();
                }
            });
        }
        this.btnFileSystemAdd = WidgetFactory.createButton((Composite)pnl, (String)WsdlSelectionPage.getString("button.addWsdlFile.filesystem"), (int)768);
        this.btnFileSystemAdd.setToolTipText(WsdlSelectionPage.getString("button.addWsdlFile.filesystem.tip"));
        this.btnFileSystemAdd.setSize(300, 100);
        this.btnFileSystemAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                WsdlSelectionPage.this.handleAddFileSystemWsdlFile();
            }
        });
        this.btnURLAdd = WidgetFactory.createButton((Composite)pnl, (String)WsdlSelectionPage.getString("button.addWsdlFile.URL"), (int)768);
        this.btnURLAdd.setToolTipText(WsdlSelectionPage.getString("button.addWsdlFile.URL.tip"));
        this.btnURLAdd.setSize(300, 100);
        this.btnURLAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                WsdlSelectionPage.this.handleAddURLWsdlFile();
            }
        });
    }

    private void createTableActions(IToolBarManager theToolBarMgr) {
        this.copyAction = new Action(WsdlSelectionPage.getString("action.copy"), 1){

            public void run() {
                WsdlSelectionPage.this.handleCopyWsdlInfo();
            }
        };
        this.copyAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor((String)"IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setHoverImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor((String)"IMG_TOOL_COPY"));
        this.copyAction.setToolTipText(WsdlSelectionPage.getString("action.copy.tip"));
        this.copyAction.setEnabled(false);
        theToolBarMgr.add(this.copyAction);
        this.removeWsdlAction = new Action(WsdlSelectionPage.getString("action.removeWsdlFile"), 1){

            public void run() {
                WsdlSelectionPage.this.handleRemoveWsdlFile();
            }
        };
        this.removeWsdlAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.removeWsdlAction.setToolTipText(WsdlSelectionPage.getString("action.removeWsdlFile.tip"));
        this.removeWsdlAction.setEnabled(false);
        theToolBarMgr.add(this.removeWsdlAction);
        this.viewWsdlAction = new Action(WsdlSelectionPage.getString("action.viewWsdlFile"), 1){

            public void run() {
                WsdlSelectionPage.this.handleViewWsdlFile();
            }
        };
        this.viewWsdlAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor((String)"IMG_OBJ_FILE"));
        this.viewWsdlAction.setToolTipText(WsdlSelectionPage.getString("action.viewWsdlFile.tip"));
        this.viewWsdlAction.setEnabled(false);
        theToolBarMgr.add(this.viewWsdlAction);
        theToolBarMgr.update(true);
    }

    protected void createTableContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.add(this.copyAction);
        mgr.add(this.removeWsdlAction);
        mgr.add(this.viewWsdlAction);
        Control table = this.viewer.getControl();
        table.setMenu(mgr.createContextMenu(table));
    }

    private void createTablePanel(Composite theParent) {
        ViewForm viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)viewForm, (String)WsdlSelectionPage.getString("label.table")));
        Composite pnl = WidgetFactory.createPanel((Composite)viewForm, (int)0, (int)1808);
        viewForm.setContent((Control)pnl);
        this.viewer = WidgetFactory.createTableViewer((Composite)pnl, (int)770);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.labelProvider = new LabelProvider(){

            public String getText(Object theElement) {
                return WebServiceUiUtil.getText((Object)theElement);
            }
        };
        this.viewer.setLabelProvider(this.labelProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                WsdlSelectionPage.this.handleTableSelectionChanged();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent theEvent) {
                WsdlSelectionPage.this.handleViewWsdlFile();
            }
        });
        this.viewer.addFilter(this.wsdlFilter);
        this.createTableActions(WidgetFactory.createViewFormToolBar((ViewForm)viewForm));
        this.createTableContextMenu();
    }

    public void dispose() {
        this.saveState();
    }

    void nameModified() {
        this.validatePage();
    }

    protected IWebServiceModelBuilder getBuilder() {
        return this.builder;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("WebServiceModel");
            settings = temp == null ? settings.addNewSection("WebServiceModel") : temp;
        }
        return settings;
    }

    private IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    private TableViewer getViewer() {
        return this.viewer;
    }

    private static String getString(String theKey) {
        return IInternalUiConstants.UTIL.getString(PREFIX + theKey);
    }

    private static String getString(String theKey, Object value1) {
        return IInternalUiConstants.UTIL.getString(PREFIX + theKey, value1);
    }

    private Map getWsdlMap() {
        return this.wsdlMap;
    }

    protected Map getUrlMap() {
        return this.builder.getUrlMap();
    }

    private Object[] getWsdlResources() {
        return this.wsdlMap.keySet().toArray();
    }

    private void handleAddFileSystemWsdlFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setText(WsdlSelectionPage.getString("dialog.addWsdl.title"));
        dialog.setFilterExtensions(WebServiceUiUtil.FILE_DIALOG_WSDL_EXTENSIONS);
        if (dialog.open() != null) {
            boolean validFiles = true;
            String[] filenames = dialog.getFileNames();
            if (filenames != null && filenames.length > 0) {
                String directory = dialog.getFilterPath();
                Object[] wsdlFiles = new Object[filenames.length];
                for (int i = 0; i < filenames.length; ++i) {
                    String path = directory + File.separatorChar + filenames[i];
                    wsdlFiles[i] = new File(path);
                    if (WebServiceUiUtil.isWsdlFile((File)((File)wsdlFiles[i]))) continue;
                    validFiles = false;
                    break;
                }
                if (validFiles) {
                    this.addWsdlFiles(wsdlFiles, false);
                } else if (MessageDialog.openQuestion((Shell)this.getShell(), (String)WsdlSelectionPage.getString("dialog.wrongFileType.title"), (String)WsdlSelectionPage.getString("dialog.wrongFileType.msg"))) {
                    this.handleAddFileSystemWsdlFile();
                }
            }
        }
        this.validatePage();
    }

    private void handleAddURLWsdlFile() {
        WsdlUrlDialog dialog = new WsdlUrlDialog(this.getShell());
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            URL newUrl = dialog.getUrlObject();
            ArrayList list = new ArrayList();
            this.urlMap = this.getUrlMap();
            try {
                String filePath = WsdlSelectionPage.formatPath(newUrl);
                File wsdlFile = URLHelper.createFileFromUrl((URL)newUrl, (String)StringUtil.createFileName((String)filePath), (String)WSDL_SUFFIX);
                this.urlMap.put(wsdlFile.getName(), newUrl.toString());
                WsdlHelper.convertImportsToAbsolutePaths((File)wsdlFile, (String)newUrl.toExternalForm(), list, (Map)this.urlMap, (boolean)true);
            }
            catch (MalformedURLException theException) {
                IInternalUiConstants.UTIL.log((Throwable)theException);
            }
            catch (IOException theException) {
                IInternalUiConstants.UTIL.log((Throwable)theException);
            }
            catch (JDOMException theException) {
                IInternalUiConstants.UTIL.log((Throwable)theException);
            }
            Object[] wsdlFiles = list.toArray();
            this.addWsdlFiles(wsdlFiles, false);
        }
        this.validatePage();
    }

    public static String formatPath(URL newUrl) {
        String filePath = newUrl.getPath();
        while (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        int dotLocation = filePath.indexOf(".");
        if (dotLocation > -1) {
            filePath = filePath.substring(0, dotLocation);
        }
        return filePath;
    }

    private void handleAddWorkspaceWsdlFile() {
        Object[] wsdlFiles = WidgetUtil.showWorkspaceObjectSelectionDialog((String)WsdlSelectionPage.getString("dialog.addWsdl.title"), (String)WsdlSelectionPage.getString("dialog.addWsdl.msg"), (boolean)true, null, (ViewerFilter)new ModelingResourceFilter(this.wsdlFilter), (ISelectionStatusValidator)this.wsdlValidator);
        if (wsdlFiles != null && wsdlFiles.length > 0) {
            Object[] aryFiles = new Object[wsdlFiles.length];
            for (int i = 0; i < wsdlFiles.length; ++i) {
                IFile ifFile = (IFile)wsdlFiles[i];
                File fNew = ifFile.getLocation().toFile();
                aryFiles[i] = fNew;
            }
            this.addWsdlFiles(aryFiles, false);
        }
        this.validatePage();
    }

    private void handleCopyWsdlInfo() {
        WebServiceUiUtil.copyToClipboard((ISelection)this.viewer.getSelection());
    }

    private void handleRemoveWsdlFile() {
        Object[] selectedWsdlFiles = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        block0: for (int i = 0; i < selectedWsdlFiles.length; ++i) {
            IWebServiceResource resource = (IWebServiceResource)this.wsdlMap.get(selectedWsdlFiles[i]);
            this.builder.remove(resource);
            this.wsdlValidationMessages.remove(resource);
            Iterator itr = this.wsdlMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (entry.getValue() != resource) continue;
                itr.remove();
                continue block0;
            }
        }
        this.viewer.remove(selectedWsdlFiles);
        this.handleTableSelectionChanged();
        this.setPageStatus();
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.copyAction.setEnabled(!selection.isEmpty());
        this.removeWsdlAction.setEnabled(this.copyAction.isEnabled());
        this.viewWsdlAction.setEnabled(selection.size() == 1);
    }

    private void handleViewWsdlFile() {
        WebServiceUiUtil.viewFile((Shell)this.getShell(), (ISelection)this.viewer.getSelection());
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void setPageStatus() {
        String msg = null;
        int wsdlCount = this.wsdlMap.size();
        msg = wsdlCount > 0 ? IInternalUiConstants.UTIL.getString(PREFIX + "page.wsdlsIncluded.msg", new Object[]{new Integer(wsdlCount)}) : WsdlSelectionPage.getString("page.noWsdls.msg");
        this.setMessage(msg, 0);
        this.getContainer().updateButtons();
    }

    public void setInitialSelection(ISelection theSelection) {
        if (!theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            Object[] selectedObjects = ((IStructuredSelection)theSelection).toArray();
            ArrayList<File> wsdls = new ArrayList<File>();
            for (int i = 0; i < selectedObjects.length; ++i) {
                if (!(selectedObjects[i] instanceof IFile) || !WebServiceUiUtil.isWsdlFile((IFile)((IFile)selectedObjects[i]))) continue;
                File fNew = ((IFile)selectedObjects[i]).getLocation().toFile();
                wsdls.add(fNew);
            }
            if (!wsdls.isEmpty()) {
                this.startupWsdls = wsdls.toArray();
            }
        }
    }

    public IPath getModelLocationPath() {
        return this.modelLocationPath;
    }

    public void setWsdlValidationMessages(Map wsdlValidationMessages) {
        this.wsdlValidationMessages = wsdlValidationMessages;
    }

    public void setModelLocationPath(IPath modelLocationPath) {
        this.modelLocationPath = modelLocationPath;
    }

    public void setVisible(boolean theShowFlag) {
        if (theShowFlag) {
            if (this.viewer.getInput() == null) {
                this.restoreState();
            }
            this.setPageComplete(true);
            if (this.startupWsdls != null) {
                this.addWsdlFiles(this.startupWsdls, false);
                this.startupWsdls = null;
            }
            this.viewer.setInput((Object)this);
            this.setPageStatus();
            if (this.btnWorkspaceAdd != null) {
                this.btnWorkspaceAdd.setFocus();
            }
        }
        super.setVisible(theShowFlag);
    }

    private void validatePage() {
        String name = this.nameText.getText();
        String problem = null;
        if (name == null || name.length() == 0) {
            problem = WsdlSelectionPage.getString("noModeName");
        }
        if (problem != null) {
            WizardUtil.setPageComplete((WizardPage)this, (String)problem, (int)3);
        } else {
            if (problem == null) {
                problem = ModelUtilities.validateModelName((String)name, (String)".xmi");
            }
            if (problem != null) {
                WizardUtil.setPageComplete((WizardPage)this, (String)(WsdlSelectionPage.getString("invalidModelName") + '\n' + problem), (int)3);
            } else {
                String pathString;
                boolean exists;
                String temp = null;
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.modelLocationPath);
                if (resource != null) {
                    IPath path = resource.getLocation();
                    temp = path.toOSString();
                }
                if (exists = new File(pathString = this.getModelPath(temp, name)).exists()) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("page.existingWebServiceModel.msg", name), (int)3);
                } else {
                    WizardUtil.setPageComplete((WizardPage)this);
                }
            }
        }
        if (this.isPageComplete() && this.viewer.getTable().getItemCount() == 0) {
            WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("page.noWsdls.msg"), (int)3);
        }
        if (this.isPageComplete()) {
            if (this.displayModelNameTextField) {
                String locPath = this.modelLocationPath.toOSString() + FileSeparatorUtil.getOSFileSeparator() + name + ".xmi";
                this.getBuilder().setModelPath((IPath)new Path(locPath));
            } else {
                this.getBuilder().setModelPath(this.modelLocationPath);
            }
        }
    }

    private String getModelPath(String modelLocation, String modelName) {
        return modelLocation + File.separator + modelName + '.' + "xmi";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            return WsdlSelectionPage.this.getWsdlResources();
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }
}

