/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.query.processor.relational.BaseJoinStrategy;
import com.metamatrix.query.processor.relational.JoinStrategy;
import com.metamatrix.query.processor.relational.MergeJoinStrategy;
import com.metamatrix.query.processor.relational.NestedLoopJoinStrategy;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JoinNode
extends RelationalNode {
    private JoinStrategy joinStrategy;
    private JoinType joinType;
    private boolean isDependent;
    private List leftExpressions;
    private List rightExpressions;
    private Criteria joinCriteria;
    private Criteria nonEquiJoinCriteria;
    private Map combinedElementMap;

    public JoinNode(int nodeID) {
        super(nodeID);
    }

    public void setJoinType(JoinType type) {
        this.joinType = type;
    }

    public void setJoinStrategy(JoinStrategy joinStrategy) {
        this.joinStrategy = joinStrategy;
    }

    public void setJoinExpressions(List leftExpressions, List rightExpressions) {
        this.leftExpressions = leftExpressions;
        this.rightExpressions = rightExpressions;
    }

    public void setJoinCriteria(Criteria joinCriteria) {
        this.joinCriteria = joinCriteria;
    }

    public void open() throws MetaMatrixComponentException {
        this.getChildren()[0].open();
        if (!this.isDependent) {
            this.getChildren()[1].open();
        }
        ArrayList combinedElements = new ArrayList(this.getChildren()[0].getElements());
        combinedElements.addAll(this.getChildren()[1].getElements());
        this.combinedElementMap = this.createLookupMap(combinedElements);
        this.joinStrategy.createSourceState(this.getChildren(), this.leftExpressions, this.rightExpressions, (short)2);
        this.joinStrategy.initialize(this.getDataManager(), this.getContext(), this.getBufferManager(), this.joinType, this.isDependent);
        if (this.joinStrategy instanceof MergeJoinStrategy) {
            ((MergeJoinStrategy)this.joinStrategy).setBatchSize(this.getBatchSize());
        }
        if (this.joinStrategy instanceof NestedLoopJoinStrategy) {
            ((BaseJoinStrategy)this.joinStrategy).setCriteria(this.joinCriteria);
        }
        if (this.joinStrategy instanceof MergeJoinStrategy) {
            ((BaseJoinStrategy)this.joinStrategy).setCriteria(this.nonEquiJoinCriteria);
        }
    }

    public void resetSourceStates(short source) {
        this.joinStrategy.createSourceState(this.getChildren(), this.leftExpressions, this.rightExpressions, source);
    }

    public void reset() {
        super.reset();
        this.joinStrategy.reset();
    }

    public Object clone() {
        JoinNode clonedNode = new JoinNode(super.getID());
        super.copy((RelationalNode)this, (RelationalNode)clonedNode);
        clonedNode.joinType = this.joinType;
        clonedNode.joinStrategy = (JoinStrategy)this.joinStrategy.clone();
        if (this.joinStrategy instanceof NestedLoopJoinStrategy) {
            clonedNode.joinCriteria = this.joinCriteria;
        } else {
            if (this.joinStrategy instanceof MergeJoinStrategy) {
                clonedNode.nonEquiJoinCriteria = this.nonEquiJoinCriteria;
            }
            ArrayList<Object> leftCopy = new ArrayList<Object>(this.leftExpressions.size());
            for (int i = 0; i < this.leftExpressions.size(); ++i) {
                leftCopy.add(((Expression)this.leftExpressions.get(i)).clone());
            }
            clonedNode.leftExpressions = leftCopy;
            ArrayList<Object> rightCopy = new ArrayList<Object>(this.rightExpressions.size());
            for (int i = 0; i < this.rightExpressions.size(); ++i) {
                rightCopy.add(((Expression)this.rightExpressions.get(i)).clone());
            }
            clonedNode.rightExpressions = rightCopy;
        }
        clonedNode.isDependent = this.isDependent;
        return clonedNode;
    }

    protected TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        while (true) {
            if (this.joinStrategy.getState() == 0) {
                super.terminateBatches();
                return super.pullBatch();
            }
            if (super.isBatchFull()) {
                return super.pullBatch();
            }
            List outputTuple = this.joinStrategy.execute();
            if (outputTuple == null) continue;
            List projectTuple = this.projectTuple(this.combinedElementMap, outputTuple, this.getElements());
            super.addBatchRow(projectTuple);
        }
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        if (this.isDependent) {
            props.put("type", "Dependent Join");
        } else {
            props.put("type", "Join");
        }
        props.put("joinStrategy", this.joinStrategy.toString());
        props.put("joinType", this.joinType.toString());
        if (this.joinStrategy instanceof NestedLoopJoinStrategy) {
            if (this.joinCriteria != null) {
                props.put("joinCriteria", this.joinCriteria.toString());
            } else {
                props.put("joinCriteria", "none");
            }
        } else {
            ArrayList<String> critList = new ArrayList<String>();
            for (int i = 0; i < this.leftExpressions.size(); ++i) {
                critList.add(this.leftExpressions.get(i).toString() + "=" + this.rightExpressions.get(i).toString());
            }
            props.put("joinCriteria", critList);
        }
        return props;
    }

    protected void getNodeString(StringBuffer str) {
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") [");
        if (this.isDependent) {
            str.append("Dependent] [");
        }
        str.append(this.joinStrategy.toString());
        str.append("] [");
        str.append(this.joinType.toString());
        str.append("] output=");
        str.append(this.getElements());
        str.append(" ");
    }

    public boolean isDependent() {
        return this.isDependent;
    }

    public void setDependent(boolean isDependent) {
        this.isDependent = isDependent;
    }

    public void close() throws MetaMatrixComponentException {
        super.close();
        this.joinStrategy.close();
    }

    public void setNonEquiJoinCriteria(Criteria oneSideJoinCriteria) {
        this.nonEquiJoinCriteria = oneSideJoinCriteria;
    }

    public Criteria getJoinCriteria() {
        return this.joinCriteria;
    }
}

