/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.IntegerIDFactory;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.dqp.internal.process.CallableStatementRequest;
import com.metamatrix.dqp.internal.process.DQPProcessorContext;
import com.metamatrix.dqp.internal.process.PreparedPlanCache;
import com.metamatrix.dqp.internal.process.PreparedStatementRequest;
import com.metamatrix.dqp.internal.process.QueryMetadataWrapper;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.internal.process.capabilities.ConnectorCapabilitiesFinder;
import com.metamatrix.dqp.internal.process.capabilities.SharedCachedFinder;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceCapabilitiesFinder;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import com.metamatrix.dqp.internal.process.multisource.MultiSourcePlanModifier;
import com.metamatrix.dqp.internal.process.validator.AuthorizationValidationVisitor;
import com.metamatrix.dqp.internal.process.validator.ModelVisibilityValidationVisitor;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.AuthorizationService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.eval.SecurityFunctionEvaluator;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.optimizer.QueryOptimizer;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.parser.ParseInfo;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.TempTableDataManager;
import com.metamatrix.query.processor.xml.XMLPlan;
import com.metamatrix.query.processor.xquery.XQueryPlan;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SQLQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.tempdata.TempTableStore;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import com.metamatrix.query.validator.AbstractValidationVisitor;
import com.metamatrix.query.validator.ValidateCriteriaVisitor;
import com.metamatrix.query.validator.ValidationVisitor;
import com.metamatrix.query.validator.Validator;
import com.metamatrix.query.validator.ValidatorFailure;
import com.metamatrix.query.validator.ValidatorReport;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;

public class Request {
    private static final String SYSTEM_MODEL = "System";
    private static final String AUTO_WRAP_OPTIMISTIC = "OPTIMISTIC";
    protected RequestMessage requestMsg;
    protected String vdbName;
    protected String vdbVersion;
    protected QueryMetadataInterface metadata;
    protected ApplicationEnvironment env;
    private VDBService vdbService;
    private BufferManager bufferManager;
    private ProcessorDataManager processorDataManager;
    private RequestManager requestMgr;
    private WorkerPool processWorkerPool;
    private Map connectorCapabilitiesCache;
    private TransactionService transactionService;
    private ResultSetCache rsCache;
    protected IDGenerator idGenerator = new IDGenerator();
    protected ProcessorPlan processPlan;
    protected Collection schemas;
    private Collection multiSourceModels;
    protected boolean updatesAllowed;
    protected boolean virtualLayerAllowed;
    protected boolean xmlAllowed;
    protected AnalysisRecord analysisRecord;
    private boolean procDebugAllowed = false;
    boolean threadSuspended;
    private DQPProcessorContext context;
    private TempTableStore tempTableStore;

    public static Request createRequest(RequestMessage requestMsg, ApplicationEnvironment env, PreparedPlanCache prepPlanCache, BufferManager bufferManager, ProcessorDataManager processorDataManager, RequestManager requestMgr, WorkerPool processWorkerPool, Map connectorCapabilitiesCache, TransactionService transactionService, boolean updatesAllowed, ResultSetCache rsCache, boolean procDebugAllowed, boolean virtualLayerAllowed, boolean xmlAllowed, TempTableStore tempTableStore) {
        Object result = null;
        if (requestMsg.isCallableStatement()) {
            result = new CallableStatementRequest();
        } else if (requestMsg.isPreparedStatement()) {
            PreparedStatementRequest preparedStatementRequest = new PreparedStatementRequest();
            preparedStatementRequest.initializePreparedPlanCache(prepPlanCache);
            result = preparedStatementRequest;
        } else {
            result = new Request();
        }
        result.initialize(requestMsg, env, bufferManager, processorDataManager, requestMgr, processWorkerPool, connectorCapabilitiesCache, transactionService, updatesAllowed, rsCache, procDebugAllowed, virtualLayerAllowed, xmlAllowed, tempTableStore);
        return result;
    }

    protected void initialize(RequestMessage requestMsg, ApplicationEnvironment env, BufferManager bufferManager, ProcessorDataManager processorDataManager, RequestManager requestMgr, WorkerPool processWorkerPool, Map connectorCapabilitiesCache, TransactionService transactionService, boolean updatesAllowed, ResultSetCache rsCache, boolean procDebugAllowed, boolean virtualLayerAllowed, boolean xmlAllowed, TempTableStore tempTableStore) {
        this.requestMsg = requestMsg;
        this.vdbName = requestMsg.getVdbName();
        this.vdbVersion = requestMsg.getVdbVersion();
        this.env = env;
        this.vdbService = (VDBService)env.findService("dqp.vdb");
        this.bufferManager = bufferManager;
        this.processorDataManager = processorDataManager;
        this.requestMgr = requestMgr;
        this.processWorkerPool = processWorkerPool;
        this.connectorCapabilitiesCache = connectorCapabilitiesCache;
        this.transactionService = transactionService;
        this.updatesAllowed = updatesAllowed;
        this.rsCache = rsCache;
        this.procDebugAllowed = procDebugAllowed;
        this.virtualLayerAllowed = virtualLayerAllowed;
        this.xmlAllowed = xmlAllowed;
        this.tempTableStore = tempTableStore;
        this.idGenerator.setDefaultFactory((ObjectIDFactory)new IntegerIDFactory());
    }

    protected void prepareCommand() throws QueryParserException, QueryResolverException, QueryValidatorException, MetaMatrixComponentException {
        this.requestMsg.markProcessingStart();
        Command command = this.getCommand();
        this.requestMsg.setCommand(command);
        List references = ReferenceCollectorVisitor.getReferences((LanguageObject)command);
        if (!(this.requestMsg.isCallableStatement() || this.requestMsg.isPreparedStatement() || references == null || references.isEmpty())) {
            throw new QueryValidatorException(DQPPlugin.Util.getString("Request.Invalid_character_in_query"));
        }
        this.initializeMetaData();
        this.decodeQueryOptions(command);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata, (AnalysisRecord)this.analysisRecord);
        if (!this.requestMsg.isTransactional() && AUTO_WRAP_OPTIMISTIC.equals(this.requestMsg.getTxnAutoWrapMode()) && command.updatingModelCount(this.metadata) > 1) {
            String msg = DQPPlugin.Util.getString("Request.txn_needed_wrong_mode", (Object)this.requestMsg.getRequestID());
            throw new MetaMatrixComponentException(msg);
        }
        this.collectReferences(command, references);
        this.resolveParameterValues();
        try {
            this.validateQuery(command, this.metadata);
        }
        catch (QueryMetadataException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        this.initCommandContext();
        if (!this.requestMsg.isTransactional() && AUTO_WRAP_OPTIMISTIC.equals(this.requestMsg.getTxnAutoWrapMode())) {
            this.context.setOptimisticTransaction(true);
        }
        this.rewriteQuery(command);
    }

    private synchronized void initializeMetaData() throws MetaMatrixComponentException {
        if (this.metadata == null) {
            this.metadata = this.getMetadataDirect((DQPInboundMessage)this.requestMsg);
            if (this.metadata == null) {
                Object[] params = new Object[]{this.vdbName, this.vdbVersion};
                String msg = DQPPlugin.Util.getString("DQPCore.Unable_to_load_metadata_for_VDB_name__{0},_version__{1}", params);
                MetaMatrixComponentException e = new MetaMatrixComponentException(msg);
                throw e;
            }
            if (this.tempTableStore != null) {
                this.metadata = this.tempTableStore.getMetadata(this.metadata);
            }
            this.metadata = new QueryMetadataWrapper(this.metadata, this.vdbName, this.vdbVersion, this.vdbService);
            this.multiSourceModels = this.vdbService.getMultiSourceModels(this.vdbName, this.vdbVersion);
            if (this.multiSourceModels != null && this.multiSourceModels.size() > 0) {
                this.multiSourceModels = new HashSet(this.multiSourceModels);
                this.metadata = new MultiSourceMetadataWrapper(this.metadata, this.multiSourceModels);
            } else {
                this.multiSourceModels = null;
            }
        }
    }

    private void rewriteQuery(Command command) throws MetaMatrixComponentException, QueryValidatorException {
        QueryCommand query;
        Command rewrittenCommand = QueryRewriter.rewrite(command, null, this.metadata, (CommandContext)this.context);
        if (this.requestMsg.getRowLimit() > 0 && rewrittenCommand instanceof QueryCommand && (query = (QueryCommand)rewrittenCommand).getLimit() == null) {
            query.setLimit(new Limit(null, (Expression)new Constant((Object)new Integer(this.requestMsg.getRowLimit()), DataTypeManager.DefaultDataClasses.INTEGER)));
        }
        this.requestMsg.setOriginalCommand(command);
        this.requestMsg.setCommand(rewrittenCommand);
    }

    static boolean usesUpdate(Command command) {
        GroupSymbol group;
        int type = command.getType();
        if (type == 2 || type == 3 || type == 4 || type == 9) {
            return true;
        }
        if (type == 1 && command instanceof Query && ((Query)command).getInto() != null && !(group = ((Query)command).getInto().getGroup()).isTempGroupSymbol()) {
            return true;
        }
        List subCommands = command.getSubCommands();
        if (subCommands != null && subCommands.size() > 0) {
            for (int i = 0; i < subCommands.size(); ++i) {
                if (!Request.usesUpdate((Command)subCommands.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsNonSystemVirtualTablesOrProcs(Command command) throws MetaMatrixComponentException, QueryMetadataException {
        List subCommands;
        int type = command.getType();
        if (type != 7 && type != 9 && type != 8) {
            if (type == 6) {
                StoredProcedure proc = (StoredProcedure)command;
                Object procModelID = proc.getModelID();
                if (this.metadata.isVirtualModel(procModelID) && !this.isSystemModel(this.metadata.getFullName(procModelID))) {
                    return true;
                }
            } else {
                Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
                Iterator i = groups.iterator();
                while (i.hasNext()) {
                    GroupSymbol group = (GroupSymbol)i.next();
                    Object groupID = group.getMetadataID();
                    if (groupID instanceof TempMetadataID || !this.metadata.isVirtualGroup(group.getMetadataID()) || this.isSystemGroup(group.getMetadataID())) continue;
                    return true;
                }
            }
        }
        if ((subCommands = command.getSubCommands()) != null && subCommands.size() > 0) {
            for (int i = 0; i < subCommands.size(); ++i) {
                if (!this.containsNonSystemVirtualTablesOrProcs((Command)subCommands.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSystemModel(String modelName) {
        return modelName.equals(SYSTEM_MODEL);
    }

    private boolean isSystemGroup(Object metadataID) throws MetaMatrixComponentException, QueryMetadataException {
        Object modelID = this.metadata.getModelID(metadataID);
        String fullName = this.metadata.getFullName(modelID);
        return this.isSystemModel(fullName);
    }

    private boolean containsXML(Command command) throws MetaMatrixComponentException, QueryMetadataException {
        int type = command.getType();
        if (type == 8) {
            return true;
        }
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            Object metadataID = ((GroupSymbol)i.next()).getMetadataID();
            if (metadataID instanceof TempMetadataID || !this.metadata.isXMLGroup(metadataID)) continue;
            return true;
        }
        List subCommands = command.getSubCommands();
        if (subCommands != null && subCommands.size() > 0) {
            for (int i2 = 0; i2 < subCommands.size(); ++i2) {
                if (!this.containsXML((Command)subCommands.get(i2))) continue;
                return true;
            }
        }
        return false;
    }

    private void checkUpdatesAllowed(Command rootCommand) throws MetaMatrixComponentException {
        boolean usesUpdate;
        if (!this.updatesAllowed && (usesUpdate = Request.usesUpdate(rootCommand))) {
            String message = DQPPlugin.Util.getString("Request.Updates_not_allowed_due_to_license_restriction._1");
            throw new MetaMatrixComponentException(message);
        }
    }

    private void checkVirtualLayerAllowed(Command rootCommand) throws MetaMatrixComponentException, QueryMetadataException {
        boolean containsVirtualEntities;
        if (!this.virtualLayerAllowed && (containsVirtualEntities = this.containsNonSystemVirtualTablesOrProcs(rootCommand))) {
            String message = DQPPlugin.Util.getString("Request.virtual_restricted");
            throw new MetaMatrixComponentException(message);
        }
    }

    private void checkXMLAllowed(Command rootCommand) throws MetaMatrixComponentException, QueryMetadataException {
        boolean containsXML;
        if (!this.xmlAllowed && (containsXML = this.containsXML(rootCommand))) {
            String message = DQPPlugin.Util.getString("Request.xml_restricted");
            throw new MetaMatrixComponentException(message);
        }
    }

    private void validateQuery(Command command, QueryMetadataInterface metadata) throws QueryValidatorException, MetaMatrixComponentException, QueryMetadataException {
        this.checkVirtualLayerAllowed(command);
        this.checkXMLAllowed(command);
        this.checkUpdatesAllowed(command);
        ValidationVisitor visitor = new ValidationVisitor();
        this.validateWithVisitor((AbstractValidationVisitor)visitor, metadata, command, false);
        visitor = new ValidateCriteriaVisitor();
        this.validateWithVisitor((AbstractValidationVisitor)visitor, metadata, command, true);
        visitor = new ModelVisibilityValidationVisitor(this.vdbService, this.vdbName, this.vdbVersion);
        this.validateWithVisitor((AbstractValidationVisitor)visitor, metadata, command, true);
        this.validateEntitlement(command);
    }

    protected Command getCommand() throws MetaMatrixComponentException, QueryParserException {
        Command commandObj = this.requestMsg.getCommand();
        ParseInfo parseInfo = this.getParseInfo();
        if (commandObj.getType() == 5) {
            QueryParser parser = new QueryParser();
            String sql = ((SQLQuery)commandObj).getQuery();
            return parser.parseCommand(sql, parseInfo);
        }
        if (commandObj.getType() == 9) {
            List updates = ((BatchedUpdateCommand)commandObj).getUpdateCommands();
            ArrayList<Command> parsedCommands = new ArrayList<Command>(updates.size());
            QueryParser parser = new QueryParser();
            SQLQuery updateCommand = null;
            for (int i = 0; i < updates.size(); ++i) {
                updateCommand = (SQLQuery)updates.get(i);
                String sql = updateCommand.getQuery();
                parsedCommands.add(parser.parseCommand(sql, parseInfo));
            }
            return new BatchedUpdateCommand(parsedCommands);
        }
        return null;
    }

    private ParseInfo getParseInfo() {
        ParseInfo info = new ParseInfo();
        if (this.requestMsg.isDoubleQuotedVariableAllowed()) {
            info.allowDoubleQuotedVariable = true;
        }
        return info;
    }

    protected void resolveParameterValues() throws QueryValidatorException {
    }

    protected void collectReferences(Command command, List references) {
    }

    protected void validateWithVisitor(AbstractValidationVisitor visitor, QueryMetadataInterface metadata, Command command, boolean validateOnlyEmbedded) throws QueryValidatorException, MetaMatrixComponentException {
        ValidatorReport report = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata, (AbstractValidationVisitor)visitor, (boolean)validateOnlyEmbedded);
        if (report.hasItems()) {
            ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
            throw new QueryValidatorException(firstFailure.getMessage());
        }
    }

    QueryMetadataInterface getMetadataDirect(DQPInboundMessage message) throws MetaMatrixComponentException {
        MetadataService metadataService = (MetadataService)this.env.findService("dqp.metadata");
        if (metadataService == null && (metadataService = (MetadataService)this.env.findService("dqp.metadata")) == null) {
            String msg = DQPPlugin.Util.getString("Request.MetadataServiceIsNull");
            throw new MetaMatrixComponentException(msg);
        }
        return metadataService.lookupMetadata(message.getVdbName(), message.getVdbVersion());
    }

    protected void processCommand() throws QueryPlannerException, MetaMatrixComponentException {
        this.context.setTupleSourceID(this.getTupleSourceID(this.requestMsg.getConnectionID()));
        QueryProcessor processor = new QueryProcessor(this.processPlan, (CommandContext)this.context, this.bufferManager, (ProcessorDataManager)new TempTableDataManager(this.processorDataManager, this.tempTableStore));
        RequestID reqID = this.requestMsg.getRequestID();
        this.registerWork(this.context.getTupleSourceID(), reqID, processor);
    }

    protected void initCommandContext() throws MetaMatrixComponentException {
        String groupName = this.requestMsg.getConnectionID();
        RequestID reqID = this.requestMsg.getRequestID();
        Properties envProps = this.env.getApplicationProperties();
        Properties props = this.createContextProps(this.env.getApplicationProperties());
        if (this.requestMsg.getConnectionID() != null) {
            props.setProperty("sessionid", this.requestMsg.getConnectionID());
        }
        this.context = new DQPProcessorContext(this.requestMsg.getClientConnection(), this.requestMsg.getMessageKey(), (Object)reqID, groupName, null, this.requestMsg.getFetchSize(), props, this.useProcDebug(), this.collectNodeStatistics(), this.requestMsg.getExecutionPayload());
        this.context.setProcessorBatchSize(this.bufferManager.getProcessorBatchSize());
        this.context.setConnectorBatchSize(this.bufferManager.getConnectorBatchSize());
        String streamingBatchSize = null;
        if (envProps != null) {
            streamingBatchSize = envProps.getProperty("metamatrix.server.streamingBatchSize");
        }
        if (streamingBatchSize != null) {
            this.context.setStreamingBatchSize(Integer.parseInt(streamingBatchSize));
        }
        if (this.multiSourceModels != null) {
            MultiSourcePlanModifier modifier = new MultiSourcePlanModifier();
            modifier.setVdbName(this.vdbName);
            modifier.setVdbVersion(this.vdbVersion);
            modifier.setVdbService(this.vdbService);
            modifier.setIdGenerator(this.idGenerator);
            modifier.setMultiSourceModels(this.multiSourceModels);
            this.context.setMultiSourcePlanModifier((Object)modifier);
        }
        this.context.setSecurityFunctionEvaluator((SecurityFunctionEvaluator)this.env.findService("dqp.authorization"));
    }

    private boolean useProcDebug() {
        Option option;
        Command command;
        if (this.procDebugAllowed && (command = this.requestMsg.getCommand()) != null && (option = command.getOption()) != null) {
            return option.getDebug();
        }
        return false;
    }

    private boolean collectNodeStatistics() {
        Option option;
        if (this.requestMsg.getShowPlan()) {
            return true;
        }
        Command command = this.requestMsg.getCommand();
        if (command != null && (option = command.getOption()) != null) {
            return option.getDebug() || option.getShowPlan();
        }
        return false;
    }

    private Properties createContextProps(Properties envProps) {
        Properties contextProps = new Properties();
        return contextProps;
    }

    private void registerWork(TupleSourceID tsID, RequestID reqID, QueryProcessor processor) throws MetaMatrixComponentException {
        try {
            this.requestMgr.addRequest(this.requestMsg, this.requestMsg.getOriginalCommand(), processor, tsID, this.analysisRecord);
            if (this.schemas != null) {
                this.requestMgr.setSchemas(reqID, this.schemas);
            }
            this.processWorkerPool.addWork((Object)new WorkItem(reqID));
        }
        catch (QueueSuspendedException e) {
            this.requestMgr.removeRequest(reqID);
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    private TupleSourceID getTupleSourceID(String groupName) throws MetaMatrixComponentException {
        List outputElements = this.processPlan.getOutputElements();
        return this.bufferManager.createTupleSource(outputElements, TypeRetrievalUtil.getTypeNames((List)outputElements), groupName, 2);
    }

    protected void generatePlan() throws MetaMatrixComponentException, QueryPlannerException {
        Command command = this.requestMsg.getCommand();
        this.resetPlanFields();
        try {
            ProcessorPlan plan;
            Collection procChildPlans;
            Collection childPlans;
            this.initProcessPlan(command);
            this.savePlanTreeIfNecessary();
            XMLPlan xmlPlan = null;
            if (this.processPlan instanceof XMLPlan) {
                xmlPlan = (XMLPlan)this.processPlan;
            } else if (this.processPlan instanceof XQueryPlan) {
                ((XQueryPlan)this.processPlan).setXMLFormat(this.requestMsg.getXMLFormat());
            } else if (command instanceof StoredProcedure && !(childPlans = this.processPlan.getChildPlans()).isEmpty() && (procChildPlans = (plan = (ProcessorPlan)childPlans.iterator().next()).getChildPlans()).size() > 0) {
                Iterator iter = procChildPlans.iterator();
                ProcessorPlan lastPlan = null;
                while (iter.hasNext()) {
                    lastPlan = (ProcessorPlan)iter.next();
                }
                if (lastPlan instanceof XMLPlan) {
                    xmlPlan = (XMLPlan)lastPlan;
                }
            }
            if (xmlPlan != null) {
                this.handleXmlPlan(xmlPlan, this.metadata);
            }
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("BasicInterceptor.ProcessTree_for__4"), this.requestMsg.getRequestID(), this.processPlan});
            this.addedProcessPlan();
        }
        catch (QueryMetadataException e) {
            Object[] params = new Object[]{this.requestMsg.getRequestID()};
            String msg = DQPPlugin.Util.getString("DQPCore.Unknown_query_metadata_exception_while_registering_query__{0}.", params);
            QueryPlannerException e2 = new QueryPlannerException((Throwable)e, msg);
            throw e2;
        }
    }

    private void resetPlanFields() {
        this.processPlan = null;
        this.schemas = null;
    }

    private void handleXmlPlan(XMLPlan xmlPlan, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        boolean shouldValidate = this.requestMsg.getValidationMode();
        xmlPlan.setShouldValidate(shouldValidate);
        xmlPlan.setStylesheet(this.requestMsg.getStyleSheet());
        xmlPlan.setXMLFormat(this.requestMsg.getXMLFormat());
        if (shouldValidate) {
            this.validateXmlSchema(xmlPlan.getDocumentGroup(), metadata, xmlPlan);
        }
    }

    private void validateXmlSchema(GroupSymbol group, QueryMetadataInterface metadata, XMLPlan xmlPlan) throws MetaMatrixComponentException, QueryMetadataException {
        this.schemas = metadata.getXMLSchemas(group.getMetadataID());
        xmlPlan.setXMLSchemas(this.schemas);
    }

    private void savePlanTreeIfNecessary() {
        if (this.analysisRecord.recordQueryPlan()) {
            this.analysisRecord.setQueryPlan(this.processPlan.getDescriptionProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProcessPlan(Command command) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ConnectorCapabilitiesFinder baseFinder = new ConnectorCapabilitiesFinder(this.vdbService, (DataService)this.env.findService("dqp.data"), this.requestMsg);
        SharedCachedFinder cachedFinder = new SharedCachedFinder((CapabilitiesFinder)baseFinder, this.connectorCapabilitiesCache);
        if (this.multiSourceModels != null) {
            cachedFinder = new MultiSourceCapabilitiesFinder((CapabilitiesFinder)cachedFinder, this.multiSourceModels);
        }
        try {
            this.processPlan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)this.metadata, (IDGenerator)this.idGenerator, (CapabilitiesFinder)cachedFinder, (AnalysisRecord)this.analysisRecord, (CommandContext)this.context);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            String debugLog = this.analysisRecord.getDebugLog();
            if (debugLog != null && debugLog.length() > 0) {
                System.out.println(debugLog);
            }
            throw throwable;
        }
        String debugLog = this.analysisRecord.getDebugLog();
        if (debugLog != null && debugLog.length() > 0) {
            System.out.println(debugLog);
        }
        if (this.multiSourceModels != null) {
            MultiSourcePlanModifier modifier = (MultiSourcePlanModifier)this.context.getMultiSourcePlanModifier();
            modifier.modifyPlan(this.processPlan, this.metadata);
        }
    }

    private void decodeQueryOptions(Command command) throws QueryValidatorException {
        Option option = command.getOption();
        boolean getPlan = this.requestMsg.getShowPlan();
        boolean debug = false;
        if (option != null) {
            getPlan = getPlan || option.getShowPlan() || option.getPlanOnly();
            debug = option.getDebug();
        }
        if (getPlan && !this.requestMsg.isQueryPlanAllowed()) {
            String message = DQPPlugin.Util.getString("Request.query_plan_not_allowed");
            throw new QueryValidatorException(message);
        }
        this.analysisRecord = new AnalysisRecord(getPlan, getPlan, debug);
    }

    protected void addedProcessPlan() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest() throws QueryValidatorException, QueryParserException, QueryResolverException, MetaMatrixComponentException, QueryPlannerException {
        block5: {
            block4: {
                try {
                    if (this.hasResultsInCache()) {
                        this.validateEntitlement(this.requestMsg.getCommand());
                        this.useResultsInCache();
                        Object var2_1 = null;
                        break block4;
                    }
                    if (this.requestMsg.isTransactional()) {
                        this.createAndExportTxn();
                    }
                    this.prepareCommand();
                    this.generatePlan();
                    this.processCommand();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    if (!this.requestMsg.isTransactional()) throw throwable;
                    if (this.threadSuspended) throw throwable;
                    if (this.requestMsg.getTransactionContext() == null) throw throwable;
                    this.suspendTransaction();
                    throw throwable;
                }
            }
            if (!this.requestMsg.isTransactional()) return;
            if (this.threadSuspended) return;
            if (this.requestMsg.getTransactionContext() == null) return;
            this.suspendTransaction();
            return;
        }
        Object var2_2 = null;
        if (!this.requestMsg.isTransactional()) return;
        if (this.threadSuspended) return;
        if (this.requestMsg.getTransactionContext() == null) return;
        this.suspendTransaction();
    }

    protected void validateEntitlement(Command command) throws QueryValidatorException, MetaMatrixComponentException {
        this.initializeMetaData();
        AuthorizationService authSvc = (AuthorizationService)this.env.findService("dqp.authorization");
        if (authSvc != null && authSvc.checkingEntitlements()) {
            AuthorizationValidationVisitor visitor = new AuthorizationValidationVisitor(this.requestMsg.getConnectionID(), authSvc);
            if (command.getType() == 8) {
                Iterator iter = command.getSubCommands().iterator();
                while (iter.hasNext()) {
                    this.validateWithVisitor((AbstractValidationVisitor)visitor, this.metadata, (Command)iter.next(), true);
                }
            } else {
                this.validateWithVisitor((AbstractValidationVisitor)visitor, this.metadata, command, true);
            }
        }
    }

    protected void createAndExportTxn() throws MetaMatrixComponentException {
        TransactionContext txnContext = null;
        try {
            if (this.requestMsg.getTransactionXid() != null) {
                txnContext = this.transactionService.getXAServer().resume(this.requestMsg.getTransactionXid());
                this.threadSuspended = false;
            } else {
                txnContext = this.transactionService.getTransactionManager().resumeTransaction(this.requestMsg.getUserTransactionId());
                this.threadSuspended = false;
            }
            this.requestMsg.setTransactionContext(txnContext);
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.resume", (Object)txnContext.toString())});
        }
        catch (XATransactionException e) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.resume", (Object)this.requestMsg.getRequestID());
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
        catch (XAException e) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.resume", (Object)this.requestMsg.getRequestID());
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
        catch (RemoteException e) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.resume", (Object)this.requestMsg.getRequestID());
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
        try {
            this.transactionService.getTransactionManager().exportTransaction(txnContext);
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.export", (Object)txnContext.toString())});
        }
        catch (XATransactionException e) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.export", (Object)this.requestMsg.getRequestID());
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
        try {
            this.transactionService.getTransactionManager().suspendTransaction(txnContext);
            this.threadSuspended = true;
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.suspend", (Object)txnContext.toString())});
        }
        catch (XATransactionException e) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.suspend", (Object)this.requestMsg.getRequestID());
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
    }

    protected void suspendTransaction() throws MetaMatrixComponentException {
        try {
            this.transactionService.getTransactionManager().suspendTransaction(this.requestMsg.getTransactionContext());
            this.threadSuspended = true;
            LogManager.logDetail((String)"DQP", (Object[])new Object[]{DQPPlugin.Util.getString("Request.txn.info.suspend", (Object)this.requestMsg.getTransactionContext().toString())});
        }
        catch (XATransactionException e) {
            String msg = DQPPlugin.Util.getString("Request.txn.err.suspend", (Object)this.requestMsg.getRequestID());
            throw new MetaMatrixComponentException((Throwable)e, msg);
        }
    }

    protected boolean hasResultsInCache() {
        if (this.rsCache == null) {
            return false;
        }
        if (!this.requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)this.requestMsg, (ResultSetCache)this.rsCache);
        return this.rsCache.hasResults(cID);
    }

    protected void useResultsInCache() throws MetaMatrixComponentException {
        this.requestMsg.markProcessingStart();
        RequestID reqID = this.requestMsg.getRequestID();
        try {
            CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)this.requestMsg, (ResultSetCache)this.rsCache);
            Command command = this.rsCache.getResults(cID, new int[]{1, 1}).getCommand();
            this.requestMgr.addRequest(this.requestMsg, command, null, null, this.analysisRecord);
            this.requestMgr.setSchemas(reqID, this.schemas);
            this.processWorkerPool.addWork((Object)new WorkItem(reqID, this.rsCache));
        }
        catch (QueueSuspendedException e) {
            this.requestMgr.removeRequest(reqID);
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }
}

