/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.util;

import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDiagramHelper
implements DiagramUiConstants {
    private static final long MAX_PRINTABLE_DIAGRAM_SIZE = 81000000L;
    private static final int COLOR_DEPTH = 16;

    protected static Shell getShell() {
        return DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    public static Image getImage(Rectangle rectFullDiagram) {
        Image image = null;
        boolean bContinue = PrintDiagramHelper.checkDiagramSize(rectFullDiagram);
        if (!bContinue) {
            return image;
        }
        Display display = Display.getDefault();
        System.gc();
        ImageData imageData = new ImageData(10, 10, 16, new PaletteData(255, 65280, 0xFF0000));
        ImageData scaledIData = imageData.scaledTo(rectFullDiagram.width, rectFullDiagram.height);
        image = new Image((Device)display, scaledIData);
        return image;
    }

    public static boolean checkDiagramSize(Rectangle rect) {
        long lRectangleSize = rect.width * rect.height;
        if (lRectangleSize > 81000000L) {
            String sMessage = DiagramUiConstants.Util.getString("PrintDiagramWarningDialog1.message", 81000000L) + DiagramUiConstants.Util.getString("PrintDiagramWarningDialog2.message", lRectangleSize);
            MessageDialog.openWarning((Shell)PrintDiagramHelper.getShell(), (String)DiagramUiConstants.Util.getString("PrintDiagramWarningDialog.title"), (String)sMessage);
            return false;
        }
        return true;
    }
}

