/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xquery;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.XMLType;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.jdbc.SQLXML;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.processor.BaseProcessorPlan;
import com.metamatrix.query.processor.DescribableUtil;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.dynamic.SqlEval;
import com.metamatrix.query.processor.xml.XMLUtil;
import com.metamatrix.query.sql.lang.XQuery;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.xquery.XQueryExpression;
import com.metamatrix.query.xquery.XQuerySQLEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class XQueryPlan
extends BaseProcessorPlan
implements ProcessorPlan {
    private XQuery xQuery;
    private BufferManager bufferMgr;
    private ProcessorDataManager dataMgr;
    private QueryProcessor internalProcessor;
    private String xmlFormat;
    private QueryMetadataInterface metadata;
    private CapabilitiesFinder finder;
    private IDGenerator generator;
    private int chunkSize = 102400;
    TupleSourceID resultsTupleSourceId = null;

    public XQueryPlan(XQuery xQuery, QueryMetadataInterface metadata, CapabilitiesFinder finder, IDGenerator generator) {
        this.xQuery = xQuery;
        this.metadata = metadata;
        this.finder = finder;
        this.generator = generator;
    }

    public void reset() {
        super.reset();
        this.internalProcessor = null;
    }

    public Object clone() {
        XQuery clonedQuery = (XQuery)this.xQuery.clone();
        return new XQueryPlan(clonedQuery, this.metadata, this.finder, this.generator);
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
        if (context.getStreamingBatchSize() != 0) {
            this.chunkSize = context.getStreamingBatchSize() * 1024;
        }
    }

    public boolean connectTupleSource(TupleSource source, int dataRequestID) {
        return this.internalProcessor.connectTupleSource(source, dataRequestID);
    }

    public boolean canHandleData(int dataRequestID) {
        return true;
    }

    public List getOutputElements() {
        ArrayList<ElementSymbol> output = new ArrayList<ElementSymbol>(1);
        ElementSymbol xml = new ElementSymbol("xml");
        xml.setType(DataTypeManager.DefaultDataClasses.XML);
        output.add(xml);
        return output;
    }

    public void open() throws MetaMatrixComponentException {
        if (this.resultsTupleSourceId == null) {
            this.resultsTupleSourceId = XMLUtil.createXMLTupleSource((BufferManager)this.bufferMgr, (String)this.getContext().getConnectionID());
        }
    }

    public TupleBatch nextBatch() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        return this.evaluateXQuery();
    }

    private TupleBatch evaluateXQuery() throws MetaMatrixComponentException, MetaMatrixProcessingException {
        XQueryExpression expr = this.xQuery.getCompiledXQuery();
        expr.setXMLFormat(this.xmlFormat);
        SqlEval sqlEval = new SqlEval(this.metadata, this.getContext(), this.finder, this.generator, this.bufferMgr, this.dataMgr);
        SQLXML xml = expr.evaluateXQuery((XQuerySQLEvaluator)sqlEval);
        sqlEval.close();
        TupleBatch batch = this.packResultsIntoBatch(xml);
        return batch;
    }

    Properties getFormatProperties() {
        Properties props = new Properties();
        if ("Tree".equals(this.xmlFormat)) {
            props.setProperty("indent", "yes");
        }
        return props;
    }

    private TupleBatch packResultsIntoBatch(SQLXML srcXML) throws MetaMatrixComponentException {
        try {
            ArrayList rows = new ArrayList(1);
            ArrayList<XMLType> row = new ArrayList<XMLType>(1);
            TupleSourceID savedId = XMLUtil.saveToBufferManager((BufferManager)this.bufferMgr, (String)this.resultsTupleSourceId.getStringID(), (SQLXML)srcXML, (int)this.chunkSize);
            XMLType xml = new XMLType(srcXML);
            xml.setPersistenceStreamId(savedId.getStringID());
            row.add(xml);
            rows.add(row);
            TupleBatch batch = new TupleBatch(1, rows);
            batch.setTerminationFlag(true);
            this.bufferMgr.addTupleBatch(this.resultsTupleSourceId, batch);
            this.bufferMgr.setStatus(this.resultsTupleSourceId, 2);
            return batch;
        }
        catch (TupleSourceNotFoundException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    public void close() throws MetaMatrixComponentException {
        if (this.resultsTupleSourceId != null) {
            try {
                this.bufferMgr.removeTupleSource(this.resultsTupleSourceId);
            }
            catch (TupleSourceNotFoundException tupleSourceNotFoundException) {
                // empty catch block
            }
            this.resultsTupleSourceId = null;
        }
    }

    public Map getDescriptionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", "XQuery Plan");
        ArrayList children = new ArrayList();
        props.put("children", children);
        props.put("outputCols", DescribableUtil.getOutputColumnProperties((List)this.getOutputElements()));
        return props;
    }

    public String toString() {
        return "XQueryPlan: " + this.xQuery.toString();
    }

    public Collection getChildPlans() {
        return Collections.EMPTY_LIST;
    }

    public void setXMLFormat(String xmlFormat) {
        this.xmlFormat = xmlFormat;
    }
}

