/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.soap;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;

public class SOAPValidator
implements IWSDL11Validator {
    private static String SOAP_RESOURCE_BUNDLE_NAME = "validatewsdlsoap";
    private final String _ERROR_INVALID_PORT_ELEMENT = "_ERROR_INVALID_PORT_ELEMENT";
    private final String _ERROR_INVALID_BINDING_ELEMENT = "_ERROR_INVALID_BINDING_ELEMENT";
    private final String _ERROR_INVALID_BINDING_OPERATION_ELEMENT = "_ERROR_INVALID_BINDING_OPERATION_ELEMENT";
    private final String _ERROR_INVALID_HEADER_BODY_ELEMENT = "_ERROR_INVALID_HEADER_BODY_ELEMENT";
    private final String _ERROR_INVALID_FAULT_ELEMENT = "_ERROR_INVALID_FAULT_ELEMENT";
    private final String _ERROR_INVALID_SOAP_ELEMENT_FOR_LOCATION = "_ERROR_INVALID_SOAP_ELEMENT_FOR_LOCATION";
    private final String _ERROR_NO_LOCATION_FOR_ADDRESS = "_ERROR_NO_LOCATION_FOR_ADDRESS";
    private final String _ERROR_NO_SOAPBINDING_FOR_ADDRESS = "_ERROR_NO_SOAPBINDING_FOR_ADDRESS";
    private final String _ERROR_INVALID_BINDING_STYLE = "_ERROR_INVALID_BINDING_STYLE";
    private final String _ERROR_INVALID_BINDING_URI = "_ERROR_INVALID_BINDING_URI";
    private final String _ERROR_INVALID_OPERATION_STYLE = "_ERROR_INVALID_OPERATION_STYLE";
    private final String _ERROR_NO_SOAPBINDING_FOR_OPERATION = "_ERROR_NO_SOAPBINDING_FOR_OPERATION";
    private final String _ERROR_INVALID_BODY_ENCODING_STYLE = "_ERROR_INVALID_BODY_ENCODING_STYLE";
    private final String _ERROR_INVALID_BODY_USE = "_ERROR_INVALID_BODY_USE";
    private final String _ERROR_INVALID_BODY_PART_NOT_TYPE = "_ERROR_INVALID_BODY_PART_NOT_TYPE";
    private final String _ERROR_INVALID_BODY_PART_UNDEFINED = "_ERROR_INVALID_BODY_PART_UNDEFINED";
    private final String _ERROR_NO_SOAPBINDING_FOR_BODY = "_ERROR_NO_SOAPBINDING_FOR_BODY";
    private final String _ERROR_HEADER_MESSAGE_UNDEFINED = "_ERROR_HEADER_MESSAGE_UNDEFINED";
    private final String _ERROR_HEADER_PART_UNDEFINED = "_ERROR_HEADER_PART_UNDEFINED";
    private final String _ERROR_HEADER_USE_UNDEFINED = "_ERROR_HEADER_USE_UNDEFINED";
    private final String _ERROR_HEADER_ENCODINGSTYLE_UNDEFINED = "_ERROR_HEADER_ENCODINGSTYLE_UNDEFINED";
    private final String _ERROR_HEADER_NAMESPACE_UNDEFINED = "_ERROR_HEADER_NAMESPACE_UNDEFINED";
    private final String _ERROR_NO_SOAPBINDING_FOR_HEADER = "_ERROR_NO_SOAPBINDING_FOR_HEADER";
    private final String _ERROR_HEADERFAULT_MESSAGE_UNDEFINED = "_ERROR_HEADERFAULT_MESSAGE_UNDEFINED";
    private final String _ERROR_HEADERFAULT_PART_UNDEFINED = "_ERROR_HEADERFAULT_PART_UNDEFINED";
    private final String _ERROR_HEADERFAULT_USE_UNDEFINED = "_ERROR_HEADERFAULT_USE_UNDEFINED";
    private final String _ERROR_HEADERFAULT_ENCODINGSTYLE_UNDEFINED = "_ERROR_HEADERFAULT_ENCODINGSTYLE_UNDEFINED";
    private final String _ERROR_HEADERFAULT_NAMESPACE_UNDEFINED = "_ERROR_HEADERFAULT_NAMESPACE_UNDEFINED";
    private final String _ERROR_INVALID_FAULT_NAME = "_ERROR_INVALID_FAULT_NAME";
    private final String ENCODED = "encoded";
    private final String LITERAL = "literal";
    private final String RPC = "rpc";
    private final String DOCUMENT = "document";
    private final String QUOTE = "'";
    private final String EMPTY_STRING = "";
    protected MessageGenerator messagegenerator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public SOAPValidator() {
        ResourceBundle rb = ResourceBundle.getBundle(SOAP_RESOURCE_BUNDLE_NAME, Locale.getDefault());
        this.messagegenerator = new MessageGenerator(rb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        block66: {
            block65: {
                Class<?> clazz = parents.get(0).getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("com.ibm.wsdl.PortImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    Class<?> clazz3 = element.getClass();
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("com.ibm.wsdl.extensions.soap.SOAPAddressImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz3 == clazz4) {
                        this.validateAddress(element, parents, valInfo);
                        return;
                    } else {
                        ExtensibilityElement e = (ExtensibilityElement)element;
                        valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_PORT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
                    }
                    return;
                }
                Class<?> clazz5 = parents.get(0).getClass();
                Class<?> clazz6 = class$2;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$2 = Class.forName("com.ibm.wsdl.BindingImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz5 == clazz6) {
                    Class<?> clazz7 = element.getClass();
                    Class<?> clazz8 = class$3;
                    if (clazz8 == null) {
                        try {
                            clazz8 = class$3 = Class.forName("com.ibm.wsdl.extensions.soap.SOAPBindingImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz7 == clazz8) {
                        this.validateBinding(element, parents, valInfo);
                        return;
                    } else {
                        ExtensibilityElement e = (ExtensibilityElement)element;
                        valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
                    }
                    return;
                }
                Class<?> clazz9 = parents.get(0).getClass();
                Class<?> clazz10 = class$4;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$4 = Class.forName("com.ibm.wsdl.BindingOperationImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz9 == clazz10) {
                    Class<?> clazz11 = element.getClass();
                    Class<?> clazz12 = class$5;
                    if (clazz12 == null) {
                        try {
                            clazz12 = class$5 = Class.forName("com.ibm.wsdl.extensions.soap.SOAPOperationImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz11 == clazz12) {
                        this.validateOperation(element, parents, valInfo);
                        return;
                    } else {
                        ExtensibilityElement e = (ExtensibilityElement)element;
                        valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_OPERATION_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
                    }
                    return;
                }
                Class<?> clazz13 = parents.get(0).getClass();
                Class<?> clazz14 = class$6;
                if (clazz14 == null) {
                    try {
                        clazz14 = class$6 = Class.forName("com.ibm.wsdl.BindingInputImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz13 == clazz14) break block65;
                Class<?> clazz15 = parents.get(0).getClass();
                Class<?> clazz16 = class$7;
                if (clazz16 == null) {
                    try {
                        clazz16 = class$7 = Class.forName("com.ibm.wsdl.BindingOutputImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz15 != clazz16) break block66;
            }
            Class<?> clazz = element.getClass();
            Class<?> clazz17 = class$8;
            if (clazz17 == null) {
                try {
                    clazz17 = class$8 = Class.forName("com.ibm.wsdl.extensions.soap.SOAPBodyImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz17) {
                this.validateBody(element, parents, valInfo);
                return;
            }
            Class<?> clazz18 = element.getClass();
            Class<?> clazz19 = class$9;
            if (clazz19 == null) {
                try {
                    clazz19 = class$9 = Class.forName("com.ibm.wsdl.extensions.soap.SOAPHeaderImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz18 == clazz19) {
                this.validateHeader(element, parents, valInfo);
                return;
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_HEADER_BODY_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
            return;
        }
        Class<?> clazz = parents.get(0).getClass();
        Class<?> clazz20 = class$10;
        if (clazz20 == null) {
            try {
                clazz20 = class$10 = Class.forName("com.ibm.wsdl.BindingFaultImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz20) {
            Class<?> clazz21 = element.getClass();
            Class<?> clazz22 = class$11;
            if (clazz22 == null) {
                try {
                    clazz22 = class$11 = Class.forName("com.ibm.wsdl.extensions.soap.SOAPFaultImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz21 == clazz22) {
                this.validateFault(element, parents, valInfo);
                return;
            } else {
                ExtensibilityElement e = (ExtensibilityElement)element;
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_FAULT_ELEMENT", "'" + e.getElementType().getLocalPart() + "'"), element);
            }
            return;
        }
        ExtensibilityElement e = (ExtensibilityElement)element;
        valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_SOAP_ELEMENT_FOR_LOCATION", "'" + e.getElementType().getLocalPart() + "'"), element);
    }

    protected void validateAddress(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Port port;
        Binding binding;
        SOAPAddressImpl sa = (SOAPAddressImpl)element;
        String uri = sa.getLocationURI();
        if (uri == null || uri.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_LOCATION_FOR_ADDRESS"), sa);
        }
        if (!this.hasSoapBinding(binding = (port = (Port)parents.get(0)).getBinding())) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_ADDRESS", "'" + binding.getQName().getLocalPart() + "'", "'" + port.getName() + "'"), sa);
        }
    }

    protected void validateBinding(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        SOAPBindingImpl sb = (SOAPBindingImpl)element;
        String style = sb.getStyle();
        String uri = sb.getTransportURI();
        if (style != null && !style.equalsIgnoreCase("rpc") && !style.equalsIgnoreCase("document")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_STYLE", "'" + sb.getStyle() + "'"), element);
        }
        if (uri.equalsIgnoreCase("")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BINDING_URI"), element);
        }
    }

    protected void validateOperation(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        SOAPOperation so = (SOAPOperation)element;
        String soapStyle = so.getStyle();
        if (soapStyle != null && !soapStyle.equalsIgnoreCase("rpc") && !soapStyle.equalsIgnoreCase("document")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_OPERATION_STYLE"), element);
        }
        if (!this.hasSoapBinding(binding = (Binding)parents.get(1))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_OPERATION", "'" + binding.getQName().getLocalPart() + "'"), so);
        }
    }

    protected void validateBody(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        List parts;
        SOAPBodyImpl sb = (SOAPBodyImpl)element;
        String use = sb.getUse();
        if (use != null && use.equalsIgnoreCase("encoded")) {
            List encodingStyles = sb.getEncodingStyles();
            if (encodingStyles == null || encodingStyles.size() == 0) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_ENCODING_STYLE"), sb);
            }
        } else if (use != null && !use.equalsIgnoreCase("literal")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_USE", "'" + use + "'"), sb);
        }
        if ((parts = sb.getParts()) != null) {
            Iterator partsIterator = parts.iterator();
            while (partsIterator.hasNext()) {
                String part = (String)partsIterator.next();
                BindingOperation bo = (BindingOperation)parents.get(1);
                Operation o = bo.getOperation();
                if (o != null && !o.isUndefined()) {
                    Message mess = null;
                    Class<?> clazz = parents.get(0).getClass();
                    Class<?> clazz2 = class$6;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("com.ibm.wsdl.BindingInputImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz2) {
                        Input input = o.getInput();
                        if (input != null) {
                            mess = input.getMessage();
                        }
                    } else {
                        Output output;
                        Class<?> clazz3 = parents.get(0).getClass();
                        Class<?> clazz4 = class$7;
                        if (clazz4 == null) {
                            try {
                                clazz4 = Class.forName("com.ibm.wsdl.BindingOutputImpl");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz3 == clazz4 && (output = o.getOutput()) != null) {
                            mess = output.getMessage();
                        }
                    }
                    if (mess != null && !mess.isUndefined()) {
                        Part p = mess.getPart(part);
                        if (p != null) {
                            if (use == null || !use.equalsIgnoreCase("encoded") || p.getTypeName() != null) continue;
                            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_NOT_TYPE", "'" + part + "'"), sb);
                            continue;
                        }
                        valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_UNDEFINED", "'" + part + "'"), sb);
                        continue;
                    }
                    valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_UNDEFINED", "'" + part + "'"), sb);
                    continue;
                }
                valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_BODY_PART_UNDEFINED", "'" + part + "'"), sb);
            }
        }
        if (!this.hasSoapBinding(binding = (Binding)parents.get(2))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_BODY", "'" + binding.getQName().getLocalPart() + "'"), sb);
        }
    }

    protected void validateHeader(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        Binding binding;
        List headerFaults;
        SOAPHeaderImpl soapHeader = (SOAPHeaderImpl)element;
        QName messageQName = soapHeader.getMessage();
        Message message = ((Definition)parents.get(parents.size() - 1)).getMessage(messageQName);
        if (message == null) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_MESSAGE_UNDEFINED", "'" + messageQName.getLocalPart() + "'"), soapHeader);
        } else {
            String partname = soapHeader.getPart();
            Part part = message.getPart(partname);
            if (part == null) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_PART_UNDEFINED", "'" + partname + "'", "'" + messageQName.getLocalPart() + "'"), soapHeader);
            }
        }
        String use = soapHeader.getUse();
        if (use != null && !use.equalsIgnoreCase("literal") && !use.equalsIgnoreCase("encoded")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_USE_UNDEFINED", "'" + use + "'"), soapHeader);
        }
        if (use.equalsIgnoreCase("encoded")) {
            String namespace;
            List encodingStyles = soapHeader.getEncodingStyles();
            if (encodingStyles == null || encodingStyles.isEmpty()) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_ENCODINGSTYLE_UNDEFINED"), soapHeader);
            }
            if ((namespace = soapHeader.getNamespaceURI()) == null || namespace.equalsIgnoreCase("")) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADER_NAMESPACE_UNDEFINED"), soapHeader);
            }
        }
        if ((headerFaults = soapHeader.getSOAPHeaderFaults()) != null) {
            Iterator iheaderFaults = headerFaults.iterator();
            while (iheaderFaults.hasNext()) {
                this.validateHeaderFault(iheaderFaults.next(), parents, valInfo);
            }
        }
        if (!this.hasSoapBinding(binding = (Binding)parents.get(2))) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_NO_SOAPBINDING_FOR_HEADER", "'" + binding.getQName().getLocalPart() + "'"), soapHeader);
        }
    }

    protected void validateHeaderFault(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        SOAPHeaderFaultImpl soapHeaderFault = (SOAPHeaderFaultImpl)element;
        QName messageQName = soapHeaderFault.getMessage();
        Message message = ((Definition)parents.get(parents.size() - 1)).getMessage(messageQName);
        if (message == null) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_MESSAGE_UNDEFINED", "'" + messageQName.getLocalPart() + "'"), soapHeaderFault);
        } else {
            String partname = soapHeaderFault.getPart();
            Part part = message.getPart(partname);
            if (part == null) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_PART_UNDEFINED", "'" + partname + "'", "'" + messageQName.getLocalPart() + "'"), soapHeaderFault);
            }
        }
        String use = soapHeaderFault.getUse();
        if (use != null && !use.equalsIgnoreCase("literal") && !use.equalsIgnoreCase("encoded")) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_USE_UNDEFINED", "'" + use + "'"), soapHeaderFault);
        }
        if (use.equalsIgnoreCase("encoded")) {
            String namespace;
            List encodingStyles = soapHeaderFault.getEncodingStyles();
            if (encodingStyles == null || encodingStyles.isEmpty()) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_ENCODINGSTYLE_UNDEFINED"), soapHeaderFault);
            }
            if ((namespace = soapHeaderFault.getNamespaceURI()) == null || namespace.equalsIgnoreCase("")) {
                valInfo.addError(this.messagegenerator.getString("_ERROR_HEADERFAULT_NAMESPACE_UNDEFINED"), soapHeaderFault);
            }
        }
    }

    protected void validateFault(Object element, List parents, IWSDL11ValidationInfo valInfo) {
        String parentName;
        SOAPFaultImpl fault = (SOAPFaultImpl)element;
        String name = fault.getName();
        if (!name.equals(parentName = ((BindingFault)parents.get(0)).getName())) {
            valInfo.addError(this.messagegenerator.getString("_ERROR_INVALID_FAULT_NAME", "'" + name + "'", "'" + parentName + "'"), fault);
        }
    }

    protected boolean hasSoapBinding(Binding binding) {
        List extelems;
        if (binding != null && (extelems = binding.getExtensibilityElements()) != null) {
            Iterator iextelems = extelems.iterator();
            while (iextelems.hasNext()) {
                Class<?> clazz = iextelems.next().getClass();
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("com.ibm.wsdl.extensions.soap.SOAPBindingImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) continue;
                return true;
            }
        }
        return false;
    }
}

