/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.relationship.ui.util;

import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.relationship.ui.textimport.RelationshipTableRowObject;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.transformation.ui.actions.TransformationSourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;

public class SqlDependencyRelationshipHelper {
    private static final String TO_STRING = "_TO_";
    private static final String DEFAULT_NAME = "NewRelationship";
    private static final String NAME_PREFIX = "REL";
    private static final String DEFAULT_REL_TYPE = "Transformation";
    private static final String BLANK_STR = "";
    public static final int ALL_LEVELS = -1;
    private Collection targetTables;
    private Object location;
    private String locationStr;
    private String relType = "Transformation";
    private int relCount = 0;
    private boolean createTableRelationships = true;
    private boolean createColumnRelationships = true;
    private boolean createAllColumnRelationships = true;
    private boolean autoGenerateNames = true;
    private List relRowStrings = new ArrayList();
    private List tableDependencies = new ArrayList();
    private int nLevels = -1;
    private int maxLevels = 0;

    public SqlDependencyRelationshipHelper(Collection targetTables, Object location, String relType, boolean createTableRels, boolean createColumnRels, boolean createAllColumnRels, boolean autoGenNames, int nLevels) {
        this.targetTables = targetTables;
        this.location = location;
        this.relType = relType;
        this.createTableRelationships = createTableRels;
        this.createColumnRelationships = createColumnRels;
        this.createAllColumnRelationships = createAllColumnRels;
        this.autoGenerateNames = autoGenNames;
        this.nLevels = nLevels;
        this.loadTableDependencies();
    }

    public SqlDependencyRelationshipHelper(Collection targetTables) {
        this.targetTables = targetTables;
        this.loadTableDependencies();
    }

    public void setOptions(Object location, String relType, boolean createTableRels, boolean createColumnRels, boolean createAllColumnRels, boolean autoGenNames, int nLevels) {
        this.location = location;
        this.setRelationshipLocation();
        this.relType = relType;
        this.createTableRelationships = createTableRels;
        this.createColumnRelationships = createColumnRels;
        this.createAllColumnRelationships = createAllColumnRels;
        this.autoGenerateNames = autoGenNames;
        this.nLevels = nLevels;
        this.createRelationships();
    }

    private void loadTableDependencies() {
        this.tableDependencies.clear();
        HashMap<EObject, List> tableMap = new HashMap<EObject, List>();
        Iterator iter = this.targetTables.iterator();
        while (iter.hasNext()) {
            EObject vTable = (EObject)iter.next();
            EObject transformationEObject = this.getTransformation(vTable);
            List sources = this.getSources(transformationEObject);
            if (sources.size() <= 0) continue;
            tableMap.put(vTable, sources);
        }
        if (tableMap.size() > 0) {
            this.tableDependencies.add(tableMap);
        }
        int currentLevel = 0;
        boolean lastLevelFound = false;
        while (!lastLevelFound) {
            Map nextLevelMap = this.createNextLevelTableMap(currentLevel);
            if (nextLevelMap.size() != 0) {
                this.tableDependencies.add(nextLevelMap);
            } else {
                lastLevelFound = true;
            }
            ++currentLevel;
        }
        this.maxLevels = this.tableDependencies.size();
    }

    private void createRelationships() {
        this.relRowStrings.clear();
        this.relCount = 0;
        if (this.locationStr != null && this.locationStr.trim().length() != 0) {
            if (this.createTableRelationships) {
                this.createTableRelationships(this.nLevels);
            }
            if (this.createColumnRelationships) {
                this.createColumnRelationships(this.nLevels);
            }
        }
    }

    public List getRelationshipRows() {
        return this.relRowStrings;
    }

    private Map createNextLevelTableMap(int currentLevel) {
        Map tableMap;
        HashMap<EObject, List> newLevelMap = new HashMap<EObject, List>();
        if (this.tableDependencies.size() > currentLevel && (tableMap = (Map)this.tableDependencies.get(currentLevel)) != null) {
            ArrayList<EObject> targets = new ArrayList<EObject>();
            Iterator keyIter = tableMap.keySet().iterator();
            while (keyIter.hasNext()) {
                List sources = (List)tableMap.get(keyIter.next());
                Iterator srcIter = sources.iterator();
                while (srcIter.hasNext()) {
                    EObject srcObj = (EObject)srcIter.next();
                    if (!TransformationHelper.isValidSqlTransformationTarget((Object)srcObj) || targets.contains(srcObj)) continue;
                    targets.add(srcObj);
                }
            }
            Iterator targetIter = targets.iterator();
            while (targetIter.hasNext()) {
                EObject target = (EObject)targetIter.next();
                EObject transformationEObject = this.getTransformation(target);
                List sources = this.getSources(transformationEObject);
                newLevelMap.put(target, sources);
            }
        }
        return newLevelMap;
    }

    public void setLocation(Object location) {
        this.setRelationshipLocation();
        this.createRelationships();
    }

    public String getLocationString() {
        return this.locationStr != null ? this.locationStr : BLANK_STR;
    }

    public void setRelationshipType(String relType) {
        this.relType = relType;
        this.createRelationships();
    }

    public String getRelationshipType() {
        return this.relType != null ? this.relType : BLANK_STR;
    }

    public void setAutoGenNames(boolean autoGen) {
        this.autoGenerateNames = autoGen;
        this.createRelationships();
    }

    public boolean getAutoGenNames() {
        return this.autoGenerateNames;
    }

    private void setRelationshipLocation() {
        if (this.location instanceof IFile) {
            this.locationStr = ((IFile)this.location).getName();
        } else if (this.location instanceof EObject) {
            this.locationStr = this.getFullPathForEObject((EObject)this.location);
        } else if (this.location instanceof ModelResource) {
            ModelResource targetResource = (ModelResource)this.location;
            this.locationStr = targetResource.getItemName();
        } else if (this.location instanceof String) {
            this.locationStr = (String)this.location;
        }
    }

    public void setNLevels(int nLevels) {
        this.nLevels = nLevels == -1 ? this.maxLevels : nLevels;
        this.createRelationships();
    }

    public int getNLevels() {
        return this.nLevels;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public void setCreateTableRelationships(boolean shouldCreate) {
        if (shouldCreate != this.createTableRelationships) {
            this.createTableRelationships = shouldCreate;
        }
        this.createRelationships();
    }

    public boolean getCreateTableRelationshipsOption() {
        return this.createTableRelationships;
    }

    public void setCreateColumnRelationships(boolean shouldCreate) {
        if (shouldCreate != this.createColumnRelationships) {
            this.createColumnRelationships = shouldCreate;
        }
        this.createRelationships();
    }

    public boolean getCreateColumnRelationshipsOption() {
        return this.createColumnRelationships;
    }

    public void setCreateAllColumnRelationships(boolean createAll) {
        if (createAll != this.createAllColumnRelationships) {
            this.createAllColumnRelationships = createAll;
        }
        this.createRelationships();
    }

    public boolean getCreateAllColumnRelationshipsOption() {
        return this.createAllColumnRelationships;
    }

    private EObject getTransformation(EObject targetVirtualGroupEObject) {
        return TransformationHelper.getTransformationMappingRoot((EObject)targetVirtualGroupEObject);
    }

    private List getSources(EObject transformationEObject) {
        return TransformationSourceManager.getSourceEObjects((EObject)transformationEObject);
    }

    private void createTableRelationships(int nLevels) {
        if (!this.createTableRelationships) {
            return;
        }
        if (nLevels == -1) {
            nLevels = this.maxLevels;
        }
        for (int i = 0; i < nLevels; ++i) {
            Map tableMap = (Map)this.tableDependencies.get(i);
            Iterator keyIter = tableMap.keySet().iterator();
            while (keyIter.hasNext()) {
                EObject vTarget = (EObject)keyIter.next();
                List sources = (List)tableMap.get(vTarget);
                if (sources == null || sources.isEmpty()) continue;
                EObject firstSource = (EObject)sources.get(0);
                ArrayList<String> targetTableList = new ArrayList<String>(1);
                targetTableList.add(this.getFullPathForEObject(vTarget));
                RelationshipTableRowObject rowObj = new RelationshipTableRowObject(this.generateName(firstSource, vTarget), null, this.relType, targetTableList, this.getPathStrings(sources), this.locationStr);
                this.relRowStrings.add(rowObj);
            }
        }
    }

    private void createColumnRelationships(int nLevels) {
        if (!this.createColumnRelationships) {
            return;
        }
        if (nLevels == -1) {
            nLevels = this.maxLevels;
        }
        if (this.createAllColumnRelationships) {
            for (int i = 0; i < nLevels; ++i) {
                Map tableMap = (Map)this.tableDependencies.get(i);
                Iterator keyIter = tableMap.keySet().iterator();
                while (keyIter.hasNext()) {
                    EObject vTarget = (EObject)keyIter.next();
                    List sources = (List)tableMap.get(vTarget);
                    if (sources.isEmpty()) continue;
                    List columns = TransformationHelper.getTableColumns((EObject)vTarget);
                    this.addSourceRelationshipRows(columns, new ArrayList());
                }
            }
        } else {
            ArrayList nextLevelAttrs = new ArrayList();
            Map tableMap = (Map)this.tableDependencies.get(0);
            Iterator keyIter = tableMap.keySet().iterator();
            while (keyIter.hasNext()) {
                EObject vTarget = (EObject)keyIter.next();
                List sources = (List)tableMap.get(vTarget);
                if (sources.isEmpty()) continue;
                List tableAttrs = TransformationHelper.getTableColumns((EObject)vTarget);
                Iterator tableAttrIter = tableAttrs.iterator();
                while (tableAttrIter.hasNext()) {
                    Object tableAttr = tableAttrIter.next();
                    if (nextLevelAttrs.contains(tableAttr)) continue;
                    nextLevelAttrs.add(tableAttr);
                }
            }
            ArrayList targetAttrs = new ArrayList();
            targetAttrs.add(nextLevelAttrs);
            for (int i = 0; i < nLevels; ++i) {
                List attrs = (List)targetAttrs.get(i);
                ArrayList dependentAttrs = new ArrayList();
                this.addSourceRelationshipRows(attrs, dependentAttrs);
                targetAttrs.add(i + 1, dependentAttrs);
            }
        }
    }

    private void addSourceRelationshipRows(List targetAttrs, List allSourceAttrs) {
        Iterator attrIter = targetAttrs.iterator();
        while (attrIter.hasNext()) {
            TransformationMappingRoot mappingRoot;
            List sourceTables;
            EObject targetAttr = (EObject)attrIter.next();
            if (!ModelObjectUtilities.isVirtual((EObject)targetAttr)) continue;
            EObject virtualTarget = targetAttr.eContainer();
            if (!TransformationHelper.isValidSqlTransformationTarget((Object)virtualTarget) && TransformationHelper.isSqlColumnSet((Object)virtualTarget)) {
                virtualTarget = virtualTarget.eContainer();
            }
            RelationshipTableRowObject rowObj = null;
            if (virtualTarget == null || (sourceTables = this.getSources((EObject)(mappingRoot = (TransformationMappingRoot)this.getTransformation(virtualTarget)))).isEmpty()) continue;
            ArrayList<String> targetAttrList = new ArrayList<String>(1);
            targetAttrList.add(this.getFullPathForEObject(targetAttr));
            ArrayList attrDepList = new ArrayList(TransformationHelper.getSourceAttributesForTargetAttr((Object)targetAttr, (Object)mappingRoot));
            if (attrDepList.isEmpty()) continue;
            ArrayList<EObject> sourceAttrList = new ArrayList<EObject>(attrDepList.size());
            EObject nextEObject = null;
            Iterator iter = attrDepList.iterator();
            EObject firstSourceAttr = null;
            while (iter.hasNext()) {
                EObject attributeParent;
                nextEObject = (EObject)iter.next();
                if (nextEObject.equals(targetAttr)) continue;
                if (firstSourceAttr == null) {
                    firstSourceAttr = nextEObject;
                }
                if (!sourceTables.contains(attributeParent = nextEObject.eContainer())) continue;
                sourceAttrList.add(nextEObject);
                if (allSourceAttrs.contains(nextEObject)) continue;
                allSourceAttrs.add(nextEObject);
            }
            rowObj = new RelationshipTableRowObject(this.generateName(firstSourceAttr, targetAttr), null, this.relType, targetAttrList, this.getPathStrings(sourceAttrList), this.locationStr);
            if (!this.containsEquivalentRow(this.relRowStrings, rowObj)) {
                this.relRowStrings.add(rowObj);
                continue;
            }
            if (!this.autoGenerateNames) continue;
            --this.relCount;
        }
    }

    private boolean containsEquivalentRow(List rowList, RelationshipTableRowObject rowObj) {
        boolean containsEquivalentRow = false;
        if (rowList != null && rowObj != null && !rowList.isEmpty()) {
            Iterator rowIter = rowList.iterator();
            while (rowIter.hasNext()) {
                RelationshipTableRowObject listRow = (RelationshipTableRowObject)rowIter.next();
                if (!listRow.referencesEqual((Object)rowObj)) continue;
                containsEquivalentRow = true;
                break;
            }
        }
        return containsEquivalentRow;
    }

    private String generateName(EObject sourceEObj, EObject targetEObj) {
        String newName = DEFAULT_NAME;
        if (this.autoGenerateNames) {
            ++this.relCount;
            String zeros = BLANK_STR;
            if (this.relCount < 10) {
                zeros = "000";
            } else if (this.relCount < 100) {
                zeros = "00";
            } else if (this.relCount < 1000) {
                zeros = "0";
            }
            newName = NAME_PREFIX + zeros + this.relCount;
        } else {
            String srcName = this.getFullPathForEObject(sourceEObj);
            srcName = srcName.replace('/', '_');
            srcName = srcName.replace(' ', '_');
            String tgtName = this.getFullPathForEObject(targetEObj);
            tgtName = tgtName.replace('/', '_');
            tgtName = tgtName.replace(' ', '_');
            newName = srcName + TO_STRING + tgtName;
        }
        return newName;
    }

    private List getPathStrings(List eObjs) {
        ArrayList<String> strList = new ArrayList<String>(eObjs.size());
        EObject nextEObj = null;
        String nextPath = null;
        Iterator iter = eObjs.iterator();
        while (iter.hasNext()) {
            nextEObj = (EObject)iter.next();
            nextPath = this.getFullPathForEObject(nextEObj);
            strList.add(nextPath);
        }
        return strList;
    }

    private String getFullPathForEObject(EObject eObj) {
        String loc = null;
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)eObj);
        if (mr != null) {
            String pathToModel = mr.getPath().removeFileExtension().toString();
            if (pathToModel.charAt(0) == '/') {
                pathToModel = pathToModel.substring(1);
            }
            loc = pathToModel;
            String pathToObject = ModelObjectUtilities.getRelativePath((EObject)eObj);
            if (pathToObject != null) {
                loc = loc + '/' + pathToObject;
            }
        }
        return loc;
    }
}

