/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.ProjectNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CapabilitiesUtil {
    private CapabilitiesUtil() {
    }

    static boolean supportsInlineView(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.FROM.INLINE.VIEWS");
    }

    static boolean supportsOrderByInInlineView(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.FROM.INLINE.VIEWS.ORDERBY");
    }

    public static boolean supportsJoins(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!caps.supportsCapability("QUERY.FROM.JOIN")) {
            return false;
        }
        return metadata.modelSupports(modelID, 2);
    }

    public static boolean supportsSelfJoins(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.FROM.JOIN.SELFJOIN") && caps.supportsCapability("QUERY.FROM.JOIN.ALIAS");
    }

    public static boolean supportsGroupAliases(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.FROM.JOIN.ALIAS");
    }

    public static boolean supportsOuterJoin(Object modelID, JoinType joinType, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!caps.supportsCapability("QUERY.FROM.JOIN.OUTER")) {
            return false;
        }
        if (joinType.equals((Object)JoinType.JOIN_FULL_OUTER) && !caps.supportsCapability("QUERY.FROM.JOIN.OUTER.FULL")) {
            return false;
        }
        return metadata.modelSupports(modelID, 6);
    }

    public static boolean supportsAggregates(List groupCols, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        boolean supportsAgg = caps.supportsCapability("QUERY.AGGREGATES");
        boolean supportsFunctions = caps.supportsCapability("FUNCTION");
        boolean supportsFunctionsInGroupBy = caps.supportsCapability("QUERY.GROUPBY.FUNCTIONS");
        if (groupCols != null && supportsAgg && supportsFunctions && !supportsFunctionsInGroupBy) {
            Iterator colIter = groupCols.iterator();
            while (colIter.hasNext()) {
                SingleElementSymbol col = (SingleElementSymbol)colIter.next();
                if (FunctionCollectorVisitor.getFunctions((LanguageObject)col, (boolean)false).size() <= 0) continue;
                return false;
            }
        }
        return supportsAgg;
    }

    public static boolean supportsAggregateFunction(Object modelID, AggregateSymbol aggregate, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!caps.supportsCapability("QUERY.AGGREGATES")) {
            return false;
        }
        String func = aggregate.getAggregateFunction();
        if (func.equals("COUNT") ? (aggregate.getExpression() == null ? !caps.supportsCapability("QUERY.AGGREGATES.COUNT.STAR") : !caps.supportsCapability("QUERY.AGGREGATES.COUNT")) : (func.equals("SUM") ? !caps.supportsCapability("QUERY.AGGREGATES.SUM") : (func.equals("AVG") ? !caps.supportsCapability("QUERY.AGGREGATES.AVG") : (func.equals("MIN") ? !caps.supportsCapability("QUERY.AGGREGATES.MIN") : func.equals("MAX") && !caps.supportsCapability("QUERY.AGGREGATES.MAX"))))) {
            return false;
        }
        return !aggregate.isDistinct() || caps.supportsCapability("QUERY.AGGREGATES.DISTINCT");
    }

    public static boolean supportsScalarFunction(Object modelID, Function function, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!caps.supportsCapability("FUNCTION")) {
            return false;
        }
        if (!caps.supportsFunction(function.getName().toLowerCase())) {
            return false;
        }
        if (FunctionLibrary.isConvert((Function)function)) {
            Class fromType = function.getArg(0).getType();
            if (DataTypeManager.DefaultDataClasses.OBJECT.equals(fromType) || DataTypeManager.DefaultDataClasses.CLOB.equals(fromType) || DataTypeManager.DefaultDataClasses.XML.equals(fromType)) {
                return false;
            }
            String targetType = (String)((Constant)function.getArg(1)).getValue();
            if ("clob".equalsIgnoreCase(targetType) || "xml".equalsIgnoreCase(targetType)) {
                return false;
            }
        }
        return true;
    }

    public static boolean supportsSelectDistinct(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!caps.supportsCapability("QUERY.SELECT.DISTINCT")) {
            return false;
        }
        return metadata.modelSupports(modelID, 1);
    }

    public static boolean supportsSelectLiterals(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.SELECT.LITERALS");
    }

    public static boolean supportsOrderBy(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!caps.supportsCapability("QUERY.ORDERBY")) {
            return false;
        }
        return metadata.modelSupports(modelID, 5);
    }

    public static boolean supportsJoinExpression(Object modelID, List joinCriteria, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!caps.supportsCapability("FUNCTION")) {
            return false;
        }
        if (joinCriteria != null && joinCriteria.size() > 0) {
            Iterator iter = joinCriteria.iterator();
            while (iter.hasNext()) {
                Criteria crit = (Criteria)iter.next();
                Collection functions = FunctionCollectorVisitor.getFunctions((LanguageObject)crit, (boolean)false);
                Iterator funcIter = functions.iterator();
                while (funcIter.hasNext()) {
                    Function function = (Function)funcIter.next();
                    if (CapabilitiesUtil.supportsScalarFunction(modelID, function, metadata, capFinder)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean supportsScalarSubquery(Object modelID, ScalarSubquery subquery, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.SUBQUERIES.SCALAR");
    }

    public static boolean supportsCorrelatedSubquery(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.SUBQUERIES.CORRELATED");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEligibleSubquery(PlanNode critNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        List plans = (List)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        if (plans == null) {
            return false;
        }
        Iterator planIter = plans.iterator();
        while (planIter.hasNext()) {
            Iterator i;
            Object var20_25;
            Collection refs;
            block31: {
                Object critNodeModelID;
                Command command;
                block32: {
                    ProcessorPlan plan = (ProcessorPlan)planIter.next();
                    if (!(plan instanceof RelationalPlan)) return false;
                    RelationalPlan rplan = (RelationalPlan)plan;
                    RelationalNode projNode = rplan.getRootNode();
                    if (projNode == null || !(projNode instanceof ProjectNode)) {
                        return false;
                    }
                    RelationalNode accessNode = projNode.getChildren()[0];
                    if (accessNode == null || !(accessNode instanceof AccessNode) || accessNode.getChildren()[0] != null) {
                        return false;
                    }
                    List projCols = ((ProjectNode)projNode).getSelectSymbols();
                    List accessCols = accessNode.getElements();
                    boolean hasSelectLiteral = false;
                    SingleElementSymbol projSymbol = (SingleElementSymbol)projCols.get(0);
                    if (projSymbol instanceof AliasSymbol) {
                        projSymbol = ((AliasSymbol)projSymbol).getSymbol();
                    }
                    if (projSymbol instanceof ExpressionSymbol && !(projSymbol instanceof AggregateSymbol)) {
                        Expression expr = ((ExpressionSymbol)projSymbol).getExpression();
                        if (expr instanceof Constant || EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)expr)) {
                            hasSelectLiteral = true;
                        } else if (expr instanceof Function) {
                            SingleElementSymbol accessSymbol = (SingleElementSymbol)accessCols.get(0);
                            if (accessSymbol instanceof AliasSymbol) {
                                accessSymbol = ((AliasSymbol)accessSymbol).getSymbol();
                            }
                            if (!(accessSymbol instanceof ExpressionSymbol)) return false;
                            Expression accessExpr = ((ExpressionSymbol)accessSymbol).getExpression();
                            if (!(accessExpr instanceof Function)) return false;
                            if (!expr.equals(accessExpr)) {
                                return false;
                            }
                        }
                    }
                    if ((command = ((AccessNode)accessNode).getCommand()) == null || !(command instanceof Query) || ((Query)command).getIsXML()) {
                        return false;
                    }
                    critNodeModelID = null;
                    try {
                        List children = NodeEditor.findAllNodes((PlanNode)critNode, (int)3);
                        if (children.size() != 1) {
                            return false;
                        }
                        critNodeModelID = RuleRaiseAccess.getModelIDFromAccess((PlanNode)((PlanNode)children.iterator().next()), (QueryMetadataInterface)metadata);
                        Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, (boolean)false);
                        if (groups.size() == 0) {
                            return false;
                        }
                        GroupSymbol group = (GroupSymbol)groups.iterator().next();
                        Object modelID = metadata.getModelID(group.getMetadataID());
                        if (!CapabilitiesUtil.isSameConnector(modelID, critNodeModelID, metadata, capFinder)) {
                            return false;
                        }
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("RulePushSelectCriteria.Error_getting_modelID"));
                    }
                    catch (MetaMatrixComponentException e) {
                        throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("RulePushSelectCriteria.Error_getting_modelID"));
                    }
                    try {
                        if (hasSelectLiteral && (critNodeModelID == null || !CapabilitiesUtil.supportsSelectLiterals(critNodeModelID, metadata, capFinder))) {
                            return false;
                        }
                    }
                    catch (QueryMetadataException e) {
                        throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
                    }
                    refs = (Collection)critNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
                    if (refs == null || refs.isEmpty()) break block31;
                    if (critNodeModelID != null && CapabilitiesUtil.supportsCorrelatedSubquery(critNodeModelID, metadata, capFinder)) break block32;
                    boolean groups = false;
                    var20_25 = null;
                    if (refs == null) return groups;
                    i = refs.iterator();
                    while (i.hasNext()) {
                        ((Reference)i.next()).setCorrelated(false);
                    }
                    return groups;
                }
                Iterator i22 = refs.iterator();
                while (i22.hasNext()) {
                    ((Reference)i22.next()).setCorrelated(true);
                }
                if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)command, critNodeModelID, metadata, capFinder)) break block31;
                boolean i22 = false;
                var20_25 = null;
                if (refs == null) return i22;
                i = refs.iterator();
                while (i.hasNext()) {
                    ((Reference)i.next()).setCorrelated(false);
                }
                return i22;
            }
            try {
                var20_25 = null;
                if (refs == null) continue;
                i = refs.iterator();
            }
            catch (Throwable throwable) {
                var20_25 = null;
                if (refs == null) throw throwable;
                i = refs.iterator();
                while (i.hasNext()) {
                    ((Reference)i.next()).setCorrelated(false);
                }
                throw throwable;
            }
            while (i.hasNext()) {
                ((Reference)i.next()).setCorrelated(false);
            }
            {
                continue;
                catch (QueryMetadataException e) {
                    throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
                }
            }
        }
        return true;
    }

    public static boolean supportsUnion(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.UNION");
    }

    public static boolean supportsUnionOrderBy(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.UNION.ORDERBY");
    }

    public static boolean supportsCaseExpression(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.CASE");
    }

    public static boolean supportsSearchedCaseExpression(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("QUERY.SEARCHED.CASE");
    }

    public static int getMaxInCriteriaSize(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return -1;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        Object maxInCriteriaSize = caps.getSourceProperty("MAX.IN.CRITERIA.SIZE");
        int value = -1;
        if (maxInCriteriaSize != null) {
            value = (Integer)maxInCriteriaSize;
        }
        if (value <= 0) {
            value = -1;
        }
        return value;
    }

    public static boolean supportsRowLimit(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("ROWLIMIT");
    }

    public static boolean supportsRowOffset(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability("ROWOFFSET");
    }

    public static boolean isSameConnector(Object modelID, Object modelID1, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (modelID == null || modelID1 == null || metadata.isVirtualModel(modelID) || metadata.isVirtualModel(modelID1)) {
            return false;
        }
        if (modelID.equals(modelID1)) {
            return true;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        SourceCapabilities caps1 = CapabilitiesUtil.getCapabilities(modelID1, metadata, capFinder);
        Object connectorID = caps.getSourceProperty("CONNECTOR_ID");
        return connectorID != null && connectorID.equals(caps1.getSourceProperty("CONNECTOR_ID"));
    }

    private static SourceCapabilities getCapabilities(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        String modelName = metadata.getFullName(modelID);
        return capFinder.findCapabilities(modelName);
    }
}

