/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.util.SqlUtil;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.DirectionKind;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.transformation.InputParameter;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.SqlAlias;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TransformationMapping;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.XQueryTransformation;
import com.metamatrix.metamodels.transformation.XQueryTransformationMappingRoot;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlResultSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.notification.util.NotificationUtilities;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.MMXmiResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.transformation.util.AttributeMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.ExternalMetadataUtil;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConstants;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.SqlStringUtil;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.util.UpdateProcedureGenerator;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.validator.UpdateValidationVisitor;
import com.metamatrix.query.validator.ValidatorReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.emf.mapping.MappingRoot;

public class TransformationHelper
implements SqlConstants {
    public static final String TRANSACTIONS = "modelerTransactions";
    public static final String THIS_CLASS = "TransformationHelper";
    private static final boolean IS_UNDOABLE = true;
    private static final boolean IS_SIGNIFICANT = true;
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UUID = true;
    private static final boolean IS_NOT_UUID = false;
    public static final String DEFAULT_SELECT = "SELECT * FROM";
    private static TransformationFactory transformationFactory = TransformationFactory.eINSTANCE;
    private static final String CHANGE_SELECT_TXN_DESCRIPTION = TransformationPlugin.Util.getString("TransformationHelper.changeSelectSqlTxnDescription");
    private static final String CHANGE_INSERT_TXN_DESCRIPTION = TransformationPlugin.Util.getString("TransformationHelper.changeInsertSqlTxnDescription");
    private static final String CHANGE_UPDATE_TXN_DESCRIPTION = TransformationPlugin.Util.getString("TransformationHelper.changeUpdateSqlTxnDescription");
    private static final String CHANGE_DELETE_TXN_DESCRIPTION = TransformationPlugin.Util.getString("TransformationHelper.changeDeleteSqlTxnDescription");
    private static final String ADD_SRC_ALIAS_TXN_DESCRIPTION = TransformationPlugin.Util.getString("TransformationHelper.addSrcAliasTxnDescription");
    private static final String REMOVE_SRC_ALIAS_TXN_DESCRIPTION = TransformationPlugin.Util.getString("TransformationHelper.removeSrcAliasTxnDescription");
    private static final String NULL_OR_INVALID_TARGET = "TransformationHelper.getTransformationMappingRoot:null or invalid target.";
    private static final String XML_SERVICE_URI = "XmlService";
    static /* synthetic */ Class class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlProcedureParameterAspect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappingHelper getMappingHelper(Object transMappingRoot) {
        XQueryTransformationMappingRoot xQueryTransMappingRoot;
        MappingHelper helper = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            SqlTransformationMappingRoot sqlTransMappingRoot = (SqlTransformationMappingRoot)transMappingRoot;
            helper = sqlTransMappingRoot.getHelper();
            if (helper == null) {
                boolean requiresStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create Mapping Helper", (Object)transMappingRoot);
                boolean succeeded = false;
                try {
                    if (!TransformationHelper.isReadOnly((EObject)sqlTransMappingRoot)) {
                        helper = transformationFactory.createSqlTransformation();
                        sqlTransMappingRoot.setHelper(helper);
                        TransformationHelper.createNestedUserSqlTransformation(helper);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiresStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        } else if (transMappingRoot instanceof XQueryTransformationMappingRoot && (helper = (xQueryTransMappingRoot = (XQueryTransformationMappingRoot)transMappingRoot).getHelper()) == null) {
            boolean requiresStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create XQuery Mapping Helper", (Object)transMappingRoot);
            boolean succeeded = false;
            try {
                if (!TransformationHelper.isReadOnly((EObject)xQueryTransMappingRoot)) {
                    helper = transformationFactory.createXQueryTransformation();
                    xQueryTransMappingRoot.setHelper(helper);
                }
                succeeded = true;
            }
            finally {
                if (requiresStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return helper;
    }

    public static SqlTransformation getUserSqlTransformation(Object transMappingRoot) {
        SqlTransformation nestedSqlTrans = null;
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null) {
            EList nestedList = helper.getNested();
            Iterator iter = nestedList.iterator();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                if (eObj == null || !(eObj instanceof SqlTransformation)) continue;
                nestedSqlTrans = (SqlTransformation)eObj;
                break;
            }
            if (nestedSqlTrans == null && !TransformationHelper.isReadOnly((EObject)helper)) {
                nestedSqlTrans = TransformationHelper.createNestedUserSqlTransformation(helper);
            }
        }
        return nestedSqlTrans;
    }

    public static SqlTransformation createNestedUserSqlTransformation(MappingHelper sqlTransformation) {
        SqlTransformation userSqlTrans = transformationFactory.createSqlTransformation();
        userSqlTrans.setNestedIn(sqlTransformation);
        if (sqlTransformation instanceof SqlTransformation) {
            SqlTransformation sqlTran = (SqlTransformation)sqlTransformation;
            String selectSql = sqlTran.getSelectSql();
            Container container = ModelerCore.getContainer((EObject)sqlTransformation);
            if (container != null) {
                String deleteSql;
                String updateSql;
                String insertSql;
                if (selectSql != null) {
                    String userSql = SqlConverter.convertUUIDsToFullNames((String)selectSql, (Container)container);
                    userSqlTrans.setSelectSql(userSql);
                }
                if ((insertSql = sqlTran.getInsertSql()) != null) {
                    String userSql = SqlConverter.convertUUIDsToFullNames((String)insertSql, (Container)container);
                    userSqlTrans.setInsertSql(userSql);
                }
                if ((updateSql = sqlTran.getUpdateSql()) != null) {
                    String userSql = SqlConverter.convertUUIDsToFullNames((String)updateSql, (Container)container);
                    userSqlTrans.setUpdateSql(userSql);
                }
                if ((deleteSql = sqlTran.getDeleteSql()) != null) {
                    String userSql = SqlConverter.convertUUIDsToFullNames((String)deleteSql, (Container)container);
                    userSqlTrans.setDeleteSql(userSql);
                }
            }
        }
        return userSqlTrans;
    }

    public static Mapping getMappingRoot(MappingHelper transMappingHelper) {
        Mapping mapping = null;
        if (transMappingHelper != null) {
            mapping = transMappingHelper.getMapper();
        }
        return mapping;
    }

    public static EObject createTransformation(EObject virtualTarget, EObject sourceGroup) {
        EObject transMappingRoot = null;
        if (virtualTarget != null && !TransformationHelper.isReadOnly(virtualTarget)) {
            transMappingRoot = TransformationHelper.getTransformationMappingRoot(virtualTarget);
            String name = TransformationHelper.getSqlEObjectFullName(sourceGroup);
            TransformationHelper.addSqlAlias(transMappingRoot, sourceGroup, name, false, virtualTarget);
            if (transMappingRoot != null) {
                SqlTableAspect tableAspect;
                Object txnSource = null;
                if (TransformationHelper.isSqlProcedure(sourceGroup)) {
                    StoredProcedure proc = TransformationSqlHelper.createStoredProc((EObject)sourceGroup);
                    if (proc != null) {
                        CreateUpdateProcedureCommand cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((Command)proc);
                        TransformationHelper.setSelectSqlString(transMappingRoot, cCommand.toString(), false, txnSource);
                    }
                } else {
                    Query query = TransformationSqlHelper.createDefaultQuery((EObject)sourceGroup);
                    TransformationHelper.setSelectSqlString(transMappingRoot, query.toString(), true, txnSource);
                }
                EObject target = TransformationHelper.getTransformationTarget(transMappingRoot);
                if (TransformationHelper.isVirtualSqlTable(target) && TransformationHelper.isSqlTable(sourceGroup) && (tableAspect = (SqlTableAspect)SqlAspectHelper.getSqlAspect((EObject)target)) != null && tableAspect.supportsUpdate(target) && tableAspect.supportsUpdate(sourceGroup)) {
                    TransformationHelper.refreshUpdateStrings(transMappingRoot, true, txnSource);
                }
                TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)transMappingRoot, txnSource);
            }
        }
        return transMappingRoot;
    }

    public static boolean isTableThatSupportsUpdate(EObject target) {
        SqlTableAspect tableAspect;
        ArgCheck.isNotNull((Object)target);
        SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)target);
        return sqlAspect != null && sqlAspect instanceof SqlTableAspect && (tableAspect = (SqlTableAspect)sqlAspect).supportsUpdate(target);
    }

    public static EObject createTransformation(EObject virtualTarget, String selectSQL) {
        EObject transMappingRoot = null;
        if (virtualTarget != null && (transMappingRoot = TransformationHelper.getTransformationMappingRoot(virtualTarget)) != null && !TransformationHelper.isReadOnly(transMappingRoot)) {
            Object txnSource = null;
            TransformationHelper.setSelectSqlString(transMappingRoot, selectSQL, true, txnSource);
            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)transMappingRoot, txnSource);
        }
        return transMappingRoot;
    }

    public static String getDefaultSqlSelectString(Object transMappingRoot) {
        EObject target = TransformationHelper.getTransformationTarget(transMappingRoot);
        String selectString = DEFAULT_SELECT;
        if (TransformationHelper.isSqlProcedure(target) || TransformationHelper.isSqlProcedureResultSet(target)) {
            selectString = "";
        }
        return selectString;
    }

    public static String getSelectSqlString(Object transMappingRoot) {
        return TransformationHelper.getSqlString(transMappingRoot, 0);
    }

    public static String getInsertSqlString(Object transMappingRoot) {
        return TransformationHelper.getSqlString(transMappingRoot, 1);
    }

    public static String getUpdateSqlString(Object transMappingRoot) {
        return TransformationHelper.getSqlString(transMappingRoot, 2);
    }

    public static String getDeleteSqlString(Object transMappingRoot) {
        return TransformationHelper.getSqlString(transMappingRoot, 3);
    }

    public static String getSqlString(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.getSqlString((Object)transMappingRoot, (int)cmdType);
    }

    public static String getUUIDSqlString(Object transMappingRoot, int cmdType) {
        String uuidString = null;
        switch (cmdType) {
            case 0: {
                uuidString = TransformationHelper.getSelectSqlUUIDString(transMappingRoot);
                break;
            }
            case 1: {
                uuidString = TransformationHelper.getInsertSqlUUIDString(transMappingRoot);
                break;
            }
            case 2: {
                uuidString = TransformationHelper.getUpdateSqlUUIDString(transMappingRoot);
                break;
            }
            case 3: {
                uuidString = TransformationHelper.getDeleteSqlUUIDString(transMappingRoot);
                break;
            }
        }
        return uuidString;
    }

    public static boolean setSelectSqlString(Object transMappingRoot, String sqlString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setSqlString(transMappingRoot, sqlString, 0, isSignificant, txnSource);
    }

    public static boolean setInsertSqlString(Object transMappingRoot, String sqlString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setSqlString(transMappingRoot, sqlString, 1, isSignificant, txnSource);
    }

    public static boolean setUpdateSqlString(Object transMappingRoot, String sqlString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setSqlString(transMappingRoot, sqlString, 2, isSignificant, txnSource);
    }

    public static boolean setDeleteSqlString(Object transMappingRoot, String sqlString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setSqlString(transMappingRoot, sqlString, 3, isSignificant, txnSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setSqlString(Object transMappingRoot, String sqlString, int cmdType, boolean isSignificant, Object txnSource) {
        boolean changed;
        block9: {
            changed = false;
            if (TransformationHelper.isReadOnly((EObject)transMappingRoot)) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_SELECT_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                String newUUIDSQL = SqlConverter.convertToUID((String)sqlString, (EObject)((EObject)transMappingRoot), (int)cmdType);
                boolean hasCachedStatus = SqlMappingRootCache.containsStatus((EObject)((EObject)transMappingRoot), (int)cmdType);
                switch (cmdType) {
                    case 0: {
                        changed = TransformationHelper.setSelectSqlUserString(transMappingRoot, sqlString, isSignificant, txnSource);
                        boolean uuidSelectChanged = TransformationHelper.setSelectSqlUUIDString(transMappingRoot, newUUIDSQL, isSignificant, txnSource);
                        boolean bl = changed = changed || uuidSelectChanged;
                        if (!hasCachedStatus || !SqlMappingRootCache.isSqlDifferent((Object)transMappingRoot, (int)cmdType, (String)sqlString, (String)newUUIDSQL)) break;
                        SqlMappingRootCache.invalidateSelectStatus((Object)transMappingRoot, (boolean)true, (Object)txnSource);
                        TransformationHelper.refreshUpdateStrings(transMappingRoot, isSignificant, txnSource);
                        changed = true;
                        break;
                    }
                    case 1: {
                        changed = TransformationHelper.setInsertSqlUserString(transMappingRoot, sqlString, isSignificant, txnSource);
                        boolean uuidInsertChanged = TransformationHelper.setInsertSqlUUIDString(transMappingRoot, newUUIDSQL, isSignificant, txnSource);
                        boolean bl = changed = changed || uuidInsertChanged;
                        if (!changed && !hasCachedStatus || !SqlMappingRootCache.isSqlDifferent((Object)transMappingRoot, (int)cmdType, (String)sqlString, (String)newUUIDSQL)) break;
                        SqlMappingRootCache.invalidateInsertStatus((Object)transMappingRoot, (boolean)true, (Object)txnSource);
                        changed = true;
                        break;
                    }
                    case 2: {
                        changed = TransformationHelper.setUpdateSqlUserString(transMappingRoot, sqlString, isSignificant, txnSource);
                        boolean uuidUpdateChanged = TransformationHelper.setUpdateSqlUUIDString(transMappingRoot, newUUIDSQL, isSignificant, txnSource);
                        boolean bl = changed = changed || uuidUpdateChanged;
                        if (!changed && !hasCachedStatus || !SqlMappingRootCache.isSqlDifferent((Object)transMappingRoot, (int)cmdType, (String)sqlString, (String)newUUIDSQL)) break;
                        SqlMappingRootCache.invalidateUpdateStatus((Object)transMappingRoot, (boolean)true, (Object)txnSource);
                        changed = true;
                        break;
                    }
                    case 3: {
                        changed = TransformationHelper.setDeleteSqlUserString(transMappingRoot, sqlString, isSignificant, txnSource);
                        boolean uuidDeleteChanged = TransformationHelper.setDeleteSqlUUIDString(transMappingRoot, newUUIDSQL, isSignificant, txnSource);
                        boolean bl = changed = changed || uuidDeleteChanged;
                        if (!changed && !hasCachedStatus || !SqlMappingRootCache.isSqlDifferent((Object)transMappingRoot, (int)cmdType, (String)sqlString, (String)newUUIDSQL)) break;
                        SqlMappingRootCache.invalidateDeleteStatus((Object)transMappingRoot, (boolean)true, (Object)txnSource);
                        changed = true;
                        break;
                    }
                }
                succeeded = true;
                Object var15_14 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block9;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    public static void refreshUpdateStrings(Object transMappingRoot, boolean isSignificant, Object txnSource) {
        String generatedProcUID;
        String generatedProc;
        if (TransformationHelper.isInsertAllowed(transMappingRoot) && TransformationHelper.isInsertSqlDefault((EObject)transMappingRoot)) {
            generatedProc = TransformationHelper.getGeneratedProcedureStr(transMappingRoot, 1);
            generatedProcUID = SqlConverter.convertToUID((String)generatedProc, (EObject)((EObject)transMappingRoot), (int)1);
            String currentInsertUserStr = TransformationHelper.getInsertSqlUserString(transMappingRoot);
            String currentInsertUUIDStr = TransformationHelper.getInsertSqlUUIDString(transMappingRoot);
            if (generatedProc == null && currentInsertUserStr != null || generatedProc != null && !generatedProc.equalsIgnoreCase(currentInsertUserStr)) {
                TransformationHelper.setInsertSqlUserString(transMappingRoot, generatedProc, isSignificant, txnSource);
            }
            if (generatedProcUID == null && currentInsertUUIDStr != null || generatedProcUID != null && !generatedProcUID.equalsIgnoreCase(currentInsertUUIDStr)) {
                TransformationHelper.setInsertSqlUUIDString(transMappingRoot, generatedProcUID, isSignificant, txnSource);
            }
        }
        if (TransformationHelper.isUpdateAllowed(transMappingRoot) && TransformationHelper.isUpdateSqlDefault((EObject)transMappingRoot)) {
            generatedProc = TransformationHelper.getGeneratedProcedureStr(transMappingRoot, 2);
            generatedProcUID = SqlConverter.convertToUID((String)generatedProc, (EObject)((EObject)transMappingRoot), (int)2);
            String currentUpdateUserStr = TransformationHelper.getUpdateSqlUserString(transMappingRoot);
            String currentUpdateUUIDStr = TransformationHelper.getUpdateSqlUUIDString(transMappingRoot);
            if (generatedProc == null && currentUpdateUserStr != null || generatedProc != null && !generatedProc.equalsIgnoreCase(currentUpdateUserStr)) {
                TransformationHelper.setUpdateSqlUserString(transMappingRoot, generatedProc, isSignificant, txnSource);
            }
            if (generatedProcUID == null && currentUpdateUUIDStr != null || generatedProcUID != null && !generatedProcUID.equalsIgnoreCase(currentUpdateUUIDStr)) {
                TransformationHelper.setUpdateSqlUUIDString(transMappingRoot, generatedProcUID, isSignificant, txnSource);
            }
        }
        if (TransformationHelper.isDeleteAllowed(transMappingRoot) && TransformationHelper.isDeleteSqlDefault((EObject)transMappingRoot)) {
            generatedProc = TransformationHelper.getGeneratedProcedureStr(transMappingRoot, 3);
            generatedProcUID = SqlConverter.convertToUID((String)generatedProc, (EObject)((EObject)transMappingRoot), (int)3);
            String currentDeleteUserStr = TransformationHelper.getDeleteSqlUserString(transMappingRoot);
            String currentDeleteUUIDStr = TransformationHelper.getDeleteSqlUUIDString(transMappingRoot);
            if (generatedProc == null && currentDeleteUserStr != null || generatedProc != null && !generatedProc.equalsIgnoreCase(currentDeleteUserStr)) {
                TransformationHelper.setDeleteSqlUserString(transMappingRoot, generatedProc, isSignificant, txnSource);
            }
            if (generatedProcUID == null && currentDeleteUUIDStr != null || generatedProcUID != null && !generatedProcUID.equalsIgnoreCase(currentDeleteUUIDStr)) {
                TransformationHelper.setDeleteSqlUUIDString(transMappingRoot, generatedProcUID, isSignificant, txnSource);
            }
        }
    }

    public static SqlAlias createSqlAlias(Object transMappingRoot, EObject eObj, String aliasName) {
        ArgCheck.isNotNull((Object)eObj);
        ArgCheck.isNotNull((Object)aliasName);
        SqlAlias sqlAlias = null;
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation) {
            sqlAlias = transformationFactory.createSqlAlias();
            sqlAlias.setAliasedObject(eObj);
            sqlAlias.setAlias(aliasName);
        }
        return sqlAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSqlAlias(Object mappingRoot, EObject eObj, String aliasName, boolean isSignificant, Object txnSource) {
        boolean wasAdded = false;
        MappingHelper helper = TransformationHelper.getMappingHelper(mappingRoot);
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot) && TransformationHelper.isValidSource(transMappingRoot, eObj) && !TransformationHelper.containsSqlAliasName(transMappingRoot, aliasName, eObj)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)ADD_SRC_ALIAS_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                EList inputEObjects = transMappingRoot.getInputs();
                if (!inputEObjects.contains(eObj)) {
                    TransformationHelper.addValueToEList((EObject)transMappingRoot, eObj, transMappingRoot.getInputs());
                }
                SqlAlias newAlias = TransformationHelper.createSqlAlias(transMappingRoot, eObj, aliasName);
                SqlTransformation sqlTrans = (SqlTransformation)helper;
                TransformationHelper.addValueToEList((EObject)sqlTrans, newAlias, sqlTrans.getAliases());
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            wasAdded = true;
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSqlAlias(Object mappingRoot, SqlAlias sqlAlias, boolean isSignificant, Object txnSource) {
        boolean wasAdded = false;
        MappingHelper helper = TransformationHelper.getMappingHelper(mappingRoot);
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot) && TransformationHelper.isValidSource(transMappingRoot, sqlAlias.getAliasedObject()) && !TransformationHelper.containsSqlAliasName(transMappingRoot, sqlAlias.getAlias(), sqlAlias.getAliasedObject())) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)ADD_SRC_ALIAS_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                EList inputEObjects = transMappingRoot.getInputs();
                if (!inputEObjects.contains(sqlAlias.getAliasedObject())) {
                    TransformationHelper.addValueToEList((EObject)transMappingRoot, sqlAlias.getAliasedObject(), transMappingRoot.getInputs());
                }
                SqlTransformation sqlTrans = (SqlTransformation)helper;
                TransformationHelper.addValueToEList((EObject)sqlTrans, sqlAlias, sqlTrans.getAliases());
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            wasAdded = true;
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSourceAndAliases(Object mappingRoot, EObject sourceEObj, boolean isSignificant, Object txnSource) {
        SqlTransformationMappingRoot transMappingRoot;
        List sources;
        if (mappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(mappingRoot) && !TransformationHelper.isReadOnly((EObject)mappingRoot) && (sources = TransformationHelper.getSourceEObjects((EObject)(transMappingRoot = (SqlTransformationMappingRoot)mappingRoot))).contains(sourceEObj)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)"Remove Source", (Object)txnSource);
            boolean succeeded = false;
            try {
                List aliases = TransformationHelper.getSqlAliasesForSource(mappingRoot, sourceEObj);
                if (!aliases.isEmpty()) {
                    try {
                        ModelerCore.getModelEditor().delete((Collection)aliases);
                    }
                    catch (ModelerCoreException e) {
                        String message = TransformationPlugin.Util.getString("TransformationHelper.removeTransSourceAliasError", (Object)transMappingRoot.toString());
                        TransformationPlugin.Util.log(4, (Throwable)e, message);
                    }
                }
                TransformationHelper.removeValueFromEList((EObject)transMappingRoot, sourceEObj, transMappingRoot.getInputs());
                TransformationHelper.removeModelImportForSourceObject((EmfResource)transMappingRoot.eResource(), sourceEObj);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static EObject getSqlColumnDatatype(EObject eObject) {
        EObject datatype = null;
        if (TransformationHelper.isSqlColumn(eObject)) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObject);
            datatype = columnAspect.getDatatype(eObject);
        }
        return datatype;
    }

    public static int getSqlColumnLength(EObject eObject) {
        int length = -1;
        if (TransformationHelper.isSqlColumn(eObject)) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObject);
            length = columnAspect.getLength(eObject);
        }
        return length;
    }

    public static String getSqlColumnRuntimeType(EObject eObject) {
        String runtimeType = null;
        if (TransformationHelper.isSqlColumn(eObject)) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObject);
            runtimeType = columnAspect.getRuntimeType(eObject);
        }
        return runtimeType;
    }

    public static String getProcedureParameterRuntimeType(EObject eObject) {
        String runtimeType = null;
        if (TransformationHelper.isSqlProcedureParameter(eObject)) {
            SqlProcedureParameterAspect columnAspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)eObject);
            runtimeType = columnAspect.getRuntimeType(eObject);
        }
        return runtimeType;
    }

    public static String getRuntimeType(EObject eObject) {
        String result = TransformationHelper.getSqlColumnRuntimeType(eObject);
        if (result != null) {
            return result;
        }
        result = TransformationHelper.getProcedureParameterRuntimeType(eObject);
        if (result != null) {
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSqlColumnDatatype(EObject eObject, EObject datatype, Object txnSource) {
        SqlColumnAspect columnAspect;
        if (TransformationHelper.isSqlColumn(eObject) && !TransformationHelper.isReadOnly(eObject) && (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObject)).canSetDatatype()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Column Datatype", (Object)txnSource);
            boolean succeeded = false;
            try {
                columnAspect.setDatatype(eObject, datatype);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSqlColumnLength(EObject eObject, int length, Object txnSource) {
        SqlColumnAspect columnAspect;
        if (TransformationHelper.isSqlColumn(eObject) && !TransformationHelper.isReadOnly(eObject) && (columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)eObject)).canSetLength()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Column Length", (Object)txnSource);
            boolean succeeded = false;
            try {
                columnAspect.setLength(eObject, length);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSqlColumnName(EObject eObject, String name, Object txnSource) {
        if (TransformationHelper.isSqlColumn(eObject) && !TransformationHelper.isReadOnly(eObject)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Column Name", (Object)txnSource);
            boolean succeeded = false;
            try {
                ModelerCore.getModelEditor().rename(eObject, name);
                succeeded = true;
            }
            catch (ModelerCoreException e) {
                String message = TransformationPlugin.Util.getString("TransformationHelper.sqlColumnRenameError", (Object)eObject.toString());
                TransformationPlugin.Util.log(4, (Throwable)e, message);
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferSqlColumnProperties(EObject targetEObj, EObject sourceEObj, Object txnSource) {
        if (TransformationHelper.isSqlColumn(targetEObj) && TransformationHelper.isSqlColumn(sourceEObj) && !TransformationHelper.isReadOnly(targetEObj)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Transfer Column Props", (Object)txnSource);
            boolean succeeded = false;
            try {
                SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)targetEObj);
                columnAspect.updateObject(targetEObj, sourceEObj);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        if (TransformationHelper.isSqlColumn(targetEObj) && TransformationHelper.isSqlProcedureParameter(sourceEObj) && !TransformationHelper.isReadOnly(targetEObj)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Transfer Column Props", (Object)txnSource);
            boolean succeeded = false;
            try {
                Column tgtColumn = (Column)targetEObj;
                SqlAspect aspect = AspectManager.getSqlAspect((EObject)sourceEObj);
                ArgCheck.isInstanceOf((Class)(class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlProcedureParameterAspect == null ? (class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlProcedureParameterAspect = TransformationHelper.class$("com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect")) : class$com$metamatrix$modeler$core$metamodel$aspect$sql$SqlProcedureParameterAspect), (Object)aspect);
                ProcedureParameter param = (ProcedureParameter)sourceEObj;
                tgtColumn.setLength(param.getLength());
                tgtColumn.setPrecision(param.getPrecision());
                tgtColumn.setRadix(param.getRadix());
                tgtColumn.setPrecision(param.getPrecision());
                tgtColumn.setScale(param.getScale());
                tgtColumn.setType(param.getType());
                tgtColumn.setDefaultValue(param.getDefaultValue());
                tgtColumn.setNullable(param.getNullable());
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static String getSqlEObjectName(EObject eObject) {
        String returnString = "NULL";
        SqlAspect aspect = AspectManager.getSqlAspect((EObject)eObject);
        if (aspect != null) {
            returnString = aspect.getName(eObject);
        }
        return returnString;
    }

    public static String getSqlEObjectFullName(EObject eObject) {
        String returnString = "NULL";
        SqlAspect aspect = AspectManager.getSqlAspect((EObject)eObject);
        if (aspect != null) {
            returnString = aspect.getFullName(eObject);
        }
        return returnString;
    }

    public static String getSqlEObjectUUID(EObject eObject) {
        String returnString = "NULL";
        SqlAspect aspect = AspectManager.getSqlAspect((EObject)eObject);
        if (aspect != null) {
            returnString = aspect.getObjectID(eObject).toString();
        }
        return returnString;
    }

    public static String getSqlEObjectPath(EObject eObject) {
        String returnString = "NULL";
        SqlAspect aspect = AspectManager.getSqlAspect((EObject)eObject);
        if (aspect != null) {
            returnString = aspect.getPath(eObject).toString();
        }
        return returnString;
    }

    public static String getSqlColumnName(EObject eObject) {
        String returnString = "NULL";
        if (TransformationHelper.isSqlColumn(eObject)) {
            if (TransformationHelper.isXmlDocument(eObject)) {
                returnString = "xml";
            } else {
                SqlAspect aspect = AspectManager.getSqlAspect((EObject)eObject);
                if (aspect != null) {
                    returnString = aspect.getName(eObject);
                }
            }
        }
        return returnString;
    }

    public static List getProcedureParameters(EObject eObject) {
        List params = null;
        if (TransformationHelper.isSqlProcedure(eObject)) {
            SqlProcedureAspect procedureAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)eObject);
            params = procedureAspect.getParameters(eObject);
        }
        if (params == null) {
            params = Collections.EMPTY_LIST;
        }
        return params;
    }

    public static List getInoutParameters(EObject eObject) {
        List params = TransformationHelper.getProcedureParameters(eObject);
        ArrayList result = new ArrayList(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            SqlProcedureParameterAspect parameterAspect;
            int type;
            Object param = iter.next();
            if (!TransformationHelper.isSqlProcedureParameter(param) || (type = (parameterAspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)param))).getType((EObject)param)) != 2) continue;
            result.add(param);
        }
        return result;
    }

    public static List getInParameters(EObject eObject) {
        List params = TransformationHelper.getProcedureParameters(eObject);
        ArrayList result = new ArrayList(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            SqlProcedureParameterAspect parameterAspect;
            int type;
            Object param = iter.next();
            if (!TransformationHelper.isSqlProcedureParameter(param) || (type = (parameterAspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)param))).getType((EObject)param)) != 0) continue;
            result.add(param);
        }
        return result;
    }

    public static List getInAndInoutParameters(EObject eObject) {
        List params = TransformationHelper.getProcedureParameters(eObject);
        ArrayList result = new ArrayList(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            SqlProcedureParameterAspect parameterAspect;
            int type;
            Object param = iter.next();
            if (!TransformationHelper.isSqlProcedureParameter(param) || (type = (parameterAspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)param))).getType((EObject)param)) != 0 && type != 2) continue;
            result.add(param);
        }
        return result;
    }

    public static List getOutAndReturnParameters(EObject eObject) {
        List params = TransformationHelper.getProcedureParameters(eObject);
        ArrayList result = new ArrayList(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            SqlProcedureParameterAspect parameterAspect;
            int type;
            Object param = iter.next();
            if (!TransformationHelper.isSqlProcedureParameter(param) || (type = (parameterAspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)((EObject)param))).getType((EObject)param)) != 1 && type != 3) continue;
            result.add(param);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSourceAlias(Object mappingRoot, EObject eObj, String aliasName, boolean isSignificant, Object txnSource) {
        boolean wasRemoved = false;
        MappingHelper helper = TransformationHelper.getMappingHelper(mappingRoot);
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)REMOVE_SRC_ALIAS_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                EList inputEObjects;
                TransformationHelper.removeSourceAliasMatchingName((EObject)transMappingRoot, eObj, aliasName);
                List aliases = TransformationHelper.getSqlAliasesForSource(transMappingRoot, eObj);
                if (aliases.size() == 0 && (inputEObjects = transMappingRoot.getInputs()).contains(eObj)) {
                    TransformationHelper.removeValueFromEList((EObject)transMappingRoot, eObj, transMappingRoot.getInputs());
                    TransformationHelper.removeModelImportForSourceObject((EmfResource)transMappingRoot.eResource(), eObj);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            wasRemoved = true;
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSourceAliases(Object mappingRoot, EObject source, List sqlAliases, boolean isSignificant, Object txnSource) {
        boolean wasRemoved = false;
        MappingHelper helper = TransformationHelper.getMappingHelper(mappingRoot);
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)REMOVE_SRC_ALIAS_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                Iterator iter = sqlAliases.iterator();
                ArrayList aliasesToRemove = new ArrayList(sqlAliases.size());
                while (iter.hasNext()) {
                    EObject aliasedObj;
                    Object nextObj = iter.next();
                    if (!(nextObj instanceof SqlAlias) || (aliasedObj = ((SqlAlias)nextObj).getAliasedObject()) == null || !aliasedObj.equals(source) || aliasesToRemove.contains(nextObj)) continue;
                    aliasesToRemove.add(nextObj);
                }
                List allSourceAliases = TransformationHelper.getSqlAliasesForSource(transMappingRoot, source);
                boolean removeSource = false;
                if (aliasesToRemove.size() == allSourceAliases.size()) {
                    removeSource = true;
                }
                SqlTransformation sqlTrans = (SqlTransformation)helper;
                Iterator removeIter = aliasesToRemove.iterator();
                while (removeIter.hasNext()) {
                    EObject removeObj = (EObject)removeIter.next();
                    TransformationHelper.removeValueFromEList((EObject)sqlTrans, removeObj, sqlTrans.getAliases());
                    TransformationHelper.removeModelImportForSourceObject((EmfResource)transMappingRoot.eResource(), removeObj);
                }
                if (removeSource) {
                    TransformationHelper.removeValueFromEList((EObject)transMappingRoot, source, transMappingRoot.getInputs());
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            wasRemoved = true;
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeAllSourcesAndAliases(Object mappingRoot, boolean isSignificant, Object txnSource) {
        boolean wasCleared = false;
        MappingHelper helper = TransformationHelper.getMappingHelper(mappingRoot);
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)REMOVE_SRC_ALIAS_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                TransformationHelper.clearXmlDocumentAsSource(transMappingRoot, true, txnSource);
                SqlTransformation sqlTrans = (SqlTransformation)helper;
                ArrayList aliasList = new ArrayList(((SqlTransformation)helper).getAliases());
                Iterator aliasIter = aliasList.iterator();
                while (aliasIter.hasNext()) {
                    TransformationHelper.removeValueFromEList((EObject)sqlTrans, aliasIter.next(), sqlTrans.getAliases());
                }
                ArrayList inputList = new ArrayList(transMappingRoot.getInputs());
                Iterator inputIter = inputList.iterator();
                while (inputIter.hasNext()) {
                    EObject removeObj = (EObject)inputIter.next();
                    TransformationHelper.removeValueFromEList((EObject)transMappingRoot, removeObj, transMappingRoot.getInputs());
                    TransformationHelper.removeModelImportForSourceObject((EmfResource)transMappingRoot.eResource(), removeObj);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            wasCleared = true;
        }
        return wasCleared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearXmlDocumentAsSource(SqlTransformationMappingRoot transformation, boolean forceClearContentViaElement, Object txnSource) {
        EObject target = transformation.getTarget();
        if (!(target instanceof Operation)) {
            return;
        }
        Operation operation = (Operation)target;
        if (operation.getOutput() != null) {
            boolean requiredStart = false;
            boolean succeeded = false;
            try {
                requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Output Property Values", (Object)txnSource);
                if (operation.getOutput().getXmlDocument() != null) {
                    operation.getOutput().setXmlDocument(null);
                }
                if (operation.getOutput().getContentElement() != null && forceClearContentViaElement) {
                    operation.getOutput().setContentElement(null);
                }
                succeeded = true;
            }
            catch (Exception ex) {
                TransformationPlugin.Util.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".clearXmlDocumentAsSource()");
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clearTransformation(Object mappingRoot, boolean isSignificant, Object txnSource, boolean removeAttributes) {
        boolean wasCleared = false;
        EObject targetEObject = null;
        MappingHelper helper = TransformationHelper.getMappingHelper(mappingRoot);
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
            targetEObject = transMappingRoot.getTarget();
        }
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)REMOVE_SRC_ALIAS_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                TransformationHelper.removeAllSourcesAndAliases(transMappingRoot, isSignificant, txnSource);
                String defaultSelect = TransformationHelper.getDefaultSqlSelectString(transMappingRoot);
                TransformationHelper.setSelectSqlString(mappingRoot, defaultSelect, isSignificant, txnSource);
                TransformationHelper.setInsertSqlString(mappingRoot, null, isSignificant, txnSource);
                TransformationHelper.setUpdateSqlString(mappingRoot, null, isSignificant, txnSource);
                TransformationHelper.setDeleteSqlString(mappingRoot, null, isSignificant, txnSource);
                AttributeMappingHelper.clearAttributeMappingInputs((Object)mappingRoot, (Object)txnSource);
                if (removeAttributes) {
                    ArrayList attributes = new ArrayList(targetEObject.eContents());
                    try {
                        ModelerCore.getModelEditor().delete(attributes);
                    }
                    catch (ModelerCoreException e) {
                        String message = TransformationPlugin.Util.getString("TransformationHelper.removeTargetAttributeError", (Object)ModelerCore.getModelEditor().getName(targetEObject));
                        TransformationPlugin.Util.log(4, (Throwable)e, message);
                    }
                    AttributeMappingHelper.clearAttributeMappings((Object)mappingRoot, (Object)txnSource);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            wasCleared = true;
        }
        return wasCleared;
    }

    public static boolean containsSqlAliasName(Object transMappingRoot, String desiredName) {
        boolean contains = false;
        List allSqlAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
        Iterator iter = allSqlAliases.iterator();
        while (iter.hasNext()) {
            String aliasName = ((SqlAlias)iter.next()).getAlias();
            if (aliasName == null || !aliasName.equalsIgnoreCase(desiredName)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static boolean containsSqlAliasName(Object transMappingRoot, String desiredName, Object sourceObject) {
        boolean contains = false;
        List allSqlAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
        Iterator iter = allSqlAliases.iterator();
        while (iter.hasNext()) {
            EObject eObj;
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            String aliasName = sqlAlias.getAlias();
            if (aliasName == null || !aliasName.equalsIgnoreCase(desiredName) || sourceObject != (eObj = sqlAlias.getAliasedObject())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private static void removeSourceAliasMatchingName(EObject transMappingRoot, EObject eObj, String aliasName) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)helper)) {
            SqlTransformation sqlTrans = (SqlTransformation)helper;
            EList aliases = sqlTrans.getAliases();
            SqlAlias aliasToRemove = null;
            Iterator iter = aliases.iterator();
            while (iter.hasNext()) {
                SqlAlias sqlAlias = (SqlAlias)iter.next();
                EObject aEObj = sqlAlias.getAliasedObject();
                String aName = sqlAlias.getAlias();
                if (aEObj == null || aName == null || !aEObj.equals(eObj) || !aName.equalsIgnoreCase(aliasName)) continue;
                aliasToRemove = sqlAlias;
                break;
            }
            if (aliasToRemove != null) {
                TransformationHelper.removeValueFromEList((EObject)sqlTrans, aliasToRemove, sqlTrans.getAliases());
            }
        }
    }

    public static void reconcileInputsAndAliases(EObject transMappingRoot) {
        if (TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            SqlTransformationMappingRoot tmRoot = (SqlTransformationMappingRoot)transMappingRoot;
            List allAliases = TransformationHelper.getAllSqlAliases(tmRoot);
            List allAliasedEObjs = TransformationHelper.getAllAliasedEObjs(tmRoot);
            EList allInputs = tmRoot.getInputs();
            ArrayList badInputList = new ArrayList(allInputs.size());
            Iterator inputIter = allInputs.iterator();
            while (inputIter.hasNext()) {
                Object input = inputIter.next();
                if (allAliasedEObjs.contains(input)) continue;
                badInputList.add(input);
            }
            if (!badInputList.isEmpty()) {
                Iterator badIter = badInputList.iterator();
                while (badIter.hasNext()) {
                    EObject removeObj = (EObject)badIter.next();
                    TransformationHelper.removeValueFromEList((EObject)tmRoot, removeObj, tmRoot.getInputs());
                    TransformationHelper.removeModelImportForSourceObject((EmfResource)tmRoot.eResource(), removeObj);
                }
            }
            ArrayList<SqlAlias> badAliasList = new ArrayList<SqlAlias>();
            Iterator aliasIter = allAliases.iterator();
            while (aliasIter.hasNext()) {
                SqlAlias sqlAlias = (SqlAlias)aliasIter.next();
                EObject aliasedEObj = sqlAlias.getAliasedObject();
                if (aliasedEObj == null || allInputs.contains(aliasedEObj)) continue;
                badAliasList.add(sqlAlias);
            }
            Iterator badAliasIter = badAliasList.iterator();
            while (badAliasIter.hasNext()) {
                MappingHelper helper = TransformationHelper.getMappingHelper(tmRoot);
                if (!(helper instanceof SqlTransformation)) continue;
                SqlTransformation sqlTrans = (SqlTransformation)helper;
                TransformationHelper.removeValueFromEList((EObject)sqlTrans, badAliasIter.next(), sqlTrans.getAliases());
            }
        }
    }

    public static List getAllTransformations(Resource resource) {
        Assertion.isNotNull((Object)resource);
        ArrayList transformations = new ArrayList();
        EList contents = resource.getContents();
        Iterator cIter = contents.iterator();
        while (cIter.hasNext()) {
            Object obj = cIter.next();
            if (!(obj instanceof TransformationContainer)) continue;
            EList mappings = ((TransformationContainer)obj).getTransformationMappings();
            transformations.addAll(mappings);
            break;
        }
        return transformations;
    }

    public static List getAllSqlAliases(Object transMappingRoot) {
        List allAliases = null;
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation) {
            allAliases = ((SqlTransformation)helper).getAliases();
        }
        if (allAliases == null) {
            allAliases = Collections.EMPTY_LIST;
        }
        return allAliases;
    }

    public static List getAllAliasedEObjs(Object transMappingRoot) {
        ArrayList<EObject> uniqueEObjList = new ArrayList<EObject>();
        List allAliases = TransformationHelper.getAllSqlAliases(transMappingRoot);
        Iterator iter = allAliases.iterator();
        while (iter.hasNext()) {
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            EObject aliasedEObj = sqlAlias.getAliasedObject();
            if (aliasedEObj == null || uniqueEObjList.contains(aliasedEObj)) continue;
            uniqueEObjList.add(aliasedEObj);
        }
        return uniqueEObjList;
    }

    public static List getSqlAliasesForSource(Object transMappingRoot, EObject eObj) {
        ArrayList<SqlAlias> matchingAliases = new ArrayList<SqlAlias>();
        ArrayList<SqlAlias> badAliasList = new ArrayList<SqlAlias>();
        Iterator iter = TransformationHelper.getAllSqlAliases(transMappingRoot).iterator();
        SqlAlias nextAlias = null;
        while (iter.hasNext()) {
            nextAlias = (SqlAlias)iter.next();
            EObject aliasedObject = nextAlias.getAliasedObject();
            if (aliasedObject != null) {
                if (!aliasedObject.equals(eObj)) continue;
                matchingAliases.add(nextAlias);
                continue;
            }
            String message = "[TransformationHelper.getSqlAliasesForSource()] WARNING:  SqlAlias has no aliased object.";
            TransformationPlugin.Util.log(2, message);
            badAliasList.add(nextAlias);
        }
        if (badAliasList.size() > 0) {
            int nBad = badAliasList.size();
            for (int i = nBad - 1; i >= 0; --i) {
                MappingHelper helper;
                SqlAlias alias = (SqlAlias)badAliasList.get(i);
                if (transMappingRoot == null || (helper = TransformationHelper.getMappingHelper(transMappingRoot)) == null || !(helper instanceof SqlTransformation)) continue;
                SqlTransformation sqlTrans = (SqlTransformation)helper;
                TransformationHelper.removeValueFromEList((EObject)sqlTrans, alias, sqlTrans.getAliases());
            }
        }
        return matchingAliases;
    }

    public static boolean isSqlTransformation(Object obj) {
        return obj != null && obj instanceof SqlTransformation;
    }

    public static boolean isXQueryTransformation(Object obj) {
        return obj instanceof XQueryTransformation;
    }

    public static boolean isSqlTable(Object obj) {
        boolean isTable = false;
        if (obj != null && obj instanceof EObject) {
            isTable = SqlAspectHelper.isTable((EObject)((EObject)obj));
        }
        return isTable;
    }

    public static boolean isSqlInputSet(Object obj) {
        boolean isInputSet = false;
        if (obj != null && obj instanceof EObject) {
            isInputSet = SqlAspectHelper.isInputSet((EObject)((EObject)obj));
        }
        return isInputSet;
    }

    public static boolean isXmlDocument(Object obj) {
        boolean isTable = false;
        if (obj != null && obj instanceof EObject) {
            isTable = SqlAspectHelper.isXmlDocument((EObject)((EObject)obj));
        }
        return isTable;
    }

    public static boolean isSqlProcedure(Object obj) {
        boolean isProcedure = false;
        if (obj != null && obj instanceof EObject) {
            isProcedure = SqlAspectHelper.isProcedure((EObject)((EObject)obj));
        }
        return isProcedure;
    }

    public static boolean isXQueryProcedure(Object obj) {
        String mmUri;
        boolean isProcedure;
        boolean result = false;
        if (obj != null && obj instanceof EObject && (isProcedure = SqlAspectHelper.isProcedure((EObject)((EObject)obj))) && (mmUri = ((EObject)obj).eClass().getEPackage().getNsURI()) != null && mmUri.endsWith(XML_SERVICE_URI)) {
            result = true;
        }
        return result;
    }

    public static boolean isSqlVirtualProcedure(Object obj) {
        boolean isVirtualProcedure = false;
        if (obj != null && obj instanceof EObject && TransformationHelper.isSqlProcedure(obj) && TransformationHelper.isVirtual(obj)) {
            isVirtualProcedure = true;
        }
        return isVirtualProcedure;
    }

    public static boolean isSqlProcedureParameter(Object obj) {
        boolean isProcedure = false;
        if (obj != null && obj instanceof EObject) {
            isProcedure = SqlAspectHelper.isProcedureParameter((EObject)((EObject)obj));
        }
        return isProcedure;
    }

    public static boolean isSqlProcedureResultSet(Object obj) {
        boolean isProcedure = false;
        if (obj != null && obj instanceof EObject) {
            isProcedure = SqlAspectHelper.isProcedureResultSet((EObject)((EObject)obj));
        }
        return isProcedure;
    }

    public static boolean isSqlInputParameter(Object obj) {
        boolean isProcedure = false;
        if (obj != null && obj instanceof EObject) {
            isProcedure = SqlAspectHelper.isInputParameter((EObject)((EObject)obj));
        }
        return isProcedure;
    }

    public static boolean isSqlColumnSet(Object obj) {
        boolean isTable = false;
        if (obj != null && obj instanceof EObject) {
            isTable = SqlAspectHelper.isColumnSet((EObject)((EObject)obj));
        }
        return isTable;
    }

    public static boolean isSqlColumn(Object obj) {
        boolean isColumn = false;
        if (obj != null && obj instanceof EObject) {
            isColumn = SqlAspectHelper.isColumn((EObject)((EObject)obj));
        }
        return isColumn;
    }

    public static boolean isNonSelectableSqlColumn(Object obj) {
        SqlColumnAspect colAspect;
        SqlAspect sqlAspect;
        boolean isNonSelectCol = false;
        if (obj != null && obj instanceof EObject && (sqlAspect = AspectManager.getSqlAspect((EObject)((EObject)obj))) instanceof SqlColumnAspect && !(colAspect = (SqlColumnAspect)sqlAspect).isSelectable((EObject)obj)) {
            isNonSelectCol = true;
        }
        return isNonSelectCol;
    }

    public static boolean isVirtualSqlTable(Object obj) {
        boolean isTable;
        boolean isVirtualTable = false;
        if (obj != null && obj instanceof EObject && (isTable = SqlAspectHelper.isTable((EObject)((EObject)obj)))) {
            isVirtualTable = TransformationHelper.isVirtual(obj);
        }
        return isVirtualTable;
    }

    public static boolean isValidSqlTransformationTarget(Object obj) {
        boolean isValidTarget = false;
        if (obj != null && obj instanceof EObject) {
            isValidTarget = SqlAspectHelper.isValidSqlTransformationTarget((EObject)((EObject)obj));
        }
        return isValidTarget;
    }

    public static boolean isValidTransformationTarget(Object obj) {
        boolean isValidTarget = false;
        if (obj != null && obj instanceof EObject) {
            isValidTarget = SqlAspectHelper.isValidTransformationTarget((EObject)((EObject)obj));
        }
        return isValidTarget;
    }

    public static boolean isValidSource(Object transformationRoot, Object obj) {
        EObject target;
        boolean isValid = false;
        if (transformationRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transformationRoot) && (TransformationHelper.isSqlTable(obj) && !TransformationHelper.isSqlInputSet(obj) && !TransformationHelper.isOperation(obj) || TransformationHelper.isSqlProcedure(obj) && !TransformationHelper.isOperation(obj)) && (target = ((SqlTransformationMappingRoot)transformationRoot).getTarget()) != null && !target.equals(obj)) {
            isValid = true;
        }
        return isValid;
    }

    public static boolean isVirtual(Object obj) {
        if (obj != null && obj instanceof EObject) {
            File newFile;
            XMIHeader header;
            URI theUri;
            EObject eObject = (EObject)obj;
            Resource resource = eObject.eResource();
            if (resource instanceof EmfResource) {
                return ModelType.VIRTUAL_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
            }
            if (resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelUtil.getXmiHeader((File)(newFile = new File(theUri.toFileString())))) != null && ModelType.VIRTUAL_LITERAL.equals(ModelType.get((String)header.getModelType()))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPhysical(Object obj) {
        if (obj != null && obj instanceof EObject) {
            File newFile;
            XMIHeader header;
            URI theUri;
            EObject eObject = (EObject)obj;
            Resource resource = eObject.eResource();
            if (resource instanceof EmfResource) {
                return ModelType.PHYSICAL_LITERAL.equals(((EmfResource)resource).getModelAnnotation().getModelType());
            }
            if (resource == null && eObject.eIsProxy() && (theUri = ((InternalEObject)eObject).eProxyURI().trimFragment()).isFile() && (header = ModelUtil.getXmiHeader((File)(newFile = new File(theUri.toFileString())))) != null && ModelType.PHYSICAL_LITERAL.equals(ModelType.get((String)header.getModelType()))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMappingClass(Object obj) {
        return obj != null && obj instanceof MappingClass && !(obj instanceof StagingTable);
    }

    public static boolean isStagingTable(Object obj) {
        return obj != null && obj instanceof StagingTable;
    }

    public static boolean isOperation(Object obj) {
        return obj != null && obj instanceof Operation;
    }

    public static boolean isSupportsUpdateTableChangeNotification(Notification notification) {
        EStructuralFeature esf;
        return NotificationUtilities.isChanged((Notification)notification) && notification.getFeature() instanceof EStructuralFeature && (esf = (EStructuralFeature)notification.getFeature()).getFeatureID() == 5;
    }

    public static boolean supportsUpdate(EObject transMappingRoot, EObject sourceTableEObject) {
        return TransformationHelper.getUpdateSqlUUIDString(transMappingRoot) != null && TransformationHelper.isUpdateAllowed(transMappingRoot);
    }

    public static boolean supportsInsert(EObject transMappingRoot, EObject sourceTableEObject) {
        return TransformationHelper.getInsertSqlUUIDString(transMappingRoot) != null && TransformationHelper.isInsertAllowed(transMappingRoot);
    }

    public static boolean supportsDelete(EObject transMappingRoot, EObject sourceTableEObject) {
        return TransformationHelper.getDeleteSqlUUIDString(transMappingRoot) != null && TransformationHelper.isDeleteAllowed(transMappingRoot);
    }

    public static boolean isAllowed(Object transMappingRoot, int cmdType) {
        boolean result = false;
        if (cmdType == 0) {
            result = true;
        } else if (cmdType == 1) {
            result = TransformationHelper.isInsertAllowed(transMappingRoot);
        } else if (cmdType == 2) {
            result = TransformationHelper.isUpdateAllowed(transMappingRoot);
        } else if (cmdType == 3) {
            result = TransformationHelper.isDeleteAllowed(transMappingRoot);
        }
        return result;
    }

    public static boolean isUpdateSqlDefault(EObject transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation) {
            return ((SqlTransformation)helper).isUpdateSqlDefault();
        }
        return false;
    }

    public static boolean isInsertSqlDefault(EObject transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation) {
            return ((SqlTransformation)helper).isInsertSqlDefault();
        }
        return false;
    }

    public static boolean isDeleteSqlDefault(EObject transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation) {
            return ((SqlTransformation)helper).isDeleteSqlDefault();
        }
        return false;
    }

    public static boolean isSqlDefault(EObject transMappingRoot, int cmdType) {
        boolean result = false;
        if (cmdType == 0) {
            result = true;
        } else if (cmdType == 1) {
            result = TransformationHelper.isInsertSqlDefault(transMappingRoot);
        } else if (cmdType == 2) {
            result = TransformationHelper.isUpdateSqlDefault(transMappingRoot);
        } else if (cmdType == 3) {
            result = TransformationHelper.isDeleteSqlDefault(transMappingRoot);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUpdateSqlDefault(Object transMappingRoot, boolean isUpdateDefault, boolean isSignificant, Object txnSource) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            SqlTransformation userTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_UPDATE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setUpdateSqlDefault(isUpdateDefault);
                if (userTrans != null) {
                    userTrans.setUpdateSqlDefault(isUpdateDefault);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInsertSqlDefault(Object transMappingRoot, boolean isInsertDefault, boolean isSignificant, Object txnSource) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            SqlTransformation userTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_INSERT_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setInsertSqlDefault(isInsertDefault);
                if (userTrans != null) {
                    userTrans.setInsertSqlDefault(isInsertDefault);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDeleteSqlDefault(Object transMappingRoot, boolean isDeleteDefault, boolean isSignificant, Object txnSource) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            SqlTransformation userTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_DELETE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setDeleteSqlDefault(isDeleteDefault);
                if (userTrans != null) {
                    userTrans.setDeleteSqlDefault(isDeleteDefault);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static boolean tableSupportsUpdate(EObject targetTableEObject) {
        SqlTableAspect aspect;
        boolean tableSupportsUpdate = false;
        if (TransformationHelper.isVirtualSqlTable(targetTableEObject) && (aspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)targetTableEObject)).supportsUpdate(targetTableEObject)) {
            tableSupportsUpdate = true;
        }
        return tableSupportsUpdate;
    }

    public static void setTableSupportsUpdate(EObject targetTableEObject, boolean supportsUpdate) {
        SqlTableAspect aspect;
        if (TransformationHelper.isVirtualSqlTable(targetTableEObject) && (aspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)targetTableEObject)) != null) {
            aspect.setSupportsUpdate(targetTableEObject, supportsUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportsUpdate(Object transMappingRoot, boolean supportsUpdate, boolean isSignificant, Object txnSource) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            SqlTransformation userTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_UPDATE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setUpdateAllowed(supportsUpdate);
                if (userTrans != null) {
                    userTrans.setUpdateAllowed(supportsUpdate);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportsInsert(Object transMappingRoot, boolean supportsInsert, boolean isSignificant, Object txnSource) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            SqlTransformation userTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_INSERT_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setInsertAllowed(supportsInsert);
                if (userTrans != null) {
                    userTrans.setInsertAllowed(supportsInsert);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportsDelete(Object transMappingRoot, boolean supportsDelete, boolean isSignificant, Object txnSource) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        if (helper != null && helper instanceof SqlTransformation && !TransformationHelper.isReadOnly((EObject)transMappingRoot)) {
            SqlTransformation userTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_DELETE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setDeleteAllowed(supportsDelete);
                if (userTrans != null) {
                    userTrans.setDeleteAllowed(supportsDelete);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EObject getTransformationMappingRoot(EObject targetVirtualGroupEObject, boolean makeSignificant, boolean makeUndoable) {
        if (!TransformationHelper.isValidSqlTransformationTarget(targetVirtualGroupEObject)) {
            throw new IllegalArgumentException(NULL_OR_INVALID_TARGET);
        }
        Object transformEObject = null;
        List allTransforms = null;
        ModelContents modelContents = ModelerCore.getModelEditor().getModelContents(targetVirtualGroupEObject);
        if (modelContents != null) {
            allTransforms = modelContents.getTransformations(targetVirtualGroupEObject);
        }
        if (!allTransforms.isEmpty()) {
            Object nextObj = allTransforms.iterator().next();
            if (TransformationHelper.isSqlTransformationMappingRoot(nextObj)) {
                transformEObject = (EObject)nextObj;
            } else if (TransformationHelper.isXQueryTransformationMappingRoot(nextObj)) {
                transformEObject = (EObject)nextObj;
            }
        } else if (!TransformationHelper.isReadOnly(targetVirtualGroupEObject)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)makeSignificant, (boolean)makeUndoable, (String)"Create Transformation Mapping Root", (Object)targetVirtualGroupEObject);
            boolean succeeded = false;
            try {
                transformEObject = TransformationHelper.isXQueryProcedure(targetVirtualGroupEObject) ? ModelResourceContainerFactory.createNewXQueryTransformationMappingRoot((EObject)targetVirtualGroupEObject, (Resource)targetVirtualGroupEObject.eResource()) : ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)targetVirtualGroupEObject, (Resource)targetVirtualGroupEObject.eResource());
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return transformEObject;
    }

    public static synchronized EObject getTransformationMappingRoot(EObject targetVirtualGroupEObject) {
        return TransformationHelper.getTransformationMappingRoot(targetVirtualGroupEObject, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EObject getMappingRoot(EObject targetVirtualGroupEObject, boolean makeSignificant, boolean makeUndoable) {
        if (!TransformationHelper.isValidTransformationTarget(targetVirtualGroupEObject)) {
            throw new IllegalArgumentException(NULL_OR_INVALID_TARGET);
        }
        EObject transformEObject = null;
        List allTransforms = null;
        ModelContents modelContents = ModelerCore.getModelEditor().getModelContents(targetVirtualGroupEObject);
        if (modelContents != null) {
            allTransforms = modelContents.getTransformations(targetVirtualGroupEObject);
        }
        if (!allTransforms.isEmpty()) {
            Object nextObj = allTransforms.iterator().next();
            if (TransformationHelper.isSqlTransformationMappingRoot(nextObj)) {
                transformEObject = (EObject)nextObj;
            }
        } else if (!TransformationHelper.isReadOnly(targetVirtualGroupEObject)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)makeSignificant, (boolean)makeUndoable, (String)"Create Transformation Mapping Root", (Object)targetVirtualGroupEObject);
            boolean succeeded = false;
            try {
                transformEObject = TransformationHelper.isXmlDocument(targetVirtualGroupEObject) ? ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)targetVirtualGroupEObject, (Resource)targetVirtualGroupEObject.eResource()) : ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)targetVirtualGroupEObject, (Resource)targetVirtualGroupEObject.eResource());
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return transformEObject;
    }

    public static synchronized EObject getMappingRoot(EObject targetVirtualGroupEObject) {
        return TransformationHelper.getMappingRoot(targetVirtualGroupEObject, false, true);
    }

    public static boolean isReadOnly(EObject theEObject) {
        boolean result = true;
        if (theEObject != null) {
            ModelResource modelResource = ModelerCore.getModelEditor().findModelResource(theEObject);
            result = modelResource != null ? ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource()) : false;
        }
        return result;
    }

    public static Map getExternalMetadataMap(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.getExternalMetadataMap((Object)transMappingRoot, (int)cmdType);
    }

    public static Map getExternalMapForCreateUpdateProcedure(EObject transMappingRoot, int cmdType) {
        return SqlMappingRootCache.getExternalMapForCreateUpdateProc((Object)transMappingRoot, (int)cmdType);
    }

    public static Map getExternalMetadataMap(Command command, SqlTransformationMappingRoot mappingRoot, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (mappingRoot != null) {
            EObject targetGroup = mappingRoot.getTarget();
            if (targetGroup instanceof MappingClass) {
                HashMap externalMetadata = new HashMap();
                InputSet inputSet = ((MappingClass)targetGroup).getInputSet();
                if (inputSet != null) {
                    externalMetadata.putAll(TransformationHelper.getExternalMetadataMapForInputSet(inputSet));
                }
                externalMetadata.putAll(TransformationHelper.getExternalMetadataMapForMappingClass((MappingClass)targetGroup, metadata));
                return externalMetadata;
            }
            if (targetGroup instanceof Table) {
                if (command != null && command.getType() == 7) {
                    return TransformationHelper.getExternalMetadataMapForUpdateProcedure((Table)targetGroup, metadata);
                }
                HashMap externalMetadata = new HashMap();
                externalMetadata.putAll(TransformationHelper.getExternalMetadataMapForTable((Table)targetGroup, metadata));
                return externalMetadata;
            }
            if (targetGroup instanceof Procedure) {
                return TransformationHelper.getStoredProcedureExternalMetadataMap((Procedure)targetGroup, metadata);
            }
            if (targetGroup instanceof Operation) {
                return TransformationHelper.getOperationExternalMetadataMap((Operation)targetGroup, metadata);
            }
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getExternalMetadataMapForMappingClass(MappingClass mc, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        HashMap externalMetadata = new HashMap();
        return externalMetadata;
    }

    public static List getProcedureResultSetParameters(StoredProcedure proc) {
        List resultParams = Collections.EMPTY_LIST;
        if (proc != null && proc.getProcedureID() instanceof ProcedureRecord) {
            SqlAspect aspect;
            ProcedureRecord record = (ProcedureRecord)proc.getProcedureID();
            Object resultSetID = record.getResultSetID();
            String uriString = record.getResourcePath() + "#" + resultSetID;
            EObject resultSetEObj = TransformationHelper.getEObjectByURI(uriString);
            if (TransformationHelper.isSqlProcedureResultSet(resultSetEObj) && (aspect = SqlAspectHelper.getSqlAspect((EObject)resultSetEObj)) != null && aspect instanceof SqlColumnSetAspect) {
                resultParams = ((SqlColumnSetAspect)aspect).getColumns(resultSetEObj);
            }
        }
        return resultParams;
    }

    public static EObject getEObjectByURI(String eObjectURI) {
        if (eObjectURI != null) {
            URI uri = URI.createURI((String)eObjectURI);
            try {
                return ModelerCore.getModelContainer().getEObject(uri, true);
            }
            catch (CoreException err) {
                TransformationPlugin.Util.log((Throwable)err);
            }
        }
        return null;
    }

    public static Map getExternalMetadataMapForTable(Table targetGroup, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (targetGroup == null) {
            return Collections.EMPTY_MAP;
        }
        String targetGroupFullName = TransformationHelper.getSqlEObjectFullName((EObject)targetGroup);
        String targetGroupUUID = TransformationHelper.getSqlEObjectUUID((EObject)targetGroup);
        GroupSymbol gSymbol = new GroupSymbol(targetGroupFullName);
        Object groupID = metadata.getGroupID(targetGroupUUID);
        if (groupID != null) {
            gSymbol.setMetadataID(groupID);
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getExternalMetadataMapForUpdateProcedure(Table targetGroup, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (targetGroup != null) {
            String targetGroupFullName = TransformationHelper.getSqlEObjectFullName((EObject)targetGroup);
            String targetGroupUUID = TransformationHelper.getSqlEObjectUUID((EObject)targetGroup);
            GroupSymbol gSymbol = new GroupSymbol(targetGroupFullName);
            Object groupID = metadata.getGroupID(targetGroupUUID);
            if (groupID != null) {
                gSymbol.setMetadataID(groupID);
                return ExternalMetadataUtil.getProcedureExternalMetadata((GroupSymbol)gSymbol, (QueryMetadataInterface)metadata);
            }
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getExternalMetadataMapForInputSet(InputSet inputSet) {
        HashMap externalMetadata = new HashMap();
        GroupSymbol inputSetSymbol = new GroupSymbol("INPUT");
        EList inputParams = inputSet.getInputParameters();
        ArrayList<SingleElementSymbol> elements = new ArrayList<SingleElementSymbol>();
        Iterator inputParamIter1 = inputParams.iterator();
        while (inputParamIter1.hasNext()) {
            InputParameter inputParam = (InputParameter)inputParamIter1.next();
            SingleElementSymbol element = TransformationSqlHelper.createElemSymbol((EObject)inputParam, (GroupSymbol)inputSetSymbol);
            if (element == null) continue;
            elements.add(element);
        }
        inputSetSymbol.setMetadataID((Object)new TempMetadataID(inputSetSymbol.getName().toUpperCase(), elements));
        if (elements.size() > 0) {
            externalMetadata.put(inputSetSymbol, elements);
        }
        ObjectID uuid = inputSet.getObjectId();
        GroupSymbol inputSetUuidSymbol = new GroupSymbol(uuid.toString());
        ArrayList<SingleElementSymbol> elementSymbols = new ArrayList<SingleElementSymbol>(elements.size());
        Iterator inputParamIter2 = inputParams.iterator();
        while (inputParamIter2.hasNext()) {
            InputParameter inputParam = (InputParameter)inputParamIter2.next();
            SingleElementSymbol element = TransformationSqlHelper.createElemSymbol((EObject)inputParam, (GroupSymbol)inputSetUuidSymbol);
            if (element == null) continue;
            elementSymbols.add(element);
        }
        inputSetUuidSymbol.setMetadataID((Object)new TempMetadataID(uuid.toString().toUpperCase(), elementSymbols));
        if (elementSymbols.size() > 0) {
            externalMetadata.put(inputSetUuidSymbol, elementSymbols);
        }
        return externalMetadata;
    }

    public static Map getExternalMetadataMapForProcedure(Procedure procedure) {
        HashMap externalMetadata = new HashMap();
        GroupSymbol procedureSymbol = new GroupSymbol(procedure.getName());
        EList params = procedure.getParameters();
        ArrayList<SingleElementSymbol> elements = new ArrayList<SingleElementSymbol>();
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol element;
            ProcedureParameter param = (ProcedureParameter)iter.next();
            if (param.getDirection() != DirectionKind.IN_LITERAL && param.getDirection() != DirectionKind.INOUT_LITERAL || (element = TransformationSqlHelper.createElemSymbol((EObject)param, (GroupSymbol)procedureSymbol)) == null) continue;
            elements.add(element);
        }
        procedureSymbol.setMetadataID((Object)new TempMetadataID(procedureSymbol.getName().toUpperCase(), elements));
        if (elements.size() > 0) {
            externalMetadata.put(procedureSymbol, elements);
        }
        ObjectID uuid = procedure.getObjectId();
        GroupSymbol procedureUuidSymbol = new GroupSymbol(uuid.toString());
        ArrayList<SingleElementSymbol> elementSymbols = new ArrayList<SingleElementSymbol>(elements.size());
        Iterator iter2 = params.iterator();
        while (iter2.hasNext()) {
            SingleElementSymbol element;
            ProcedureParameter param = (ProcedureParameter)iter2.next();
            if (param.getDirection() != DirectionKind.IN_LITERAL || (element = TransformationSqlHelper.createElemSymbol((EObject)param, (GroupSymbol)procedureUuidSymbol)) == null) continue;
            elementSymbols.add(element);
        }
        procedureUuidSymbol.setMetadataID((Object)new TempMetadataID(uuid.toString().toUpperCase(), elementSymbols));
        if (elementSymbols.size() > 0) {
            externalMetadata.put(procedureUuidSymbol, elementSymbols);
        }
        return externalMetadata;
    }

    public static Map getStoredProcedureExternalMetadataMap(Procedure targetProcedure, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (targetProcedure != null) {
            String targetProcFullName = TransformationHelper.getSqlEObjectFullName((EObject)targetProcedure);
            GroupSymbol gSymbol = new GroupSymbol(targetProcFullName);
            return ExternalMetadataUtil.getStoredProcedureExternalMetadata((GroupSymbol)gSymbol, (QueryMetadataInterface)metadata);
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getOperationExternalMetadataMap(Operation targetOperation, QueryMetadataInterface metadata) throws MetaMatrixComponentException, QueryMetadataException {
        if (targetOperation != null) {
            String targetProcFullName = TransformationHelper.getSqlEObjectFullName((EObject)targetOperation);
            GroupSymbol gSymbol = new GroupSymbol(targetProcFullName);
            return ExternalMetadataUtil.getStoredProcedureExternalMetadata((GroupSymbol)gSymbol, (QueryMetadataInterface)metadata);
        }
        return Collections.EMPTY_MAP;
    }

    public static boolean isTransformationMappingRoot(Object object) {
        return object != null && object instanceof TransformationMappingRoot;
    }

    public static boolean isTransformationMapping(Object object) {
        return object != null && object instanceof TransformationMapping;
    }

    public static boolean isMapping(Object object) {
        return object != null && object instanceof Mapping;
    }

    public static boolean isSqlTransformationMappingRoot(Object object) {
        return object != null && object instanceof SqlTransformationMappingRoot;
    }

    public static boolean isXQueryTransformationMappingRoot(Object object) {
        return object instanceof XQueryTransformationMappingRoot;
    }

    public static boolean isTransformationObject(Object object) {
        boolean result = false;
        if (object instanceof EObject && (TransformationHelper.isTransformationMapping(object) || TransformationHelper.isTransformationMappingRoot(object) || TransformationHelper.isSqlTransformation(object) || TransformationHelper.isSqlTransformationMappingRoot(object) || TransformationHelper.isXQueryTransformation(object) || TransformationHelper.isXQueryTransformationMappingRoot(object))) {
            result = true;
        }
        return result;
    }

    public static boolean isTargetGroupLocked(Object object) {
        EObject mappingRoot;
        boolean isReadOnly = false;
        if (TransformationHelper.isSqlTransformationMappingRoot(object)) {
            isReadOnly = ((SqlTransformationMappingRoot)object).isOutputReadOnly();
        } else if (TransformationHelper.isVirtualSqlTable(object) && (mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)object)) instanceof SqlTransformationMappingRoot) {
            isReadOnly = ((SqlTransformationMappingRoot)mappingRoot).isOutputReadOnly();
        }
        return isReadOnly;
    }

    public static List getSourceEObjects(EObject mappingRoot) {
        List sources = null;
        if (mappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            sources = ((SqlTransformationMappingRoot)mappingRoot).getInputs();
        }
        if (sources == null) {
            sources = Collections.EMPTY_LIST;
        }
        return sources;
    }

    public static EObject getTransformationLinkTarget(EObject mappingRoot) {
        EObject target = null;
        if (TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            target = ((SqlTransformationMappingRoot)mappingRoot).getTarget();
        } else if (TransformationHelper.isXQueryTransformationMappingRoot(mappingRoot)) {
            target = ((XQueryTransformationMappingRoot)mappingRoot).getTarget();
        }
        return target;
    }

    public static EObject getTransformationTarget(Object mappingRoot) {
        EObject result = null;
        if (mappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            EObject rootTarget = ((SqlTransformationMappingRoot)mappingRoot).getTarget();
            if (TransformationHelper.isSqlProcedure(rootTarget)) {
                SqlProcedureAspect procAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)rootTarget);
                result = (EObject)procAspect.getResult(rootTarget);
                if (result == null) {
                    result = TransformationHelper.createProcResultSet(rootTarget);
                }
            } else {
                result = rootTarget;
            }
        }
        return result;
    }

    public static List getTransformationSources(Object mappingRoot) {
        List inputs = Collections.EMPTY_LIST;
        if (mappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(mappingRoot)) {
            inputs = ((SqlTransformationMappingRoot)mappingRoot).getInputs();
        }
        return inputs;
    }

    public static List getTransformationTargetAttributes(EObject mappingRoot) {
        EObject virtualTarget = TransformationHelper.getTransformationTarget(mappingRoot);
        return TransformationHelper.getTargetAttributes(virtualTarget);
    }

    public static List getTargetAttributes(EObject virtualTarget) {
        List result = null;
        if (TransformationHelper.isVirtualSqlTable(virtualTarget)) {
            result = TransformationHelper.getTableColumns(virtualTarget);
        } else if (TransformationHelper.isSqlColumnSet(virtualTarget)) {
            result = TransformationHelper.getColumnSetColumns(virtualTarget);
        }
        if (result == null || result.isEmpty()) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public static List getTableColumns(EObject sqlTable) {
        ArrayList columns = new ArrayList();
        if (sqlTable != null && SqlAspectHelper.isTable((EObject)sqlTable)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)sqlTable);
            columns.addAll(tableAspect.getColumns(sqlTable));
        }
        if (columns.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return columns;
    }

    public static List getColumnSetColumns(EObject sqlColumnSet) {
        SqlColumnSetAspect columnSetAspect;
        List columnList;
        ArrayList columns = new ArrayList();
        if (sqlColumnSet != null && SqlAspectHelper.isColumnSet((EObject)sqlColumnSet) && (columnList = (columnSetAspect = (SqlColumnSetAspect)AspectManager.getSqlAspect((EObject)sqlColumnSet)).getColumns(sqlColumnSet)) != null && !columnList.isEmpty()) {
            columns.addAll(columnSetAspect.getColumns(sqlColumnSet));
        }
        if (columns.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return columns;
    }

    public static Command getCommand(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.getCommand((Object)transMappingRoot, (int)cmdType);
    }

    public static boolean isParsable(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.isParsable((Object)transMappingRoot, (int)cmdType);
    }

    public static boolean isResolvable(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.isResolvable((Object)transMappingRoot, (int)cmdType);
    }

    public static boolean isValid(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.isValid((Object)transMappingRoot, (int)cmdType);
    }

    public static boolean hasSourceGroup(Object transMappingRoot, Object sourceGroup, int cmdType) {
        return SqlMappingRootCache.hasSourceGroup((Object)transMappingRoot, (Object)sourceGroup, (int)cmdType);
    }

    public static void invalidateCachedRootsWithSourceGroups(Set sourceGroups) {
        SqlMappingRootCache.invalidateRootsWithSourceGroups((Set)sourceGroups);
    }

    public static void invalidateCachedRootsWithTargetGroups(Set groups) {
        SqlMappingRootCache.invalidateRootsWithTargetGroups((Set)groups);
    }

    public static boolean isTargetValid(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.isTargetValid((Object)transMappingRoot, (int)cmdType);
    }

    public static IStatus getTargetValidStatus(Object transMappingRoot, int cmdType) {
        return SqlMappingRootCache.getTargetValidStatus((Object)transMappingRoot, (int)cmdType);
    }

    public static boolean isValidQuery(Object transMappingRoot) {
        Command command;
        boolean result = false;
        if (SqlMappingRootCache.isSelectValid((Object)transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot)) instanceof Query) {
            result = true;
        }
        return result;
    }

    public static boolean isValidSetQuery(Object transMappingRoot) {
        Command command;
        boolean result = false;
        if (SqlMappingRootCache.isSelectValid((Object)transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot)) instanceof SetQuery) {
            result = true;
        }
        return result;
    }

    public static boolean isParsableQuery(Object transMappingRoot) {
        Command command;
        boolean result = false;
        if (SqlMappingRootCache.isSelectParsable((Object)transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot)) instanceof Query) {
            result = true;
        }
        return result;
    }

    public static boolean isParsableSetQuery(Object transMappingRoot) {
        Command command;
        boolean result = false;
        if (SqlMappingRootCache.isSelectParsable((Object)transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot)) instanceof SetQuery) {
            result = true;
        }
        return result;
    }

    public static boolean isInitialSelect(Object transMappingRoot) {
        String sqlString = TransformationHelper.getSelectSqlString(transMappingRoot);
        return TransformationHelper.isDefaultSelect(sqlString);
    }

    public static boolean isDefaultSelect(String sqlString) {
        if (sqlString == null) {
            return false;
        }
        StringBuffer sb = new StringBuffer(sqlString);
        SqlStringUtil.replaceAll((StringBuffer)sb, (String)"\n", (String)"");
        SqlStringUtil.replaceAll((StringBuffer)sb, (String)"\t", (String)"");
        SqlStringUtil.replaceAll((StringBuffer)sb, (String)"  ", (String)" ");
        String str = sb.toString();
        return str != null && str.trim().equalsIgnoreCase(DEFAULT_SELECT);
    }

    public static boolean isSelectFromString(Object transMappingRoot) {
        String sqlString = TransformationHelper.getSelectSqlString(transMappingRoot);
        return TransformationHelper.isSelectFromString(sqlString);
    }

    public static boolean isSelectFromString(String sqlString) {
        boolean isSelectFrom = false;
        if (sqlString != null) {
            String trimmedSQL;
            StringBuffer sb = new StringBuffer(sqlString);
            SqlStringUtil.replaceAll((StringBuffer)sb, (String)"\n", (String)"");
            SqlStringUtil.replaceAll((StringBuffer)sb, (String)"\t", (String)"");
            SqlStringUtil.replaceAll((StringBuffer)sb, (String)"  ", (String)" ");
            String str = sb.toString();
            if (str != null && (trimmedSQL = str.trim().toUpperCase()).startsWith("SELECT") && trimmedSQL.endsWith("FROM")) {
                isSelectFrom = true;
            }
        }
        return isSelectFrom;
    }

    public static boolean isEmptySelect(Object transMappingRoot) {
        String sqlString = TransformationHelper.getSelectSqlString(transMappingRoot);
        return TransformationHelper.isEmptySelect(sqlString);
    }

    public static boolean isEmptySelect(String sqlString) {
        boolean result = false;
        if (sqlString == null) {
            result = true;
        } else {
            StringBuffer sb = new StringBuffer(sqlString);
            SqlStringUtil.replaceAll((StringBuffer)sb, (String)"\n", (String)"");
            SqlStringUtil.replaceAll((StringBuffer)sb, (String)"\t", (String)"");
            String str = sb.toString();
            if (str != null && str.trim().length() == 0) {
                result = true;
            }
        }
        return result;
    }

    public static boolean canUseReconciler(Object transMappingRoot) {
        boolean canUse = false;
        boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
        Command command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (command != null) {
            if (isValid && command instanceof Query) {
                canUse = true;
            } else if (command instanceof SetQuery) {
                canUse = true;
            }
        }
        return canUse;
    }

    public static boolean isUnionCommand(Object transMappingRoot) {
        boolean isUnion = false;
        Command command = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
        if (command != null && command instanceof SetQuery) {
            isUnion = true;
        }
        return isUnion;
    }

    public static boolean isDeleteAllowed(Object transMappingRoot) {
        MappingHelper helper;
        boolean result = false;
        EObject target = TransformationHelper.getTransformationTarget(transMappingRoot);
        if (TransformationHelper.tableSupportsUpdate(target) && (helper = TransformationHelper.getMappingHelper(transMappingRoot)) != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).isDeleteAllowed();
        }
        return result;
    }

    public static boolean isInsertAllowed(Object transMappingRoot) {
        MappingHelper helper;
        boolean result = false;
        EObject target = TransformationHelper.getTransformationTarget(transMappingRoot);
        if (TransformationHelper.tableSupportsUpdate(target) && (helper = TransformationHelper.getMappingHelper(transMappingRoot)) != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).isInsertAllowed();
        }
        return result;
    }

    public static boolean isUpdateAllowed(Object transMappingRoot) {
        MappingHelper helper;
        boolean result = false;
        EObject target = TransformationHelper.getTransformationTarget(transMappingRoot);
        if (TransformationHelper.tableSupportsUpdate(target) && (helper = TransformationHelper.getMappingHelper(transMappingRoot)) != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).isUpdateAllowed();
        }
        return result;
    }

    public static String getGeneratedProcedureStr(Object transMappingRoot, int type) {
        CreateUpdateProcedureCommand generatedProc = TransformationHelper.getGeneratedProcedure(transMappingRoot, type);
        if (generatedProc != null) {
            return generatedProc.toString();
        }
        return null;
    }

    public static CreateUpdateProcedureCommand getGeneratedProcedure(Object transMappingRoot, int type) {
        CreateUpdateProcedureCommand generatedProc = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            EObject targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot);
            if (targetGroup == null) {
                return null;
            }
            boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
            int procType = 0;
            if (type == 1) {
                procType = 1;
            } else if (type == 2) {
                procType = 2;
            } else if (type == 3) {
                procType = 3;
            }
            if (isValid && (procType == 1 || procType == 2 || procType == 3)) {
                String virtualTargetFullName = TransformationHelper.getSqlEObjectFullName(targetGroup);
                Command selectCommand = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
                if (selectCommand != null && selectCommand instanceof Query) {
                    try {
                        QueryMetadataInterface resolver = TransformationMetadataFactory.getInstance().getModelerMetadata(targetGroup);
                        generatedProc = UpdateProcedureGenerator.createProcedure((int)procType, (String)virtualTargetFullName, (Command)selectCommand, (QueryMetadataInterface)resolver);
                    }
                    catch (MetaMatrixComponentException e) {
                        String message = "[TransformationHelper.getGeneratedProcedure()] INFO:  Couldnt generate procedure\n";
                        TransformationPlugin.Util.log(1, message + e.getMessage());
                    }
                    catch (QueryMetadataException e) {
                        String message = "[TransformationHelper.getGeneratedProcedure()] INFO:  Couldnt generate procedure\n";
                        TransformationPlugin.Util.log(1, message + e.getMessage());
                    }
                }
            }
        }
        return generatedProc;
    }

    public static String getProcedureGenerationErrorMsg(Object transMappingRoot) {
        String errorMsg = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            EObject targetGroup = TransformationHelper.getTransformationTarget(transMappingRoot);
            if (targetGroup == null) {
                return null;
            }
            boolean isValid = SqlMappingRootCache.isSelectValid((Object)transMappingRoot);
            if (isValid) {
                Command selectCommand = SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
                QueryMetadataInterface resolver = TransformationMetadataFactory.getInstance().getModelerMetadata(targetGroup);
                UpdateValidationVisitor updateVisitor = new UpdateValidationVisitor(resolver);
                PreOrderNavigator.doVisit((LanguageObject)selectCommand, (LanguageVisitor)updateVisitor);
                ValidatorReport report = updateVisitor.getReport();
                if (report.hasItems()) {
                    errorMsg = report.getFailureMessage();
                }
            }
        }
        return errorMsg;
    }

    public static Collection getSourceAttributesForTargetAttr(Object targetAttr, Object transMappingRoot) {
        Collection sourceAttributes = null;
        if (transMappingRoot != null && TransformationHelper.isTransformationMappingRoot(transMappingRoot)) {
            Command selectCommand = TransformationHelper.getCommand(transMappingRoot, 0);
            if (!(selectCommand instanceof SetQuery)) {
                sourceAttributes = new ArrayList();
                EList attrMappings = ((MappingRoot)transMappingRoot).getNested();
                Iterator iter = attrMappings.iterator();
                while (iter.hasNext()) {
                    EObject output;
                    Mapping mapping = (Mapping)iter.next();
                    EList outputs = mapping.getOutputs();
                    if (outputs == null || outputs.isEmpty() || (output = (EObject)outputs.get(0)) == null || !output.equals(targetAttr)) continue;
                    sourceAttributes.addAll(mapping.getInputs());
                    break;
                }
            } else {
                sourceAttributes = TransformationHelper.getUnionSourceAttributesForTargetAttr(targetAttr, (SetQuery)selectCommand);
            }
        }
        if (sourceAttributes == null) {
            sourceAttributes = Collections.EMPTY_LIST;
        }
        return sourceAttributes;
    }

    private static Collection getUnionSourceAttributesForTargetAttr(Object targetAttr, SetQuery unionQry) {
        ArrayList sourceAttributes = new ArrayList();
        if (unionQry != null && unionQry.getOperation() == 0 && unionQry.isResolved()) {
            List projSymbolNames = TransformationSqlHelper.getProjectedSymbolNames((Command)unionQry);
            int index = -1;
            if (TransformationHelper.isSqlColumn(targetAttr)) {
                String attrName = TransformationHelper.getSqlColumnName((EObject)targetAttr);
                for (int i = 0; i < projSymbolNames.size(); ++i) {
                    String symbolName = (String)projSymbolNames.get(i);
                    if (symbolName == null || !symbolName.equalsIgnoreCase(attrName)) continue;
                    index = i;
                    break;
                }
            }
            if (index != -1) {
                List queries = unionQry.getQueries();
                Iterator qIter = queries.iterator();
                while (qIter.hasNext()) {
                    QueryCommand query = (QueryCommand)qIter.next();
                    List projSymbols = query.getProjectedSymbols();
                    if (index >= projSymbols.size()) continue;
                    SingleElementSymbol seSymbol = (SingleElementSymbol)projSymbols.get(index);
                    Collection elemSymbols = ElementCollectorVisitor.getElements((LanguageObject)seSymbol, (boolean)true);
                    List elemEObjs = TransformationSqlHelper.getElementSymbolEObjects((Collection)elemSymbols, (Command)query);
                    sourceAttributes.addAll(elemEObjs);
                }
            }
        }
        return sourceAttributes;
    }

    public static Collection getTargetAttributesForSourceAttr(Object sourceAttr, Object transMappingRoot) {
        ArrayList targetAttributes = null;
        if (transMappingRoot != null && TransformationHelper.isTransformationMappingRoot(transMappingRoot)) {
            targetAttributes = new ArrayList();
            EList attrMappings = ((MappingRoot)transMappingRoot).getNested();
            Iterator iter = attrMappings.iterator();
            while (iter.hasNext()) {
                Mapping mapping = (Mapping)iter.next();
                EList inputs = mapping.getInputs();
                if (inputs == null || inputs.isEmpty() || !inputs.contains(sourceAttr)) continue;
                targetAttributes.addAll(mapping.getOutputs());
            }
        }
        if (targetAttributes == null) {
            targetAttributes = Collections.EMPTY_LIST;
        }
        return targetAttributes;
    }

    public static boolean isUserSqlDifferent(String sql, Object sqlMappingRoot, int cmdType) {
        boolean isDifferent = true;
        String currentUserSql = null;
        switch (cmdType) {
            case 0: {
                currentUserSql = TransformationHelper.getSelectSqlUserString(sqlMappingRoot);
                break;
            }
            case 1: {
                currentUserSql = TransformationHelper.getInsertSqlUserString(sqlMappingRoot);
                break;
            }
            case 2: {
                currentUserSql = TransformationHelper.getUpdateSqlUserString(sqlMappingRoot);
                break;
            }
            case 3: {
                currentUserSql = TransformationHelper.getDeleteSqlUserString(sqlMappingRoot);
                break;
            }
        }
        if (sql == null) {
            if (currentUserSql == null) {
                isDifferent = false;
            }
        } else if (sql.equals(currentUserSql)) {
            isDifferent = false;
        }
        return isDifferent;
    }

    private static String getSelectSqlUserString(Object transMappingRoot) {
        SqlTransformation sqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (sqlTrans != null) {
            result = sqlTrans.getSelectSql();
        }
        return result;
    }

    private static String getInsertSqlUserString(Object transMappingRoot) {
        SqlTransformation sqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (sqlTrans != null) {
            result = sqlTrans.getInsertSql();
        }
        return result;
    }

    private static String getUpdateSqlUserString(Object transMappingRoot) {
        SqlTransformation sqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (sqlTrans != null) {
            result = sqlTrans.getUpdateSql();
        }
        return result;
    }

    private static String getDeleteSqlUserString(Object transMappingRoot) {
        SqlTransformation sqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
        String result = null;
        if (sqlTrans != null) {
            result = sqlTrans.getDeleteSql();
        }
        return result;
    }

    private static String getSelectSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getSelectSql();
        }
        return result;
    }

    private static String getInsertSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getInsertSql();
        }
        return result;
    }

    private static String getUpdateSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getUpdateSql();
        }
        return result;
    }

    private static String getDeleteSqlUUIDString(Object transMappingRoot) {
        MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
        String result = null;
        if (helper != null && helper instanceof SqlTransformation) {
            result = ((SqlTransformation)helper).getDeleteSql();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setSelectSqlUUIDString(Object transMappingRoot, String selectString, boolean isSignificant, Object txnSource) {
        boolean changed;
        block3: {
            changed = false;
            if (!TransformationHelper.isSqlDifferent(transMappingRoot, 0, selectString, true)) return changed;
            MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
            if (helper == null) return changed;
            if (!(helper instanceof SqlTransformation)) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_SELECT_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setSelectSql(selectString);
                changed = true;
                succeeded = true;
                Object var9_8 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block3;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setInsertSqlUUIDString(Object transMappingRoot, String insertString, boolean isSignificant, Object txnSource) {
        boolean changed;
        block3: {
            changed = false;
            if (!TransformationHelper.isSqlDifferent(transMappingRoot, 1, insertString, true)) return changed;
            MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
            if (helper == null) return changed;
            if (!(helper instanceof SqlTransformation)) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_INSERT_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setInsertSql(insertString);
                changed = true;
                succeeded = true;
                Object var9_8 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block3;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setUpdateSqlUUIDString(Object transMappingRoot, String updateString, boolean isSignificant, Object txnSource) {
        boolean changed;
        block3: {
            changed = false;
            if (!TransformationHelper.isSqlDifferent(transMappingRoot, 2, updateString, true)) return changed;
            MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
            if (helper == null) return changed;
            if (!(helper instanceof SqlTransformation)) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_UPDATE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                ((SqlTransformation)helper).setUpdateSql(updateString);
                changed = true;
                succeeded = true;
                Object var9_8 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block3;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setDeleteSqlUUIDString(Object transMappingRoot, String deleteString, boolean isSignificant, Object txnSource) {
        boolean changed;
        block4: {
            changed = false;
            if (!TransformationHelper.isSqlDifferent(transMappingRoot, 3, deleteString, true)) return changed;
            MappingHelper helper = TransformationHelper.getMappingHelper(transMappingRoot);
            if (helper == null) return changed;
            if (!(helper instanceof SqlTransformation)) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_DELETE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                if (((SqlTransformation)helper).getDeleteSql() == null) {
                    changed = true;
                }
                ((SqlTransformation)helper).setDeleteSql(deleteString);
                succeeded = true;
                Object var9_8 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block4;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    public static boolean setSelectSqlUserString(Object transMappingRoot, String selectString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setSelectSqlUserString(transMappingRoot, selectString, true, isSignificant, txnSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setSelectSqlUserString(Object transMappingRoot, String selectString, boolean checkIfDifferent, boolean isSignificant, Object txnSource) {
        boolean changed;
        block3: {
            changed = false;
            boolean setString = false;
            setString = checkIfDifferent ? TransformationHelper.isSqlDifferent(transMappingRoot, 0, selectString, false) : true;
            if (!setString) return changed;
            SqlTransformation userSqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            if (userSqlTrans == null) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_SELECT_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                userSqlTrans.setSelectSql(SqlUtil.normalize(selectString));
                changed = true;
                succeeded = true;
                Object var11_10 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block3;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    public static boolean setInsertSqlUserString(Object transMappingRoot, String insertString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setInsertSqlUserString(transMappingRoot, insertString, true, isSignificant, txnSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setInsertSqlUserString(Object transMappingRoot, String insertString, boolean checkIfDifferent, boolean isSignificant, Object txnSource) {
        boolean changed;
        block3: {
            changed = false;
            boolean setString = false;
            setString = checkIfDifferent ? TransformationHelper.isSqlDifferent(transMappingRoot, 1, insertString, false) : true;
            if (!setString) return changed;
            SqlTransformation userSqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            if (userSqlTrans == null) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_INSERT_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                userSqlTrans.setInsertSql(SqlUtil.normalize(insertString));
                changed = true;
                succeeded = true;
                Object var11_10 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block3;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    public static boolean setUpdateSqlUserString(Object transMappingRoot, String updateString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setUpdateSqlUserString(transMappingRoot, updateString, true, isSignificant, txnSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setUpdateSqlUserString(Object transMappingRoot, String updateString, boolean checkIfDifferent, boolean isSignificant, Object txnSource) {
        boolean changed;
        block3: {
            changed = false;
            boolean setString = false;
            setString = checkIfDifferent ? TransformationHelper.isSqlDifferent(transMappingRoot, 2, updateString, false) : true;
            if (!setString) return changed;
            SqlTransformation userSqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot);
            if (userSqlTrans == null) return changed;
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_UPDATE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                userSqlTrans.setUpdateSql(SqlUtil.normalize(updateString));
                changed = true;
                succeeded = true;
                Object var11_10 = null;
                if (!requiredStart) return changed;
                if (!succeeded) break block3;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!requiredStart) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                changed = false;
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return changed;
        }
        changed = false;
        ModelerCore.rollbackTxn();
        return changed;
    }

    public static boolean setDeleteSqlUserString(Object transMappingRoot, String deleteString, boolean isSignificant, Object txnSource) {
        return TransformationHelper.setDeleteSqlUserString(transMappingRoot, deleteString, true, isSignificant, txnSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDeleteSqlUserString(Object transMappingRoot, String deleteString, boolean checkIfDifferent, boolean isSignificant, Object txnSource) {
        SqlTransformation userSqlTrans;
        boolean changed = false;
        boolean setString = false;
        setString = checkIfDifferent ? TransformationHelper.isSqlDifferent(transMappingRoot, 3, deleteString, false) : true;
        if (setString && (userSqlTrans = TransformationHelper.getUserSqlTransformation(transMappingRoot)) != null) {
            boolean requiredStart = ModelerCore.startTxn((boolean)isSignificant, (boolean)true, (String)CHANGE_DELETE_TXN_DESCRIPTION, (Object)txnSource);
            boolean succeeded = false;
            try {
                userSqlTrans.setDeleteSql(SqlUtil.normalize(deleteString));
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return changed;
    }

    public static boolean isSqlDifferent(Object transMappingRoot, int cmdType, String sqlString, boolean isUUID) {
        boolean isDifferent = true;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot(transMappingRoot)) {
            if (isUUID) {
                String currentUUIDSql = TransformationHelper.getUUIDSqlString(transMappingRoot, cmdType);
                isDifferent = TransformationHelper.stringsDifferent(SqlUtil.normalize(currentUUIDSql), SqlUtil.normalize(sqlString));
            } else {
                String currentSql = TransformationHelper.getSqlString(transMappingRoot, cmdType);
                isDifferent = TransformationHelper.stringsDifferent(SqlUtil.normalize(currentSql), SqlUtil.normalize(sqlString));
            }
        }
        return isDifferent;
    }

    private static boolean stringsDifferent(String newSql, String oldSql) {
        boolean isDifferent = true;
        if (newSql == null) {
            if (oldSql == null) {
                isDifferent = false;
            }
        } else if (oldSql != null) {
            StringBuffer newSb = new StringBuffer(newSql.trim());
            StringBuffer oldSb = new StringBuffer(oldSql.trim());
            StringUtil.replaceAll((StringBuffer)newSb, (String)"\n", (String)"");
            StringUtil.replaceAll((StringBuffer)newSb, (String)"\t", (String)"");
            String newSbString = StringUtil.collapseWhitespace((String)newSb.toString());
            StringUtil.replaceAll((StringBuffer)oldSb, (String)"\n", (String)"");
            StringUtil.replaceAll((StringBuffer)oldSb, (String)"\t", (String)"");
            String oldSbString = StringUtil.collapseWhitespace((String)oldSb.toString());
            if (newSbString != null && newSbString.equals(oldSbString)) {
                isDifferent = false;
            }
        }
        return isDifferent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EObject createProcResultSet(EObject procEObj) {
        EObject resultSet = null;
        if (TransformationHelper.isSqlProcedure(procEObj) && !TransformationHelper.isReadOnly(procEObj)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Create Result Set", (Object)procEObj);
            boolean succeeded = false;
            try {
                SqlProcedureAspect procAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)procEObj);
                EObject currentResultSet = (EObject)procAspect.getResult(procEObj);
                if (currentResultSet == null) {
                    org.eclipse.emf.common.command.Command resultSetDesc = TransformationHelper.getProcResultSetDescriptor(procEObj);
                    resultSet = ModelerCore.getModelEditor().createNewChildFromCommand(procEObj, resultSetDesc);
                }
                succeeded = true;
            }
            catch (ModelerCoreException e) {
                String message = TransformationPlugin.Util.getString("TransformationHelper.createProcResultSetError", (Object)procEObj.toString());
                TransformationPlugin.Util.log(4, (Throwable)e, message);
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return resultSet;
    }

    private static org.eclipse.emf.common.command.Command getProcResultSetDescriptor(EObject procEObject) {
        EObject eObj;
        org.eclipse.emf.common.command.Command resultSetDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(procEObject);
        }
        catch (ModelerCoreException e) {
            String message = TransformationPlugin.Util.getString("TransformationHelper.getProcResultSetDescriptorError", (Object)procEObject.toString());
            TransformationPlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !SqlAspectHelper.isColumnSet((EObject)(eObj = (EObject)(resultSetDescriptor = (org.eclipse.emf.common.command.Command)iter.next()).getResult().iterator().next()))) {
        }
        return resultSetDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EObject createProcResultSetColumn(EObject procResultEObj) {
        EObject resultSet = null;
        if (TransformationHelper.isSqlProcedureResultSet(procResultEObj) && !TransformationHelper.isReadOnly(procResultEObj)) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Create Result Set", (Object)procResultEObj);
            boolean succeeded = false;
            try {
                SqlColumnSetAspect procResultAspect = (SqlColumnSetAspect)AspectManager.getSqlAspect((EObject)procResultEObj);
                List columns = procResultAspect.getColumns(procResultEObj);
                if (columns.isEmpty()) {
                    org.eclipse.emf.common.command.Command resultSetDesc = TransformationHelper.getProcResultSetColumnDescriptor(procResultEObj);
                    resultSet = ModelerCore.getModelEditor().createNewChildFromCommand(procResultEObj, resultSetDesc);
                }
                succeeded = true;
            }
            catch (ModelerCoreException e) {
                String message = TransformationPlugin.Util.getString("TransformationHelper.createProcResultSetError", (Object)procResultEObj.toString());
                TransformationPlugin.Util.log(4, (Throwable)e, message);
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return resultSet;
    }

    private static org.eclipse.emf.common.command.Command getProcResultSetColumnDescriptor(EObject procResultEObject) {
        EObject eObj;
        org.eclipse.emf.common.command.Command resultSetColumnDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(procResultEObject);
        }
        catch (ModelerCoreException e) {
            String message = TransformationPlugin.Util.getString("TransformationHelper.getProcResultSetDescriptorError", (Object)procResultEObject.toString());
            TransformationPlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !SqlAspectHelper.isColumn((EObject)(eObj = (EObject)(resultSetColumnDescriptor = (org.eclipse.emf.common.command.Command)iter.next()).getResult().iterator().next()))) {
        }
        return resultSetColumnDescriptor;
    }

    private static void removeModelImportForSourceObject(EmfResource targetResource, EObject sourceObj) {
        if (targetResource != null && sourceObj != null) {
            EObject source = sourceObj;
            if (sourceObj instanceof SqlAlias) {
                source = ((SqlAlias)sourceObj).getAliasedObject();
            }
            ArrayList<Resource> externalResources = new ArrayList<Resource>();
            Resource sourceResource = source.eResource();
            if (sourceResource != targetResource && !externalResources.contains(sourceResource)) {
                externalResources.add(sourceResource);
            }
            Object iter = source.eAllContents();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                sourceResource = eObj.eResource();
                if (sourceResource == targetResource || externalResources.contains(sourceResource)) continue;
                externalResources.add(sourceResource);
            }
            iter = externalResources.iterator();
            while (iter.hasNext()) {
                Resource externalResource = (Resource)iter.next();
                try {
                    ModelerCore.getModelEditor().removeModelImport((MMXmiResource)targetResource, externalResource);
                }
                catch (ModelerCoreException e) {
                    String msg = TransformationPlugin.Util.getString("TransformationHelper.Error_removing_Model_Import_from_{0}_1", (Object)targetResource.getURI());
                    TransformationPlugin.Util.log(4, (Throwable)e, msg);
                }
            }
        }
    }

    private static void addValueToEList(EObject eListOwner, Object value, EList eList) {
        try {
            ModelerCore.getModelEditor().addValue((Object)eListOwner, value, eList);
        }
        catch (ModelerCoreException e) {
            TransformationPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    private static void removeValueFromEList(EObject eListOwner, Object value, EList eList) {
        try {
            ModelerCore.getModelEditor().removeValue((Object)eListOwner, value, eList);
        }
        catch (ModelerCoreException e) {
            TransformationPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public static void printTransformation(EObject someEObject) {
        SqlTransformationMappingRoot mappingRoot = null;
        if (someEObject instanceof TransformationMappingRoot && TransformationHelper.isSqlTransformationMappingRoot(someEObject)) {
            mappingRoot = (SqlTransformationMappingRoot)someEObject;
        }
        if (mappingRoot != null) {
            TransformationPlugin.Util.log(4, " --------------- SQL TRANSFORMATION ------------------");
            EObject target = TransformationHelper.getTransformationTarget(mappingRoot);
            String targetName = "null";
            if (target != null) {
                targetName = TransformationHelper.getSqlEObjectFullName(target);
            }
            TransformationPlugin.Util.log(4, " Virtual Group Target = " + targetName);
            TransformationPlugin.Util.log(4, "");
            int nSources = mappingRoot.getInputs().size();
            TransformationPlugin.Util.log(4, " # transformation Sources = " + nSources);
            if (nSources > 0) {
                EList inputs = mappingRoot.getInputs();
                for (int i = 0; i < nSources; ++i) {
                    EObject input = (EObject)inputs.get(i);
                    String inputName = "null";
                    if (input != null) {
                        inputName = TransformationHelper.getSqlEObjectFullName(input);
                    }
                    TransformationPlugin.Util.log(4, " Source " + (i + 1) + ": " + inputName);
                }
            }
            TransformationPlugin.Util.log(4, "");
            MappingHelper helper = TransformationHelper.getMappingHelper(mappingRoot);
            if (helper != null && helper instanceof SqlTransformation) {
                TransformationPlugin.Util.log(4, " === SQL (UUID Form) ===");
                SqlTransformation sHelper = (SqlTransformation)helper;
                TransformationPlugin.Util.log(4, "     SELECT SQL (UUID) = " + sHelper.getSelectSql());
                TransformationPlugin.Util.log(4, "     INSERT SQL (UUID) = " + sHelper.getInsertSql());
                TransformationPlugin.Util.log(4, "     UPDATE SQL (UUID) = " + sHelper.getUpdateSql());
                TransformationPlugin.Util.log(4, "     DELETE SQL (UUID) = " + sHelper.getDeleteSql());
                TransformationPlugin.Util.log(4, "");
                TransformationPlugin.Util.log(4, " === SQL TEXT Form) ===");
                SqlTransformation subHelper = TransformationHelper.getUserSqlTransformation(mappingRoot);
                if (subHelper != null && subHelper instanceof SqlTransformation) {
                    TransformationPlugin.Util.log(4, "     SELECT SQL (TEXT) = " + subHelper.getSelectSql());
                    TransformationPlugin.Util.log(4, "     INSERT SQL (TEXT) = " + subHelper.getInsertSql());
                    TransformationPlugin.Util.log(4, "     UPDATE SQL (TEXT) = " + subHelper.getUpdateSql());
                    TransformationPlugin.Util.log(4, "     DELETE SQL (TEXT) = " + subHelper.getDeleteSql());
                    TransformationPlugin.Util.log(4, "");
                }
            }
            List attributeMappings = AttributeMappingHelper.getAttributeMappings((Object)mappingRoot);
            int nMappings = attributeMappings.size();
            TransformationPlugin.Util.log(4, " # Attribute Mappings = " + nMappings);
            if (nMappings > 0) {
                Mapping nextMapping = null;
                for (int i = 0; i < nMappings; ++i) {
                    nextMapping = (Mapping)attributeMappings.get(i);
                    EList outputs = nextMapping.getOutputs();
                    EList inputs = nextMapping.getInputs();
                    int nInputs = inputs.size();
                    int nOutputs = outputs.size();
                    TransformationPlugin.Util.log(4, "     Attribute Mapping " + (i + 1));
                    if (nOutputs > 0) {
                        EObject output = (EObject)outputs.get(0);
                        String outputName = "null";
                        if (output != null) {
                            outputName = TransformationHelper.getSqlEObjectFullName(output);
                        }
                        TransformationPlugin.Util.log(4, "       Attr Mapping Output: " + outputName);
                    } else {
                        TransformationPlugin.Util.log(4, "       No Attr Mapping Outputs");
                    }
                    if (nInputs > 0) {
                        EObject nextEObject = null;
                        for (int iInput = 0; iInput < nInputs; ++iInput) {
                            nextEObject = (EObject)inputs.get(iInput);
                            String inputName = "null";
                            if (inputName != null) {
                                inputName = TransformationHelper.getSqlEObjectFullName(nextEObject);
                            }
                            TransformationPlugin.Util.log(4, "       Attr Mapping Input " + (iInput + 1) + ": " + inputName);
                        }
                        continue;
                    }
                    TransformationPlugin.Util.log(4, "       No Attr Mapping Inputs");
                }
            }
            TransformationPlugin.Util.log(1, " ---------------------------------------------------\n");
        }
    }

    public static Object getSqlProcedureForResultSet(Object obj) {
        SqlAspect aspect;
        if (obj != null && obj instanceof EObject && (aspect = SqlAspectHelper.getSqlAspect((EObject)((EObject)obj))) != null && aspect instanceof SqlResultSetAspect) {
            return ((SqlResultSetAspect)aspect).getProcedure((EObject)obj);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

