/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.lob.ExceptionLobChunk;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.types.Streamable;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.CacheResults;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.dqp.internal.process.DQPProcessorContext;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.internal.process.LobChunkStream;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.analysis.QueryAnnotation;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.StoredProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.transaction.SystemException;

public class ProcessWorker
extends QueueWorker {
    private RequestManager requestMgr;
    private BufferManager bufferMgr;
    private int processorTimeslice;
    private TrackingService tracker;
    private ResultSetCache rsCache;
    private TransactionService transactionService;

    public ProcessWorker(RequestManager requestMgr, BufferManager bufferMgr, WorkerPool processPool, int processorTimeslice, DataTierManager dataTierMgr, TrackingService tracker, ResultSetCache rsCache, TransactionService transactionService) {
        this.requestMgr = requestMgr;
        this.bufferMgr = bufferMgr;
        this.processorTimeslice = processorTimeslice;
        this.tracker = tracker;
        this.rsCache = rsCache;
        this.transactionService = transactionService;
    }

    public void initialize() throws QueueWorkerException {
    }

    public void cleanup() throws QueueWorkerException {
        this.requestMgr = null;
    }

    public void process(Object o) throws QueueWorkerException {
        WorkItem workItem = (WorkItem)o;
        RequestID requestID = workItem.getRequestID();
        RequestMessage request = this.requestMgr.getRequest(requestID);
        try {
            if (request != null) {
                this.processDirect(workItem, requestID, request);
            }
        }
        catch (Throwable e) {
            LogManager.logError((String)"DQP", (Throwable)e, (String)"############# PW PROCESSING ERROR OCCURRED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processDirect(WorkItem workItem, RequestID requestID, RequestMessage request) {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("############# PW PROCESSING on " + requestID + " workItem.getType(): " + workItem.getType() + " ###########"));
        }
        if (!this.shouldContinue(processor = this.requestMgr.getProcessor(requestID), workItem, request)) {
            LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - no processor found ###########"));
            return;
        }
        switch (workItem.getType()) {
            case 3: {
                try {
                    this.requestMgr.startProcessing(requestID);
                    this.requestMgr.markResultsSent(requestID);
                    this.sendResultsFromCache(requestID, request, workItem.getResultSetCache(), null);
                }
                catch (Throwable var6_8) {
                    try {
                        this.requestMgr.markDoneProcessing(requestID, workItem);
                    }
                    catch (Throwable e2) {
                        this.sendError(request, e2);
                    }
                    throw var6_8;
                }
                try {
                    this.requestMgr.markDoneProcessing(requestID, workItem);
                }
                catch (Throwable e2) {
                    this.sendError(request, e2);
                }
                break;
            }
            case 1: {
                try {
                    this.sendNextLobChunk(requestID, request, processor, workItem);
                }
                catch (BlockedOnMemoryException e) {
                    try {
                        this.requestMgr.markHasData(requestID, workItem);
                        LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - reenqueueing for more processing due to lack of available memory ###########"));
                    }
                    catch (QueueSuspendedException qse) {}
                }
                break;
            }
            case 0: {
                doneProducingBatches = false;
                processSucceeded = false;
                this.requestMgr.startProcessing(requestID);
                try {
                    try {
                        if (this.requestMgr.getProcessingException(requestID) != null) {
                            throw this.requestMgr.getProcessingException(requestID);
                        }
                        if (this.requestMgr.isPlanOnly(requestID)) {
                            this.bufferMgr.setStatus(processor.getResultsID(), 2);
                            doneProducingBatches = true;
                        } else if (this.bufferMgr.getFinalRowCount(processor.getResultsID()) < 0) {
                            if (this.requestMgr.isRequestCancelled(requestID)) {
                                processor.requestCancelled();
                            }
                            doneProducingBatches = processor.process((long)this.processorTimeslice, this.requestMgr.needsResults(requestID, false));
                        } else {
                            doneProducingBatches = true;
                        }
                        processSucceeded = true;
                    }
                    catch (BlockedOnMemoryException e) {
                        try {
                            this.requestMgr.markHasData(requestID, workItem);
                            LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - reenqueueing for more processing due to lack of available memory ###########"));
                        }
                        catch (QueueSuspendedException qse) {}
                    }
                    catch (BlockedException e) {
                        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
                            LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - processor blocked ###########"));
                        }
                    }
                    catch (TupleSourceNotFoundException e) {
                    }
                    catch (Throwable e) {
                        LogManager.logDetail((String)"DQP", (Throwable)e, (String)("##### [ProcessWorker.processDirect] ##### CASE: WorkItem.PROCESSING threw: " + e.toString()));
                        if (this.requestMgr.isRequestCancelled(requestID)) {
                            LogManager.logDetail((String)"DQP", (Throwable)e, (String)("############# PW EXITING on " + requestID + " - error occurred ###########"));
                        } else {
                            LogManager.logError((String)"DQP", (Throwable)e, (String)("############# PW EXITING on " + requestID + " - error occurred ###########"));
                        }
                        this.requestMgr.setProcessingException(requestID, e);
                        if (!this.requestMgr.needsResults(requestID, true)) ** GOTO lbl89
                        if (request.isTransactional() && request.getTransactionContext().getTransactionType() == 2) {
                            try {
                                this.transactionService.getTransactionServer().rollback(request.getTransactionContext());
                            }
                            catch (XATransactionException e1) {
                                LogManager.logWarning((String)"DQP", (Throwable)e1, (String)DQPPlugin.Util.getString("ProcessWorker.failed_rollback"));
                            }
                            catch (SystemException err) {
                                LogManager.logWarning((String)"DQP", (Throwable)err, (String)DQPPlugin.Util.getString("ProcessWorker.failed_rollback"));
                            }
                        }
                        this.requestMgr.markResultsSent(requestID);
                        this.sendError(request, this.requestMgr.getProcessingException(requestID));
                    }
lbl89:
                    // 7 sources

                    if (!processSucceeded || !this.requestMgr.needsResults(requestID, doneProducingBatches)) ** GOTO lbl131
                    try {
                        warnings = processor.getAndClearWarnings();
                        if (warnings != null && !warnings.isEmpty()) {
                            warningIter = warnings.iterator();
                            while (warningIter.hasNext()) {
                                this.requestMgr.addWarning((MetaMatrixException)warningIter.next(), requestID);
                            }
                        }
                        if ((analysisRecord = this.requestMgr.getAnalysisRecord(requestID)).recordQueryPlan()) {
                            analysisRecord.setQueryPlan(processor.getProcessorPlan().getDescriptionProperties());
                        }
                        this.requestMgr.markResultsSent(requestID);
                        if (request.isTransactional()) {
                            Assertion.assertTrue((boolean)this.requestMgr.areConnectorsReadyToClose(requestID));
                        }
                        if (request.isTransactional() && request.getTransactionContext().getTransactionType() == 2) {
                            this.transactionService.getTransactionServer().commit(request.getTransactionContext());
                        }
                        this.sendResults(requestID, request, processor.getResultsID(), processor.getProcessorPlan().getOutputElements(), doneProducingBatches, workItem);
                    }
                    catch (BlockedOnMemoryException err) {
                        range = this.requestMgr.getBatchInterval(requestID);
                        try {
                            this.requestMgr.markNeedsResults(requestID, workItem, range[0], range[1]);
                            LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - reenqueueing for more processing due to lack of available memory ###########"));
                        }
                        catch (QueueSuspendedException err1) {
                            this.sendError(request, err1);
                        }
                    }
                    catch (Throwable e) {
                        this.sendError(request, e);
                    }
                }
                catch (Throwable var10_25) {
                    try {
                        if (processSucceeded && !doneProducingBatches) {
                            this.requestMgr.markHasData(requestID, workItem);
                            LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - reenqueueing for more processing ###########"));
                        }
                        if (doneProducingBatches && this.requestMgr.areConnectorsClosed(requestID)) {
                            this.requestMgr.markDoneProcessing(requestID, workItem);
                        } else {
                            this.requestMgr.markEndProcessing(requestID, workItem);
                        }
                    }
                    catch (Throwable e2) {
                        this.sendError(request, e2);
                    }
                    throw var10_25;
                }
lbl131:
                // 5 sources

                try {
                    if (processSucceeded && !doneProducingBatches) {
                        this.requestMgr.markHasData(requestID, workItem);
                        LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - reenqueueing for more processing ###########"));
                    }
                    if (doneProducingBatches && this.requestMgr.areConnectorsClosed(requestID)) {
                        this.requestMgr.markDoneProcessing(requestID, workItem);
                        break;
                    }
                    this.requestMgr.markEndProcessing(requestID, workItem);
                }
                catch (Throwable e2) {
                    this.sendError(request, e2);
                }
                break;
            }
        }
    }

    private void sendNextLobChunk(RequestID requestId, RequestMessage request, QueryProcessor processor, WorkItem workItem) throws BlockedOnMemoryException {
        int streamRequestId = workItem.getStreamRequestId();
        int chunkSize = workItem.getChunkSize();
        Object chunk = null;
        Throwable exception = this.requestMgr.getProcessingException(requestId);
        chunk = exception != null ? new ExceptionLobChunk(exception) : this.getNextChunk(requestId, workItem.getStreamId(), streamRequestId, chunkSize);
        if (chunk != null) {
            ResultsMessage response = new ResultsMessage(request);
            response.setLobChunk((LobChunk)chunk);
            this.sendResponse(request, response, false);
        }
    }

    private LobChunk getNextChunk(RequestID requestId, String streamId, int streamRequestId, int chunkSize) throws BlockedOnMemoryException {
        LobChunk chunk;
        LobChunkStream stream = this.requestMgr.getLobStream(requestId, streamId, streamRequestId);
        try {
            if (stream == null) {
                stream = this.createLobStream(new TupleSourceID(streamId), chunkSize);
                this.requestMgr.addLobStream(requestId, streamId, streamRequestId, stream);
            }
            if ((chunk = stream.getNextChunk()).isLast()) {
                this.requestMgr.removeLobStream(requestId, streamId, streamRequestId);
            }
        }
        catch (BlockedOnMemoryException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            chunk = new ExceptionLobChunk((Throwable)e);
            LogManager.logWarning((String)"DQP", (Throwable)e, (String)DQPPlugin.Util.getString("ProcessWorker.LobError"));
        }
        catch (IOException e) {
            chunk = new ExceptionLobChunk((Throwable)e);
        }
        return chunk;
    }

    private LobChunkStream createLobStream(TupleSourceID referenceStreamId, int chunkSize) throws BlockedOnMemoryException, MetaMatrixComponentException, IOException {
        TupleBatch batch = null;
        try {
            Object anObj;
            batch = this.bufferMgr.pinTupleBatch(referenceStreamId, 1, 1);
            List[] tuples = batch.getAllTuples();
            tuples = batch.getAllTuples();
            if (tuples != null && tuples.length > 0 && (anObj = tuples[0].get(0)) instanceof Streamable) {
                Streamable streamable = (Streamable)anObj;
                LobChunkStream lobChunkStream = new LobChunkStream(streamable, chunkSize, this.bufferMgr);
                return lobChunkStream;
            }
            try {
                throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ProcessWorker.wrongdata"));
            }
            catch (MemoryNotAvailableException e) {
                throw BlockedOnMemoryException.INSTANCE;
            }
            catch (TupleSourceNotFoundException e) {
                String msg = DQPPlugin.Util.getString("BufferManagerLobChunkStream.no_tuple_source", new Object[]{referenceStreamId});
                LogManager.logWarning((String)"DQP", (Throwable)e, (String)msg);
                throw new IOException(msg);
            }
        }
        finally {
            try {
                if (batch != null) {
                    this.bufferMgr.unpinTupleBatch(referenceStreamId, batch.getBeginRow(), batch.getEndRow());
                }
            }
            catch (Exception e) {}
        }
    }

    private boolean shouldContinue(QueryProcessor processor, WorkItem workItem, RequestMessage request) {
        if (processor != null) {
            return true;
        }
        return workItem.getType() == 3 || this.hasResultsInCache(request);
    }

    private boolean validRequest(RequestMessage request) {
        if (request == null) {
            String msg = DQPPlugin.Util.getString("ProcessWorker.Could_not_deliver_response_as_request_has_been_removed.");
            LogManager.logDetail((String)"DQP", (String)msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResults(RequestID requestID, RequestMessage request, TupleSourceID tupleSourceId, List elements, boolean done, WorkItem work) throws BlockedOnMemoryException, QueueSuspendedException, MetaMatrixComponentException {
        LogManager.logDetail((String)"DQP", (String)("[ProcessWorker.sendResults] requestID: " + requestID + " resultsID: " + tupleSourceId + " done: " + done));
        TupleBatch batch = null;
        int[] range = null;
        try {
            CacheID cid;
            range = this.requestMgr.getBatchInterval(requestID);
            range[1] = Math.min(range[1], this.bufferMgr.getRowCount(tupleSourceId));
            batch = this.bufferMgr.pinTupleBatch(tupleSourceId, range[0], range[1]);
            if (!done && batch.getRowCount() == 0) {
                throw BlockedOnMemoryException.INSTANCE;
            }
            ResultsMessage response = null;
            response = new ResultsMessage(request, batch.getAllTuples(), elements);
            response.setFirstRow(batch.getBeginRow());
            response.setLastRow(batch.getEndRow());
            int finalRowCount = this.bufferMgr.getFinalRowCount(tupleSourceId);
            LogManager.logDetail((String)"DQP", (String)("[ProcessWorker.sendResults] finalRowCount: " + finalRowCount));
            response.setFinalRow(finalRowCount);
            boolean isPartialResultSet = finalRowCount < 0 || batch.getEndRow() < finalRowCount;
            response.setPartialResults(isPartialResultSet);
            response.setSchemas(this.requestMgr.getSchemas(requestID));
            response.setWarnings(this.requestMgr.getAndClearWarnings(requestID));
            AnalysisRecord analysisRecord = this.requestMgr.getAnalysisRecord(requestID);
            this.setAnalysisRecords(response, analysisRecord);
            Command command = request.getCommand();
            if (command instanceof StoredProcedure) {
                response.setParameters(this.getParameterInfo((StoredProcedure)command));
            }
            this.sendResponse(request, response, false);
            if (this.rsCache != null && request.useResultSetCache() && request.getCommand().areResultsCachable() && !this.rsCache.hasResults(cid = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache))) {
                CacheResults cr = new CacheResults(response.getResults(), elements, response.getFirstRow(), !response.isPartialResults());
                cr.setCommand(this.requestMgr.getOriginalCommand(requestID));
                if (batch.getSize() != -1L) {
                    cr.setSize(batch.getSize());
                }
                if (analysisRecord != null) {
                    cr.setAnalysisRecord(analysisRecord);
                }
                this.rsCache.setResults(cid, cr, (Object)requestID);
            }
        }
        catch (MemoryNotAvailableException e) {
            throw BlockedOnMemoryException.INSTANCE;
        }
        catch (TupleSourceNotFoundException e) {
        }
        finally {
            try {
                if (batch != null) {
                    this.bufferMgr.unpinTupleBatch(tupleSourceId, batch.getBeginRow(), batch.getEndRow());
                }
            }
            catch (Exception e) {}
        }
    }

    private void setAnalysisRecords(ResultsMessage response, AnalysisRecord analysisRecord) {
        if (analysisRecord != null) {
            response.setPlanDescription(analysisRecord.getQueryPlan());
            response.setDebugLog(analysisRecord.getDebugLog());
            Collection anns = analysisRecord.getAnnotations();
            ArrayList<String[]> converted = null;
            if (anns != null) {
                converted = new ArrayList<String[]>(anns.size());
                for (QueryAnnotation ann : anns) {
                    String[] jdbcAnn = new String[]{ann.getCategory(), ann.getAnnotation(), ann.getResolution(), "" + ann.getPriority()};
                    converted.add(jdbcAnn);
                }
                response.setAnnotations(converted);
            }
        }
    }

    private void sendResultsFromCache(RequestID requestID, RequestMessage request, ResultSetCache resultSetCache, int[] interval) {
        if (!this.validRequest(request)) {
            return;
        }
        if (interval == null) {
            interval = this.requestMgr.getBatchInterval(requestID);
        }
        if (interval == null || interval[0] == 0) {
            return;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache);
        CacheResults cResult = resultSetCache.getResults(cID, interval);
        List[] results = cResult.getResults();
        int firstRow = cResult.getFirstRow();
        ResultsMessage response = new ResultsMessage(request, results, cResult.getElements());
        response.setFirstRow(firstRow);
        response.setLastRow(firstRow + results.length - 1);
        boolean isFinal = cResult.isFinal();
        if (isFinal) {
            response.setFinalRow(cResult.getFinalRow());
        }
        response.setPartialResults(!isFinal);
        AnalysisRecord analysisRecord = cResult.getAnalysisRecord();
        this.setAnalysisRecords(response, analysisRecord);
        try {
            request.getClientConnection().send((Message)response, request.getMessageKey());
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{requestID};
            String msg = DQPPlugin.Util.getString("ProcessWorker.Failed_to_deliver_response_for_{0}", (Object)params);
            LogManager.logError((String)"DQP", (Throwable)e, (String)msg);
        }
    }

    private void sendError(RequestMessage request, Throwable error) {
        if (!this.validRequest(request)) {
            return;
        }
        Object[] params = new Object[]{request.getRequestID()};
        String msg = DQPPlugin.Util.getString("ProcessWorker.send_error", (Object)params);
        LogManager.logWarning((String)"DQP", (Throwable)error, (String)msg);
        ResultsMessage response = new ResultsMessage(request);
        response.setException(error);
        AnalysisRecord analysisRecord = this.requestMgr.getAnalysisRecord(request.getRequestID());
        this.setAnalysisRecords(response, analysisRecord);
        this.sendResponse(request, response, !this.requestMgr.isRequestCancelled(request.getRequestID()));
        if (this.rsCache != null) {
            CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache);
            this.rsCache.removeTempResults(cID);
        }
    }

    private void sendResponse(RequestMessage request, ResultsMessage response, boolean error) {
        RequestID requestID = request.getRequestID();
        QueryProcessor processor = this.requestMgr.getProcessor(requestID);
        if (processor == null) {
            return;
        }
        DQPProcessorContext context = (DQPProcessorContext)processor.getContext();
        ClientConnection clientConn = context.getClientConnection();
        if (error) {
            this.logCommandError(request);
        }
        String messageKey = context.getMessageKey();
        if (response.getLobChunk() != null) {
            messageKey = "LOB_" + messageKey;
        }
        try {
            clientConn.send((Message)response, messageKey);
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{requestID};
            String msg = DQPPlugin.Util.getString("ProcessWorker.Failed_to_deliver_response_for_{0}", (Object)params);
            LogManager.logError((String)"DQP", (Throwable)e, (String)msg);
        }
    }

    private void logCommandError(RequestMessage request) {
        if (this.tracker == null || !this.tracker.willRecordMMCmd()) {
            return;
        }
        RequestID rID = request.getRequestID();
        TransactionID transactionID = null;
        Command command = request.getCommand();
        if (request.isTransactional()) {
            transactionID = request.getTransactionContext().getTxnID();
        }
        this.tracker.log(rID.toString(), transactionID == null ? null : transactionID.getID(), (short)2, (short)4, request.getRequestID().getConnectionID(), (String)request.getClientConnection().getConnectionProperty("ApplicationName"), request.getUserName(), request.getVdbName(), request.getVdbVersion(), command, -1);
    }

    private List getParameterInfo(StoredProcedure procedure) {
        List params = procedure.getParameters();
        ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>(params.size());
        for (SPParameter param : params) {
            ParameterInfo info = new ParameterInfo(param.getParameterType(), param.getResultSetColumns().size());
            paramInfos.add(info);
        }
        return paramInfos;
    }

    private boolean hasResultsInCache(RequestMessage requestMsg) {
        if (this.rsCache == null) {
            return false;
        }
        if (!requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)requestMsg, (ResultSetCache)this.rsCache);
        return this.rsCache.hasResults(cID);
    }
}

