/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCBaseExecution;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.connector.jdbc.util.JDBCExecutionHelper;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;

public class JDBCQueryExecution
extends JDBCBaseExecution
implements SynchQueryExecution {
    protected int maxBatchSize = -1;
    protected ResultSet results;
    protected Class[] columnDataTypes;
    protected Calendar calendar;

    public JDBCQueryExecution(Connection connection, SQLTranslator sqlTranslator, ResultsTranslator resultsTranslator, ConnectorLogger logger, Properties props, ExecutionContext context) {
        super(connection, sqlTranslator, resultsTranslator, logger, props, context);
        TimeZone dbmsTimeZone = resultsTranslator.getDatabaseTimezone();
        this.calendar = dbmsTimeZone != null ? Calendar.getInstance(dbmsTimeZone) : Calendar.getInstance();
    }

    public void execute(IQuery command, int maxBatchSize) throws ConnectorException {
        block6: {
            this.maxBatchSize = maxBatchSize;
            this.columnDataTypes = JDBCExecutionHelper.getColumnDataTypes((ICommand)command);
            TranslatedCommand translatedComm = this.translateCommand((ICommand)command);
            String sql = translatedComm.getSql();
            try {
                if (translatedComm.getStatementType() == 0) {
                    this.results = this.getStatement().executeQuery(sql);
                    break block6;
                }
                if (translatedComm.getStatementType() == 1) {
                    PreparedStatement pstatement = this.getPreparedStatement(sql);
                    this.resultsTranslator.bindPreparedStatementValues(this.connection, pstatement, translatedComm);
                    this.results = pstatement.executeQuery();
                    break block6;
                }
                throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSynchExecution.Statement_type_not_support_for_command_1", (Object)new Integer(translatedComm.getStatementType()), (Object)sql));
            }
            catch (SQLException e) {
                ConnectorException ce = this.createAndLogError(e, translatedComm);
                try {
                    this.close();
                }
                catch (ConnectorException ce2) {
                    this.logger.logError(ce2.getLocalizedMessage(), (Throwable)ce2);
                }
                throw ce;
            }
        }
    }

    public Batch nextBatch() throws ConnectorException {
        return JDBCExecutionHelper.createBatch(this.results, this.columnDataTypes, this.maxBatchSize, this.trimString, this.resultsTranslator, this.context, this.calendar);
    }

    public synchronized void close() throws ConnectorException {
        if (this.results != null) {
            try {
                this.results.close();
                this.results = null;
            }
            catch (SQLException e) {
                this.logger.logError(e.getMessage());
                throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
            }
        }
        super.close();
    }
}

