/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSDateTime;
import com.metamatrix.util.UtilByteArray;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public final class TDSRPCParameter {
    private static String footprint = "$Revision:   3.40.1.4  $";
    private int MAX_IMAGE_BYTES = Integer.MAX_VALUE;
    private int MAX_TEXT_BYTES = Integer.MAX_VALUE;
    private int MAX_NTEXT_BYTES = Integer.MAX_VALUE;
    private int MAX_NTEXT_CHARS = 0x3FFFFFFF;
    private BaseExceptions exceptions;
    private int tdsVersion;
    protected String paramName;
    protected byte tdsType;
    protected String nativeTypeName;
    protected UtilTransliterator transliterator = null;
    private TDSConnection conn;
    protected boolean isInput;
    protected boolean isOutput;
    public int maxLength;
    protected int actualLength;
    protected int precision;
    protected int scale;
    public BaseData data;
    private int nativeTypeNameIndex;
    private int describedNativeTypeNameIndex;
    public boolean isForRowUpdate;
    public boolean wasSetByName;
    public String serverReportedNativeType;
    static final int BIT = 0;
    static final int TINYINT = 1;
    static final int SMALLINT = 2;
    static final int INT = 3;
    static final int BIGINT = 4;
    static final int DATETIME = 5;
    static final int VARCHAR = 6;
    static final int NVARCHAR = 7;
    static final int TEXT = 8;
    static final int NTEXT = 9;
    static final int VARBINARY = 10;
    static final int IMAGE = 11;
    static final int REAL = 12;
    static final int FLOAT = 13;
    static final int DECIMAL_28 = 14;
    static final int DECIMAL_38 = 43;
    static final int NUMERIC_28 = 82;
    static final int NUMERIC_38 = 111;
    static final int VARBINARYMAX = 150;
    static final int VARCHARMAX = 151;
    static final int NVARCHARMAX = 152;
    static final int XML = 153;
    static final String[] nativeTypeNames = new String[]{"bit", "tinyint", "smallint", "int", "bigint", "datetime", "varchar(8000)", "nvarchar(4000)", "text", "ntext", "varbinary(8000)", "image", "real", "float", "decimal(28,0)", "decimal(28,1)", "decimal(28,2)", "decimal(28,3)", "decimal(28,4)", "decimal(28,5)", "decimal(28,6)", "decimal(28,7)", "decimal(28,8)", "decimal(28,9)", "decimal(28,10)", "decimal(28,11)", "decimal(28,12)", "decimal(28,13)", "decimal(28,14)", "decimal(28,15)", "decimal(28,16)", "decimal(28,17)", "decimal(28,18)", "decimal(28,19)", "decimal(28,20)", "decimal(28,21)", "decimal(28,22)", "decimal(28,23)", "decimal(28,24)", "decimal(28,25)", "decimal(28,26)", "decimal(28,27)", "decimal(28,28)", "decimal(38,0)", "decimal(38,1)", "decimal(38,2)", "decimal(38,3)", "decimal(38,4)", "decimal(38,5)", "decimal(38,6)", "decimal(38,7)", "decimal(38,8)", "decimal(38,9)", "decimal(38,10)", "decimal(38,11)", "decimal(38,12)", "decimal(38,13)", "decimal(38,14)", "decimal(38,15)", "decimal(38,16)", "decimal(38,17)", "decimal(38,18)", "decimal(38,19)", "decimal(38,20)", "decimal(38,21)", "decimal(38,22)", "decimal(38,23)", "decimal(38,24)", "decimal(38,25)", "decimal(38,26)", "decimal(38,27)", "decimal(38,28)", "decimal(38,29)", "decimal(38,30)", "decimal(38,31)", "decimal(38,32)", "decimal(38,33)", "decimal(38,34)", "decimal(38,35)", "decimal(38,36)", "decimal(38,37)", "decimal(38,38)", "numeric(28,0)", "numeric(28,1)", "numeric(28,2)", "numeric(28,3)", "numeric(28,4)", "numeric(28,5)", "numeric(28,6)", "numeric(28,7)", "numeric(28,8)", "numeric(28,9)", "numeric(28,10)", "numeric(28,11)", "numeric(28,12)", "numeric(28,13)", "numeric(28,14)", "numeric(28,15)", "numeric(28,16)", "numeric(28,17)", "numeric(28,18)", "numeric(28,19)", "numeric(28,20)", "numeric(28,21)", "numeric(28,22)", "numeric(28,23)", "numeric(28,24)", "numeric(28,25)", "numeric(28,26)", "numeric(28,27)", "numeric(28,28)", "numeric(38,0)", "numeric(38,1)", "numeric(38,2)", "numeric(38,3)", "numeric(38,4)", "numeric(38,5)", "numeric(38,6)", "numeric(38,7)", "numeric(38,8)", "numeric(38,9)", "numeric(38,10)", "numeric(38,11)", "numeric(38,12)", "numeric(38,13)", "numeric(38,14)", "numeric(38,15)", "numeric(38,16)", "numeric(38,17)", "numeric(38,18)", "numeric(38,19)", "numeric(38,20)", "numeric(38,21)", "numeric(38,22)", "numeric(38,23)", "numeric(38,24)", "numeric(38,25)", "numeric(38,26)", "numeric(38,27)", "numeric(38,28)", "numeric(38,29)", "numeric(38,30)", "numeric(38,31)", "numeric(38,32)", "numeric(38,33)", "numeric(38,34)", "numeric(38,35)", "numeric(38,36)", "numeric(38,37)", "numeric(38,38)", "varbinary(max)", "varchar(max)", "nvarchar(max)", "xml"};
    static final String[] commonParamNames = new String[]{"@P1", "@P2", "@P3", "@P4", "@P5", "@P6", "@P7", "@P8", "@P9", "@P10", "@P11", "@P12", "@P13", "@P14", "@P15", "@P16", "@P17", "@P18", "@P19", "@P20"};
    StringBuffer stringBufferForConversion;

    public TDSRPCParameter(TDSConnection tDSConnection, int n) {
        this.conn = tDSConnection;
        this.tdsVersion = this.conn.getTDSVersion();
        this.precision = n;
        this.exceptions = this.conn.exceptions;
        this.stringBufferForConversion = this.conn.connection.stringBufferForConversion;
        this.data = new BaseData((BaseConnection)this.conn.connection);
    }

    public final void initializeInternalParam(byte by, boolean bl, boolean bl2, int n, int n2, int n3, String string) {
        this.tdsType = by;
        this.isInput = bl;
        this.isOutput = bl2;
        this.maxLength = n;
        this.actualLength = n2;
        this.scale = n3;
        this.data.setString(string);
        this.nativeTypeName = null;
        this.paramName = null;
        this.isForRowUpdate = false;
    }

    public final void initializeInternalParam(byte by, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        this.tdsType = by;
        this.isInput = bl;
        this.isOutput = bl2;
        this.maxLength = n;
        this.actualLength = n2;
        this.scale = n3;
        this.data.setInteger(n4);
        this.nativeTypeName = null;
        this.paramName = null;
        this.isForRowUpdate = false;
    }

    public final void initializeUserParam(int n, BaseParameters baseParameters, boolean bl, int n2) throws SQLException {
        int n3;
        BaseParameter baseParameter = baseParameters.getInput(n);
        BaseParameter baseParameter2 = baseParameters.getOutput(n);
        this.isInput = baseParameter != null;
        this.isOutput = baseParameter2 != null;
        int n4 = this.isOutput ? baseParameter2.sqlType : baseParameter.sqlType;
        if (this.isInput) {
            n3 = baseParameter.nativeType;
            this.transliterator = baseParameter.transliterator;
        } else {
            n3 = 0;
        }
        if (baseParameters.parameterOrder == 1) {
            this.wasSetByName = true;
            this.paramName = this.isOutput ? baseParameter2.name : baseParameter.name;
        } else {
            this.wasSetByName = false;
            if (n > commonParamNames.length) {
                StringBuffer stringBuffer = new StringBuffer("@P");
                stringBuffer.append(n);
                this.paramName = stringBuffer.toString();
            } else {
                this.paramName = commonParamNames[n - 1];
            }
        }
        this.prepareData(n4, n3, this.isInput, (BaseData)baseParameter, this.isOutput, this.isOutput ? baseParameter2.scale : 0, bl, n2);
        this.nativeTypeName = nativeTypeNames[this.nativeTypeNameIndex];
        if (this.isOutput) {
            this.nativeTypeName = this.nativeTypeName + " OUTPUT";
        }
        this.isForRowUpdate = false;
    }

    public final void initializeURSParam(BaseColumn baseColumn, BaseData baseData) throws SQLException {
        this.prepareData(baseColumn.type, 0, true, baseData, false, 0, true, 0);
        this.paramName = "@" + baseColumn.name;
        this.isForRowUpdate = true;
    }

    private void prepareData(int n, int n2, boolean bl, BaseData baseData, boolean bl2, int n3, boolean bl3, int n4) throws SQLException {
        block1 : switch (n) {
            case -7: {
                if (bl && !baseData.isNull) {
                    if (baseData.getType() != 9) {
                        baseData.setBoolean(baseData.getBoolean(this.exceptions));
                    }
                    this.actualLength = 1;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeNameIndex = 0;
                this.maxLength = 1;
                this.tdsType = (byte)104;
                break;
            }
            case -6: {
                if (bl && !baseData.isNull) {
                    short s;
                    if (baseData.getType() != 3) {
                        baseData.setShort(baseData.getShort(this.exceptions));
                    }
                    if ((s = baseData.getShortNoConvert()) < 0 || s > 255) {
                        throw this.exceptions.getException(6024);
                    }
                    this.actualLength = 1;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeNameIndex = 1;
                this.maxLength = 1;
                this.tdsType = (byte)38;
                break;
            }
            case 5: {
                if (bl && !baseData.isNull) {
                    if (baseData.getType() != 3) {
                        baseData.setShort(baseData.getShort(this.exceptions));
                    }
                    this.actualLength = 2;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeNameIndex = 2;
                this.maxLength = 2;
                this.tdsType = (byte)38;
                break;
            }
            case 4: {
                if (bl && !baseData.isNull) {
                    if (baseData.getType() != 4) {
                        baseData.setInteger(baseData.getInteger(this.exceptions));
                    }
                    this.actualLength = 4;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeNameIndex = 3;
                this.maxLength = 4;
                this.tdsType = (byte)38;
                break;
            }
            case -5: {
                if (this.tdsVersion < 2) {
                    if (bl && !baseData.isNull) {
                        if (baseData.getType() != 5) {
                            baseData.setLong(baseData.getLong(this.exceptions));
                        }
                        String string = baseData.getString(-1, this.exceptions);
                        baseData.setString(string);
                        this.actualLength = string.length();
                    } else {
                        this.actualLength = -1;
                    }
                    this.nativeTypeNameIndex = 6;
                    this.maxLength = 8000;
                    this.tdsType = (byte)-89;
                    break;
                }
                if (bl && !baseData.isNull) {
                    if (baseData.getType() != 5) {
                        baseData.setLong(baseData.getLong(this.exceptions));
                    }
                    this.actualLength = 8;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeNameIndex = 4;
                this.tdsType = (byte)38;
                this.maxLength = 8;
                break;
            }
            case 7: {
                if (bl && !baseData.isNull) {
                    if (baseData.getType() != 6) {
                        baseData.setFloat(baseData.getFloat(this.exceptions));
                    }
                    this.actualLength = 4;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeNameIndex = 12;
                this.maxLength = 4;
                this.tdsType = (byte)109;
                break;
            }
            case 6: 
            case 8: {
                if (bl && !baseData.isNull) {
                    if (baseData.getType() != 7) {
                        baseData.setDouble(baseData.getDouble(this.exceptions));
                    }
                    this.actualLength = 8;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeNameIndex = 13;
                this.maxLength = 8;
                this.tdsType = (byte)109;
                break;
            }
            case 2: 
            case 3: {
                if (bl && !baseData.isNull) {
                    this.actualLength = 17;
                    baseData.setBigDecimal(baseData.getBigDecimal(this.exceptions));
                    int n5 = baseData.getBigDecimal(this.exceptions).scale();
                    if (n3 > n5) {
                        this.scale = n3;
                        baseData.setBigDecimal(baseData.getBigDecimal(this.exceptions).setScale(this.scale));
                    } else {
                        this.scale = n5;
                    }
                } else {
                    this.actualLength = 0;
                    this.scale = n3 < 0 ? this.conn.connection.implConnection.defaultScale : n3;
                    if (this.scale > 38) {
                        this.scale = this.precision == 38 ? 38 : 28;
                    }
                }
                if (this.scale > 38) {
                    String[] stringArray = new String[]{baseData.getBigDecimal(this.exceptions).toString()};
                    throw this.exceptions.getException(7013, stringArray);
                }
                if (n == 2) {
                    this.tdsType = (byte)108;
                    this.nativeTypeNameIndex = this.precision == 28 ? 82 : 111;
                } else {
                    this.tdsType = (byte)106;
                    this.nativeTypeNameIndex = this.precision == 28 ? 14 : 43;
                }
                this.nativeTypeNameIndex += this.scale;
                this.maxLength = 17;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (bl && !baseData.isNull) {
                    switch (baseData.getType()) {
                        case 20: {
                            Clob clob = baseData.getClobNoConvert();
                            long l = clob.length();
                            if (l > (long)this.MAX_NTEXT_CHARS) {
                                // empty if block
                            }
                            this.actualLength = (int)l;
                            baseData.setCharacterStreamReader(clob.getCharacterStream());
                            switch (n2) {
                                case -25: 
                                case -17: {
                                    if (this.maxLength == 65535) {
                                        this.nativeTypeNameIndex = 152;
                                        this.tdsType = (byte)-25;
                                        break block1;
                                    }
                                    this.nativeTypeNameIndex = 7;
                                    this.maxLength = 8000;
                                    this.tdsType = (byte)-25;
                                    break block1;
                                }
                                case 39: 
                                case 47: {
                                    if (this.maxLength == 65535) {
                                        this.nativeTypeNameIndex = 151;
                                        this.tdsType = (byte)-89;
                                        break block1;
                                    }
                                    this.nativeTypeNameIndex = 6;
                                    this.maxLength = 8000;
                                    this.tdsType = (byte)-89;
                                    break block1;
                                }
                                case 99: {
                                    this.nativeTypeNameIndex = 9;
                                    this.maxLength = this.MAX_NTEXT_BYTES;
                                    this.tdsType = (byte)99;
                                    break block1;
                                }
                                case 35: {
                                    this.nativeTypeNameIndex = 8;
                                    this.maxLength = this.MAX_TEXT_BYTES;
                                    this.tdsType = (byte)35;
                                    break block1;
                                }
                            }
                            if (this.tdsVersion < 3) {
                                this.nativeTypeNameIndex = 9;
                                this.tdsType = (byte)99;
                                this.maxLength = this.MAX_NTEXT_BYTES;
                                break block1;
                            }
                            this.nativeTypeNameIndex = 152;
                            this.tdsType = (byte)-25;
                            this.maxLength = 65535;
                            break block1;
                        }
                        case 15: {
                            this.actualLength = this.getLength(baseData.getASCIIStreamNoConvert());
                            switch (n2) {
                                case -25: 
                                case -17: {
                                    if (this.maxLength == 65535) {
                                        this.nativeTypeNameIndex = 152;
                                        this.tdsType = (byte)-25;
                                        break block1;
                                    }
                                    this.nativeTypeNameIndex = 7;
                                    this.maxLength = 8000;
                                    this.tdsType = (byte)-25;
                                    break block1;
                                }
                                case 39: 
                                case 47: {
                                    if (this.maxLength == 65535) {
                                        this.nativeTypeNameIndex = 151;
                                        this.tdsType = (byte)-89;
                                        break block1;
                                    }
                                    this.nativeTypeNameIndex = 6;
                                    this.maxLength = 8000;
                                    this.tdsType = (byte)-89;
                                    break block1;
                                }
                                case 99: {
                                    this.nativeTypeNameIndex = 9;
                                    this.maxLength = this.MAX_NTEXT_BYTES;
                                    this.tdsType = (byte)99;
                                    break block1;
                                }
                                case 35: {
                                    this.nativeTypeNameIndex = 8;
                                    this.maxLength = this.MAX_TEXT_BYTES;
                                    this.tdsType = (byte)35;
                                    break block1;
                                }
                            }
                            if (this.actualLength > 8000) {
                                if (this.tdsVersion < 3) {
                                    this.nativeTypeNameIndex = 8;
                                    this.maxLength = this.MAX_TEXT_BYTES;
                                    this.tdsType = (byte)35;
                                    break block1;
                                }
                                this.nativeTypeNameIndex = 151;
                                this.maxLength = 65535;
                                this.tdsType = (byte)-89;
                                break block1;
                            }
                            this.nativeTypeNameIndex = 6;
                            this.maxLength = 8000;
                            this.tdsType = (byte)-89;
                            break block1;
                        }
                        case 18: {
                            this.actualLength = this.getLength(baseData.getCharacterStreamReaderNoConvert());
                            switch (n2) {
                                case -25: 
                                case -17: {
                                    if (this.maxLength == 65535) {
                                        this.nativeTypeNameIndex = 152;
                                        this.tdsType = (byte)-25;
                                        break block1;
                                    }
                                    this.nativeTypeNameIndex = 7;
                                    this.maxLength = 8000;
                                    this.tdsType = (byte)-25;
                                    break block1;
                                }
                                case 39: 
                                case 47: {
                                    if (this.maxLength == 65535) {
                                        this.nativeTypeNameIndex = 151;
                                        this.tdsType = (byte)-89;
                                        break block1;
                                    }
                                    this.nativeTypeNameIndex = 6;
                                    this.maxLength = 8000;
                                    this.tdsType = (byte)-89;
                                    break block1;
                                }
                                case 99: {
                                    this.nativeTypeNameIndex = 9;
                                    this.maxLength = this.MAX_NTEXT_BYTES;
                                    this.tdsType = (byte)99;
                                    break block1;
                                }
                                case 35: {
                                    this.nativeTypeNameIndex = 8;
                                    this.maxLength = this.MAX_TEXT_BYTES;
                                    this.tdsType = (byte)35;
                                    break block1;
                                }
                            }
                            if (this.actualLength > 4000) {
                                if (this.tdsVersion < 3) {
                                    this.nativeTypeNameIndex = 9;
                                    this.maxLength = this.MAX_NTEXT_BYTES;
                                    this.tdsType = (byte)99;
                                    break block1;
                                }
                                this.nativeTypeNameIndex = 152;
                                this.maxLength = 65535;
                                this.tdsType = (byte)-25;
                                break block1;
                            }
                            this.nativeTypeNameIndex = 7;
                            this.maxLength = 8000;
                            this.tdsType = (byte)-25;
                            break block1;
                        }
                        case 14: 
                        case 16: 
                        case 17: {
                            UtilDebug.assert((String)"Unexpected input stream.", (boolean)false);
                            break block1;
                        }
                    }
                    if (baseData.getType() == 8) {
                        BigDecimal bigDecimal = (BigDecimal)baseData.getObject();
                        baseData.setString(this.convertBigDecimaltoPlainString(bigDecimal));
                    } else {
                        baseData.setString(baseData.getString(-1, this.exceptions));
                    }
                    this.actualLength = baseData.getStringNoConvert().length();
                    switch (n2) {
                        case -25: 
                        case -17: {
                            if (this.maxLength == 65535) {
                                this.nativeTypeNameIndex = 152;
                                this.tdsType = (byte)-25;
                                break block1;
                            }
                            this.nativeTypeNameIndex = 7;
                            this.maxLength = 8000;
                            this.tdsType = (byte)-25;
                            break block1;
                        }
                        case 39: 
                        case 47: {
                            if (this.maxLength == 65535) {
                                this.nativeTypeNameIndex = 151;
                                this.tdsType = (byte)-89;
                                break block1;
                            }
                            this.nativeTypeNameIndex = 6;
                            this.maxLength = 8000;
                            this.tdsType = (byte)-89;
                            break block1;
                        }
                        case 99: {
                            this.nativeTypeNameIndex = 9;
                            this.maxLength = this.MAX_NTEXT_BYTES;
                            this.tdsType = (byte)99;
                            break block1;
                        }
                        case 35: {
                            this.nativeTypeNameIndex = 8;
                            this.maxLength = this.MAX_TEXT_BYTES;
                            this.tdsType = (byte)35;
                            break block1;
                        }
                    }
                    if (bl3) {
                        if (this.actualLength > 4000) {
                            if (this.tdsVersion < 3) {
                                this.nativeTypeNameIndex = 9;
                                this.maxLength = this.MAX_NTEXT_BYTES;
                                this.tdsType = (byte)99;
                                break;
                            }
                            this.nativeTypeNameIndex = 152;
                            this.tdsType = (byte)-25;
                            this.maxLength = 65535;
                            break;
                        }
                        this.nativeTypeNameIndex = 7;
                        this.maxLength = 8000;
                        this.tdsType = (byte)-25;
                        break;
                    }
                    if (this.actualLength > 8000) {
                        if (this.tdsVersion < 3) {
                            this.nativeTypeNameIndex = 8;
                            this.maxLength = this.MAX_TEXT_BYTES;
                            this.tdsType = (byte)35;
                            break;
                        }
                        this.nativeTypeNameIndex = 151;
                        this.tdsType = (byte)-89;
                        this.maxLength = 65535;
                        break;
                    }
                    this.nativeTypeNameIndex = 6;
                    this.maxLength = 8000;
                    this.tdsType = (byte)-89;
                    break;
                }
                if (bl && baseData.isNull) {
                    this.actualLength = -1;
                    if (bl3) {
                        if (this.maxLength == 65535) {
                            this.nativeTypeNameIndex = 152;
                            this.tdsType = (byte)-25;
                            break;
                        }
                        this.nativeTypeNameIndex = 7;
                        this.tdsType = (byte)-25;
                        this.maxLength = 8000;
                        break;
                    }
                    if (this.maxLength == 65535) {
                        this.nativeTypeNameIndex = 151;
                        this.tdsType = (byte)-89;
                        break;
                    }
                    this.nativeTypeNameIndex = 6;
                    this.tdsType = (byte)-89;
                    this.maxLength = 8000;
                    break;
                }
                this.initializeUserStringOutputParam(n4);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (bl && !baseData.isNull) {
                    switch (baseData.getType()) {
                        case 19: {
                            Blob blob = baseData.getBlob(null, null);
                            long l = blob.length();
                            if (l > (long)this.MAX_IMAGE_BYTES) {
                                // empty if block
                            }
                            this.actualLength = (int)l;
                            baseData.setBinaryStream(blob.getBinaryStream());
                            if (this.tdsVersion < 3) {
                                this.nativeTypeNameIndex = 11;
                                this.tdsType = (byte)34;
                                this.maxLength = this.MAX_IMAGE_BYTES;
                                break block1;
                            }
                            this.nativeTypeNameIndex = 150;
                            this.tdsType = (byte)-91;
                            this.maxLength = 65535;
                            break block1;
                        }
                        case 14: 
                        case 15: {
                            this.actualLength = (int)((BaseInputStreamWrapper)baseData.getObject()).determineLength();
                            if (this.actualLength > 8000) {
                                if (this.tdsVersion < 3) {
                                    this.nativeTypeNameIndex = 11;
                                    this.tdsType = (byte)34;
                                    this.maxLength = this.MAX_IMAGE_BYTES;
                                    break block1;
                                }
                                this.nativeTypeNameIndex = 150;
                                this.tdsType = (byte)-91;
                                this.maxLength = 65535;
                                break block1;
                            }
                            this.nativeTypeNameIndex = 10;
                            this.tdsType = (byte)-91;
                            this.maxLength = 8000;
                            break block1;
                        }
                        case 18: {
                            UtilDebug.assert((String)"Unexpected input stream.", (boolean)false);
                            break block1;
                        }
                        case 16: 
                        case 17: {
                            UtilDebug.assert((String)"Unexpected input stream.", (boolean)false);
                            break block1;
                        }
                    }
                    baseData.setBytes(baseData.getBytes(-1, this.exceptions));
                    this.actualLength = baseData.getBytesNoConvert().length;
                    if (this.actualLength > 8000) {
                        if (this.tdsVersion < 3) {
                            this.nativeTypeNameIndex = 11;
                            this.tdsType = (byte)34;
                            this.maxLength = this.MAX_IMAGE_BYTES;
                            break;
                        }
                        this.nativeTypeNameIndex = 150;
                        this.tdsType = (byte)-91;
                        this.maxLength = 65535;
                        break;
                    }
                    this.nativeTypeNameIndex = 10;
                    this.tdsType = (byte)-91;
                    this.maxLength = 8000;
                    break;
                }
                if (bl && baseData.isNull) {
                    this.nativeTypeNameIndex = 10;
                    this.tdsType = (byte)-91;
                    this.maxLength = 8000;
                    this.actualLength = -1;
                    break;
                }
                this.initializeUserBinaryOutputParam(n4);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.nativeTypeNameIndex = 5;
                this.maxLength = 8;
                this.tdsType = (byte)111;
                if (bl && !baseData.isNull) {
                    try {
                        baseData.setTimestamp(baseData.getTimestamp(this.exceptions));
                        this.actualLength = 8;
                    }
                    catch (SQLException sQLException) {
                        baseData.setString(baseData.getString(23, this.exceptions));
                        this.actualLength = -1;
                        switch (n2) {
                            case -25: 
                            case -17: {
                                if (this.maxLength == 65535) {
                                    this.nativeTypeNameIndex = 152;
                                    this.tdsType = (byte)-25;
                                    break;
                                }
                                this.nativeTypeNameIndex = 7;
                                this.maxLength = 8000;
                                this.tdsType = (byte)-25;
                                break;
                            }
                            case 39: 
                            case 47: {
                                if (this.maxLength == 65535) {
                                    this.nativeTypeNameIndex = 151;
                                    this.tdsType = (byte)-89;
                                    break;
                                }
                                this.nativeTypeNameIndex = 6;
                                this.maxLength = 8000;
                                this.tdsType = (byte)-89;
                                break;
                            }
                            case 99: {
                                this.nativeTypeNameIndex = 9;
                                this.maxLength = this.MAX_NTEXT_BYTES;
                                this.tdsType = (byte)99;
                                break;
                            }
                            case 35: {
                                this.nativeTypeNameIndex = 8;
                                this.maxLength = this.MAX_TEXT_BYTES;
                                this.tdsType = (byte)35;
                                break;
                            }
                            default: {
                                if (bl3) {
                                    this.nativeTypeNameIndex = 7;
                                    this.maxLength = 8000;
                                    this.tdsType = (byte)-25;
                                    break;
                                }
                                this.nativeTypeNameIndex = 6;
                                this.maxLength = 8000;
                                this.tdsType = (byte)-89;
                            }
                        }
                    }
                    if (this.tdsType != 111) break;
                    TDSDateTime.validateTimestamp(this.exceptions, baseData.getTimestamp(this.exceptions));
                    break;
                }
                this.actualLength = 0;
                break;
            }
            default: {
                throw this.exceptions.getException(6022);
            }
        }
        if (bl) {
            this.data.populate(baseData);
        } else {
            this.data.setNull(0);
        }
    }

    final void write(SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter) throws UtilException, SQLException {
        int[] nArray;
        if (this.isForRowUpdate || this.wasSetByName) {
            sQLServerByteOrderedDataWriter.writeInt8(this.paramName.length());
            sQLServerByteOrderedDataWriter.writeString(this.paramName);
        } else {
            sQLServerByteOrderedDataWriter.writeInt8(0);
        }
        int n = 0;
        if (this.isOutput) {
            n |= 1;
        }
        sQLServerByteOrderedDataWriter.writeInt8(n);
        byte[] byArray = null;
        if (this.tdsType == -89 && this.data.getType() == 10 && this.maxLength != 65535) {
            try {
                if (this.actualLength > 0) {
                    nArray = new int[1];
                    byArray = this.transliterator != null ? this.transliterator.encode(this.data.getStringNoConvert(), nArray) : this.conn.nonUnicodeTransliterator.encode(this.data.getStringNoConvert(), nArray);
                    this.actualLength = nArray[0];
                    if (this.actualLength > 8000) {
                        if (this.tdsVersion < 3) {
                            this.nativeTypeNameIndex = 8;
                            this.maxLength = this.MAX_TEXT_BYTES;
                            this.tdsType = (byte)35;
                        } else {
                            this.nativeTypeNameIndex = 151;
                            this.maxLength = 65535;
                            this.tdsType = (byte)-89;
                        }
                    }
                }
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
        sQLServerByteOrderedDataWriter.writeInt8(this.tdsType);
        this.writeLength(sQLServerByteOrderedDataWriter, this.maxLength);
        if (this.tdsType == 106 || this.tdsType == 108) {
            sQLServerByteOrderedDataWriter.writeInt8(this.precision);
            sQLServerByteOrderedDataWriter.writeInt8(this.scale);
        }
        if (this.conn.getTDSVersion() >= 2 && (this.tdsType == -81 || this.tdsType == -89 || this.tdsType == 35 || this.tdsType == -17 || this.tdsType == -25 || this.tdsType == 99)) {
            sQLServerByteOrderedDataWriter.writeBytes(this.conn.getSQLCollation());
        }
        if (!this.data.isNull) {
            switch (this.tdsType) {
                case 111: {
                    nArray = TDSDateTime.toDaysFraction(this.data.getTimestampNoConvert());
                    sQLServerByteOrderedDataWriter.writeInt8(this.actualLength);
                    sQLServerByteOrderedDataWriter.writeInt32(nArray[0]);
                    sQLServerByteOrderedDataWriter.writeInt32(nArray[1]);
                    break;
                }
                case 99: {
                    if (this.data.getType() == 10) {
                        sQLServerByteOrderedDataWriter.writeStringAsUCS2WithLength32(this.data.getStringNoConvert());
                        break;
                    }
                    if (this.data.getType() == 15) {
                        sQLServerByteOrderedDataWriter.writeAsciiStreamWithLength32(this.data.getASCIIStreamNoConvert(), this.getLength(this.data.getASCIIStreamNoConvert()));
                        break;
                    }
                    sQLServerByteOrderedDataWriter.writeReaderWithLength32(this.data.getCharacterStreamReaderNoConvert(), this.getLength(this.data.getCharacterStreamReaderNoConvert()));
                    break;
                }
                case -15: {
                    if (this.conn.connection.implConnection.xmlDescribeTypeIsChar) {
                        sQLServerByteOrderedDataWriter.transliterator = this.conn.unicodeTransliterator;
                        if (this.data.getType() == 10) {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getStringNoConvert(), -1, true);
                            break;
                        }
                        if (this.data.getType() == 15) {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getASCIIStreamNoConvert(), this.getLength(this.data.getASCIIStreamNoConvert()), true);
                            break;
                        }
                        sQLServerByteOrderedDataWriter.writePLPBody(this.data.getCharacterStreamReaderNoConvert(), this.getLength(this.data.getCharacterStreamReaderNoConvert()), true);
                        break;
                    }
                    if (this.data.getType() == 14) {
                        sQLServerByteOrderedDataWriter.writePLPBody(this.data.getBinaryStreamNoConvert(), this.getLength(this.data.getBinaryStreamNoConvert()), false);
                        break;
                    }
                    sQLServerByteOrderedDataWriter.writePLPBody(this.data.getBytesNoConvert(), this.actualLength, false);
                    break;
                }
                case 35: {
                    if (byArray != null) {
                        sQLServerByteOrderedDataWriter.writeInt32(this.actualLength);
                        sQLServerByteOrderedDataWriter.writeBytes(byArray, 0, this.actualLength);
                        break;
                    }
                    sQLServerByteOrderedDataWriter.transliterator = this.transliterator != null ? this.transliterator : this.conn.nonUnicodeTransliterator;
                    if (this.data.getType() == 10) {
                        sQLServerByteOrderedDataWriter.writeStringWithLength32(this.data.getStringNoConvert());
                    } else if (this.data.getType() == 18) {
                        sQLServerByteOrderedDataWriter.writeReaderWithLength32(this.data.getCharacterStreamReaderNoConvert(), this.getLength(this.data.getCharacterStreamReaderNoConvert()));
                    } else {
                        sQLServerByteOrderedDataWriter.writeAsciiStreamWithLength32(this.data.getASCIIStreamNoConvert(), this.getLength(this.data.getASCIIStreamNoConvert()));
                    }
                    sQLServerByteOrderedDataWriter.transliterator = this.conn.unicodeTransliterator;
                    break;
                }
                case -25: {
                    if (this.maxLength == 65535) {
                        sQLServerByteOrderedDataWriter.transliterator = this.conn.unicodeTransliterator;
                        if (this.data.getType() == 10) {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getStringNoConvert(), -1, true);
                            break;
                        }
                        if (this.data.getType() == 15) {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getASCIIStreamNoConvert(), this.getLength(this.data.getASCIIStreamNoConvert()), true);
                            break;
                        }
                        sQLServerByteOrderedDataWriter.writePLPBody(this.data.getCharacterStreamReaderNoConvert(), this.getLength(this.data.getCharacterStreamReaderNoConvert()), true);
                        break;
                    }
                    if (this.data.getType() == 10) {
                        sQLServerByteOrderedDataWriter.writeStringAsUCS2WithLength16(this.data.getStringNoConvert());
                        break;
                    }
                    if (this.data.getType() == 15) {
                        sQLServerByteOrderedDataWriter.writeAsciiStreamWithLength16(this.data.getASCIIStreamNoConvert(), this.getLength(this.data.getASCIIStreamNoConvert()));
                        break;
                    }
                    sQLServerByteOrderedDataWriter.writeReaderWithLength16(this.data.getCharacterStreamReaderNoConvert(), this.getLength(this.data.getCharacterStreamReaderNoConvert()));
                    break;
                }
                case -89: {
                    if (this.maxLength == 65535) {
                        if (byArray != null) {
                            sQLServerByteOrderedDataWriter.writePLPBody(byArray, this.actualLength, false);
                            break;
                        }
                        sQLServerByteOrderedDataWriter.transliterator = this.transliterator != null ? this.transliterator : this.conn.nonUnicodeTransliterator;
                        if (this.data.getType() == 10) {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getStringNoConvert(), -1, true);
                        } else if (this.data.getType() == 18) {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getCharacterStreamReaderNoConvert(), this.getLength(this.data.getCharacterStreamReaderNoConvert()), true);
                        } else {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getASCIIStreamNoConvert(), this.getLength(this.data.getASCIIStreamNoConvert()), true);
                        }
                        sQLServerByteOrderedDataWriter.transliterator = this.conn.unicodeTransliterator;
                        break;
                    }
                    if (byArray != null) {
                        sQLServerByteOrderedDataWriter.writeInt16(this.actualLength);
                        sQLServerByteOrderedDataWriter.writeBytes(byArray, 0, this.actualLength);
                        break;
                    }
                    sQLServerByteOrderedDataWriter.transliterator = this.transliterator != null ? this.transliterator : this.conn.nonUnicodeTransliterator;
                    if (this.data.getType() == 10) {
                        sQLServerByteOrderedDataWriter.writeStringWithLength16(this.data.getStringNoConvert());
                    } else if (this.data.getType() == 18) {
                        sQLServerByteOrderedDataWriter.writeReaderWithLength16(this.data.getCharacterStreamReaderNoConvert(), this.getLength(this.data.getCharacterStreamReaderNoConvert()));
                    } else {
                        sQLServerByteOrderedDataWriter.writeAsciiStreamWithLength16(this.data.getASCIIStreamNoConvert(), this.getLength(this.data.getASCIIStreamNoConvert()));
                    }
                    sQLServerByteOrderedDataWriter.transliterator = this.conn.unicodeTransliterator;
                    break;
                }
                case 104: {
                    sQLServerByteOrderedDataWriter.writeInt8(1);
                    sQLServerByteOrderedDataWriter.writeInt8(this.data.getBooleanNoConvert() ? 1 : 0);
                    break;
                }
                case 48: {
                    sQLServerByteOrderedDataWriter.writeInt8(this.data.getByte(this.exceptions));
                    break;
                }
                case 52: {
                    sQLServerByteOrderedDataWriter.writeInt16(this.data.getShortNoConvert());
                    break;
                }
                case 56: {
                    sQLServerByteOrderedDataWriter.writeInt32(this.data.getIntegerNoConvert());
                    break;
                }
                case 127: {
                    sQLServerByteOrderedDataWriter.writeInt64(this.data.getLongNoConvert());
                    break;
                }
                case 38: {
                    sQLServerByteOrderedDataWriter.writeInt8(this.actualLength);
                    if (this.actualLength == 1) {
                        sQLServerByteOrderedDataWriter.writeInt8((byte)this.data.getShortNoConvert());
                        break;
                    }
                    if (this.actualLength == 2) {
                        sQLServerByteOrderedDataWriter.writeInt16(this.data.getShortNoConvert());
                        break;
                    }
                    if (this.actualLength == 4) {
                        sQLServerByteOrderedDataWriter.writeInt32(this.data.getIntegerNoConvert());
                        break;
                    }
                    if (this.actualLength == 8) {
                        sQLServerByteOrderedDataWriter.writeInt64(this.data.getLongNoConvert());
                        break;
                    }
                    UtilDebug.assert((String)"Unexpected TDS_INTN actualLength defined", (this.actualLength == 0 ? 1 : 0) != 0);
                    break;
                }
                case 34: {
                    if (this.data.getType() == 14) {
                        sQLServerByteOrderedDataWriter.writeStreamWithLength32(this.data.getBinaryStreamNoConvert(), this.getLength(this.data.getBinaryStreamNoConvert()));
                        break;
                    }
                    sQLServerByteOrderedDataWriter.writeInt32(this.actualLength);
                    sQLServerByteOrderedDataWriter.writeBytes(this.data.getBytesNoConvert());
                    break;
                }
                case -91: 
                case -83: {
                    if (this.maxLength == 65535) {
                        if (this.data.getType() == 14) {
                            sQLServerByteOrderedDataWriter.writePLPBody(this.data.getBinaryStreamNoConvert(), this.getLength(this.data.getBinaryStreamNoConvert()), false);
                            break;
                        }
                        sQLServerByteOrderedDataWriter.writePLPBody(this.data.getBytesNoConvert(), this.actualLength, false);
                        break;
                    }
                    if (this.data.getType() == 14) {
                        sQLServerByteOrderedDataWriter.writeStreamWithLength16(this.data.getBinaryStreamNoConvert(), this.getLength(this.data.getBinaryStreamNoConvert()));
                        break;
                    }
                    sQLServerByteOrderedDataWriter.writeInt16(this.actualLength);
                    sQLServerByteOrderedDataWriter.writeBytes(this.data.getBytesNoConvert());
                    break;
                }
                case 109: {
                    sQLServerByteOrderedDataWriter.writeInt8(this.actualLength);
                    if (this.actualLength == 4) {
                        sQLServerByteOrderedDataWriter.writeIEEE32BitFloat(this.data.getFloatNoConvert());
                        break;
                    }
                    if (this.actualLength == 8) {
                        sQLServerByteOrderedDataWriter.writeIEEE64BitDouble(this.data.getDoubleNoConvert());
                        break;
                    }
                    UtilDebug.assert((String)"Unexpected TDS_FLTN actualLength defined", (boolean)false);
                    break;
                }
                case 62: {
                    sQLServerByteOrderedDataWriter.writeIEEE64BitDouble(this.data.getDoubleNoConvert());
                    break;
                }
                case 106: 
                case 108: {
                    BigDecimal bigDecimal = this.data.getBigDecimalNoConvert();
                    sQLServerByteOrderedDataWriter.writeInt8(this.actualLength);
                    sQLServerByteOrderedDataWriter.writeInt8(bigDecimal.signum() == -1 ? 0 : 1);
                    BigDecimal bigDecimal2 = bigDecimal.abs();
                    bigDecimal2 = bigDecimal2.movePointRight(bigDecimal2.scale());
                    byte[] byArray2 = bigDecimal2.toBigInteger().toByteArray();
                    UtilByteArray.reverse((byte[])byArray2);
                    if (byArray2.length > 16) {
                        String[] stringArray = new String[]{bigDecimal.toString()};
                        throw this.exceptions.getException(7013, stringArray);
                    }
                    byte[] byArray3 = UtilByteArray.allocate((int)16, (int)0);
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                    sQLServerByteOrderedDataWriter.writeBytes(byArray3);
                    break;
                }
                default: {
                    UtilDebug.assert((String)"Unexpected tdsType", (boolean)false);
                    break;
                }
            }
        } else if (this.maxLength == 65535 && (this.tdsType == -89 || this.tdsType == -25 || this.tdsType == -91) || this.tdsType == -15) {
            sQLServerByteOrderedDataWriter.writeInt64(-1L);
        } else {
            this.writeLength(sQLServerByteOrderedDataWriter, this.actualLength);
        }
    }

    private void writeLength(SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, int n) throws UtilException {
        switch (this.tdsType) {
            case 38: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: {
                sQLServerByteOrderedDataWriter.writeInt8(n);
                break;
            }
            case -25: {
                sQLServerByteOrderedDataWriter.writeInt16(n);
                break;
            }
            case -91: 
            case -89: 
            case -83: {
                sQLServerByteOrderedDataWriter.writeInt16(n);
                break;
            }
            case 99: {
                sQLServerByteOrderedDataWriter.writeInt32(n);
                break;
            }
            case 34: 
            case 35: {
                sQLServerByteOrderedDataWriter.writeInt32(n);
                break;
            }
            case -15: {
                sQLServerByteOrderedDataWriter.writeInt8(0);
                break;
            }
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 61: 
            case 62: 
            case 127: {
                break;
            }
            default: {
                UtilDebug.assert((String)"Unexpected tdsType", (boolean)false);
            }
        }
    }

    final boolean hasStateChanged() {
        return this.describedNativeTypeNameIndex != this.nativeTypeNameIndex;
    }

    final void recordState() {
        this.describedNativeTypeNameIndex = this.nativeTypeNameIndex;
    }

    private int getLength(InputStream inputStream) throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)inputStream;
        return (int)baseInputStreamWrapper.determineLength();
    }

    private int getLength(Reader reader) throws SQLException {
        BaseCharacterStreamWrapper baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)reader;
        return (int)baseCharacterStreamWrapper.determineLength();
    }

    final void initializeUserStringOutputParam(int n) throws SQLException {
        int n2 = n;
        this.actualLength = -1;
        if (n == 2 && this.serverReportedNativeType != null) {
            if (this.serverReportedNativeType.equals("xml")) {
                this.nativeTypeNameIndex = 153;
                this.tdsType = (byte)-15;
                return;
            }
            if (this.serverReportedNativeType.equals("varchar") || this.serverReportedNativeType.equals("char") || this.serverReportedNativeType.equals("varchar(max)")) {
                n2 = 1;
            }
        }
        if (this.maxLength == 65535) {
            if (n2 == 1) {
                this.nativeTypeNameIndex = 151;
                this.tdsType = (byte)-89;
            } else {
                this.nativeTypeNameIndex = 152;
                this.tdsType = (byte)-25;
            }
        } else {
            if (n2 == 1) {
                this.nativeTypeNameIndex = 6;
                this.tdsType = (byte)-89;
            } else {
                this.nativeTypeNameIndex = 7;
                this.tdsType = (byte)-25;
            }
            this.maxLength = 8000;
        }
    }

    final void initializeUserBinaryOutputParam(int n) throws SQLException {
        if (n == 2 && this.serverReportedNativeType != null && this.serverReportedNativeType.equals("varbinary(max)")) {
            this.nativeTypeNameIndex = 150;
            this.tdsType = (byte)-91;
            this.maxLength = 65535;
        } else {
            this.nativeTypeNameIndex = 10;
            this.tdsType = (byte)-91;
            this.maxLength = 8000;
        }
        this.actualLength = -1;
    }

    final String convertBigDecimaltoPlainString(BigDecimal bigDecimal) {
        String string = bigDecimal.toString();
        if (string.indexOf(69) == -1) {
            return string;
        }
        if (bigDecimal.scale() < 0) {
            bigDecimal = bigDecimal.setScale(0);
        }
        if (bigDecimal.scale() == 0) {
            return bigDecimal.unscaledValue().toString();
        }
        String string2 = bigDecimal.unscaledValue().abs().toString();
        int n = bigDecimal.signum();
        int n2 = string2.length() - bigDecimal.scale();
        if (n2 == 0) {
            return (n < 0 ? "-0." : "0.") + string2;
        }
        if (n2 > 0) {
            this.stringBufferForConversion.setLength(0);
            this.stringBufferForConversion.append(string2);
            this.stringBufferForConversion.insert(n2, '.');
            if (n < 0) {
                this.stringBufferForConversion.insert(0, '-');
            }
            return this.stringBufferForConversion.toString();
        }
        this.stringBufferForConversion.setLength(0);
        this.stringBufferForConversion.ensureCapacity(3 - n2 + string2.length());
        this.stringBufferForConversion.append(n < 0 ? "-0." : "0.");
        for (int i = 0; i < -n2; ++i) {
            this.stringBufferForConversion.append('0');
        }
        this.stringBufferForConversion.append(string2);
        return this.stringBufferForConversion.toString();
    }
}

