/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseMessages;
import com.metamatrix.jdbc.base.BaseSpyIndirection;
import com.metamatrix.jdbc.base.BaseURLParser;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilDummyPrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BaseDriver
implements Driver {
    private static String footprint = "$Revision:   3.10.1.0  $";
    public UtilDebug debug;
    public BaseExceptions exceptions;

    protected static void dumpDriverInfo(BaseDriver baseDriver) {
        try {
            String string = BaseClassUtility.getRootName(baseDriver);
            BaseMessages baseMessages = new BaseMessages(string);
            String[] stringArray = new String[1];
            BaseConnection baseConnection = (BaseConnection)Class.forName("com.metamatrix.jdbc." + string.toLowerCase() + "." + string + "Connection").newInstance();
            stringArray[0] = new BaseDatabaseMetaData(baseConnection, null).getDriverVersion();
            System.out.println(baseMessages.getMessage(6016, stringArray, false));
            System.out.flush();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    protected static void registerDriver(BaseDriver baseDriver) {
        try {
            DriverManager.registerDriver(baseDriver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean acceptsURL(String string) throws SQLException {
        this.setupExceptionHandling();
        String string2 = BaseClassUtility.getRootName(this);
        BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
        return baseURLParser.parse(string2, string, null);
    }

    public final Connection connect(String string, Properties properties) throws SQLException {
        BaseConnectionProperties baseConnectionProperties = new BaseConnectionProperties();
        BaseConnection baseConnection = BaseClassUtility.getConnection(this);
        this.setupExceptionHandling();
        baseConnectionProperties.put("loginTimeout", String.valueOf(DriverManager.getLoginTimeout()));
        String string2 = BaseClassUtility.getRootName(this);
        BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
        boolean bl = baseURLParser.parse(string2, string, baseConnectionProperties);
        if (bl) {
            String string3 = baseConnectionProperties.get("SpyAttributes");
            if (string3 != null) {
                return BaseSpyIndirection.getSpyConnection(this, string3, string, properties);
            }
            if (properties != null) {
                baseConnectionProperties.putUserSpecifed(properties);
            }
            baseConnection.modifyUserSpecifiedConnectProperties(baseConnectionProperties);
            BaseDriverPropertyInfos baseDriverPropertyInfos = baseConnection.getPropertyInfo();
            baseConnectionProperties.mergeDefaultProperties(baseDriverPropertyInfos);
            try {
                baseConnectionProperties.validate(baseDriverPropertyInfos, this.exceptions);
                this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
                baseConnection.open(baseConnectionProperties, this.exceptions, this.debug);
            }
            catch (SQLException sQLException) {
                baseConnection = null;
                throw sQLException;
            }
        } else {
            if (baseURLParser.parse(string2, string, null)) {
                throw this.exceptions.getException(6030);
            }
            baseConnection = null;
        }
        return baseConnection;
    }

    public final int getMajorVersion() {
        return BaseDatabaseMetaData.getVersionInternal("driverMajorVersion", this);
    }

    public final int getMinorVersion() {
        return BaseDatabaseMetaData.getVersionInternal("driverMinorVersion", this);
    }

    public final DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        this.setupExceptionHandling();
        DriverPropertyInfo[] driverPropertyInfoArray = null;
        String string2 = BaseClassUtility.getRootName(this);
        BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
        if (baseURLParser.parse(string2, string, null)) {
            BaseConnection baseConnection = BaseClassUtility.getConnection(this);
            driverPropertyInfoArray = baseConnection.getPropertyInfo().get();
        }
        return driverPropertyInfoArray;
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    private void setupExceptionHandling() throws SQLException {
        if (this.exceptions == null) {
            this.exceptions = new BaseExceptions(BaseClassUtility.getRootName(this));
        }
        this.exceptions = new BaseExceptions(this.exceptions.getMessages(), this.exceptions.getReturnVendorCode());
    }

    public static UtilDebug setupDebugging(BaseConnectionProperties baseConnectionProperties) {
        UtilDebug utilDebug = new UtilDebug();
        try {
            String string = baseConnectionProperties.get("debug_to_standard_out");
            if (string == null || string.equalsIgnoreCase("true")) {
                // empty if block
            }
            utilDebug.setPrintWriter(new UtilDummyPrintWriter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return utilDebug;
    }
}

