/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.util.Vector;

public class UtilTransliteratorPool {
    private static String footprint = "$Revision:   3.1.4.0  $";
    Vector transliterators;

    public UtilTransliteratorPool(int n) {
        this.transliterators = new Vector(n);
    }

    public UtilTransliterator getTransliteratorForCodePage(String string) throws UtilException {
        TransliteratorForLCID transliteratorForLCID;
        for (int i = 0; i < this.transliterators.size(); ++i) {
            transliteratorForLCID = (TransliteratorForLCID)this.transliterators.elementAt(i);
            if (string.compareTo(transliteratorForLCID.codePage) != 0) continue;
            return transliteratorForLCID.transliterator;
        }
        UtilTransliterator utilTransliterator = UtilTransliterator.GetNewTransliterator(string);
        if (utilTransliterator != null) {
            transliteratorForLCID = new TransliteratorForLCID();
            transliteratorForLCID.codePage = string;
            transliteratorForLCID.transliterator = utilTransliterator;
            this.transliterators.addElement(transliteratorForLCID);
        }
        return utilTransliterator;
    }

    public void reset() {
        for (int i = 0; i < this.transliterators.size(); ++i) {
            TransliteratorForLCID transliteratorForLCID = (TransliteratorForLCID)this.transliterators.elementAt(i);
            transliteratorForLCID.transliterator.setDefaultCacheSize();
        }
    }

    private class TransliteratorForLCID {
        String codePage;
        UtilTransliterator transliterator;

        private TransliteratorForLCID() {
        }
    }
}

