/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.dqp.internal.config;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.dqp.DqpPluginHelper;
import com.metamatrix.modeler.dqp.config.ExtensionModuleChangeEvent;
import com.metamatrix.modeler.dqp.config.IExtensionModuleChangeListener;
import com.metamatrix.modeler.dqp.internal.config.DqpConfigHandler;
import com.metamatrix.modeler.dqp.internal.config.DqpFileCopyHandler;
import com.metamatrix.modeler.dqp.internal.config.UdfJarMapperManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DqpExtensionsHandler
extends DqpConfigHandler {
    public static final String CONNECTOR_PATCH_JAR = "connector_patch.jar";
    private List<String> builtInExtensionJars;
    private boolean isLoaded = false;
    private List<IExtensionModuleChangeListener> listeners = new ArrayList<IExtensionModuleChangeListener>();
    private IPath dqpExtensionsFolderPath;
    private UdfJarMapperManager udfJarMapperManager;
    private DqpPluginHelper pluginHelper;

    public DqpExtensionsHandler(DqpFileCopyHandler dqpFileCopyHandler, DqpPluginHelper pHelper) {
        super(dqpFileCopyHandler);
        this.pluginHelper = pHelper;
        this.udfJarMapperManager = new UdfJarMapperManager(this.dqpExtensionsFolderPath, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        this.builtInExtensionJars = new ArrayList<String>();
        this.dqpExtensionsFolderPath = this.getDqpFileCopyHandler().getDqpExtensionPath();
        IPath extInstallPath = this.getDqpFileCopyHandler().getDqpInstallationPath().append("extensions");
        File[] extensionContents = extInstallPath.toFile().listFiles();
        if (extensionContents != null) {
            for (int i = 0; i < extensionContents.length; ++i) {
                if (!extensionContents[i].isFile()) continue;
                File outputFile = this.dqpExtensionsFolderPath.append(extensionContents[i].getName()).toFile();
                this.builtInExtensionJars.add(outputFile.getAbsolutePath());
                AbstractInterruptibleChannel srcChannel = null;
                AbstractInterruptibleChannel dstChannel = null;
                try {
                    srcChannel = new FileInputStream(extensionContents[i]).getChannel();
                    dstChannel = new FileOutputStream(outputFile).getChannel();
                    ((FileChannel)dstChannel).transferFrom((ReadableByteChannel)((Object)srcChannel), 0L, ((FileChannel)srcChannel).size());
                    continue;
                }
                catch (Exception e) {
                    DqpPlugin.Util.log(4, (Throwable)e, DqpExtensionsHandler.getString((String)"extensionFileCopyError", (Object)extensionContents[i].getName()));
                    continue;
                }
                finally {
                    try {
                        if (srcChannel != null) {
                            srcChannel.close();
                        }
                        if (dstChannel != null) {
                            dstChannel.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            this.isLoaded = true;
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void loadUdfMapper() {
        this.udfJarMapperManager.load();
    }

    protected UdfJarMapperManager getUdfJarMapperManager() {
        return this.udfJarMapperManager;
    }

    public boolean addConnectorJar(Object source, File jarFile) {
        boolean success = true;
        boolean changed = false;
        try {
            this.getDqpFileCopyHandler().copyFileToExtensionsFolder(jarFile);
            changed = true;
        }
        catch (IOException exception) {
            success = false;
            String msg = DqpPlugin.Util.getString(I18nUtil.getPropertyPrefix(DqpExtensionsHandler.class) + "problemAddingExtensionModule", (Object)jarFile.getName());
            DqpPlugin.Util.log(4, msg);
        }
        if (changed) {
            ExtensionModuleChangeEvent event = new ExtensionModuleChangeEvent(source, ExtensionModuleChangeEvent.Type.ADDED_FROM_CAF, (Object)jarFile.getName());
            this.fireExtensionModuleChangeEvent(event);
        }
        return success;
    }

    public boolean addUdfJars(Object source, File[] jarFiles) {
        boolean success = true;
        boolean changed = false;
        ArrayList<File> affectedObjects = new ArrayList<File>(jarFiles.length);
        ArrayList<String> jarNames = new ArrayList<String>();
        for (File file : jarFiles) {
            try {
                this.getDqpFileCopyHandler().copyFileToExtensionsFolder(file);
                changed = true;
                jarNames.add(file.getName());
                affectedObjects.add(file);
            }
            catch (IOException exception) {
                success = false;
                String msg = DqpPlugin.Util.getString(I18nUtil.getPropertyPrefix(DqpExtensionsHandler.class) + "problemAddingExtensionModule", (Object)file.getName());
                DqpPlugin.Util.log(4, msg);
            }
        }
        if (changed) {
            this.udfJarMapperManager.addJars(jarNames);
            ExtensionModuleChangeEvent event = new ExtensionModuleChangeEvent(source, ExtensionModuleChangeEvent.Type.ADDED_FOR_UDF, affectedObjects);
            this.fireExtensionModuleChangeEvent(event);
        }
        return success;
    }

    public boolean addConnectorJars(Object source, ExtensionModule[] extModules) {
        boolean success = true;
        boolean changed = false;
        ArrayList<String> affectedObjects = new ArrayList<String>(extModules.length);
        for (ExtensionModule extModule : extModules) {
            try {
                this.getDqpFileCopyHandler().writeCAFJarFileToExtensionFolder(extModule);
                changed = true;
                affectedObjects.add(extModule.getFullName());
            }
            catch (IOException exception) {
                success = false;
                String msg = DqpPlugin.Util.getString(I18nUtil.getPropertyPrefix(DqpExtensionsHandler.class) + "problemAddingExtensionModule", (Object)extModule.getFullName());
                DqpPlugin.Util.log(4, msg);
            }
        }
        if (changed) {
            ExtensionModuleChangeEvent event = new ExtensionModuleChangeEvent(source, ExtensionModuleChangeEvent.Type.ADDED_FROM_CAF, affectedObjects);
            this.fireExtensionModuleChangeEvent(event);
        }
        return success;
    }

    public boolean deleteUdfJarFiles(Object source, File[] jarFiles) {
        boolean success = true;
        boolean changed = false;
        ArrayList<File> affectedObjects = new ArrayList<File>(jarFiles.length);
        ArrayList<String> jarNames = new ArrayList<String>();
        for (File file : jarFiles) {
            boolean isConnJar = this.isConnectorJar(file);
            boolean deleted = false;
            if (!isConnJar && file.exists()) {
                deleted = file.delete();
            }
            if (deleted || isConnJar) {
                changed = true;
                jarNames.add(file.getName());
                affectedObjects.add(file);
                continue;
            }
            success = false;
            String msg = DqpPlugin.Util.getString(I18nUtil.getPropertyPrefix(DqpExtensionsHandler.class) + "problemDeletingExtensionModule", (Object)file.getName());
            DqpPlugin.Util.log(4, msg);
        }
        if (changed) {
            this.udfJarMapperManager.removeJars(jarNames);
            if (!affectedObjects.isEmpty()) {
                ExtensionModuleChangeEvent event = new ExtensionModuleChangeEvent(source, ExtensionModuleChangeEvent.Type.DELETED_FROM_UDF, affectedObjects);
                this.fireExtensionModuleChangeEvent(event);
            }
        }
        return success;
    }

    public boolean deleteConnectorJars(Object source, File[] jarFiles) {
        boolean success = true;
        boolean changed = false;
        ArrayList<File> affectedObjects = new ArrayList<File>(jarFiles.length);
        for (File file : jarFiles) {
            boolean isUdfJar = this.isUdfJar(file);
            boolean deleted = false;
            if (!isUdfJar) {
                deleted = file.delete();
            }
            if (deleted) {
                changed = true;
                affectedObjects.add(file);
                continue;
            }
            if (isUdfJar) continue;
            success = false;
            String msg = DqpPlugin.Util.getString(I18nUtil.getPropertyPrefix(DqpExtensionsHandler.class) + "problemDeletingExtensionModule", (Object)file.getName());
            DqpPlugin.Util.log(4, msg);
        }
        if (changed) {
            ExtensionModuleChangeEvent event = new ExtensionModuleChangeEvent(source, ExtensionModuleChangeEvent.Type.DELETED, affectedObjects);
            this.fireExtensionModuleChangeEvent(event);
        }
        return success;
    }

    public boolean isUdfJar(File jarFile) {
        return this.isUdfJar(jarFile.getName());
    }

    public boolean isUdfJar(String jarFileName) {
        return this.udfJarMapperManager.isUdfJar(jarFileName);
    }

    public boolean isConnectorJar(File jarFile) {
        return this.isConnectorJar(jarFile.getName());
    }

    public boolean isConnectorJar(String jarFileName) {
        return this.getAllConnectorJars().contains(jarFileName);
    }

    public List<String> getAllConnectorJars() {
        HashSet<String> theJars = new HashSet<String>();
        List<String> bindingJars = this.getConnectorBindingJars();
        List<String> typeJars = this.getConnectorTypeJars();
        theJars.addAll(bindingJars);
        theJars.addAll(typeJars);
        return new ArrayList<String>(theJars);
    }

    public List<String> getConnectorTypeJars() {
        Collection types = this.pluginHelper.getConfigurationManager().getConnectorTypes();
        ArrayList<String> theJars = new ArrayList<String>();
        for (ComponentType type : types) {
            String[] jarNames;
            for (String jarName : jarNames = this.getConnectorTypeExtensionModules(type)) {
                if (theJars.contains(jarName) || CONNECTOR_PATCH_JAR.equals(jarName) && !this.extensionModuleExists(CONNECTOR_PATCH_JAR)) continue;
                theJars.add(jarName);
            }
        }
        return theJars;
    }

    public String[] getConnectorTypeExtensionModules(ComponentType type) {
        ArrayList<String> modules = new ArrayList<String>();
        String classPath = type.getDefaultValue("ConnectorClassPath");
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath, ";");
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                int idx = path.indexOf("extensionjar");
                if (idx == -1) continue;
                String jarFile = path.substring(idx + "extensionjar".length() + 1);
                modules.add(jarFile);
            }
        }
        return modules.toArray(new String[modules.size()]);
    }

    public String[] getConnectorBindingExtensionModules(ConnectorBinding binding) {
        ArrayList<String> modules = new ArrayList<String>();
        String classPath = binding.getProperty("ConnectorClassPath");
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath, ";");
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                int idx = path.indexOf("extensionjar");
                if (idx == -1) continue;
                String jarFile = path.substring(idx + "extensionjar".length() + 1);
                modules.add(jarFile);
            }
        }
        return modules.toArray(new String[modules.size()]);
    }

    public List<String> getConnectorBindingJars() {
        Collection bindings = this.pluginHelper.getConfigurationManager().getConnectorBindings();
        ArrayList<String> theJars = new ArrayList<String>();
        for (ConnectorBinding binding : bindings) {
            String[] jarNames;
            for (String jarName : jarNames = this.getConnectorBindingExtensionModules(binding)) {
                if (theJars.contains(jarName) || CONNECTOR_PATCH_JAR.equals(jarName) && !this.extensionModuleExists(CONNECTOR_PATCH_JAR)) continue;
                theJars.add(jarName);
            }
        }
        return theJars;
    }

    public List<File> getUdfJarFiles() {
        return this.udfJarMapperManager.getUdfJarFiles();
    }

    public List<String> getUdfJarNames() {
        ArrayList<String> udfJarNames = new ArrayList<String>(5);
        List<File> files = this.getUdfJarFiles();
        for (File file : files) {
            String fName = file.getName();
            if (udfJarNames.contains(fName)) continue;
            udfJarNames.add(fName);
        }
        return udfJarNames;
    }

    public List<File> getNonBuildInConnectorJarFiles() {
        ArrayList<File> jarFiles = new ArrayList<File>();
        File extDir = this.dqpExtensionsFolderPath.toFile();
        if (extDir.exists() && extDir.isDirectory()) {
            File[] extDirContents = extDir.listFiles();
            for (int i = 0; i < extDirContents.length; ++i) {
                if (this.isBuiltInExtensionModule(extDirContents[i])) continue;
                jarFiles.add(extDirContents[i]);
            }
        }
        return jarFiles;
    }

    public boolean extensionModuleExists(String moduleName) {
        IPath extensionModule = this.dqpExtensionsFolderPath.append(moduleName);
        return extensionModule.toFile().exists();
    }

    public IPath getDqpExtensionsFolderPath() {
        return this.dqpExtensionsFolderPath;
    }

    public boolean isBuiltInExtensionModule(File jarFile) {
        return this.builtInExtensionJars.contains(jarFile.getAbsolutePath());
    }

    public boolean isBuiltInExtensionModuleName(String jarName) {
        for (String builtIn : this.builtInExtensionJars) {
            if (!new File(builtIn).getName().equals(jarName)) continue;
            return true;
        }
        return false;
    }

    public void copyExtensionModule(String moduleName, IPath destinationDirectory) throws IOException {
        this.copyExtensionModules(Collections.singletonList(moduleName), destinationDirectory);
    }

    public void copyExtensionModules(Collection<String> moduleNames, IPath destinationDirectory) throws IllegalArgumentException, IOException {
        if (!destinationDirectory.toFile().exists()) {
            String msg = DqpPlugin.Util.getString(I18nUtil.getPropertyPrefix(DqpExtensionsHandler.class) + "missingDestinationDirectory", (Object)destinationDirectory);
            DqpPlugin.Util.log(4, msg);
            throw new IllegalArgumentException(msg);
        }
        DqpFileCopyHandler handler = this.getDqpFileCopyHandler();
        for (String moduleName : moduleNames) {
            IPath extensionModule = this.dqpExtensionsFolderPath.append(moduleName);
            if (!extensionModule.toFile().exists()) {
                String msg = DqpPlugin.Util.getString(I18nUtil.getPropertyPrefix(DqpExtensionsHandler.class) + "missingExtensionsModule", (Object)moduleName);
                DqpPlugin.Util.log(4, msg);
                throw new IllegalArgumentException(msg);
            }
            handler.copyFileToSpecifiedFolder(extensionModule.toFile(), destinationDirectory);
        }
    }

    public void addChangeListener(IExtensionModuleChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(IExtensionModuleChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireExtensionModuleChangeEvent(ExtensionModuleChangeEvent event) {
        for (IExtensionModuleChangeListener listener : this.listeners) {
            listener.extensionModulesChanged(event);
        }
    }
}

