/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce.connection;

import com.metamatrix.connector.salesforce.Connector;
import com.metamatrix.connector.salesforce.ConnectorTarget;
import com.metamatrix.connector.salesforce.Messages;
import com.metamatrix.connector.salesforce.SalesforceCapabilities;
import com.metamatrix.connector.salesforce.SalesforceConnectorException;
import com.metamatrix.connector.salesforce.execution.DataPayload;
import com.metamatrix.connector.salesforce.execution.QueryExecutionImpl;
import com.metamatrix.connector.salesforce.execution.UpdateExecutionParent;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.QueryOptions;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.SessionHeader;
import com.sforce.soap.partner.SforceServiceLocator;
import com.sforce.soap.partner.SoapBindingStub;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.soap.partner.fault.InvalidQueryLocatorFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import com.sforce.soap.partner.sobject.SObject;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.SimpleSessionHandler;
import org.apache.axis.transport.http.CommonsHTTPSender;

public class SalesforceConnection
implements Connection {
    public static final int QUERY_RETRY_COUNT = 4;
    private SalesforceCapabilities salesforceCapabilites;
    private Connector connector;
    private ConnectorEnvironment env;
    private ConnectorTarget target;
    private SoapBindingStub binding;
    private ConnectorLogger logger;
    private long prevTime;
    private long pingInterval;
    private int timeout;
    private String sessionId;
    private String userId;
    private String serverUrl;
    private SalesforceConnectorException failure;

    public SalesforceConnection(Connector connector, ConnectorTarget target) throws ConnectorException {
        try {
            this.connector = connector;
            this.target = target;
            this.env = connector.getConnectorEnv();
            this.logger = this.env.getLogger();
            String capabilitiesClass = this.env.getProperties().getProperty("ConnectorCapabilities");
            if (capabilitiesClass != null) {
                try {
                    this.salesforceCapabilites = (SalesforceCapabilities)Class.forName(capabilitiesClass).newInstance();
                }
                catch (Exception e) {
                    throw new SalesforceConnectorException(e, "Unable to load Capabilities Class");
                }
            } else {
                throw new SalesforceConnectorException("Capabilities Class name not found");
            }
            try {
                String inLimitString = this.env.getProperties().getProperty("InLimit");
                int inLimit = inLimitString == null ? -1 : Integer.decode(inLimitString);
                this.salesforceCapabilites.setMaxInCriteriaSize(inLimit);
            }
            catch (NumberFormatException e) {
                throw new SalesforceConnectorException(Messages.getString((String)"SalesforceConnection.bad.IN.value"));
            }
            try {
                String pingIntervalString = this.env.getProperties().getProperty("SourceConnectionTestInterval");
                this.pingInterval = pingIntervalString == null ? 5000L : Long.decode(pingIntervalString);
            }
            catch (NumberFormatException e) {
                throw new SalesforceConnectorException(Messages.getString((String)"SalesforceConnection.bad.ping.value"));
            }
            this.timeout = 120000;
            try {
                String timeoutString = this.env.getProperties().getProperty("SourceConnectionTimeout");
                if (null != timeoutString) {
                    this.timeout = Integer.decode(timeoutString);
                }
            }
            catch (NumberFormatException e) {
                throw new SalesforceConnectorException(Messages.getString((String)"SalesforceConnection.bad.timeout.value"));
            }
            this.prevTime = System.currentTimeMillis();
        }
        catch (Throwable t) {
            this.logger.logError("SalesforceConnection() ErrorMessage: " + t.getMessage());
            if (t instanceof SalesforceConnectorException) {
                throw (SalesforceConnectorException)((Object)t);
            }
            throw new SalesforceConnectorException(t);
        }
    }

    public void login() throws ConnectorException {
        if (this.binding != null) {
            return;
        }
        this.login(this.target.getUsername(), this.target.getPassword(), this.target.getURL(), this.timeout);
        this.prevTime = System.currentTimeMillis();
    }

    public String key() {
        return this.target.key();
    }

    public Execution createExecution(int executionMode, ExecutionContext context, RuntimeMetadata metadata) throws ConnectorException {
        try {
            QueryExecutionImpl retVal = null;
            String errKey = null;
            switch (executionMode) {
                case 0: {
                    retVal = new QueryExecutionImpl(this, metadata, context, this.env);
                    break;
                }
                case 1: {
                    retVal = new UpdateExecutionParent(this, metadata, context, this.env);
                    break;
                }
                case 2: {
                    errKey = Messages.getString((String)"SalesforceConnection.procedures.not.supported");
                    break;
                }
                default: {
                    errKey = Messages.getString((String)"SalesforceConnection.invalid.execution.mode");
                }
            }
            if (errKey != null) {
                throw new SalesforceConnectorException(errKey);
            }
            return retVal;
        }
        catch (RuntimeException e) {
            throw new SalesforceConnectorException(e);
        }
    }

    public ConnectorCapabilities getCapabilities() {
        return this.salesforceCapabilites;
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
        try {
            this.connector.returnConnection(this);
        }
        catch (Exception e) {
            this.logger.logError("SaleforceConnection release() encounter error attempting to return connection " + this.key() + " to pool: " + e.getMessage());
        }
    }

    public void close() {
        if (this.binding != null) {
            try {
                if (!this.connector.isSessionClosed(this.getSessionId())) {
                    this.logger.logTrace("SaleforceConnection logout() called on " + this.getServerUrl() + " as " + this.getUserId() + " with session id " + this.getSessionId());
                    this.connector.registerClosedSession(this.getSessionId());
                }
            }
            catch (NoSuchMethodError e) {
                this.logger.logWarning("Warning : logout() not implemented in WSDL jar implementation, attempting to logout " + this.key() + ":" + e.getMessage());
            }
            catch (Exception e) {
                this.logger.logWarning("Warning : Unexpected error (" + e.getClass().getName() + ") attempting to logout " + this.key() + ":" + e.getMessage());
            }
            this.binding = null;
        }
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public QueryResult query(String queryString, int maxBatchSize) throws ConnectorException {
        if (this.isFailed()) {
            throw new ConnectorException((Throwable)new IllegalStateException(Messages.getString((String)"SaleforceQueryExecution.failed.connection")));
        }
        QueryResult qr = null;
        int retryCount = 4;
        while (retryCount > 0) {
            QueryOptions qo = new QueryOptions();
            qo.setBatchSize(new Integer(maxBatchSize));
            this.binding.setHeader(new SforceServiceLocator().getServiceName().getNamespaceURI(), "QueryOptions", (Object)qo);
            try {
                qr = this.binding.query(queryString);
                break;
            }
            catch (ApiFault ex) {
                if (--retryCount <= 0) {
                    this.failure = new SalesforceConnectorException(this.apiFaultExceptionMessage("query(" + queryString + ", " + maxBatchSize + ")", ex));
                    throw this.failure;
                }
                this.logger.logInfo("Retry: query() : binding.query() due to ApiFault " + ex.getMessage());
            }
            catch (RemoteException ex) {
                if (--retryCount <= 0) {
                    this.failure = new SalesforceConnectorException("query()", "binding.query()", this.apiFaultExceptionMessage("query(" + queryString + ", " + maxBatchSize + ")", ex), ex);
                    throw this.failure;
                }
                this.logger.logInfo("Retry: query() : binding.query() due to RemoteException " + ex.getMessage());
            }
        }
        return qr;
    }

    public QueryResult queryMore(String queryLocator) throws ConnectorException {
        if (this.isFailed()) {
            throw new SalesforceConnectorException(new IllegalStateException(Messages.getString((String)"SaleforceQueryExecution.failed.connection")));
        }
        QueryResult result = null;
        int retryCount = 4;
        while (retryCount > 0) {
            try {
                result = this.binding.queryMore(queryLocator);
                break;
            }
            catch (InvalidQueryLocatorFault e) {
                this.failure = new SalesforceConnectorException("queryMore()", "binding.queryMore()", this.apiFaultExceptionMessage("queryMore(" + queryLocator + ")", (ApiFault)((Object)e)), e);
                throw this.failure;
            }
            catch (UnexpectedErrorFault e) {
                if (--retryCount <= 0) {
                    this.failure = new SalesforceConnectorException("queryMore()", "binding.queryMore()", this.apiFaultExceptionMessage("queryMore(" + queryLocator + ")", (ApiFault)((Object)e)), e);
                    throw this.failure;
                }
                this.logger.logInfo("Retry: queryMore() : binding.queryMore() due to UnexpectedError " + e.getMessage());
            }
            catch (ApiFault e) {
                if (--retryCount <= 0) {
                    this.failure = new SalesforceConnectorException("queryMore()", "binding.queryMore()", this.apiFaultExceptionMessage("queryMore(" + queryLocator + ")", e), e);
                    throw this.failure;
                }
                this.logger.logInfo("Retry: queryMore() : binding.queryMore() due to ApiFault " + e.getMessage());
            }
            catch (RemoteException e) {
                if (--retryCount <= 0) {
                    this.failure = new SalesforceConnectorException("queryMore()", "binding.queryMore()", this.apiFaultExceptionMessage("queryMore(" + queryLocator + ")", e), e);
                    throw this.failure;
                }
                this.logger.logInfo("Retry: query() : binding.queryMore() due to RemoteException " + e.getMessage());
            }
        }
        return result;
    }

    public boolean isAlive() {
        boolean result = true;
        if (this.isFailed()) {
            this.binding = null;
            return false;
        }
        if (this.connector.isSessionClosed(this.getSessionId())) {
            this.binding = null;
            return false;
        }
        if (null != this.binding) {
            try {
                long currentTime = System.currentTimeMillis();
                this.logger.logInfo("Calling isAlive(), currentTime=" + currentTime + ", prevTime=" + this.prevTime + ", diff=" + (currentTime - this.prevTime) / 1000L + ", pingInterval=" + this.pingInterval);
                if ((currentTime - this.prevTime) / 1000L > this.pingInterval) {
                    this.prevTime = currentTime;
                    this.binding.getServerTimestamp();
                }
            }
            catch (UnexpectedErrorFault e) {
                this.failure = new SalesforceConnectorException("isAlive()", " binding.getServerTimestamp()", this.apiFaultExceptionMessage("isAlive()", (ApiFault)((Object)e)), e);
                this.logger.logError(this.failure.toString());
                result = false;
            }
            catch (RemoteException e) {
                this.failure = new SalesforceConnectorException("isAlive()", " binding.getServerTimestamp()", this.apiFaultExceptionMessage("isAlive()", e), e);
                this.logger.logError(this.failure.toString());
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    SoapBindingStub getBinding() {
        return this.binding;
    }

    public int delete(String[] ids) throws ConnectorException {
        DeleteResult[] results = null;
        try {
            results = this.binding.delete(ids);
        }
        catch (UnexpectedErrorFault e) {
            this.failure = new SalesforceConnectorException("delete()", "binding.delete()", this.apiFaultExceptionMessage("delete()", (ApiFault)((Object)e)), e);
            throw this.failure;
        }
        catch (RemoteException e) {
            this.failure = new SalesforceConnectorException("delete()", "binding.delete()", this.apiFaultExceptionMessage("delete()", e), e);
            throw this.failure;
        }
        boolean allGood = true;
        StringBuffer errorMessages = new StringBuffer();
        for (int i = 0; i < results.length; ++i) {
            Error[] errors;
            DeleteResult result = results[i];
            if (result.isSuccess()) continue;
            if (allGood) {
                errorMessages.append("Error(s) executing DELETE: ");
                allGood = false;
            }
            if (null == (errors = result.getErrors()) || errors.length <= 0) continue;
            for (int x = 0; x < errors.length; ++x) {
                Error error = errors[x];
                errorMessages.append(error.getMessage()).append(';');
            }
        }
        if (!allGood) {
            throw new SalesforceConnectorException(errorMessages.toString());
        }
        return results.length;
    }

    public int create(DataPayload data) throws ConnectorException {
        SaveResult[] result;
        SObject toCreate = new SObject();
        toCreate.setType(data.getType());
        toCreate.set_any(data.getMessageElements());
        SObject[] create = new SObject[]{toCreate};
        try {
            result = this.binding.create(create);
        }
        catch (ApiFault e) {
            this.failure = new SalesforceConnectorException("create()", "binding.create()", this.apiFaultExceptionMessage("create()", e), e);
            throw this.failure;
        }
        catch (RemoteException e) {
            this.failure = new SalesforceConnectorException("create()", "binding.create()", this.apiFaultExceptionMessage("create()", e), e);
            throw this.failure;
        }
        return this.analyzeResult(result);
    }

    public int update(List updateDataList) throws ConnectorException {
        SaveResult[] result;
        SObject[] params = new SObject[updateDataList.size()];
        for (int i = 0; i < updateDataList.size(); ++i) {
            DataPayload data = (DataPayload)updateDataList.get(i);
            SObject toCreate = new SObject();
            toCreate.setType(data.getType());
            toCreate.setId(data.getID());
            toCreate.set_any(data.getMessageElements());
            params[i] = toCreate;
        }
        try {
            result = this.binding.update(params);
        }
        catch (ApiFault e) {
            this.failure = new SalesforceConnectorException("update()", "binding.update()", this.apiFaultExceptionMessage("update()", e), e);
            throw this.failure;
        }
        catch (RemoteException e) {
            this.failure = new SalesforceConnectorException("update()", "binding.update()", this.apiFaultExceptionMessage("update()", e), e);
            throw this.failure;
        }
        return this.analyzeResult(result);
    }

    public String getBindingUserName() throws ConnectorException {
        try {
            return this.binding.getUserInfo().getUserName();
        }
        catch (UnexpectedErrorFault e) {
            this.failure = new SalesforceConnectorException("getBindingUserName()", "binding.getUserInfo().getUserName()", this.apiFaultExceptionMessage("update()", (ApiFault)((Object)e)), e);
            throw this.failure;
        }
        catch (RemoteException e) {
            this.failure = new SalesforceConnectorException("getBindingUserName()", "binding.getUserInfo().getUserName()", this.apiFaultExceptionMessage("update()", e), e);
            throw this.failure;
        }
    }

    private int analyzeResult(SaveResult[] results) throws ConnectorException {
        for (int i = 0; i < results.length; ++i) {
            SaveResult result = results[i];
            if (result.isSuccess()) continue;
            throw new SalesforceConnectorException(result.getErrors()[0].getMessage());
        }
        return results.length;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    private EngineConfiguration getStaticConnectionConfig() {
        SimpleProvider clientConfig = new SimpleProvider();
        SimpleSessionHandler sessionHandler = new SimpleSessionHandler();
        SimpleChain reqHandler = new SimpleChain();
        SimpleChain respHandler = new SimpleChain();
        reqHandler.addHandler((Handler)sessionHandler);
        respHandler.addHandler((Handler)sessionHandler);
        CommonsHTTPSender pivot = new CommonsHTTPSender();
        SimpleTargetedChain transport = new SimpleTargetedChain((Handler)reqHandler, (Handler)pivot, (Handler)respHandler);
        clientConfig.deployTransport("http", (Handler)transport);
        return clientConfig;
    }

    private void login(String username, String password, URL url, int timeout) throws ConnectorException {
        if (!this.isAlive()) {
            LoginResult loginResult = null;
            this.failure = null;
            this.binding = null;
            SforceServiceLocator locator = new SforceServiceLocator();
            EngineConfiguration myConfig = this.getStaticConnectionConfig();
            locator.setEngineConfiguration(myConfig);
            locator.setEngine((AxisEngine)new AxisClient(myConfig));
            try {
                this.binding = null != url ? (SoapBindingStub)new SforceServiceLocator().getSoap(url) : (SoapBindingStub)new SforceServiceLocator().getSoap();
                this.binding.setTimeout(timeout);
                loginResult = this.binding.login(username, password);
                this.sessionId = loginResult.getSessionId();
                this.userId = loginResult.getUserId();
                this.serverUrl = loginResult.getServerUrl();
            }
            catch (ApiFault ex) {
                this.failure = new SalesforceConnectorException("login(" + username + ")", "binding.login()", this.apiFaultExceptionMessage("login", ex), ex);
                throw this.failure;
            }
            catch (RemoteException e) {
                this.failure = new SalesforceConnectorException("login(" + username + ")", "binding.login()", this.apiFaultExceptionMessage("login", e), e);
                throw this.failure;
            }
            catch (ServiceException e) {
                this.failure = new SalesforceConnectorException("login(" + username + ")", "binding.login()", this.apiFaultExceptionMessage("login", e), e);
                throw this.failure;
            }
            this.logger.logTrace("Login was successful for username " + username);
            this.binding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)loginResult.getServerUrl());
            SessionHeader sh = new SessionHeader();
            sh.setSessionId(loginResult.getSessionId());
            this.binding.setHeader(new SforceServiceLocator().getServiceName().getNamespaceURI(), "SessionHeader", (Object)sh);
            try {
                this.binding.getUserInfo();
            }
            catch (UnexpectedErrorFault e) {
                this.failure = new SalesforceConnectorException("login(" + username + ")", "binding.getUserInfo() after successful login", this.apiFaultExceptionMessage("getUserInfo()", (ApiFault)((Object)e)), e);
                throw this.failure;
            }
            catch (RemoteException e) {
                this.failure = new SalesforceConnectorException("login(" + username + ")", "binding.getUserInfo() after successful login", this.apiFaultExceptionMessage("getUserInfo()", e), e);
                throw this.failure;
            }
        }
    }

    private String apiFaultExceptionMessage(String tag, ApiFault apiFault) {
        StringBuffer sb = new StringBuffer("APIFault:");
        sb.append("(").append(((Object)((Object)apiFault)).getClass().getName()).append(")\n");
        sb.append("message=").append(apiFault.getMessage()).append(")\n");
        sb.append(",sessionId=").append(this.sessionId);
        sb.append(",userName=").append(this.userId);
        sb.append(",serverUrl=").append(this.serverUrl);
        sb.append(",FAULT DUMP\n").append(apiFault.dumpToString());
        sb.append(",exceptionCode=").append(apiFault.getExceptionCode());
        sb.append(",exceptionMessage=").append(apiFault.getExceptionMessage());
        return sb.toString();
    }

    private String apiFaultExceptionMessage(String tag, RemoteException remoteException) {
        StringBuffer sb = new StringBuffer("RemoteException:");
        sb.append("(").append(remoteException.getClass().getName()).append(")\n");
        sb.append("message=").append(remoteException.getMessage()).append(")\n");
        sb.append(",sessionId=").append(this.sessionId);
        sb.append(",userName=").append(this.userId);
        sb.append(",serverUrl=").append(this.serverUrl);
        return sb.toString();
    }

    private String apiFaultExceptionMessage(String tag, ServiceException serviceException) {
        StringBuffer sb = new StringBuffer("ServiceException:");
        sb.append("(").append(((Object)((Object)serviceException)).getClass().getName()).append(")\n");
        sb.append("message=").append(serviceException.getMessage()).append(")\n");
        sb.append(",sessionId=").append(this.sessionId);
        sb.append(",userName=").append(this.userId);
        sb.append(",serverUrl=").append(this.serverUrl);
        return sb.toString();
    }
}

