/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.validator;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.resolver.util.ResolverVisitorUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.validator.AbstractValidationVisitor;
import java.util.Collection;

public class ModelVisibilityValidationVisitor
extends AbstractValidationVisitor {
    private VDBService vdbService;
    private String vdbName;
    private String vdbVersion;

    public ModelVisibilityValidationVisitor(VDBService vdbService, String vdbName, String vdbVersion) {
        this.vdbService = vdbService;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
    }

    public void visit(Delete obj) {
        this.validateModelVisibility((Command)obj);
    }

    public void visit(Insert obj) {
        this.validateModelVisibility((Command)obj);
    }

    public void visit(Query obj) {
        this.validateModelVisibility((Command)obj);
    }

    public void visit(Update obj) {
        this.validateModelVisibility((Command)obj);
    }

    public void visit(StoredProcedure obj) {
        this.validateModelVisibility((Command)obj);
    }

    public void visit(Function obj) {
        if ("lookup".equalsIgnoreCase(obj.getName())) {
            try {
                ResolverVisitorUtil.ResolvedLookup resolvedLookup = ResolverVisitorUtil.resolveLookup(obj, this.getMetadata());
                this.validateModelVisibility(this.getMetadata().getModelID(resolvedLookup.getGroup().getMetadataID()), resolvedLookup.getGroup());
            }
            catch (QueryResolverException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
            catch (QueryMetadataException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
        }
    }

    protected void validateModelVisibility(Command obj) {
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)true);
        try {
            for (GroupSymbol group : groups) {
                Object modelID = null;
                modelID = obj instanceof StoredProcedure ? ((StoredProcedure)obj).getModelID() : this.getMetadata().getModelID(group.getMetadataID());
                if (modelID instanceof TempMetadataID) {
                    return;
                }
                this.validateModelVisibility(modelID, group);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
    }

    protected void validateModelVisibility(Object modelID, GroupSymbol group) throws QueryMetadataException, MetaMatrixComponentException {
        String modelName = this.getMetadata().getFullName(modelID);
        int visibility = this.vdbService.getModelVisibility(this.vdbName, this.vdbVersion, modelName);
        if (visibility != 0) {
            this.handleValidationError(DQPPlugin.Util.getString("ERR.018.005.0088", (Object)this.getMetadata().getFullName(group.getMetadataID())));
        }
    }
}

